# Tamito KAJIYAMA <1 October 2001>
# $Id: alias.py,v 1.1.1.1 2003/04/11 05:54:31 shy Exp $

import string
import sys

import ninix.config

builtin_open = open

def print_error(message):
    sys.stderr.write(message + "\n")

def fatal(error):
    print_error("alias.py: %s" % str(error))
    return ninix.config.null_config()

def open(path):
    file = builtin_open(path)
    buffer = []
    while 1:
        line = file.readline()
        if not line:
            break
        line = string.strip(line)
        if not line:
            continue
        buffer.append(line)
    return new_alias(buffer)

def new_alias(buffer):
    dict = ninix.config.Config()
    i, j = 0, len(buffer)
    while i < j:
        line = buffer[i]
        i = i + 1
        if line in ["sakura.surface.alias", "kero.surface.alias"]:
            name = line
            table = {}
            try:
                while 1:
                    if i < j:
                        line = buffer[i]
                        i = i + 1
                    else:
                        raise ValueError, "unexpedted end of file"
                    line = string.strip(string.replace(line, "\x81\x40", ""))
                    if not line:
                        continue
                    elif line == "{":
                        break
                    raise ValueError, "open brace not found"
                while 1:
                    if i < j:
                        line = buffer[i]
                        i = i + 1
                    else:
                        raise ValueError, "unexpected end of file"
                    line = string.strip(string.replace(line, "\x81\x40", ""))
                    if not line:
                        continue
                    elif line == "}":
                        break
                    line = string.split(line, ',', 1)
                    if len(line) == 2:
                        key, values = map(string.strip, line)
                    else:
                        raise ValueError, "malformed line found"
                    if values and values[0] == "[" and values[-1] == "]":
                        table[key] = []
                        for value in string.split(values[1:-1], ','):
                            try:
                                value = str(int(value))
                            except ValueError:
                                pass
                            table[key].append(value)
                    else:
                        raise ValueError, "malformed line found"
            except ValueError, error:
                return fatal(error)
            dict[name] = table
        else:
            line = string.split(line, ',', 1)
            if len(line) == 2:
                key, value = map(string.strip, line)
            else:
                return fatal("malformed line found")
            if key == "makoto":
                if value and value[0] == "[" and value[-1] == "]":
                    value = string.split(value[1:-1], ',')
                else:
                    value = [value]
            dict[key] = value
    return dict

# test
if __name__ == "__main__":
    import sys
    print open(sys.argv[1])
