<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: create_user.php5,v 1.23 2005/06/10 22:16:44 mdruilhe Exp $
 *	Usage:		Create a new user for a site
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

require ("init_admin.inc");

# Read site administration configuration
# --------------------------------------
require ("$site_cfg_file");	
if (empty($bn_msgs) ) {
	include ("$bn_dir_default/site_msgs.$ext");
} else {
	include "$bn_dir/$bn_msgs";
}

display_header (TITLE_NEW_USER);

# gets all forums in this site for which the logged user is moderator
# -------------------------------------------------------------------
if ($auth->level >= ADMIN ) {
	// get all forums if user is administrator
	$forums = $db->listForums ($site);
} else {
	$forums = $db->listForums ($site, $auth->userid);
}

# Loads user table fields definitions
# -----------------------------------
if (file_exists("$bn_dir_default/user_fields.$ext") ) {
	include "$bn_dir_default/user_fields.$ext";
} else {
	include "$tmpl_dir/admin/user_fields.$ext";
}

# If Creation form have been submitted
# ------------------------------------
if (isset($go)) {

	$go=0;

#	Check for required fields
#	-------------------------
	if (empty ($passwd1) || ($passwd1 != $passwd2)) {
		MsgForm (ERROR_NO_PASSWORD, "$WA_SELF", 'back');
		exit;
	}

	if (is_array ($user_bind_var)) {
		reset($user_bind_var);
		while (list($field, $required) = each($user_bind_var)) {
			if ($required && isset($_POST[$field]) && ($$field=="") ) {
				$mess = sprintf (ERROR_MISSING_FIELD, $field);
				MsgForm ("$mess", "$WA_SELF", 'back');
				exit;
			}
		}
	}

	$userid = trim(strip_magic_quotes($userid));	// remove spaces at beginning and end
	
#	Check if user already exists
#	-----------------------------
	$u = $db->getUser($site, $userid, "userid");
	if (is_array($u)) {
		msgForm (sprintf(ERROR_USER_ALREADY_EXISTS, $userid), "$WA_SELF", 'back');
		echo "</body></html>";
		exit;
	}

	$u = $db->getUser($site, $useraddress, "useraddress");
	if (is_array($u)) {
		msgForm (sprintf(ERROR_EMAIL_ALREADY_EXISTS, $useraddress), "$WA_SELF", 'back');
		echo "</body></html>";
		exit;
	}

#	gets all input form variables and set fields in user array
#	----------------------------------------------------------

	$unixdate = time();
	
# -------------------------------------------------------------------
# Create user privileges (user->forums relation) for each forum
# -------------------------------------------------------------------

# initialize default values
# --------------------------
	$uf_fields["unixdate"]=$unixdate;
	$uf_fields["userid"]=$userid;
	$uf_fields["lastpost"]=0;
	$uf_fields["totalpost"]=0;

# For each forum in this site (if user is not an admin)
# -----------------------------------------------------
	if ( ($userpriv != "admin") && is_array ($forums)) {
		reset ($forums);
		while (list($name) = each ($forums) ) {
			$forum = $forums[$name]["bn_name"];
			if (is_array ($$forum)) {
# if user has rights on this forum => gets all privileges set on this forum for this user
# ---------------------------------------------------------------------------------------
				// initialize default values
				$uf_fields["bn_name"]=$forum;
				$uf_fields["listpriv"] = 0;
				$uf_fields["readpriv"] = 0;
				$uf_fields["writepriv"] = 0;
				$uf_fields["modpriv"] = 0;
				$uf_fields["state"] = 0;
				while ( list($priv, $val) = each($$forum) ) {
					$uf_fields[$priv] = $val;
				}
# if moderator has been selected for this forum :
# -----------------------------------------------
				if ($uf_fields["modpriv"] == 1) {
					if ($userpriv == "moder") {
						//  moderator can also read, write, list => force all privileges
						$uf_fields["listpriv"]=1;
						$uf_fields["readpriv"]=1;
						$uf_fields["writepriv"]=1;
					} else {
						// this user has not moderator privilege
						$uf_fields["modpriv"]=0;
					}
				}
			
# insert into userforum
# ---------------------
				$ret = $db->InsertPrivs ($site, $forum, $userid, $uf_fields);

				if ($ret < 0) {
					MsgForm (sprintf(ERROR_NO_ADD_USER, $userid,$site), "$WA_SELF?site=$site", 'back');
					exit;
				}
# If moderator has been choosen, set forum's owner if not already set
# ------------------------------------------------------------------
				if ( ($uf_fields["modpriv"] == 1) && empty($forums[$name]["owner"]) ) {
					$forums[$name]["owner"] = $userid;
					$ret = $db->updateForum ($site, $forum, $forums[$name]);
					if ($ret < 0) {
						MsgForm (sprintf(ERROR_NO_OWNER_UPDATE,$forum, $site), "$WA_SELF?site=$site", 'back');
						exit;
					}
				}
			}
		}
	}

#	Check Home page URL if set 
#	---------------------------
	if (!empty($homepage) && !eregi ("^https*://[[:alnum:]]+", $homepage)) {
		$homepage = "";
	}

#  Now insert this user in users table
#  -----------------------------------
	
	for (reset ($user_var); $form_field=current($user_var); next($user_var)) {
		$$field=strip_magic_quotes($$form_field);
		$u_fields[$form_field]=$$field;
	}

	$u_fields["password"] = md5(strip_magic_quotes($passwd1));
	$u_fields["lastlogin"] = 0;
	$u_fields["totallogins"] = 0;
	if ($bn_registration_mode==REG_ADMIN_APPROVAL && !$is_administrator) {
		$u_fields["state"] = "P";
	} else {
		$u_fields["state"] = "1";
	}

	$ret = $db->insertUser ($site, $u_fields);

	if ($ret < 0) {
		MsgForm (sprintf(ERROR_NO_SITE_ADD_USER, $userid, $site), "$WA_SELF?site=$site", 'back');
		exit;
	} elseif ( ($bn_registration_mode == REG_ADMIN_APPROVAL) && !$is_administrator) {
		$bn_action = "create_user";
		include ("$inc_dir/mail.$ext");
		$admins = $db->getAdministrators($site);
		foreach($admins as $admin) {
			$moderators[] = $admin['useraddress'];
		}
		mail_profile ($userid, '', $u_fields, $moderators);
	}

# If new user has administrator privilege =>  insert into main database
# ---------------------------------------------------------------------
	if ( ($userpriv == "admin" || $userpriv == "root") ) {
		$agora_dbparam = getDBaccess('agora');
		$agora_access = $agora_dbparam["bn_access"];
		$agora_dbname = $agora_dbparam["dbname"];
		$agora_dbhost = $agora_dbparam["dbhost"];
		$agora_dbport = $agora_dbparam["dbport"];
		$agora_dbuser = $agora_dbparam["dbuser"];
		$agora_dbpassword = $agora_dbparam["dbpassword"];

		if ($site_access != $agora_access) {
			include ("$inc_dir/$agora_access.$ext");
		}
		$agora_db_class = "${agora_access}_access";
		$agora_db = new $agora_db_class;
		$ret = $agora_db->openDB($agora_dbhost, $agora_dbport, $agora_dbuser, $agora_dbpassword, $agora_dbname, "agora");

		$ret = $agora_db->insertUser ("agora", $u_fields);
		if ($ret == -3) {
			// if the user already exists in the main database, then update his infos
			$agora_db->updateUser ("agora", $userid, $u_fields);
		}
	}

	$msg = "<strong>" . sprintf(LABEL_USER_ADDED,$userid);
	if ( ($bn_registration_mode == REG_ADMIN_APPROVAL) && !$is_administrator) {
		$msg .= "<br/>".LABEL_USER_SENT_FOR_APPROVAL;
	}
	$msg .= "<br/><br/>". anchor ("$WA_SELF?site=$site", "", LABEL_CREATE_ANOTHER_USER, LABEL_CREATE_ANOTHER_USER);
	$msg .= "&nbsp;&nbsp;" . anchor ("admin_user.$ext?site=$site&action=edit&userid=$userid", "", LABEL_EDIT_THIS_USER, ALT_EDIT_THIS_USER) ."<br/>";
	msgWarning($msg);

	exit;
} // End $go

#  -------------------------------------------
#  Initialize default values then display FORM
#  -------------------------------------------

	$userid = (isset($userid)) ? $userid : "";
	$username = (isset($username)) ? $username : "";
	$useraddress = (isset($useraddress)) ? $useraddress : "";
	$homepage = (empty($homepage)) ? 'http://' : $homepage;
	$details = (isset($details)) ? $details : "";
	$mailok = (isset($mailok)) ? $mailok : "Y";

?>

<FORM NAME="form_post" METHOD="post" ACTION="<?php echo $WA_SELF?>">

<INPUT TYPE="hidden" NAME="site" VALUE="<?php echo $site?>">
<INPUT TYPE="hidden" NAME="go" VALUE="1">
<INPUT TYPE="hidden" NAME="key" VALUE="<?php echo $key?>">
<?php
	table_header (LABEL_SITE_CREATE_NEW_USER . "<em>$site</em>");
?>
 <TABLE BORDER="0" WIDTH="100%">
  <CAPTION><B><?php echo LABEL_USER_INFORMATIONS ?></B></CAPTION>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_ID ?>: </TD>
   <TD><?php textField ("userid", $userid, 30, 32);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_NAME?>: </TD>
   <TD><?php textField ("username", $username, 30, 64);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_EMAIL ?>: </TD>
   <TD><?php textField ("useraddress", $useraddress, 30, 255);?></td>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_WEBPAGE ?>: </TD>
   <TD><?php textField ("homepage", $homepage, 30, 255);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="TOP" class=label><?php echo COLUMN_USER_DESCRIPTION ?>: </TD>
   <TD><?php textArea ("details", $details, 2, 30);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_PASSWORD ?>: </TD>
   <TD><?passwordField ("passwd1", $passwd1, 30, 32);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo COLUMN_USER_CONFIRM_PASSWORD ?>: </TD>
   <TD><?passwordField ("passwd2", $passwd2, 30, 32);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?php echo LABEL_ADD_MAILING_LIST ?></td>
   <TD><?php radioButton ("mailok", "Y", $mailok, LABEL_YES);echo "<br>";radioButton ("mailok", "N", $mailok, LABEL_NO); ?></TD>
  </TR>
 </TABLE>
<?php 
## </td></tr>
# Initialize user privileges choices
# ----------------------------------
	$granted_privs["user"] = $user_privs["user"];

# super user/administrator can grant moderator privilege
	if (($auth->type=="root") || ($auth->type=="admin") ) {
		$granted_privs["moder"] = $user_privs["moder"];
	}

# super user can grant administrator privilege
	if ($auth->type=="root") {
		$granted_privs["admin"] = $user_privs["admin"];
	}

# Only 'admin' can grant sysadmin privilege
	if ($auth->userid=="admin") {
		$granted_privs["root"] = $user_privs["root"];
	}

# Now displays a combo with granteable privileges if we are admin or root
	if (count($granted_privs) > 1) {
## <TR><TD>
?>
 <TABLE BORDER=0 WIDTH="100%">
  <CAPTION><B><?php echo CAPTION_USER_PRIVILEGE ?></B></CAPTION>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE"><?php echo LABEL_USER_PRIVILEGE ?>: </TD>
   <TD><?php listBox ("userpriv", $granted_privs, "user");?></TD>
  </TR>
 </TABLE>
<?php 
## </TD></TR>
	} else {
		hiddenField ("userpriv", "user"); 
	}
	
# Now, if the logged user is a moderator: we display all the forums he is responsible for
# ---------------------------------------------------------------------------------------
	if ( ($auth->level >= MODER) && is_array ($forums) ) {
		reset ($forums);
		echo "<br><TABLE border=0 cellspacing=0 cellpadding=0 WIDTH='100%'>";
		caption ("<font size=2><b>" . CAPTION_CHANGE_USER_FORUM_PRIVILEGES  . "</b><br>" . LABEL_AS .  $user_privs[$auth->type] . LABEL_GRANT_PRIVILEGES . "</font><br><br>", "");
		echo "<tr bgcolor=white><td>" . COLUMN_FORUM . "</td><td>" . COLUMN_FORUM_TITLE . "</td><td>" . COLUMN_CAN_LIST . "</td><td>" . COLUMN_CAN_READ . "</td><td>" . COLUMN_CAN_WRITE . "</td>";
		if ($auth->level > MODER) {
			echo "<td>" . LABEL_MODERATOR . "</td>";
		}
		echo "<td>" . LABEL_ACTIVE . "</td></tr>";
		while (list($name) = each ($forums) ) {
			$bn_title = $forums[$name]["bn_title"];
			$forum = $forums[$name]["bn_name"];
			printf ("<tr><td class=label><b>%s</b></td><td class=label>%s</TD><td class=label>", $name, $bn_title);
			checkBox ($forum."[listpriv]", "1", "1");
			print ("</td><td class=label>");
			checkBox ($forum."[readpriv]", "1", "1");
			print ("</td><td class=label>");
			checkBox ($forum."[writepriv]", "1", "1");
			print ("</td><td class=label>");
			if ($auth->level > MODER) {
				checkBox ($forum."[modpriv]", "1", "0");
				print ("</td><td class=label>");
			}
			checkBox ($forum."[state]", "1", "1");
			print ("</td></tr>");
		}
		echo " </TABLE>";
	}
?>
<br>
<center>
 <INPUT TYPE="submit" VALUE="<?php echo LABEL_CREATE_USER ?>">
 <INPUT TYPE="reset"  VALUE="<?php echo LABEL_RESET ?>">
</CENTER>
<?php table_footer() ?>
</FORM>
</BODY>
</HTML>
