#!/bin/sh 
#
# This should be done at initial booting after installation.
# requires:
#	httpd-2.0.59
#	php-5.2.x
#
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

HTTPD_DIR=$ROOT/opt/httpd
PHP5_DIR=$ROOT/usr

cd $ROOT/


PHPINI_FILE=$ROOT/etc/php.ini
mv $PHPINI_FILE $PHPINI_FILE.bak
sed -e 's/;extension=apc.so/extension=apc.so/' \
    -e 's/;extension=uploadprogress.so/extension=uploadprogress.so/' \
    $PHPINI_FILE.bak > $PHPINI_FILE
if ! fgrep "apc.so" $PHPINI_FILE 1> /dev/null 2>&1; then
    echo "    extension=apc.so" >>$PHPINI_FILE
fi
if ! fgrep "uploadprogress.so" $PHPINI_FILE 1> /dev/null 2>&1; then
    echo "    extension=uploadprogress.so" >>$PHPINI_FILE
fi


if ! fgrep "APC3 by Plamo-4.2" $PHPINI_FILE 1> /dev/null 2>&1; then
    cat >>$PHPINI_FILE<<EOF

;;
;; APC3 by Plamo-4.2
;;
apc.enabled = on
apc.shm_segments = 1
apc.shm_size = 128
apc.optimization = on
apc.ttl = 7200
apc.user_ttl = 7200
apc.gc_ttl = 3600
apc.filters =
apc.num_files_hint = 1024
apc.user_entities_hint = 4096
apc.mmap_file_mask = /tmp/apc.XXXXXX
apc.enable_cli = on
apc.cache_by_default = on
apc.max_file_size = 1M
apc.stat = on
apc.rfc1867 = on
;;
;;
;;
EOF
fi


pecl install uploadprogress
pecl upgrade uploadprogress

pear install HTML_AJAX-beta
pear upgrade HTML_AJAX-beta



# ( DONOT CHANGE THE NEXT ONE LINE )
# Add UploadProgressMeter Entry to Httpd document index.
if [ -f $HTTPD_DIR/htdocs/contents.list ]; then
  if ! fgrep "UploadProgressMeter" $HTTPD_DIR/htdocs/contents.list 1> /dev/null 2>&1; then
    HTTPD_DIR=$ROOT/opt/httpd
    cat >> $HTTPD_DIR/htdocs/contents.list <<EOL

    <P ALIGN="CENTER"> UploadProgressMeter
    ( <A
	HREF="http://bluga.net/projects/uploadProgressMeter/"
      >http://bluga.net/projects/uploadProgressMeter/</A>
    )<BR>
     (Upload Progress Meter demo)<BR>
     <A
      HREF="UploadProgressMeter"
     >UploadProgressMeter</A>
<BR> 

    </P>
EOL
  fi

  chown root.apache $HTTPD_DIR/htdocs/UploadProgressMeter/*
  chmod go+r $HTTPD_DIR/htdocs/UploadProgressMeter/*

  $HTTPD_DIR/bin/apachectl stop
  sleep 1
  $HTTPD_DIR/bin/apachectl startssl

else
  awk '/Add UploadProgressMeter Entry/,/#EOS1/' $ROOT/install/doinst.sh >> /tmp/add_httpd_test.sh
fi
#EOS1
