#!/bin/sh

SWNAME=xmpeg_play-2.0
ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc

rm -rf mpeg_play
tar zxf mpeg_play-src.tar.Z
cd mpeg_play
patch -p1 <<EOF
--- mpeg_play/mpeg_play.1~	1993-02-03 09:26:58.000000000 +0900
+++ mpeg_play/mpeg_play.1	2004-05-25 20:10:12.000000000 +0900
@@ -53,7 +53,7 @@
 .HP
 ordered - ordered dither. 
 .HP
-ordered2 - a faster ordered dither. This is the default.
+ordered2 - a faster ordered dither.
 .HP
 mbordered - ordered dithering at the macroblock level. Although there
 is a noticeable decrease in dither quality, this is the fastest dither
@@ -79,7 +79,7 @@
 gray - Grayscale dithering. The image is dithered into 128 grayscales. Chrominance
 information is thrown away.
 .HP
-color - Full color display (only available on 24 bit color displays).
+color - Full color display (only available on 24 bit color displays). This is the default.
 .HP
 none - no dithering is done, no image is displayed. Used to time decoding process.
 .HP
--- mpeg_play/mib/Makefile._orig_	1994-01-31 14:07:58.000000000 +0900
+++ mpeg_play/mib/Makefile	2004-05-25 18:51:42.000000000 +0900
@@ -1,5 +1,5 @@
 LIB = libmib.a
-CFLAGS = -I/usr/local/include
+CFLAGS = -I/usr/X11R6/include
 LDFLAGS = -L/usr/local/lib -L.
 CC = gcc
 
@@ -9,7 +9,7 @@
 # if it's sgi:
 # AR = ar us
 
-AR = ar uc
+AR = ar cru
 
 LIBS= -lXm -lXt -lX11 -lPW
 
--- mpeg_play/Makefile._orig_	1994-01-31 07:24:03.000000000 +0900
+++ mpeg_play/Makefile	2004-05-25 18:53:34.000000000 +0900
@@ -8,7 +8,7 @@
 #	Set INCLUDEDIR equal to -I followed by include directory
 #	path for X11 include files. 
 
-INCLUDEDIR    = 
+INCLUDEDIR    = -I/usr/X11R6/include
 
 #
 # Step 3:
@@ -19,7 +19,7 @@
 #       -DSH_MEM from CFLAGS.
 #
 #Sun C Flags
-CFLAGS	      =  -O3 -DSH_MEM -DNDEBUG -DBSD -DNONANSI_INCLUDES \$(INCLUDEDIR)
+CFLAGS	      =  -O2 -DRS6000 -DSH_MEM -DNDEBUG -DBSD -DNONANSI_INCLUDES \$(INCLUDEDIR)
 
 #HP C Flags 
 #CFLAGS        = -Ac +O3 -DSH_MEM -DNDEBUG \$(INCLUDEDIR)
@@ -57,7 +57,7 @@
 #       NOTE: below the default definition are
 #             a few definitions for specific architectures.
 
-LIBS	      = /usr/lib/libXext.a /usr/lib/libX11.a
+LIBS	      = -L/usr/X11R6/lib -lXext -lX11
 
 # LIBS for MIPS RISC/os 4.5{1,2}
 # LIBS         = -L/usr/lib -lXext -lX11_s
@@ -137,7 +137,7 @@
 		@echo Installing \$(PROGRAM) in \$(DEST)
 		@-strip \$(PROGRAM)
 		@if [ \$(DEST) != . ]; then \\
-		(rm -f \$(DEST)/\$(PROGRAM); \$(INSTALL) -f \$(DEST) \$(PROGRAM)); fi
+		(rm -f \$(DEST)/\$(PROGRAM); \$(INSTALL) \$(PROGRAM) \$(DEST) ); fi
 
 print:;		@\$(PRINT) \$(HDRS) \$(SRCS)
 
--- mpeg_play/main.c._orig_	1994-01-30 19:00:40.000000000 +0900
+++ mpeg_play/main.c	2004-05-25 19:07:32.000000000 +0900
@@ -234,7 +234,7 @@
 
   name = "";
   input = stdin;
-  ditherType = ORDERED2_DITHER;
+  ditherType = FULL_COLOR_DITHER;
   LUM_RANGE = 8;
   CR_RANGE = CB_RANGE = 4;
   noDisplayFlag = 0;
EOF

make

rm -rf ../pkg
mkdir -p ../pkg/usr/X11R6/bin
mkdir -p ../pkg/${MANDIR}/man1
mkdir -p ../pkg/${DOCDIR}/${SWNAME}

make install DEST=`pwd`/../pkg/usr/X11R6/bin INSTALL=/bin/install
mv ../pkg/usr/X11R6/bin/mpeg_play ../pkg/usr/X11R6/bin/xmpeg_play
cat mpeg_play.1 | sed -e 's/mpeg_play/xmpeg_play/g' -e 's/MPEG_PLAY/XMPEG_PLAY/g' > ../pkg/${MANDIR}/man1/xmpeg_play.1
gzip ../pkg/${MANDIR}/man1/xmpeg_play.1
cp -p ../PlamoBuild.sh A* B* C* P* R* V* ../pkg/${DOCDIR}/${SWNAME}/.
chown -R root:root ../pkg/${DOCDIR}/${SWNAME}

cd ../pkg
/sbin/makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
