//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall 
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.


#ifndef WSDXAREADEV_H
#define WSDXAREADEV_H

#include <WSDwindowDev.h>
#include <win/WSwincom.h>
#include <windows.h>

class WSDwinformDev               :public WSDwindowDev {
  private:
  protected:
    HDC       _dc;
    HDC       _mdc;
    HBITMAP   _pixmap;
    HWND      _wnd;
    HWND      _pwnd;
    COLORREF  _bg_cref;
    HBITMAP   _bg_image;
    HCURSOR   _mouse_val;
//    WSClistData _depend_children;
    short    _back_cno;
    short    _back_pixno;
    short  _abs_x;
    short  _abs_y;
    WSCbool _exposed;
    WSCbool _moved;
    WSCbool _resized;
    WSCbool _grabed;
    WSCushort _w_now;
    WSCushort _h_now;
    WSCushort _mouse_no;
    long      _click_time;
    HBITMAP   _pixmap_mdc;
    unsigned _resize_sequence:1;

virtual  void _evh_expose(WinEvent*);
virtual  void _evh_btn_press(WinEvent*,int);
virtual  void _evh_btn_release(WinEvent*,int);
virtual  void _evh_mouse_move(WinEvent*);
virtual  void _evh_mouse_in(WinEvent*);
virtual  void _evh_mouse_out(WinEvent*);
virtual  void _evh_resize(WinEvent*);
virtual  void _evh_move(WinEvent*);
virtual  void _evh_dummy(WinEvent*);
virtual  void _evh_delete(WinEvent*);
virtual  void _evh_delete2(void*);


virtual long createWindow();
virtual long createPixmap(); //call for Expose only...
//virtual long createContext();
virtual long destroyWindow();
virtual long destroyPixmap();
//virtual long destroyContext();

    long    setPixmap(HBITMAP);
    void    setHWND(HWND);

virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area(long x,long y,WSCulong w,WSCulong h);

   WSDwinformDev* getParentAreaDev();

  public:
    WSDwinformDev();
    virtual ~WSDwinformDev();
    virtual long setVisible(WSCbool fl);
    virtual long setValue(long kind,void*);
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();
    virtual WSDdev* getEventParentDev();
    virtual long dispatchEvent(WinEvent*);
    virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool,WSCbool scaling = True);
    virtual long endDraw();
    HWND  getHWND();
    HWND  getWindow();
    HBITMAP  getPixmap();
    WSCushort  getMouseNo();
    short getAbsoluteX();
    short getAbsoluteY();
    void invalidate(WSCbool);
    void setExposed(WSCbool);
virtual  void _clear_and_expose();
//    Window  getWindow();
//    GC      getGC();
//    virtual void     setDependDev(WSDdev*);
//    void    addDependChild(WSDwinformDev*);
//    void    delDependChild(WSDwinformDev*);
//    void    destroyAllDependChildren();

    virtual long raise();
    virtual long lower();

    WSMFclassDef(WSDwinformDev,WSDwindowDev);
};
#endif
 
