/*-------------------------------------------------------------------------*/
/*  J3W ver 6.43  3D Animation Kit                                         */
/*  timing.h       4/10/2001                                               */
/*  Copyright (C) 1995 - 2001 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_timing_h)
#define _timing_h

#include <sys/time.h>
#include <unistd.h>
#ifdef WS
#ifdef WIN32
#include <windows.h>
#include <sys/timeb.h>
#include <time.h>
#include <winsock.h>
#endif //WIN32
#endif WS

class cTiming {
#ifdef WIN32
    SYSTEMTIME start_st;
    SYSTEMTIME loss_st;
    SYSTEMTIME now_st;
#else //WIN32
    timeval  start, now, losstime;
    struct timezone tzone;
#endif //WIN32
    long   msec;
  public:
    cTiming() {}
    ~cTiming() {}
#ifdef WIN32
    void StartTimer() {
      GetLocalTime(&start_st);
    }
    void PauseTimer() {
      GetLocalTime(&loss_st);
    }
    void RestartTimer() {
      GetLocalTime(&now_st);
      start_st.wYear += now_st.wYear - loss_st.wYear;
      start_st.wMonth += now_st.wMonth - loss_st.wMonth;
      start_st.wDayOfWeek += now_st.wDayOfWeek - loss_st.wDayOfWeek;
      start_st.wDay += now_st.wDay - loss_st.wDay;
      start_st.wHour += now_st.wHour - loss_st.wHour;
      start_st.wMinute += now_st.wMinute - loss_st.wMinute;
      start_st.wSecond += now_st.wSecond - loss_st.wSecond;
      start_st.wMilliseconds += now_st.wMilliseconds - loss_st.wMilliseconds;
    }
    long GetTime() {
      GetLocalTime(&now_st);
      long ret = (now_st.wDay - start_st.wDay)*24*60*60*1000;
      ret += (now_st.wHour - start_st.wHour)*60*60*1000;
      ret += (now_st.wMinute - start_st.wMinute)*60*1000;
      ret += (now_st.wSecond - start_st.wSecond)*1000;
      ret += now_st.wMilliseconds - start_st.wMilliseconds;
      return ret;
    }
#else //WIN32
    void StartTimer() { gettimeofday(&start, &tzone); }
    void PauseTimer() { gettimeofday(&losstime, &tzone); }
    void RestartTimer() {
        gettimeofday(&now, &tzone);
        start.tv_sec += now.tv_sec - losstime.tv_sec;
        start.tv_usec += now.tv_usec - losstime.tv_usec;
    }
    long GetTime() {
        gettimeofday(&now, &tzone);
        msec = (now.tv_sec - start.tv_sec)*1000 +
                    long((now.tv_usec - start.tv_usec)/1000);
        return msec;
    }
#endif //WIN32
    long GetTick() { return 1; }
    long GetPeriodInTick () { return GetTime(); }
};

#endif

