//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVIFIELD_H
#define WSCVIFIELD_H

#include <WScom.h>
#include <WSCvlabel.h>
class WSDkeyboard;

#define WSCvifield_VER  1001

class WSCvifield   :public WSCvlabel{

  protected:
    static long _cur_timer_id;
    long      _mx;
    long      _my;
    char*     _upname;
    char*     _dwname;
    char*     _lname;
    char*     _rname;
    char*     _rtname;
    char*     _tbname;
    char*     _btbname;
    char*     _data_source_name;

    long      _cur_pos;
//    WSCushort _columns;
    WSCushort _cbase;
    long     _disp_cur_x;
    long     _disp_cur_y;
    long      _cur_pos_bk;
    WSCushort* _ucs2;
    WSCushort* _str_work;

    long      _lines;
    unsigned  _data_source_type:2;
    long      _select_pos1;
    long      _select_pos2;
    unsigned  _kanji_in:1;
    unsigned  _icursor:1;
    unsigned  _enable_focus_move:1;
    unsigned  _fspace:1;
    unsigned  _cursor_adjust:1;
    unsigned  _multi_lines:1;
    unsigned  _skip_mode:1;
    unsigned  _enable_max:1;
    unsigned  _cursor_fore:1;
    unsigned  _no_hatch:1;
    unsigned  _no_mcur_adjust:1;
    unsigned  _mouse_pressed:1;
    unsigned  _deleting:1;
    unsigned  _return_key_focus:1;
    unsigned  _key_input_disable:1;
    unsigned  _fep_set_focus:1;
    unsigned  _display_only:1;
    unsigned  _need_ds_update:1;


//    WSMFpropertyDef(WSNcolumns,     WSCushort, _columns);
    WSMFpropertyDef(WSNcursorPos,   short,    _cur_pos);
    WSMFpropertyDef(WSNkanjiIn,     WSCbool,  _kanji_in);
    WSMFpropertyDef(WSNinterCur,    WSCbool,  _icursor);
    WSMFpropertyDef(WSNenableFocusMove,  WSCbool, _enable_focus_move );
    WSMFpropertyDef(WSNupward,    char*,   _upname);
    WSMFpropertyDef(WSNdownward, char*,   _dwname);
    WSMFpropertyDef(WSNleftward,   char*,   _lname);
    WSMFpropertyDef(WSNrightward,  char*,   _rname);
    WSMFpropertyDef(WSNreturn,     char*,   _rtname);
    WSMFpropertyDef(WSNtab,     char*,   _tbname);
    WSMFpropertyDef(WSNbacktab,     char*,   _btbname);
    WSMFpropertyDef(WSNfillSpace,   WSCbool,      _fspace);
    WSMFpropertyDef(WSNcursorAdjust,WSCbool,      _cursor_adjust);
    WSMFpropertyDef(WSNifieldSkipMode,   WSCbool, _skip_mode);
    WSMFpropertyDef(WSNnoHatch,   WSCbool, _no_hatch);
    WSMFpropertyDef(WSNreturnKeyFocus,   WSCbool, _return_key_focus);

    WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
    WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
    WSMFpropertyDef(WSNdisplayOnly,  WSCbool, _display_only  );


    virtual void setWorkWSNmaxLength(WSCushort data);
    virtual void setWorkWSNlabelString(char* data);
    virtual void getWorkWSNlabelString(char** data);

    static void _cursor_blink_handler(WSCuchar,void*);
    static WSCbool _special_key_handler(void*,WSDkeyboard*,WSCbool);
    static void _key_handler(void*,WSDkeyboard*,WSCbool);
//    static void _focus_lose_handler(void*);


    virtual void  _on_key_input(WSDkeyboard*,WSCbool); 
    virtual long  _device_initialize();

//    char* _get_text();
    void  _adjust_cbase();
    void  _set_text(WSCushort*);
    void  _update_text();
    void  _fill_space();
    void  _set_cur_pos(long absolute_pos);
    void  _get_cur_pos(long* x,long* y,long* pos);

//    WSCushort* _get_disp_string();
    WSCbool _return_key_ok();  

    void _fep_cursor_adjust(WSDkeyboard*);
virtual long _cursor_move(char direction);
    void _get_disp_cur_pos(long* x,long* y);
    long _get_absolute_pos(long x,long y);
    void _set_select_pos1(long pos);
    void _set_select_pos2(long pos);
    void _delete_select_string();
    void _reset_select_string();
    void _replace_string(WSCushort*);
    void _adjust_max_len();
    void _set_ds_instance();

  public:
    WSCvifield(WSCbase*,char*);
    virtual ~WSCvifield();

    virtual void onCursorBlink();                  
    virtual void onFocusChange(WSCbool);
    virtual void onSpecialFocusChange(WSCbool);
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onKeyHook(WSDkeyboard*);
    virtual void onKeyInput(WSDkeyboard*,WSCbool);
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onActivate();
    virtual void onValueChange();
    virtual void onSelectionChange(WSCbool);
    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);

    virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    virtual long getDataSourceType();                                     
    virtual char* getDataSourcePropertyName();

    virtual long draw();
    virtual void update();

    void setCursorFore(WSCbool fl);
    WSCbool getCursorFore();
    WSCbool setCurPos(long pos); //pos >= 0
    void replaceSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSCstring getSelectedString();
    void deleteSelectedString();
    long setSelect(long,long);
    long getSelectedPos();
    long setFepStatus(WSCbool);
    WSCushort* getBuf();
    WSCstring getString();
    void setBuf(WSCushort*);
    void addString(char*,long encode = WS_EN_DEFAULT);
    WSMFguiClassDef(WSCvifield,WSCvlabel);
    WSMFversionDef(WSCvifield);
};
#define WS_MLINE_MARGIN 2
#endif
