# -*- coding: ascii -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: prefs.py,v 1.4 2004/04/13 05:21:59 shy Exp $
#

import mimetools
import os
import UserDict

import ninix.home

class Preferences(UserDict.UserDict):
    def __init__(self, filename):
        UserDict.UserDict.__init__(self)
        self.filename = filename
    def load(self):
        try:
            file = open(self.filename)
        except IOError:
            return
        prefs = mimetools.Message(file)
        for key, value in prefs.items():
            self[key] = value
        file.close()
    def save(self):
        try:
            os.makedirs(os.path.dirname(self.filename))
        except OSError:
            pass
        file = open(self.filename, "w")
        keys = self.keys()
        keys.sort()
        for key in keys:
            file.write("%s: %s\n" % (key, self[key]))
        file.close()
    def _get(self, name, default, conv):
        value = self.get(name)
        if value:
            try:
                return conv(value)
            except ValueError:
                pass
        return default
    def getint(self, name, default=None):
        return self._get(name, default, int)
    def getfloat(self, name, default=None):
        return self._get(name, default, float)

def new_prefs():
    filename = ninix.home.get_preferences()
    return Preferences(filename)

def load_prefs():
    prefs = new_prefs()
    prefs.load()
    return prefs
