<?php
require_once('Text/Diff.php');
//require_once('Text/Diff/Renderer.php');



/**
 * Diffの内容を表示しやすいように加工するクラス。
 */
class DiffRenderer
{
	protected $diff;	//加工するDiff
	
	
	/**
	 * @param	Text_Diff	$diff	加工対象のDiff
	 */
	function __construct($diff)
	{
		$this->diff = $diff;
	}
	
	
	/**
	 * Diffをテキスト形式にして取得する。
	 * 
	 * @param	bool	$diffonly	trueのときは差分のみを返す。
	 */
	function render($diffonly = false)
	{
		$edits = $this->diff->getDiff();
		foreach($edits as $edit){
            switch (get_class($edit)) {
	            case 'Text_Diff_Op_copy':
	            	if(!$diffonly){
	                	$ret[] = $this->lines(' ', $edit->orig);
	                }
	                break;
	            case 'Text_Diff_Op_add':
	                $ret[] = $this->lines('+', $edit->final);
	                break;
	            case 'Text_Diff_Op_delete':
	                $ret[] = $this->lines('-', $edit->orig);
	                break;
	            case 'Text_Diff_Op_change':
	                $ret[] = $this->lines('-', $edit->orig);
	                $ret[] = $this->lines('+', $edit->final);
	                break;
	            default:
	                throw MyException("DiffRenderer: Unknown edit type");
			}
		}
		return join("\n", $ret);
	}
	
	
	/**
	 * 行頭にprefixをつける。
	 * 
	 * 引数が配列で返値はstringになる。
	 * 
	 * @param	string	$prefix	行頭につけるprefix
	 * @param	array(string)	$lines	文字列群
	 * @return	string
	 */
	protected function lines($prefix, $lines)
	{
		$ret = array();
		foreach($lines as $l){
			$ret[] = $prefix . $l;
		}
		return join("\n", $ret);
	}
}

?>