#=====================================================================================
#   
#            FILE:  epsg_option.tcl
#   
#     DESCRIPTION:  adds the utility to execute Netelers script to create a location 
#                   using the epsg codes
#  
#           NOTES:  ---
#          AUTHOR:  Antonello Andrea
#           EMAIL:  antonell ing.unitn.it
#         COMPANY:  Engineering, University of Trento / CUDAM
#       COPYRIGHT:  Copyright (C) 2004 University of Trento / CUDAM, ITALY, GPL
#         VERSION:  1.2
#         CREATED:  04/01/2004
#        REVISION:  22/04/2006 (Michael Barton, Arizona State University)
#=====================================================================================
#
#
# 
#  This library is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU Library General Public 
#  License as published by the Free Software Foundation; either 
#  version 2 of the License, or (at your option) any later version. 
#
#  This library is distributed in the hope that it will be useful, 
#  but WITHOUT ANY WARRANTY; without even the implied warranty of 
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#  Library General Public License for more details. 
#
#  You should have received a copy of the GNU Library General Public 
#  License along with this library; if not, write to the Free 
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
#  USA 
#
#1. Redistributions of source code must retain the above copyright   
#   notice, this list of conditions and the following disclaimer.   
#2. Redistributions in binary form must reproduce the above copyright   
#   notice, this list of conditions and the following disclaimer in the   
#   documentation and/or other materials provided with the distribution.   
# 
#############################################################################
#
#   part regarding to the creation of a new location using proj and 
#   the EPSG codes    (routines epsgLocCom and infoEpsg)
#
#############################################################################

global browsedepsg 

# G_msg.tcl should be sourced first for internationalized strings.

# the frame used to set EPSG parameters 
proc epsgLocCom args {
        #vars declaration
        global database
        global epsgLocation 
        global epsg_code
        global env
        global thelocation
        global browsedepsg 
        global locpath
        
	# NOTE: the epsg file is generated in GDAL for PROJ4 
	# with gdal/pymod/epsg_tr.py
	set browsedepsg "/usr/share/proj/epsg"
        set epsgLocation "newLocation"
        set epsg_code ""
        set locpath $database
        
        # creation of the parameter window
        toplevel .optPopup
        wm title .optPopup {Define location using EPSG projection codes}
        # put it in the middle of the screen
        update idletasks
        set winWidth [winfo reqwidth .optPopup]
        set winHeight [winfo reqheight .optPopup]
        set scrnWidth [winfo screenwidth .optPopup]
        set scrnHeight [winfo screenheight .optPopup]
        set x [expr ($scrnWidth - $winWidth) / 2-250]
        set y [expr ($scrnHeight  - $winHeight) / 2]
        wm geometry .optPopup +$x+$y
        wm deiconify .optPopup
        
        #create the form and buttons
        label .optPopup.input1_ppb -text [G_msg "Name of new location"] -justify right -height 2
        entry .optPopup.input1_ppbEntry -textvariable epsgLocation -width 35 -bg white
        label .optPopup.input2_ppb -text [G_msg "Path to new location"] -justify right -height 2
        entry .optPopup.input2_ppbEntry -textvariable locpath  -width 35 -bg white
        label .optPopup.input3_ppb -text [G_msg "Path to the EPSG-codes file"] -justify right -height 2
        entry .optPopup.input3_ppbEntry -textvariable browsedepsg  -width 35 -bg white
        label .optPopup.input4_ppb -text [G_msg "EPSG code number of projection"] -justify right -height 2
        entry .optPopup.input4_ppbEntry -textvariable epsg_code  -width 35 -bg white
        
		#browse for database path
        button .optPopup.db -justify center -width 12 -text [G_msg "Browse..."] \
			-command "set locpath \[tk_getOpenFile\]" 

        bind .optPopup.db <Leave> {
             if {$locpath == ""} {
                set locpath $database
            }
        }

		#browse for epsg file
        button .optPopup.browseepsgfile -justify center -width 12 -text [G_msg "Browse..."] \
			-command "set browsedepsg \[tk_getOpenFile\]" 
                                        
        bind .optPopup.input3_ppbEntry <Leave> {
             if {$browsedepsg == ""} {
                set browsedepsg "/usr/share/proj/epsg"
            }
        }

		#browse epsg codes in file
        button .optPopup.codes 	-justify center -width 12 -text [G_msg "Browse..."] \
			-command {
				if {[file exists $browsedepsg]== 0} {
					DialogGen .wrnDlg [G_msg "WARNING: epsg-codes file not found"] warning \
					[G_msg "WARNING: The epsg-codes file was not found!"] \
					0 OK;
				}
				if {[file exists $browsedepsg]== 1} {
					codesEpsg;
				}
			}
                                
                                     
        pack .optPopup.codes -side left -fill both -expand 0
        
        button .optPopup.param 	-justify center -bg honeydew2 -text [G_msg "Help"] \
                        -command {infoEpsg}
        pack .optPopup.param -side left -fill both -expand 0
        
        button .optPopup.submit 	-justify center -width 15 -text [G_msg "Define location"] -state disabled\
			-command {
				set thelocation "$locpath/$epsgLocation";
				if {[file exists $thelocation ]== 1} {
					DialogGen .wrnDlg [G_msg "WARNING: location exists"] warning \
					[G_msg "WARNING: The location '$thelocation' already exists, please try another name"] \
					0 OK;
				}
				if {[file exists $browsedepsg]== 0} {
					DialogGen .wrnDlg [G_msg "WARNING: epsg-codes file not found"] warning \
					[G_msg "WARNING: The epsg-codes file was not found!"] \
					0 OK;
				}
				if {[file exists $browsedepsg]== 1} {
					if {[file exists $thelocation ]==0} {  
						destroy .optPopup; 
						exec -- $env(GISBASE)/etc/grass-xterm-wrapper -e $env(GISBASE)/etc/make_location_epsg.sh \
							$epsg_code $epsgLocation $locpath >@stdout 2>@stderr; 
						DialogGen .wrnDlg [G_msg "WARNING: restart GRASS please"] warning \
						[G_msg "WARNING: Please restart GRASS in order find the created location in the list (closing it for you now)"] \
							0 OK; 
						set env(EPSGSCRIPT) {yes};
						puts stdout "exit";
						destroy . 
					}
				}
				set thelocation ""
			 }
			
        bind .optPopup.input4_ppbEntry <KeyRelease> {
            .optPopup.submit configure -state active
        }

        pack .optPopup.submit -side left -fill both -expand 0
        
        button .optPopup.cancel -justify center -width 15 -text [G_msg "Cancel"] \
                        -command {destroy .optPopup}
        pack .optPopup.submit -side left -fill both -expand 0

        # geometry
        grid .optPopup.input1_ppb -row 0 -column 0 -sticky e
        grid .optPopup.input1_ppbEntry 	-row 0 -column 1 -columnspan 2
        
        grid .optPopup.input2_ppb 	-row 1 -column 0 -sticky e
        grid .optPopup.input2_ppbEntry 	-row 1 -column 1 -columnspan 2
        grid .optPopup.db   -row 1 -column 3 
        
        grid .optPopup.input3_ppb 	-row 2 -column 0 -sticky e
        grid .optPopup.input3_ppbEntry 	-row 2 -column 1 -columnspan 2
        grid .optPopup.browseepsgfile   -row 2 -column 3 
        
        grid .optPopup.input4_ppb 	-row 3 -column 0 -sticky e
        grid .optPopup.input4_ppbEntry 	-row 3 -column 1 -columnspan 2
        grid .optPopup.codes 		-row 3 -column 3 
        
        grid .optPopup.submit 		-row 4 -column 0
        grid .optPopup.cancel 		-row 4 -column 1
        grid .optPopup.param 		-row 4 -column 2 
}

# listing of the EPSG codes
proc codesEpsg args {
    
        global browsedepsg
    
        toplevel .infoPopup
        wm title .infoPopup {EPSG-codes}
        update idletasks
        set winWidth [winfo reqwidth .infoPopup]
        set winHeight [winfo reqheight .infoPopup]
        set scrnWidth [winfo screenwidth .infoPopup]
        set scrnHeight [winfo screenheight .infoPopup]
        set x [expr ($scrnWidth - $winWidth) / 2-230]
        set y [expr ($scrnHeight  - $winHeight) / 2 - 110]
        wm geometry .infoPopup +$x+$y
        wm deiconify .infoPopup
        
        text .infoPopup.text -width 100 -height 50\
                   -wrap word \
                   -relief raised \
                   -yscrollcommand ".infoPopup.vscroll set"
                   
        # tag configuration
        .infoPopup.text tag configure underline -underline 1
        .infoPopup.text tag configure title -relief sunken -borderwidth 2 \
        	-background white -foreground "medium blue" -justify center
        .infoPopup.text tag configure lefttitle -relief flat  
        .infoPopup.text tag configure subtitle -relief flat -background beige
    
        
        # the text to be inserted
        .infoPopup.text insert end [format " \n %s\n\n" [format [G_msg "EPSG CODES (from file: %s)"] $browsedepsg]] title
        .infoPopup.text insert end " \n" lefttitle
        .infoPopup.text insert end " \n\n" subtitle
        
        # open the file 
        set f [open $browsedepsg "r"]
        set found ""
        while { [eof $f] == 0 } {
            set line [gets $f]
            set firstdash [string first # $line]
            set firstminor [string first < $line]
            if {$firstdash == "0"} {
                .infoPopup.text insert end "\n$line\n" lefttitle
                set found "yes"
            }
            if {$firstminor == "0"} {
                .infoPopup.text insert end "\n$line\n\n" subtitle
            }
            if {$firstminor != "0" && $firstdash != "0" && $found != "yes"} {
                .infoPopup.text insert end [format "\n\n%s\n\n" [G_msg "GUESS THAT IS NOT THE EPSG FILE"]] title;
                break;
            }
        }
        
        pack .infoPopup.text -side left -fill y 
        
        scrollbar .infoPopup.vscroll \
                    -relief sunken \
                    -command ".infoPopup.text yview"
        pack .infoPopup.vscroll -side right -fill y
        
        button .infoPopup.ex -justify center -width 6 -text [G_msg "Close"] \
                             -command {destroy .infoPopup}			
        pack .infoPopup.ex -side bottom -expand 1 -fill both
}

# help for the EPSG Location creation
proc infoEpsg args {

        toplevel .infoPopup
        wm title .infoPopup {Info}
        update idletasks
        set winWidth [winfo reqwidth .infoPopup]
        set winHeight [winfo reqheight .infoPopup]
        set scrnWidth [winfo screenwidth .infoPopup]
        set scrnHeight [winfo screenheight .infoPopup]
        set x [expr ($scrnWidth - $winWidth) / 2-230]
        set y [expr ($scrnHeight  - $winHeight) / 2]
        wm geometry .infoPopup +$x+$y
        wm deiconify .infoPopup
        
        text .infoPopup.text -width 40 -height 30\
                   -wrap word \
                   -relief raised \
                   -yscrollcommand ".infoPopup.vscroll set"
                   
        # tag configuration
        .infoPopup.text tag configure underline -underline 1
        .infoPopup.text tag configure title -relief raised -borderwidth 2 -background grey -justify center
        .infoPopup.text tag configure subtitle -relief flat -borderwidth 1 
        .infoPopup.text tag configure info -relief sunken -borderwidth 1 -background white 
    
        # the text to be inserted
        .infoPopup.text insert end [G_msg " \nCREATION OF A NEW GRASS LOCATION WITH EPSG\n "] title
        .infoPopup.text insert end [G_msg "- needed parameters -\n\n"] title
        .infoPopup.text insert end "\n" 
        .infoPopup.text insert end [G_msg "\n   Name of new location:\n\n"] subtitle
        .infoPopup.text insert end [G_msg "\nRequires as input the name of the new location to be created\n\n"] info
        .infoPopup.text insert end "\n" 
        .infoPopup.text insert end [G_msg "\n   Path to location:\n\n"] subtitle
        .infoPopup.text insert end [G_msg "\nThe folder (GRASS database) in which the location should be created\n\n"] info
        .infoPopup.text insert end "\n" 
        .infoPopup.text insert end [G_msg "\n   EPSG code number of projection:\n\n"] subtitle
        .infoPopup.text insert end [G_msg "\nEPSG code number of projection (see /usr/share/proj/epsg or push the 'EPSG-codes' button)\n\n"] info
        
        pack .infoPopup.text -side left -fill both 
        
        scrollbar .infoPopup.vscroll \
                    -relief raised \
                    -command ".infoPopup.text yview"
        pack .infoPopup.vscroll -side right -fill y
        
        button .infoPopup.ex -justify center -width 6 -text [G_msg "OK"] \
                             -command {destroy .infoPopup}			
        pack .infoPopup.ex -side bottom -expand 1 -fill both
}


