#%% begin initialize heimdal-1.0-i386
export PATH=/bin:/usr/bin:/sbin:/usr/sbin

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

cd $ROOT/

TEMPLATE=$ROOT/usr/heimdal/etc/krb5.conf.template
KRB5CONF=$ROOT/etc/krb5.conf
#dname=`hostname -d`
if ! dname=`dnsdomainname`; then
  if [ -f $ROOT/etc/HOSTNAME ]; then
    dname=`cat $ROOT/etc/HOSTNAME  | cut -f2- -d.`
  fi
fi
if [ "_$dname" = "_" ]; then
  dname="localdomain"
fi
rname=`echo $dname | tr '[:lower:]' '[:upper:]'`
sed -e "s/REALM.NAME/$rname/" \
    -e "s/domain.name/$dname/" $TEMPLATE > ${KRB5CONF}.default-plamo
if [ ! -f $KRB5CONF ]; then
  cp ${KRB5CONF}.default-plamo ${KRB5CONF}
fi

if ! fgrep "/usr/heimdal/lib" $ROOT/etc/ld.so.conf 1> /dev/null 2>&1; then
  echo "/usr/heimdal/lib" >> $ROOT/etc/ld.so.conf

  if [ "$ROOT" != "" ] ; then
    /sbin/ldconfig
  fi
fi


if ! fgrep "Id: services.append,v 1.6" $ROOT/etc/services 1> /dev/null 2>&1; then
  cat $ROOT/usr/heimdal/etc/services.append >> $ROOT/etc/services
  echo "extra services are appended in $ROOT/etc/services."

  kill -HUP `pidof inetd`
fi


if [ -d $ROOT/usr/info ]; then
  INF_DIR=$ROOT/usr/info
else
  if [ -d $ROOT/usr/share/info ]; then
    INF_DIR=$ROOT/usr/share/info
  else
    if [ -d $ROOT/usr/local/info ]; then
      INF_DIR=$ROOT/usr/local/info
    fi
  fi
fi
if [ ."$INF_DIR" != ."" ]; then
  cp -p $ROOT/usr/heimdal/info/heimdal.info* $ROOT/$INF_DIR/
  /sbin/mkinfodir
fi


( cd $ROOT/usr/bin ; rm -rf krb5-config )
( cd $ROOT/usr/bin ; ln -sf ../heimdal/bin/krb5-config krb5-config )

#%% end


( cd usr/heimdal/lib ; rm -rf libroken.so.18 )
( cd usr/heimdal/lib ; ln -sf libroken.so.18.1.0 libroken.so.18 )
( cd usr/heimdal/lib ; rm -rf libroken.so )
( cd usr/heimdal/lib ; ln -sf libroken.so.18.1.0 libroken.so )
( cd usr/heimdal/lib ; rm -rf libeditline.so.0 )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so.0 )
( cd usr/heimdal/lib ; rm -rf libeditline.so )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so )
( cd usr/heimdal/lib ; rm -rf libsl.so.0 )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.2.1 libsl.so.0 )
( cd usr/heimdal/lib ; rm -rf libsl.so )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.2.1 libsl.so )
( cd usr/heimdal/lib ; rm -rf libss.so.0 )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.6 libss.so.0 )
( cd usr/heimdal/lib ; rm -rf libss.so )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.6 libss.so )
( cd usr/heimdal/lib ; rm -rf libasn1.so.8 )
( cd usr/heimdal/lib ; ln -sf libasn1.so.8.0.0 libasn1.so.8 )
( cd usr/heimdal/lib ; rm -rf libasn1.so )
( cd usr/heimdal/lib ; ln -sf libasn1.so.8.0.0 libasn1.so )
( cd usr/heimdal/lib ; rm -rf libhx509.so.1 )
( cd usr/heimdal/lib ; ln -sf libhx509.so.1.1.0 libhx509.so.1 )
( cd usr/heimdal/lib ; rm -rf libhx509.so )
( cd usr/heimdal/lib ; ln -sf libhx509.so.1.1.0 libhx509.so )
( cd usr/heimdal/lib ; rm -rf libkrb5.so.22 )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.22.1.0 libkrb5.so.22 )
( cd usr/heimdal/lib ; rm -rf libkrb5.so )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.22.1.0 libkrb5.so )
( cd usr/heimdal/lib ; rm -rf libheimntlm.so.0 )
( cd usr/heimdal/lib ; ln -sf libheimntlm.so.0.1.0 libheimntlm.so.0 )
( cd usr/heimdal/lib ; rm -rf libheimntlm.so )
( cd usr/heimdal/lib ; ln -sf libheimntlm.so.0.1.0 libheimntlm.so )
( cd usr/heimdal/lib ; rm -rf libkafs.so.0 )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.5.1 libkafs.so.0 )
( cd usr/heimdal/lib ; rm -rf libkafs.so )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.5.1 libkafs.so )
( cd usr/heimdal/lib ; rm -rf libgssapi.so.2 )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.2.0.0 libgssapi.so.2 )
( cd usr/heimdal/lib ; rm -rf libgssapi.so )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.2.0.0 libgssapi.so )
( cd usr/heimdal/lib ; rm -rf libhdb.so.9 )
( cd usr/heimdal/lib ; ln -sf libhdb.so.9.2.0 libhdb.so.9 )
( cd usr/heimdal/lib ; rm -rf libhdb.so )
( cd usr/heimdal/lib ; ln -sf libhdb.so.9.2.0 libhdb.so )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so.8 )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.8.0.1 libkadm5srv.so.8 )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.8.0.1 libkadm5srv.so )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so.7 )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.7.0.1 libkadm5clnt.so.7 )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.7.0.1 libkadm5clnt.so )
( cd usr/heimdal/lib ; rm -rf libotp.so.0 )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.5 libotp.so.0 )
( cd usr/heimdal/lib ; rm -rf libotp.so )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.5 libotp.so )
( cd usr/heimdal/lib ; rm -rf libkdc.so.2 )
( cd usr/heimdal/lib ; ln -sf libkdc.so.2.0.0 libkdc.so.2 )
( cd usr/heimdal/lib ; rm -rf libkdc.so )
( cd usr/heimdal/lib ; ln -sf libkdc.so.2.0.0 libkdc.so )
( cd usr/heimdal/lib ; rm -rf windc.so.0 )
( cd usr/heimdal/lib ; ln -sf windc.so.0.0.0 windc.so.0 )
( cd usr/heimdal/lib ; rm -rf windc.so )
( cd usr/heimdal/lib ; ln -sf windc.so.0.0.0 windc.so )
( cd usr/heimdal/bin ; rm -rf kauth )
( cd usr/heimdal/bin ; ln -sf kinit kauth )
