#!/bin/sh

BUILDSCRIPT=`pwd`/$0
PKGDIR=`pwd`/pkg_gcl
ARCH=i386
PVER=P1
MANDIR=/usr/share/man
DOCDIR=/usr/share/doc
INFODIR=/usr/share/info

WISHVERSION=8.3

SWNAME=gcl-2.5.3
rm -rf $SWNAME
tar zxf $SWNAME.tar.gz

cd $SWNAME

patch -p1 <<EOF
--- gcl-2.5.2/configure.orig	2003-03-03 00:23:17.000000000 +0900
+++ gcl-2.5.2/configure	2003-04-29 19:33:48.000000000 +0900
@@ -5186,8 +5186,6 @@
 echo "configure:5187: checking emacs site lisp directory" >&5
 if [ "\$EMACS" != "" ]  && [ "\$EMACS_SITE_LISP" = "unknown" ] ; then
 	EMACS_SITE_LISP=\`\$EMACS -q -batch --no-site-file -l conftest.el 2>&1 | sed -e /Loading/d | sed -e /load/d \`
-else
-	EMACS_SITE_LISP=""
 fi
 echo "\$ac_t""\$EMACS_SITE_LISP" 1>&6
 
EOF

./configure --enable-machine=386-linux --host=i386-pc-linux-gnu --prefix=/usr --enable-readine --enable-emacsdir=/usr/share/emacs/site-lisp --enable-infodir=$INFODIR --mandir=$MANDIR
make

rm -rf $PKGDIR
mkdir -p ${PKGDIR}/usr
make install DESTDIR=$PKGDIR

mkdir -p ${PKGDIR}${DOCDIR}/$SWNAME
mv ${PKGDIR}${DOCDIR}/gcl-doc ${PKGDIR}${DOCDIR}/$SWNAME/.
cp -p $BUILDSCRIPT COPYING.LIB-* ChangeLog ChangeLog.old RELEASE-* readme* faq ${PKGDIR}${DOCDIR}/$SWNAME/.
( cd ${PKGDIR}/usr/lib/${SWNAME}/info 
  RMLIST=`/bin/ls`
  gzip *.info-?
  gzip *.info-??
  mkdir -p ${PKGDIR}${INFODIR}
  cd ${PKGDIR}${INFODIR}
  rm $RMLIST
  ln -s ../../lib/${SWNAME}/info/* .
)
mkdir -p ${PKGDIR}${MANDIR}
cp -dpuR man/man1 ${PKGDIR}${MANDIR}/.
gzip ${PKGDIR}${MANDIR}/man1/*.1

cd ${PKGDIR}
rm ./${INFODIR}/dir
chown -R root:root ./${DOCDIR}
chown -R root:root ./${MANDIR}
chown -R root:root usr/lib

/sbin/makepkg ${SWNAME}-${ARCH}-${PVER}.tgz <<EOF
y
y
EOF
cat >> install/doinst.sh <<EOF
#%% begin initialize $SWNAME
if [ -x /usr/bin/install-info ] ; then
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl.info
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl-si.info
 /usr/bin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl-tk.info
elif [ -x usr/sbin/install-info ] ; then
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl.info
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl-si.info
 /usr/sbin/install-info --info-dir=${INFODIR} ${INFODIR}/gcl-tk.info
fi
#%% end
EOF
tar zcf ${SWNAME}-${ARCH}-${PVER}.tgz usr install

