//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDSOCKET_H
#define WSDSOCKET_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSCstring.h>

class WSDsocket :public WSCroot{
  
  protected:
    WSCushort _port;
    WSCulong _addr;
    WSCstring _naddr;
    WSCulong _dest_addr;
    WSCstring _dest_naddr;
    WSCushort _dest_port;
    WSCulong _timeout;
    WSCulong _cl_timeout;
    void*    _user_data;
    WSCbool _started_accept;
    WSCbool _stop_accept;
    WSCbool _udp;
    WSCbool _udp_binded;

    WSClistData _sock_list;

    virtual long destroy();
    virtual long initialize();
static WSDsocket* (*_chandler)();

  public:
    void _set_dest_addr_(WSCulong addr); 

    WSDsocket();
    virtual ~WSDsocket();

    long setPort(WSCushort);
    long setAddr(char* addr);

    long setDestPort(WSCushort);
    long setDestAddr(char* addr); 

    WSCushort getPort();
    WSCushort getDestPort();

    WSCstring getAddr();
    WSCstring getDestAddr();

    virtual void* accept();

    virtual long acceptEx(void(*)(WSDsocket*,void*,WSCulong));
    virtual long _continue_udp_read_accept();

    virtual long stopAcceptEx();
    virtual long listen();
    virtual long connect();
    virtual long close(void* sock= NULL);

//    virtual WSCbool checkData();
    virtual long read(void* handle,WSCuchar* buffer,long size);
    virtual long write(void* handle,WSCuchar* buffer,long size);
    virtual long read(WSCuchar* buffer,long size);
    virtual long write(WSCuchar* buffer,long size);

    WSCbool getAcceptStarted();

static void setCreateHandler(WSDsocket* (*)());

static WSDsocket* getNewInstance();
     void setTimeout(WSCulong timeout);
     void setClTimeout(WSCulong timeout);

     WSCulong getTimeout();
     WSCulong getClTimeout();

     void setUserData(void*);
     void* getUserData();

     void setIsUdp(WSCbool);
     WSCbool getIsUdp();
     virtual WSCstring getLastError();

    WSMFclassDef(WSDsocket,WSDres);
};
#endif //WSDSOCKET_H
