//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVTGLBTN_H
#define WSCVTGLBTN_H

#include <WScom.h>
#include <WSCvlabel.h>
#define WSCvtoggle_VER  1000

class WSDkeyboard;
class WSClistData;

class WSCvtoggle :public WSCvlabel{

  private:
  protected:
    char*     _select_string;
    char*     _group_name;
    char*     _td_name;
    char*     _bd_name;
    char*     _ld_name;
    char*     _rd_name;
    char*     _tb_name;
    char*     _btb_name;
    short     _indicator_color;
    short     _select_color;
    short     _indicator_pixmap;
    short     _select_pixmap;
    short     _id;
    unsigned  _indicator_size:6;
    unsigned  _indicator_type:2;
    unsigned  _indicator_shadow_thick:4;
    unsigned  _indicator_on:1;
    unsigned  _enable_focus_move:1;
    unsigned  _unique:1;
    unsigned  _select_reset:1;
    unsigned  _press_status:1;
    unsigned  _toggle_status:1;

    WSMFpropertyDef(WSNselectString,    char*,   _select_string  );
    WSMFpropertyDef(WSNindicatorOn,     WSCbool, _indicator_on   );
    WSMFpropertyDef(WSNindicatorType,   WSCuchar, _indicator_type   );
    WSMFpropertyDef(WSNindicatorSize,   WSCuchar, _indicator_size   );
    WSMFpropertyDef(WSNindicatorShadow, WSCuchar, _indicator_shadow_thick );
    WSMFpropertyDef(WSNindicatorColor,  short,  _indicator_color );
    WSMFpropertyDef(WSNindicatorPixmap, short,  _indicator_pixmap );
    WSMFpropertyDef(WSNselectColor,     short,  _select_color );
    WSMFpropertyDef(WSNselectPixmap,    short,  _select_pixmap );
    WSMFpropertyDef(WSNunique,          WSCbool,   _unique       );
    WSMFpropertyDef(WSNgroup,           char*,     _group_name   );
    WSMFpropertyDef(WSNid,              short,     _id           );
    WSMFpropertyDef(WSNselectReset,     WSCbool,   _select_reset  );
    WSMFpropertyDef(WSNenableFocusMove, WSCbool,   _enable_focus_move);
    WSMFpropertyDef(WSNupward,     char*,    _td_name);
    WSMFpropertyDef(WSNdownward,  char*,     _bd_name);
    WSMFpropertyDef(WSNleftward,   char*,    _ld_name);
    WSMFpropertyDef(WSNrightward,   char*,   _rd_name);
    WSMFpropertyDef(WSNtab,   char*,   _tb_name);
    WSMFpropertyDef(WSNbacktab,   char*,   _btb_name);
    WSMFpropertyDef(WSNstatus,   WSCbool,   _toggle_status);

    virtual long _device_initialize();

    static WSClistData* _tgl_list;
    static WSClistData* _get_toggle_list();
    static void _key_handler(void*,WSDkeyboard*,WSCbool);

  public:
    WSCvtoggle(WSCbase*,char*);
    virtual ~WSCvtoggle();

    virtual void onMousePress(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onMouseOut();
    virtual void onValueChange(WSCbool);
    virtual void onSensitiveChange(WSCbool);
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onFocusChange(WSCbool);

    virtual long addProcedure(WSCprocedure*);
    virtual long draw();
    long setStatus(WSCbool state,WSCbool create_event = True);
    WSCbool getStatus();
    long getGroupValue();
    long setGroupValue(long);
    long clearGroupValue();

    WSMFguiClassDef(WSCvtoggle,WSCvlabel);
    WSMFversionDef(WSCvtoggle);
};
#endif
