//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCTEXTFIELD_H
#define WSCTEXTFIELD_H

#include <WScom.h>
#include <WSCform.h>
#include <WSDkeyboard.h>
#include <WSCvscrBar.h>

class WSCvmifield;
class WSCvscrBar;

#define WSCtextField_VER  1002

class WSCtextField   :public WSCform{

  protected:
    WSCvmifield* _ifd;
    WSCvscrBar*  _h_scr;
    WSCvscrBar*  _v_scr;
    WSCform*    _form;
    WSCushort _bw;
//    char*     _label_string;
    short     _bar_back_color;
    short     _work_back_color;
    WSCulong _vpos;
    WSCulong _hpos;
    char      _fw;
    char      _fh;
    unsigned  _margin:3;
    unsigned  _enable_input:1;
    unsigned  _font:4;

//    WSMFpropertyDef(WSNlabelString, char*,     _label_string  );
    WSMFpropertyDef(WSNworkBackColor, short,     _work_back_color  );
    WSMFpropertyDef(WSNbarThickness,  WSCushort, _bw   );
    WSMFpropertyDef(WSNbarShadowColor,short,     _bar_back_color   );
    WSMFpropertyDef(WSNmargin,  WSCuchar, _margin);
    WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input);
    WSMFpropertyDef(WSNvbarValue,  WSCulong, _vpos);
    WSMFpropertyDef(WSNhbarValue,  WSCulong, _hpos);
    WSMFpropertyDef(WSNfont,WSCuchar,_font);

//    virtual void setWorkWSNlabelString(char*);
    virtual void setWorkWSNshadowThickness(WSCuchar);
    virtual void setWorkWSNforeColor(short);
    virtual void setWorkWSNtopShadowColor(short);
    virtual void setWorkWSNbottomShadowColor(short);
    virtual void setWorkWSNbackColor(short);
    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);

    static void _h_scr_work_op(WSCbase*);
    static void _ha_scr_work_op(WSCbase*);
    static void _v_scr_work_op(WSCbase*);
    static void _va_scr_work_op(WSCbase*);

    static void _valuech_work(WSCbase*);
    static void _keypress_work(WSCbase*);
    static void _keyrelease_work(WSCbase*);
    static void _keyhook_work(WSCbase*);
    static void _scr_mouse_press(WSCbase*);
    static void _scr_mouse_release(WSCbase*);
    static void _scr_mouse_move(WSCbase*);


//    virtual WSCbool _use_bscrbar_class();

    long _get_font_width();
    long _get_font_height();
    void _scr_adjust();
    virtual void _adjust();

  public:
    WSCtextField(WSCbase*,char*);
    virtual ~WSCtextField();

    virtual void onActivate();
    virtual void onValueChange();
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onKeyHook(WSDkeyboard*);
    virtual void onScrMousePress(WSCpoint*);
    virtual void onScrMouseRelease(WSCpoint*);
    virtual void onScrMouseMove(WSCpoint*);
    virtual void onMousePress(WSCpoint*);


static void setUseScrBarClass(char*);
static char* getUseScrBarClass();

    virtual long initialize();
    virtual long draw();
    virtual WSCbase* getPropertyInheritChild();

    WSCbase* getTextFrame();
    virtual void update();
    virtual char* getDefaultProperty();

    void addString(char*,long encode = WS_EN_DEFAULT);
    WSCushort* getBuf(); 

    void replaceSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSCstring getSelectedString();
    WSCstring getString();
    void deleteSelectedString();
    long setSelect(long,long);
    long getSelectedPos();

    long getLines();
    long getTopLine();
    long setTopLine(long pos);
    long getBottomLine();
    long setBottomLine(long pos);

    WSMFguiClassDef(WSCtextField,WSCform);
    WSMFversionDef(WSCtextField);
};
#endif
