//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCFILESELECT_H
#define WSCFILESELECT_H

#include <WScom.h>
#include <WSCbaseDialog.h>

class WSCscrForm;
class WSCvbtn;
class WSCform;
class WSCvlabel;
class WSCoption;
class WSCvtoggle;
class WSCvifield;
class WSCbaseDialog;
class WSCinputDialog;

#define WSCfileSelect_VER  1001

class WSCfileSelect :public WSCbaseDialog{

  protected:
    char* _dir_name;
    char* _file_name;
    char* _mask_name;
    WSClistData _icon_list;
    WSClistData _label_list;
    WSCscrForm*  _form;
    WSCform*     _form2;
    WSCvifield*  _dir_if;
    WSCvifield*  _file_if;
    WSCvifield*  _mask_if;
    WSCscrForm*  _scr_form;
//    WSCform*     _scr_form2;
    WSCvlabel*   _sp1;
    WSCvlabel*   _sp2;
    WSCbase*     _dtitle2;
    WSCbase*     _dtitle3;
    WSCvbtn*     _up_btn;
    WSCvbtn*     _mkdir_btn;
    WSCinputDialog*  _mkdir_dlg;
    short     _wbg_no;
    WSCstring _provider_name;
    WSCstring _workgroup_name;


    unsigned     _select_dir:1;
    unsigned     _need_update_fl:1;
    unsigned     _desktop:1;
    unsigned     _network:1;
    WSMFpropertyDef(WSNdirName,     char*, _dir_name ); 
    WSMFpropertyDef(WSNfileName,    char*, _file_name); 
    WSMFpropertyDef(WSNmaskFileName,char*, _mask_name); 
    WSMFpropertyDef(WSNselectDir,   WSCbool, _select_dir); 
    WSMFpropertyDef(WSNworkBackColor,  short,      _wbg_no );

    void _adjust();
    void _update_list();

    static  void _mkdir_btn_work(WSCbase*);
    static  void _up_btn_work(WSCbase*);
    static  void _set_btn_work(WSCbase*);
    static  void _label_btn_work(WSCbase*);
    static  void _dir_if_work(WSCbase*);
    static  void _label_btn_key_work(WSCbase*);

    virtual void setWorkWSNwidth(WSCushort );
    virtual void setWorkWSNheight(WSCushort );
  public:
    WSCfileSelect(WSCbase*,char*);
    virtual ~WSCfileSelect();

    virtual long initialize();
    char* getFileName();

    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onActivate();
    virtual void onResize(WSCrect*);
    virtual void onGuiPolicyChange(long);
    virtual void update();

    WSMFguiClassDef(WSCfileSelect,WSCbaseDialog);
    WSMFversionDef(WSCfileSelect);
};
extern WSDLEX WSCfileSelect* WSGIappFileSelect();
#endif
