/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.io.Serializable;
import javax.accessibility.Accessible;

public class Scrollbar
extends Component
implements Accessible,
Adjustable,
Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final long serialVersionUID = 8451667562882310543L;
    private int lineIncrement;
    private int pageIncrement;
    private int maximum;
    private int minimum;
    private int orientation;
    private int value;
    private int visibleAmount;
    private AdjustmentListener adjustment_listeners;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int orientation) throws IllegalArgumentException {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visibleAmount, int minimum, int maximum) throws IllegalArgumentException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
        this.setValues(value, visibleAmount, minimum, maximum);
        this.lineIncrement = 1;
        this.pageIncrement = (maximum - minimum) / 5;
        if (this.pageIncrement == 0) {
            this.pageIncrement = 1;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.setValues(value, this.visibleAmount, this.minimum, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.setValues(this.value, this.visibleAmount, this.minimum, maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.setValues(this.value, this.visibleAmount, minimum, this.maximum);
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public int getVisible() {
        return this.getVisibleAmount();
    }

    public void setVisibleAmount(int visibleAmount) {
        this.setValues(this.value, visibleAmount, this.minimum, this.maximum);
    }

    public synchronized void setValues(int value, int visibleAmount, int minimum, int maximum) {
        int range;
        if (maximum < minimum) {
            maximum = minimum;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum) {
            value = maximum;
        }
        if (visibleAmount > value) {
            visibleAmount = value;
        }
        this.value = value;
        this.visibleAmount = visibleAmount;
        this.minimum = minimum;
        this.maximum = maximum;
        ScrollbarPeer sp = (ScrollbarPeer)this.getPeer();
        if (sp != null) {
            sp.setValues(value, visibleAmount, minimum, maximum);
        }
        if (this.lineIncrement > (range = maximum - minimum)) {
            this.lineIncrement = range == 0 ? 1 : range;
            if (sp != null) {
                sp.setLineIncrement(this.lineIncrement);
            }
        }
        if (this.pageIncrement > range) {
            this.pageIncrement = range == 0 ? 1 : range;
            if (sp != null) {
                sp.setPageIncrement(this.pageIncrement);
            }
        }
    }

    public int getUnitIncrement() {
        return this.lineIncrement;
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public synchronized void setUnitIncrement(int unitIncrement) {
        if (unitIncrement < 0) {
            throw new IllegalArgumentException("Unit increment less than zero.");
        }
        int range = this.maximum - this.minimum;
        if (unitIncrement > range) {
            unitIncrement = range == 0 ? 1 : range;
        }
        if (unitIncrement == this.lineIncrement) {
            return;
        }
        this.lineIncrement = unitIncrement;
        ScrollbarPeer sp = (ScrollbarPeer)this.getPeer();
        if (sp != null) {
            sp.setLineIncrement(this.lineIncrement);
        }
    }

    public void setLineIncrement(int lineIncrement) {
        this.setUnitIncrement(lineIncrement);
    }

    public int getBlockIncrement() {
        return this.pageIncrement;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public synchronized void setBlockIncrement(int blockIncrement) {
        if (blockIncrement < 0) {
            throw new IllegalArgumentException("Block increment less than zero.");
        }
        int range = this.maximum - this.minimum;
        if (blockIncrement > range) {
            blockIncrement = range == 0 ? 1 : range;
        }
        if (blockIncrement == this.pageIncrement) {
            return;
        }
        this.pageIncrement = blockIncrement;
        ScrollbarPeer sp = (ScrollbarPeer)this.getPeer();
        if (sp != null) {
            sp.setPageIncrement(this.pageIncrement);
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.setBlockIncrement(pageIncrement);
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        super.addNotify();
    }

    public synchronized void addAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.add(this.adjustment_listeners, listener);
        this.enableEvents(256);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.remove(this.adjustment_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent event) {
        if (this.adjustment_listeners != null) {
            this.adjustment_listeners.adjustmentValueChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 601 && e.id >= 601 && (this.adjustment_listeners != null || (this.eventMask & (long)256) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "value=" + this.getValue() + ",visibleAmount=" + this.getVisibleAmount() + ",minimum=" + this.getMinimum() + ",maximum=" + this.getMaximum() + ",pageIncrement=" + this.pageIncrement + ",lineIncrement=" + this.lineIncrement + ",orientation=" + (this.orientation == 0 ? "HORIZONTAL" : "VERTICAL") + super.paramString();
    }
}

