// * This makes emacs happy -*-Mode: C++;-*-
/****************************************************************************
 * Copyright (c) 1998,1999,2000,2001 Free Software Foundation, Inc.         *
 *                                                                          *
 * Permission is hereby granted, free of charge, to any person obtaining a  *
 * copy of this software and associated documentation files (the            *
 * "Software"), to deal in the Software without restriction, including      *
 * without limitation the rights to use, copy, modify, merge, publish,      *
 * distribute, distribute with modifications, sublicense, and/or sell       *
 * copies of the Software, and to permit persons to whom the Software is    *
 * furnished to do so, subject to the following conditions:                 *
 *                                                                          *
 * The above copyright notice and this permission notice shall be included  *
 * in all copies or substantial portions of the Software.                   *
 *                                                                          *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
 * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
 *                                                                          *
 * Except as contained in this notice, the name(s) of the above copyright   *
 * holders shall not be used in advertising or otherwise to promote the     *
 * sale, use or other dealings in this Software without prior written       *
 * authorization.                                                           *
 ****************************************************************************/

/****************************************************************************
 *   Author: Juergen Pfeifer <juergen.pfeifer@gmx.net> 1997                 *
 ****************************************************************************/

// $Id: etip.h.in,v 1.22 2001/12/08 21:26:49 tom Exp $

#ifndef NCURSES_ETIP_H_incl
#define NCURSES_ETIP_H_incl 1

// These are substituted at configure/build time
#ifndef HAVE_BUILTIN_H
#define HAVE_BUILTIN_H 0
#endif

#ifndef HAVE_GXX_BUILTIN_H
#define HAVE_GXX_BUILTIN_H 0
#endif

#ifndef HAVE_GPP_BUILTIN_H
#define HAVE_GPP_BUILTIN_H 0
#endif

#ifndef HAVE_STRSTREAM_H
#define HAVE_STRSTREAM_H 0
#endif

#ifndef HAVE_TYPEINFO
#define HAVE_TYPEINFO 1
#endif

#ifndef HAVE_VALUES_H
#define HAVE_VALUES_H 0
#endif

#ifndef ETIP_NEEDS_MATH_H
#define ETIP_NEEDS_MATH_H 1
#endif

#ifndef ETIP_NEEDS_MATH_EXCEPTION
#define ETIP_NEEDS_MATH_EXCEPTION 0
#endif

#ifndef CPP_HAS_PARAM_INIT
#define CPP_HAS_PARAM_INIT 0
#endif

#ifndef USE_STRSTREAM_VSCAN
#define USE_STRSTREAM_VSCAN 0
#endif

#ifndef USE_STRSTREAM_VSCAN_CAST
#define USE_STRSTREAM_VSCAN 0
#endif

#ifdef __GNUG__
#  if ((__GNUG__ <= 2) && (__GNUC_MINOR__ < 8))
#    if HAVE_TYPEINFO
#      include <typeinfo>
#    endif
#  endif
#endif

#if defined(__GNUG__)
#  if HAVE_BUILTIN_H || HAVE_GXX_BUILTIN_H || HAVE_GPP_BUILTIN_H
#    if ETIP_NEEDS_MATH_H
#      if ETIP_NEEDS_MATH_EXCEPTION
#        undef exception
#        define exception math_exception
#      endif
#      include <math.h>
#    endif
#    undef exception
#    define exception builtin_exception
#    if HAVE_GPP_BUILTIN_H
#     include <gpp/builtin.h>
#    elif HAVE_GXX_BUILTIN_H
#     include <g++/builtin.h>
#    else
#     include <builtin.h>
#    endif
#    undef exception
#  endif
#elif defined (__SUNPRO_CC)
#  include <generic.h>
#  include <string.h>
#else
#  include <string.h>
#endif

#include <ncurses_dll.h>

extern "C" {
#if HAVE_VALUES_H
#  include <values.h>
#endif

#include <assert.h>
#include <eti.h>
#include <errno.h>
}

// Language features
#if CPP_HAS_PARAM_INIT
#define NCURSES_PARAM_INIT(value) = value
#else
#define NCURSES_PARAM_INIT(value) /*nothing*/
#endif

// Forward Declarations
class NCURSES_IMPEXP NCursesPanel;
class NCURSES_IMPEXP NCursesMenu;
class NCURSES_IMPEXP NCursesForm;

class NCURSES_IMPEXP NCursesException
{
public:
  const char *message;
  int errorno;

  NCursesException (const char* msg, int err)
    : message(msg), errorno (err)
    {};

  NCursesException (const char* msg)
    : message(msg), errorno (E_SYSTEM_ERROR)
    {};

  virtual const char *classname() const {
    return "NCursesWindow";
  }
};

class NCURSES_IMPEXP NCursesPanelException : public NCursesException
{
public:
  const NCursesPanel* p;

  NCursesPanelException (const char *msg, int err) :
    NCursesException (msg, err),
    p ((NCursesPanel*)0)
    {};

  NCursesPanelException (const NCursesPanel* panel,
			 const char *msg,
			 int err) :
    NCursesException (msg, err),
    p (panel)
    {};

  NCursesPanelException (int err) :
    NCursesException ("panel library error", err),
    p ((NCursesPanel*)0)
    {};

  NCursesPanelException (const NCursesPanel* panel,
			 int err) :
    NCursesException ("panel library error", err),
    p (panel)
    {};

  virtual const char *classname() const {
    return "NCursesPanel";
  }

};

class NCURSES_IMPEXP NCursesMenuException : public NCursesException
{
public:
  const NCursesMenu* m;

  NCursesMenuException (const char *msg, int err) :
    NCursesException (msg, err),
    m ((NCursesMenu *)0)
    {};

  NCursesMenuException (const NCursesMenu* menu,
			const char *msg,
			int err) :
    NCursesException (msg, err),
    m (menu)
    {};

  NCursesMenuException (int err) :
    NCursesException ("menu library error", err),
    m ((NCursesMenu *)0)
    {};

  NCursesMenuException (const NCursesMenu* menu,
			int err) :
    NCursesException ("menu library error", err),
    m (menu)
    {};

  virtual const char *classname() const {
    return "NCursesMenu";
  }

};

class NCURSES_IMPEXP NCursesFormException : public NCursesException
{
public:
  const NCursesForm* f;

  NCursesFormException (const char *msg, int err) :
    NCursesException (msg, err),
    f ((NCursesForm*)0)
    {};

  NCursesFormException (const NCursesForm* form,
			const char *msg,
			int err) :
    NCursesException (msg, err),
    f (form)
    {};

  NCursesFormException (int err) :
    NCursesException ("form library error", err),
    f ((NCursesForm*)0)
    {};

  NCursesFormException (const NCursesForm* form,
			int err) :
    NCursesException ("form library error", err),
    f (form)
    {};

  virtual const char *classname() const {
    return "NCursesForm";
  }

};

#if !(defined(__GNUG__)||defined(__SUNPRO_CC))
#  include <iostream.h>
   extern "C" void exit(int);
#endif

inline void THROW(const NCursesException *e) {
#if defined(__GNUG__)
#  if ((__GNUG__ <= 2) && (__GNUC_MINOR__ < 8))
      (*lib_error_handler)(e?e->classname():"",e?e->message:"");
#else
      throw *e;
#endif
#elif defined(__SUNPRO_CC)
#  if !defined(__SUNPRO_CC_COMPAT) || (__SUNPRO_CC_COMPAT < 5)
  genericerror(1, ((e != 0) ? (char *)(e->message) : ""));
#else
  throw *e;
#endif
#else
  if (e)
    cerr << e->message << endl;
  exit(0);
#endif
}

#define THROWS(s)

#endif // NCURSES_ETIP_H_incl
