/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.PropertyPermission;

public class SecurityManager {
    protected boolean inCheck;

    public SecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("createSecurityManager"));
        }
    }

    public boolean getInCheck() {
        return this.inCheck;
    }

    protected Class[] getClassContext() {
        return VMSecurityManager.getClassContext();
    }

    protected ClassLoader currentClassLoader() {
        return VMSecurityManager.currentClassLoader();
    }

    protected Class currentLoadedClass() {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].getClassLoader() == null) continue;
            return c[i];
        }
        return null;
    }

    protected int classDepth(String className) {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (!className.equals(c[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected int classLoaderDepth() {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].getClassLoader() == null) continue;
            return i;
        }
        return -1;
    }

    protected boolean inClass(String className) {
        return this.classDepth(className) != -1;
    }

    protected boolean inClassLoader() {
        return this.classLoaderDepth() != -1;
    }

    public Object getSecurityContext() {
        return new SecurityContext(this.getClassContext());
    }

    public void checkPermission(Permission perm) {
        throw new SecurityException("Operation not allowed");
    }

    public void checkPermission(Permission perm, Object context) {
        throw new SecurityException("Operation not allowed");
    }

    public void checkCreateClassLoader() {
        this.checkPermission(new RuntimePermission("createClassLoader"));
    }

    public void checkAccess(Thread t) {
        if (t.group != null && t.group.getParent() != null) {
            this.checkPermission(new RuntimePermission("modifyThread"));
        }
    }

    public void checkAccess(ThreadGroup g) {
        if (g.getParent() != null) {
            this.checkPermission(new RuntimePermission("modifyThreadGroup"));
        }
    }

    public void checkExit(int status) {
        this.checkPermission(new RuntimePermission("exitVM"));
    }

    public void checkExec(String program) {
        if (!program.equals(new File(program).getAbsolutePath())) {
            program = "<<ALL FILES>>";
        }
        this.checkPermission(new FilePermission(program, "execute"));
    }

    public void checkLink(String filename) {
        this.checkPermission(new RuntimePermission("loadLibrary." + filename.toString()));
    }

    public void checkRead(FileDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("readFileDescriptor"));
    }

    public void checkRead(String filename) {
        this.checkPermission(new FilePermission(filename, "read"));
    }

    public void checkRead(String filename, Object context) {
        throw new SecurityException("Cannot read files via file names.");
    }

    public void checkWrite(FileDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.checkPermission(new RuntimePermission("writeFileDescriptor"));
    }

    public void checkWrite(String filename) {
        this.checkPermission(new FilePermission(filename, "write"));
    }

    public void checkDelete(String filename) {
        this.checkPermission(new FilePermission(filename, "delete"));
    }

    public void checkConnect(String host, int port) {
        if (port == -1) {
            this.checkPermission(new SocketPermission(host, "resolve"));
        } else {
            this.checkPermission(new SocketPermission(host.toString() + ":" + port, "connect"));
        }
    }

    public void checkConnect(String host, int port, Object securityContext) {
        throw new SecurityException("Cannot make network connections.");
    }

    public void checkListen(int port) {
        this.checkPermission(new SocketPermission("localhost:" + (port == 0 ? "1024-" : "" + port), "listen"));
    }

    public void checkAccept(String host, int port) {
        this.checkPermission(new SocketPermission(host.toString() + ":" + port, "accept"));
    }

    public void checkMulticast(InetAddress addr) {
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
    }

    public void checkMulticast(InetAddress addr, byte ttl) {
        this.checkPermission(new SocketPermission(addr.getHostAddress(), "accept,connect"));
    }

    public void checkPropertiesAccess() {
        this.checkPermission(new PropertyPermission("*", "read,write"));
    }

    public void checkPropertyAccess(String key) {
        this.checkPermission(new PropertyPermission(key, "read"));
    }

    public boolean checkTopLevelWindow(Object window) {
        if (window == null) {
            throw new NullPointerException();
        }
        try {
            this.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void checkPrintJobAccess() {
        this.checkPermission(new RuntimePermission("queuePrintJob"));
    }

    public void checkSystemClipboardAccess() {
        this.checkPermission(new AWTPermission("accessClipboard"));
    }

    public void checkAwtEventQueueAccess() {
        throw new SecurityException("Cannot access the AWT event queue.");
    }

    public void checkPackageAccess(String packageName) {
        this.checkPackageList(packageName, "access", "accessClassInPackage.");
    }

    public void checkPackageDefinition(String packageName) {
        this.checkPackageList(packageName, "definition", "defineClassInPackage.");
    }

    public void checkSetFactory() {
        this.checkPermission(new RuntimePermission("setFactory"));
    }

    public void checkMemberAccess(Class c, int memberType) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (memberType == 0) {
            return;
        }
        this.checkPermission(new RuntimePermission("accessDeclaredMembers"));
    }

    public void checkSecurityAccess(String action) {
        this.checkPermission(new SecurityPermission(action));
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    void checkPackageList(String packageName, String restriction, String permission) {
        RuntimePermission p = new RuntimePermission(permission + packageName.toString());
        String list = Security.getProperty("package." + restriction);
        if (list == null) {
            return;
        }
        while (!"".equals(packageName)) {
            int index = list.indexOf(packageName);
            while (index != -1) {
                int packageNameCount = packageName.length();
                if (index + packageNameCount == list.length() || list.charAt(index + packageNameCount) == ',') {
                    this.checkPermission(p);
                    return;
                }
                index = list.indexOf(packageName, index + 1);
            }
            index = packageName.lastIndexOf(46);
            packageName = index < 0 ? "" : packageName.substring(0, index);
        }
    }
}

