/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.ValidatorAndPriority;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static final Class[] readObjectParams = new Class[]{ObjectInputStream.class$("java.io.ObjectInputStream")};
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Hashtable objectLookupTable;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private boolean readDataFromBlock;
    private boolean isDeserializing;
    private boolean fieldsAlreadyRead;
    private Vector validators;
    private static boolean dump;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public ObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this.resolveEnabled = false;
        this.isDeserializing = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(in);
        this.nextOID = 0x7E0000;
        this.objectLookupTable = new Hashtable();
        this.validators = new Vector();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object readObject() throws ClassNotFoundException, IOException {
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean was_deserializing = this.isDeserializing;
        boolean is_consumed = false;
        boolean old_mode = this.setBlockDataMode(false);
        this.isDeserializing = true;
        byte marker = this.realInputStream.readByte();
        this.dumpElement("MARKER: 0x" + Integer.toHexString(marker) + " ");
        try {
            switch (marker) {
                case 120: {
                    Object ret_val = null;
                    is_consumed = true;
                    return ret_val;
                }
                case 119: 
                case 122: {
                    if (marker == 122) {
                        this.dumpElementln("BLOCKDATALONG");
                    } else {
                        this.dumpElementln("BLOCKDATA");
                    }
                    this.readNextBlock(marker);
                    throw new StreamCorruptedException("Unexpected blockData");
                }
                case 112: {
                    this.dumpElementln("NULL");
                    Object ret_val = null;
                    return ret_val;
                }
                case 113: {
                    this.dumpElement("REFERENCE ");
                    Integer oid = new Integer(this.realInputStream.readInt());
                    this.dumpElementln(Integer.toHexString(oid));
                    Object ret_val = ((ObjectIdentityWrapper)this.objectLookupTable.get((Object)oid)).object;
                    return ret_val;
                }
                case 118: {
                    this.dumpElementln("CLASS");
                    ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                    Class clazz = osc.forClass();
                    this.assignNewHandle(clazz);
                    Object ret_val = clazz;
                    return ret_val;
                }
                case 125: {
                    this.dumpElementln("PROXYCLASS");
                    int n_intf = this.realInputStream.readInt();
                    String[] intfs = new String[n_intf];
                    for (int i = 0; i < n_intf; ++i) {
                        intfs[i] = this.realInputStream.readUTF();
                        System.out.println(intfs[i]);
                    }
                    boolean oldmode = this.setBlockDataMode(true);
                    Class cl = this.resolveProxyClass(intfs);
                    this.setBlockDataMode(oldmode);
                    ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
                    this.assignNewHandle(osc);
                    if (!is_consumed) {
                        byte b = this.realInputStream.readByte();
                        if (b != 120) {
                            throw new IOException("Data annotated to class was not consumed." + b);
                        }
                    } else {
                        is_consumed = false;
                    }
                    ObjectStreamClass superosc = (ObjectStreamClass)this.readObject();
                    osc.setSuperclass(superosc);
                    Object ret_val = osc;
                    return ret_val;
                }
                case 114: {
                    this.dumpElement("CLASSDESC NAME=");
                    String name = this.realInputStream.readUTF();
                    this.dumpElement(name + "; UID=");
                    long uid = this.realInputStream.readLong();
                    this.dumpElement(Long.toHexString(uid) + "; FLAGS=");
                    byte flags = this.realInputStream.readByte();
                    this.dumpElement(Integer.toHexString(flags) + "; FIELD COUNT=");
                    int field_count = this.realInputStream.readShort();
                    this.dumpElementln(Short.toString((short)field_count));
                    ObjectStreamField[] fields = new ObjectStreamField[field_count];
                    ObjectStreamClass osc = new ObjectStreamClass(name, uid, flags, fields);
                    this.assignNewHandle(osc);
                    for (int i = 0; i < field_count; ++i) {
                        this.dumpElement("  TYPE CODE=");
                        char type_code = (char)this.realInputStream.readByte();
                        this.dumpElement(type_code + "; FIELD NAME=");
                        String field_name = this.realInputStream.readUTF();
                        this.dumpElementln(field_name);
                        String class_name = type_code == 'L' || type_code == '[' ? (String)this.readObject() : String.valueOf(type_code);
                        fields[i] = new ObjectStreamField(field_name, class_name);
                    }
                    boolean oldmode = this.setBlockDataMode(true);
                    osc.setClass(this.resolveClass(osc));
                    this.setBlockDataMode(oldmode);
                    if (!is_consumed) {
                        byte b = this.realInputStream.readByte();
                        if (b != 120) {
                            throw new IOException("Data annotated to class was not consumed." + b);
                        }
                    } else {
                        is_consumed = false;
                    }
                    osc.setSuperclass((ObjectStreamClass)this.readObject());
                    Object ret_val = osc;
                    return ret_val;
                }
                case 116: 
                case 124: {
                    this.dumpElement("STRING=");
                    String s = this.realInputStream.readUTF();
                    this.dumpElementln(s);
                    Object ret_val = this.processResolution(s, this.assignNewHandle(s));
                    return ret_val;
                }
                case 117: {
                    this.dumpElementln("ARRAY");
                    ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                    Class componentType = osc.forClass().getComponentType();
                    this.dumpElement("ARRAY LENGTH=");
                    int length = this.realInputStream.readInt();
                    this.dumpElementln(length + "; COMPONENT TYPE=" + componentType);
                    Object array = Array.newInstance(componentType, length);
                    int handle = this.assignNewHandle(array);
                    this.readArrayElements(array, componentType);
                    int len = Array.getLength(array);
                    for (int i = 0; i < len; ++i) {
                        this.dumpElementln("  ELEMENT[" + i + "]=" + Array.get(array, i));
                    }
                    Object ret_val = this.processResolution(array, handle);
                    return ret_val;
                }
                case 115: {
                    Object ret_val;
                    this.dumpElementln("OBJECT");
                    ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                    Class clazz = osc.forClass();
                    if (!ObjectInputStream.class$("java.io.Serializable").isAssignableFrom(clazz)) {
                        throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                    }
                    if (ObjectInputStream.class$("java.io.Externalizable").isAssignableFrom(clazz)) {
                        Externalizable obj = null;
                        try {
                            obj = (Externalizable)clazz.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new ClassNotFoundException("Instance of " + clazz + " could not be created");
                        }
                        catch (IllegalAccessException e) {
                            throw new ClassNotFoundException("Instance of " + clazz + " could not be created because class or zero-argument constructor is not accessible");
                        }
                        catch (NoSuchMethodError e) {
                            throw new ClassNotFoundException("Instance of " + clazz + " could not be created because zero-argument constructor is not defined");
                        }
                        int handle = this.assignNewHandle(obj);
                        boolean read_from_blocks = (osc.getFlags() & 8) != 0;
                        boolean oldmode = this.readDataFromBlock;
                        if (read_from_blocks) {
                            this.setBlockDataMode(true);
                        }
                        obj.readExternal(this);
                        if (read_from_blocks) {
                            this.setBlockDataMode(oldmode);
                        }
                        ret_val = this.processResolution(obj, handle);
                        return ret_val;
                    }
                    Class first_nonserial = clazz.getSuperclass();
                    while (ObjectInputStream.class$("java.io.Serializable").isAssignableFrom(first_nonserial) || Modifier.isAbstract(first_nonserial.getModifiers())) {
                        first_nonserial = first_nonserial.getSuperclass();
                    }
                    Object obj = null;
                    obj = this.newObject(clazz, first_nonserial);
                    if (obj == null) {
                        throw new ClassNotFoundException("Instance of " + clazz + " could not be created");
                    }
                    int handle = this.assignNewHandle(obj);
                    this.currentObject = obj;
                    ObjectStreamClass[] hierarchy = ObjectStreamClass.getObjectStreamClasses(clazz);
                    for (int i = 0; i < hierarchy.length; ++i) {
                        this.currentObjectStreamClass = hierarchy[i];
                        this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                        if (this.currentObjectStreamClass.hasReadMethod()) {
                            this.fieldsAlreadyRead = false;
                            boolean oldmode = this.setBlockDataMode(true);
                            this.callReadMethod(obj, this.currentObjectStreamClass);
                            this.setBlockDataMode(oldmode);
                            this.dumpElement("ENDBLOCKDATA? ");
                            try {
                                if (this.realInputStream.readByte() != 120) {
                                    throw new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.");
                                }
                                this.dumpElementln("yes");
                            }
                            catch (EOFException e) {
                                this.dumpElementln("no, got EOFException");
                            }
                            catch (IOException e) {
                                this.dumpElementln("no, got IOException");
                            }
                            continue;
                        }
                        this.readFields(obj, this.currentObjectStreamClass);
                    }
                    this.currentObject = null;
                    this.currentObjectStreamClass = null;
                    ret_val = this.processResolution(obj, handle);
                    return ret_val;
                }
                case 121: {
                    this.dumpElementln("RESET");
                    this.clearHandles();
                    Object ret_val = this.readObject();
                    return ret_val;
                }
                case 123: {
                    this.dumpElement("EXCEPTION=");
                    Exception e = (Exception)this.readObject();
                    this.dumpElementln(e.toString());
                    this.clearHandles();
                    throw new WriteAbortedException("Exception thrown during writing of stream", e);
                }
                default: {
                    throw new IOException("Unknown marker on stream: " + marker);
                }
            }
        }
        finally {
            Object object = null;
            this.setBlockDataMode(old_mode);
            this.isDeserializing = was_deserializing;
            if (!was_deserializing && this.validators.size() > 0) {
                this.invokeValidators();
            }
        }
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean oldmode = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(oldmode);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation validator, int priority) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (validator == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        this.validators.addElement(new ValidatorAndPriority(validator, priority));
    }

    protected Class resolveClass(ObjectStreamClass osc) throws ClassNotFoundException, IOException {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager(this){
                private /* synthetic */ ObjectInputStream this$0;
                {
                    this.this$0 = this$0;
                }
            };
        }
        if ((cl = ObjectInputStream.currentClassLoader(sm)) == null) {
            return Class.forName(osc.getName());
        }
        return cl.loadClass(osc.getName());
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected Class resolveProxyClass(String[] intfs) throws IOException, ClassNotFoundException {
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager(this){
                private /* synthetic */ ObjectInputStream this$0;
                {
                    this.this$0 = this$0;
                }
            };
        }
        ClassLoader cl = ObjectInputStream.currentClassLoader(sm);
        Class[] clss = new Class[intfs.length];
        if (cl == null) {
            for (i = 0; i < intfs.length; ++i) {
                clss[i] = Class.forName(intfs[i]);
            }
            cl = ClassLoader.getSystemClassLoader();
        } else {
            for (i = 0; i < intfs.length; ++i) {
                clss[i] = cl.loadClass(intfs[i]);
            }
        }
        try {
            return Proxy.getProxyClass(cl, clss);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubtitution"));
        }
        boolean old_val = this.resolveEnabled;
        this.resolveEnabled = enable;
        return old_val;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        this.dumpElement("STREAM MAGIC ");
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        this.dumpElementln("STREAM VERSION ");
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition + length > this.blockDataBytes) {
                int remain = this.blockDataBytes - this.blockDataPosition;
                if (remain != 0) {
                    System.arraycopy(this.blockData, this.blockDataPosition, data, offset, remain);
                    offset += remain;
                    length -= remain;
                }
                this.readNextBlock();
            }
            System.arraycopy(this.blockData, this.blockDataPosition, data, offset, length);
            this.blockDataPosition += length;
            return length;
        }
        return this.realInputStream.read(data, offset, length);
    }

    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    public void close() throws IOException {
        this.realInputStream.close();
    }

    public boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    public int readInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public long readLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    public float readFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    public void readFully(byte[] data) throws IOException {
        this.dataInputStream.readFully(data);
    }

    public void readFully(byte[] data, int offset, int size) throws IOException {
        this.dataInputStream.readFully(data, offset, size);
    }

    public int skipBytes(int len) throws IOException {
        return this.dataInputStream.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        ObjectStreamClass clazz = this.currentObjectStreamClass;
        byte[] prim_field_data = new byte[clazz.primFieldSize];
        Object[] objs = new Object[clazz.objectFieldCount];
        boolean oldmode = this.setBlockDataMode(false);
        this.readFully(prim_field_data);
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.readObject();
        }
        this.setBlockDataMode(oldmode);
        return new GetField(this, objs, prim_field_data, clazz){
            private /* synthetic */ ObjectInputStream this$0;
            private /* synthetic */ Object[] val$objs;
            private /* synthetic */ byte[] val$prim_field_data;
            private /* synthetic */ ObjectStreamClass val$clazz;
            {
                this.this$0 = this$0;
                this.finit$(parm$objs, parm$prim_field_data, parm$clazz);
            }

            private /* synthetic */ void finit$(Object[] parm$objs, byte[] parm$prim_field_data, ObjectStreamClass parm$clazz) {
                this.val$clazz = parm$clazz;
                this.val$prim_field_data = parm$prim_field_data;
                this.val$objs = parm$objs;
            }

            public ObjectStreamClass getObjectStreamClass() {
                return this.val$clazz;
            }

            public boolean defaulted(String name) throws IOException, IllegalArgumentException {
                return this.val$clazz.getField(name) == null;
            }

            public boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Boolean.TYPE);
                if (field == null) {
                    return defvalue;
                }
                return this.val$prim_field_data[field.getOffset()] != 0;
            }

            public char get(String name, char defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Character.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (char)((this.val$prim_field_data[off++] & 0xFF) << 8 | this.val$prim_field_data[off] & 0xFF);
            }

            public byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Byte.TYPE);
                if (field == null) {
                    return defvalue;
                }
                return this.val$prim_field_data[field.getOffset()];
            }

            public short get(String name, short defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Short.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (short)((short)((this.val$prim_field_data[off++] & 0xFF) << 8) | (short)this.val$prim_field_data[off] & 0xFF);
            }

            public int get(String name, int defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Integer.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | this.val$prim_field_data[off] & 0xFF;
            }

            public long get(String name, long defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Long.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return (this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | (this.val$prim_field_data[off++] & 0xFF) << 0 | (this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | this.val$prim_field_data[off] & 0xFF;
            }

            public float get(String name, float defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Float.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Float.intBitsToFloat((this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | this.val$prim_field_data[off] & 0xFF);
            }

            public double get(String name, double defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, Double.TYPE);
                if (field == null) {
                    return defvalue;
                }
                int off = field.getOffset();
                return Double.longBitsToDouble((this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | (this.val$prim_field_data[off++] & 0xFF) << 0 | (this.val$prim_field_data[off++] & 0xFF) << 24 | (this.val$prim_field_data[off++] & 0xFF) << 16 | (this.val$prim_field_data[off++] & 0xFF) << 8 | this.val$prim_field_data[off] & 0xFF);
            }

            public Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
                ObjectStreamField field = this.getField(name, defvalue == null ? null : defvalue.getClass());
                if (field == null) {
                    return defvalue;
                }
                return this.val$objs[field.getOffset()];
            }

            private ObjectStreamField getField(String name, Class type) throws IllegalArgumentException {
                ObjectStreamField field = this.val$clazz.getField(name);
                if (field == null) {
                    return null;
                }
                Class field_type = field.getType();
                if (type == field_type || type == null && !field_type.isPrimitive()) {
                    return field;
                }
                throw new IllegalArgumentException("Field requested is of type " + field_type.getName() + ", but requested type was " + (type == null ? "Object" : type.getName()));
            }
        };
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private int assignNewHandle(Object obj) {
        this.objectLookupTable.put(new Integer(this.nextOID), new ObjectIdentityWrapper(obj));
        return this.nextOID++;
    }

    private Object processResolution(Object obj, int handle) throws IOException {
        if (obj instanceof Serializable) {
            Method m = null;
            try {
                Class[] classArgs = new Class[]{};
                m = obj.getClass().getDeclaredMethod("readResolve", classArgs);
                obj = m.invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException ignore) {
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException ignore) {
                // empty catch block
            }
        }
        if (this.resolveEnabled) {
            obj = this.resolveObject(obj);
        }
        this.objectLookupTable.put(new Integer(handle), new ObjectIdentityWrapper(obj));
        return obj;
    }

    private void clearHandles() {
        this.objectLookupTable.clear();
        this.nextOID = 0x7E0000;
    }

    private void readNextBlock() throws IOException {
        this.readNextBlock(this.realInputStream.readByte());
    }

    private void readNextBlock(byte marker) throws IOException {
        if (marker == 119) {
            this.dumpElement("BLOCK DATA SIZE=");
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            this.dumpElementln(Integer.toString(this.blockDataBytes));
        } else if (marker == 122) {
            this.dumpElement("BLOCK DATA LONG SIZE=");
            this.blockDataBytes = this.realInputStream.readInt();
            this.dumpElementln(Integer.toString(this.blockDataBytes));
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private void readArrayElements(Object array, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readBoolean();
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readByte();
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readChar();
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readDouble();
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readFloat();
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readInt();
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readLong();
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                for (int i = 0; i < cast_array.length; ++i) {
                    cast_array[i] = this.realInputStream.readShort();
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            for (int i = 0; i < cast_array.length; ++i) {
                cast_array[i] = this.readObject();
            }
        }
    }

    private void readFields(Object obj, ObjectStreamClass stream_osc) throws ClassNotFoundException, IOException {
        ObjectStreamField[] stream_fields = stream_osc.fields;
        ObjectStreamField[] real_fields = ObjectStreamClass.lookup((Class)stream_osc.forClass()).fields;
        String field_name = null;
        Class type = null;
        ObjectStreamField stream_field = null;
        ObjectStreamField real_field = null;
        int stream_idx = 0;
        int real_idx = 0;
        while (stream_idx < stream_fields.length && real_idx < real_fields.length) {
            boolean default_initialize = false;
            boolean set_value = true;
            if (stream_idx == stream_fields.length) {
                default_initialize = true;
            } else {
                stream_field = stream_fields[stream_idx];
                type = stream_field.getType();
            }
            if (real_idx == real_fields.length) {
                set_value = false;
            } else {
                real_field = real_fields[real_idx];
                type = real_field.getType();
                field_name = real_field.getName();
            }
            if (set_value && !default_initialize) {
                int comp_val = real_field.compareTo(stream_field);
                if (comp_val < 0) {
                    default_initialize = true;
                    ++real_idx;
                } else if (comp_val > 0) {
                    set_value = false;
                    ++stream_idx;
                } else {
                    ++real_idx;
                    ++stream_idx;
                }
            }
            try {
                Object value;
                int value2;
                if (type == Boolean.TYPE) {
                    int n = value2 = default_initialize ? 0 : this.realInputStream.readBoolean();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + (value2 != 0));
                    }
                    if (!set_value) continue;
                    this.setBooleanField(obj, stream_osc.forClass(), field_name, value2 != 0);
                    continue;
                }
                if (type == Byte.TYPE) {
                    value2 = (char)(default_initialize ? 0 : this.realInputStream.readByte());
                    char c = (char)value2;
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value2);
                    }
                    if (!set_value) continue;
                    this.setByteField(obj, stream_osc.forClass(), field_name, (byte)value2);
                    continue;
                }
                if (type == Character.TYPE) {
                    value2 = (char)(default_initialize ? 0 : this.realInputStream.readChar());
                    char c = (char)value2;
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + (char)value2);
                    }
                    if (!set_value) continue;
                    this.setCharField(obj, stream_osc.forClass(), field_name, (char)value2);
                    continue;
                }
                if (type == Double.TYPE) {
                    double value3;
                    double d = value3 = default_initialize ? 0.0 : this.realInputStream.readDouble();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value3);
                    }
                    if (!set_value) continue;
                    this.setDoubleField(obj, stream_osc.forClass(), field_name, value3);
                    continue;
                }
                if (type == Float.TYPE) {
                    float value4;
                    float f = value4 = default_initialize ? 0.0f : this.realInputStream.readFloat();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value4);
                    }
                    if (!set_value) continue;
                    this.setFloatField(obj, stream_osc.forClass(), field_name, value4);
                    continue;
                }
                if (type == Integer.TYPE) {
                    int n = value2 = default_initialize ? 0 : this.realInputStream.readInt();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value2);
                    }
                    if (!set_value) continue;
                    this.setIntField(obj, stream_osc.forClass(), field_name, value2);
                    continue;
                }
                if (type == Long.TYPE) {
                    long value5;
                    long l = value5 = default_initialize ? 0L : this.realInputStream.readLong();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value5);
                    }
                    if (!set_value) continue;
                    this.setLongField(obj, stream_osc.forClass(), field_name, value5);
                    continue;
                }
                if (type == Short.TYPE) {
                    int n = value2 = default_initialize ? 0 : this.realInputStream.readShort();
                    if (!default_initialize && set_value) {
                        this.dumpElementln("  " + field_name + ": " + value2);
                    }
                    if (!set_value) continue;
                    this.setShortField(obj, stream_osc.forClass(), field_name, (short)value2);
                    continue;
                }
                Object object = value = default_initialize ? null : this.readObject();
                if (!set_value) continue;
                this.setObjectField(obj, stream_osc.forClass(), field_name, real_field.getTypeString(), value);
            }
            catch (NoSuchFieldError e) {
                this.dumpElementln("XXXX " + field_name + " does not exist.");
            }
        }
    }

    private boolean setBlockDataMode(boolean on) {
        boolean oldmode = this.readDataFromBlock;
        this.readDataFromBlock = on;
        this.dataInputStream = on ? this.blockDataInput : this.realInputStream;
        return oldmode;
    }

    /*
     * WARNING - void declaration
     */
    private Object newObject(Class real_class, Class constructor_class) {
        try {
            void e;
            Object obj = this.allocateObject(real_class);
            this.callConstructor(constructor_class, obj);
            return e;
        }
        catch (InstantiationException e) {
            return null;
        }
    }

    private void invokeValidators() throws InvalidObjectException {
        Object[] validators = new Object[this.validators.size()];
        this.validators.copyInto(validators);
        Arrays.sort(validators);
        try {
            for (int i = 0; i < validators.length; ++i) {
                ((ObjectInputValidation)validators[i]).validateObject();
            }
            Object var2_3 = null;
            this.validators.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.validators.removeAllElements();
            throw throwable;
        }
    }

    private static ClassLoader currentClassLoader(SecurityManager sm) {
        return ClassLoader.getSystemClassLoader();
    }

    private static Field getField(Class klass, String name) throws NoSuchFieldException {
        return klass.getDeclaredField(name);
    }

    private static Method getMethod(Class klass, String name, Class[] args) throws NoSuchMethodException {
        return klass.getDeclaredMethod(name, args);
    }

    private void callReadMethod(Object obj, ObjectStreamClass osc) throws IOException {
        Class klass = osc.forClass();
        try {
            Class[] classArgs = new Class[]{ObjectInputStream.class$("java.io.ObjectInputStream")};
            Method m = ObjectInputStream.getMethod(klass, "readObject", classArgs);
            if (m == null) {
                return;
            }
            Object[] args = new Object[]{this};
            m.invoke(obj, args);
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Exception thrown from readObject() on " + klass + ": " + exception.getClass().getName());
        }
        catch (Exception x) {
            throw new IOException("Failure invoking readObject() on " + klass + ": " + x.getClass().getName());
        }
    }

    private native Object allocateObject(Class var1) throws InstantiationException;

    private native void callConstructor(Class var1, Object var2);

    private void setBooleanField(Object obj, Class klass, String field_name, boolean val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setBoolean(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setByteField(Object obj, Class klass, String field_name, byte val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setByte(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setCharField(Object obj, Class klass, String field_name, char val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setChar(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setDoubleField(Object obj, Class klass, String field_name, double val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setDouble(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setFloatField(Object obj, Class klass, String field_name, float val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setFloat(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setIntField(Object obj, Class klass, String field_name, int val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setInt(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setLongField(Object obj, Class klass, String field_name, long val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setLong(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setShortField(Object obj, Class klass, String field_name, short val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.setShort(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void setObjectField(Object obj, Class klass, String field_name, String type_code, Object val) {
        try {
            Field f = ObjectInputStream.getField(klass, field_name);
            f.setAccessible(true);
            f.set(obj, val);
        }
        catch (Exception _) {
            // empty catch block
        }
    }

    private void dumpElement(String msg) {
    }

    private void dumpElementln(String msg) {
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

