/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.util.Map;

public final class TextLayout
implements Cloneable {
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();
    private AttributedString attributedString;
    private FontRenderContext fontRenderContext;

    public TextLayout(AttributedCharacterIterator text, FontRenderContext frc) {
        this.attributedString = new AttributedString(text);
        this.fontRenderContext = frc;
    }

    public TextLayout(String string, Font font, FontRenderContext frc) {
        this.attributedString = new AttributedString(string);
        this.attributedString.addAttribute(TextAttribute.FONT, font);
        this.fontRenderContext = frc;
    }

    public TextLayout(String string, Map attributes, FontRenderContext frc) {
        this.attributedString = new AttributedString(string, attributes);
        this.fontRenderContext = frc;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void draw(Graphics2D g2, float x, float y) {
        AttributedCharacterIterator ci = this.attributedString.getIterator();
        CharacterIteratorProxy proxy = new CharacterIteratorProxy(this, ci);
        Font defFont = g2.getFont();
        char c = ci.first();
        while (c != '\uffff') {
            proxy.begin = ci.getIndex();
            proxy.limit = ci.getRunLimit(TextAttribute.FONT);
            if (proxy.limit > proxy.begin) {
                proxy.index = proxy.begin;
                Object fnt = ci.getAttribute(TextAttribute.FONT);
                GlyphVector gv = fnt instanceof Font ? ((Font)fnt).createGlyphVector(this.fontRenderContext, proxy) : defFont.createGlyphVector(this.fontRenderContext, proxy);
                g2.drawGlyphVector(gv, x, y);
                int n = gv.getNumGlyphs();
                for (int i = 0; i < n; ++i) {
                    GlyphMetrics gm = gv.getGlyphMetrics(i);
                    if (gm.getAdvanceX() == gm.getAdvance()) {
                        x += gm.getAdvanceX();
                        continue;
                    }
                    y += gm.getAdvanceY();
                }
            }
            c = ci.next();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)obj);
    }

    public boolean equals(TextLayout tl) {
        throw new Error("not implemented");
    }

    public float getAdvance() {
        throw new Error("not implemented");
    }

    public float getAscent() {
        throw new Error("not implemented");
    }

    public byte getBaseline() {
        throw new Error("not implemented");
    }

    public float[] getBaselineOffsets() {
        throw new Error("not implemented");
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        throw new Error("not implemented");
    }

    public Rectangle2D getBounds() {
        throw new Error("not implemented");
    }

    public float[] getCaretInfo(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    public float[] getCaretInfo(TextHitInfo hit, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public Shape getCaretShape(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    public Shape getCaretShape(TextHitInfo hit, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public Shape[] getCaretShapes(int offset) {
        throw new Error("not implemented");
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public int getCharacterCount() {
        throw new Error("not implemented");
    }

    public byte getCharacterLevel(int index) {
        throw new Error("not implemented");
    }

    public float getDescent() {
        throw new Error("not implemented");
    }

    public TextLayout getJustifiedLayout(float justificationWidth) {
        throw new Error("not implemented");
    }

    public float getLeading() {
        throw new Error("not implemented");
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint) {
        throw new Error("not implemented");
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(int offset) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(int offset, CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(int offset) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(int offset, CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    public Shape getOutline(AffineTransform tx) {
        throw new Error("not implemented");
    }

    public float getVisibleAdvance() {
        throw new Error("not implemented");
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        throw new Error("not implemented");
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    protected void handleJustify(float justificationWidth) {
        throw new Error("not implemented");
    }

    public int hashCode() {
        throw new Error("not implemented");
    }

    public TextHitInfo hitTestChar(float x, float y) {
        throw new Error("not implemented");
    }

    public TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public boolean isLeftToRight() {
        throw new Error("not implemented");
    }

    public boolean isVertical() {
        throw new Error("not implemented");
    }

    public String toString() {
        throw new Error("not implemented");
    }

    protected class CharacterIteratorProxy
    implements CharacterIterator {
        private /* synthetic */ TextLayout this$0;
        public CharacterIterator target;
        public int begin;
        public int limit;
        public int index;

        public CharacterIteratorProxy(TextLayout this$0, CharacterIterator ci) {
            this.this$0 = this$0;
            this.target = ci;
        }

        public int getBeginIndex() {
            return this.begin;
        }

        public int getEndIndex() {
            return this.limit;
        }

        public int getIndex() {
            return this.index;
        }

        public char setIndex(int idx) throws IllegalArgumentException {
            if (idx < this.begin || idx >= this.limit) {
                throw new IllegalArgumentException();
            }
            char ch = this.target.setIndex(idx);
            this.index = idx;
            return ch;
        }

        public char first() {
            int save = this.target.getIndex();
            char ch = this.target.setIndex(this.begin);
            this.target.setIndex(save);
            return ch;
        }

        public char last() {
            if (this.begin == this.limit) {
                return this.first();
            }
            int save = this.target.getIndex();
            char ch = this.target.setIndex(this.limit - 1);
            this.target.setIndex(save);
            return ch;
        }

        public char current() {
            return this.target.current();
        }

        public char next() {
            if (this.index >= this.limit - 1) {
                return '\uffff';
            }
            ++this.index;
            return this.target.next();
        }

        public char previous() {
            if (this.index <= this.begin) {
                return '\uffff';
            }
            --this.index;
            return this.target.previous();
        }

        public Object clone() {
            CharacterIteratorProxy cip = new CharacterIteratorProxy(this.this$0, this.target);
            cip.begin = this.begin;
            cip.limit = this.limit;
            cip.index = this.index;
            return cip;
        }
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2, TextLayout layout) {
            throw new Error("not implemented");
        }
    }
}

