/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Record {
    private byte[] data;
    private byte attributes = 0;

    public Record() {
        this.data = new byte[0];
    }

    public Record(byte[] byArray) {
        this(byArray, 0);
    }

    public Record(byte[] byArray, byte by) {
        this.data = new byte[byArray.length];
        this.attributes = by;
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    public int getSize() {
        return this.data.length;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public byte getAttributes() {
        return this.attributes;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeByte(this.attributes);
        dataOutputStream.writeShort(this.data.length);
        dataOutputStream.write(this.data);
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.attributes = dataInputStream.readByte();
        int n = dataInputStream.readUnsignedShort();
        this.data = new byte[n];
        dataInputStream.readFully(this.data);
    }

    public boolean equals(Object object) {
        boolean bl;
        block3: {
            Record record;
            bl = false;
            if (object instanceof Record && (record = (Record)object).getAttributes() == this.attributes && record.getSize() == this.data.length) {
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == record.data[i]) {
                        continue;
                    }
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

