"""
@package menudata.py

@brief Complex list for main menu entries for GRASS wxPython GUI.

Classes:
 - Data

COPYRIGHT:  (C) 2007-2008 by the GRASS Development Team
This program is free software under the GNU General Public
License (>=v2). Read the file COPYING that comes with GRASS
for details.

@author Michael Barton (Arizona State University)
@author Yann Chemin
@author Martin Landa <landa.martin gmail.com>
"""

import os

class Data:
    '''Data object that returns menu descriptions to be used in wxgui.py.
    Probably could be changed to XML or *.dtd file.'''
    def GetMenu(self):
        return [(
                (_("File"), (
                        (_("Workspace"), (
                                (_("New workspace"),
                                 _("Create new workspace file (erase current workspace settings first)"),
                                 "self.OnWorkspaceNew",
                                 ""),
                                (_("Open existing workspace"),
                                 _("Open existing workspace file"),
                                 "self.OnWorkspaceOpen",
                                 ""),
                                (_("Load map layers"),
                                 _("Load map layers into layer tree"),
                                 "self.OnWorkspaceLoad",
                                 ""),
                                (_("Save workspace"),
                                 _("Save current workspace to file"),
                                 "self.OnWorkspaceSave",
                                 ""),
                                (_("Save workspace as"),
                                 _("Save current workspace as file"),
                                 "self.OnWorkspaceSaveAs",
                                 ""),
                                (_("Close current workspace"),
                                 _("Close current workspace file"),
                                 "self.OnWorkspaceClose",
                                 ""),
                                )
                         ),
                        ("","","", ""),
                        (_("Import raster map"), (
                                (_("Multiple import formats using GDAL"),
                                 _("Import file in format supported by GDAL"),
                                 "self.OnMenuCmd",
                                 "r.in.gdal"),
                                ("","","", ""),
                                (_("Aggregate ASCII xyz import"),
                                 _("Import aggregated ASCII xyz data"),
                                 "self.OnMenuCmd",
                                 "r.in.xyz"),
                                (_("ASCII grid import"),
                                 _("Import ASCII GRID (includes GRASS ASCII)"),
                                 "self.OnMenuCmd",
                                 "r.in.ascii"),
                                (_("ASCII polygons and lines import"),
                                 _("Import polygons and lines from ASCII file"),
                                 "self.OnMenuCmd",
                                 "r.in.poly"),
                                ("","","", ""),
                                (_("Binary file import"),
                                 _("Import binary file (includes GTOPO30 format)"),
                                 "self.OnMenuCmd",
                                 "r.in.bin"),
                                (_("ESRI ASCII grid import"),
                                 _("Import ESRI Arc/Info ASCII grid"),
                                 "self.OnMenuCmd",
                                 "r.in.arc"),
                                (_("GRIDATB.FOR import"),
                                 _("Import GRIDATB.FOR map file (TOPMODEL)"),
                                 "self.OnMenuCmd",
                                 "r.in.gridatb"),
                                (_("MAT-File (v.4) import"),
                                 _("Import MAT-File (v.4) array (Matlab or Octave)"),
                                 "self.OnMenuCmd",
                                 "r.in.mat"),
                                (_("SPOT NDVI import"),
                                 _("Import SPOT vegetation NDVI data sets"),
                                 "self.OnMenuCmd",
                                 "r.in.spotvgt"),
                                (_("SRTM HGT import"),
                                 _("Import SRTM HGT files"),
                                 "self.OnMenuCmd", "r.in.srtm"),
                                (_("Terra ASTER HDF import"),
                                 _("Import Terra ASTER HDF files"),
                                 "self.OnMenuCmd",
                                 "r.in.aster"),
                                ("","","", ""),
                                (_("WMS import"),
                                 _("Import Web Mapping Server layer"),
                                 "self.OnMenuCmd",
                                 "r.in.wms"),
                                )
                         ),
                        (_("Import vector map"), (
                                (_("Multiple import formats using OGR"),
                                 _("Import file in format supported by OGR (e.g. Shapefile)"),
                                 "self.OnMenuCmd",
                                 "v.in.ogr"),
                                ("","","", ""),
                                (_("ASCII points/GRASS ASCII vector import"),
                                 _("Import ASCII points file or GRASS ASCII vector file"),
                                 "self.OnMenuCmd",
                                 "v.in.ascii"),
                                (_("Old GRASS vector import"),
                                 _("Import file in old GRASS vector format"),
                                 "self.OnMenuCmd",
                                 "v.convert"),
                                ("","","", ""),
                                (_("DXF import"),
                                 _("Import DXF file"),
                                 "self.OnMenuCmd",
                                 "v.in.dxf"),
                                (_("ESRI e00 import"),
                                 _("Import ESRI e00 file"),
                                 "self.OnMenuCmd",
                                 "v.in.e00"),
                                (_("Garmin GPS import"),
                                 _("Import Garmin GPS Waypoints/Routes/Tracks"),
                                 "self.OnMenuCmd",
                                 "v.in.garmin"),
                                (_("GPSBabel GPS import"),
                                 _("Import GPS Waypoints/Routes/Tracks using GPSBabel"),
                                 "self.OnMenuCmd",
                                 "v.in.gpsbabel"),
                                (_("GEOnet import"),
                                 _("Import GEOnet Name server country files (US-NGA GNS)"),
                                 "self.OnMenuCmd",
                                 "v.in.gns"),
                                (_("Matlab and MapGen import"),
                                 _("Import Matlab and MapGen files"),
                                 "self.OnMenuCmd",
                                 "v.in.mapgen"),
                                )
                         ),
                        (_("Import grid 3D volume"), (
                                (_("ASCII 3D import"),
                                 _("Import ASCII Raster 3D file"),
                                 "self.OnMenuCmd",
                                 "r3.in.ascii"),
                                (_("Vis5D import"),
                                 _("Import Vis5D file"),
                                 "self.OnMenuCmd",
                                 "r3.in.v5d"),
                                )
                         ),
                        (_("Import database table"), (
                                (_("Multiple import formats using OGR"),
                                 _("Import database file in format supported by OGR"),
                                 "self.OnMenuCmd",
                                 "db.in.ogr"),
                                )
                         ),
                        ("","","", ""),
                        (_("Export raster map"), (
                                (_("Multiple export formats using GDAL"),
                                 _("Export raster map to format supported by GDAL"),
                                 "self.OnMenuCmd",
                                 "r.out.gdal"),
                                ("","","", ""),
                                (_("ASCII grid export"),
                                 _("Export ASCII grid (for GRASS, Surfer, Modflow, etc.)"),
                                 "self.OnMenuCmd",
                                 "r.out.ascii"),
                                (_("ASCII x,y,z export"),
                                 _("Export ASCII x,y,z values of cell centers"),
                                 "self.OnMenuCmd",
                                 "r.out.xyz"),
                                ("","","", ""),
                                (_("ESRI ASCII grid export"),
                                 _("Export ESRI Arc/Info ASCII grid"),
                                 "self.OnMenuCmd",
                                 "r.out.arc"),
                                (_("GRIDATB.FOR export"),
                                 _("Export GRIDATB.FOR map file (TOPMODEL)"),
                                 "self.OnMenuCmd",
                                 "r.out.gridatb"),
                                (_("MAT-File (v.4) export"),
                                 _("Export MAT-File (v.4) array (Matlab or Octave)"),
                                 "self.OnMenuCmd",
                                 "r.out.mat"),
                                ("","","", ""),
                                (_("Binary export"),
                                 _("Export binary file"),
                                 "self.OnMenuCmd",
                                 "r.out.bin"),
                                ("","","", ""),
                                (_("MPEG-1 export"),
                                 _("Export MPEG-1 animations"),
                                 "self.OnMenuCmd",
                                 "r.out.mpeg"),
                                (_("PNG export"),
                                 _("Export PNG image (not georeferenced)"),
                                 "self.OnMenuCmd",
                                 "r.out.png"),
                                (_("PPM export"),
                                 _("Export PPM image (24bit)"),
                                 "self.OnMenuCmd",
                                 "r.out.ppm"),
                                (_("PPM from RGB export"),
                                 _("Export PPM image from red, green, blue raster maps"),
                                 "self.OnMenuCmd",
                                 "r.out.ppm3"),
                                (_("POV-Ray export"),
                                 _("Export POVray height-field"),
                                 "self.OnMenuCmd",
                                 "r.out.pov"),
                                (_("TIFF export"),
                                 _("Export TIFF image (8/24bit)"),
                                 "self.OnMenuCmd",
                                 "r.out.tiff"),
                                (_("VRML export"),
                                 _("Export VRML file"),
                                 "self.OnMenuCmd",
                                 "r.out.vrml"),
                                (_("VTK export"),
                                 _("Export VTK ASCII file"),
                                 "self.OnMenuCmd",
                                 "r.out.vtk"),
                                )
                         ),
                        (_("Export vector map"), (
                                (_("Multiple export formats using OGR"),
                                 _("Export vector map to format supported by OGR (e.g. Shapefile)"),
                                 "self.OnMenuCmd",
                                 "v.out.ogr"),
                                ("","","", ""),
                                (_("ASCII points/GRASS ASCII vector export"),
                                 _("Export vector map into ASCII points file or GRASS ASCII vector file"),
                                 "self.OnMenuCmd",
                                 "v.out.ascii"),
                                (_("DXF export"),
                                 _("Export vector map into DXF file"),
                                 "self.OnMenuCmd",
                                 "v.out.dxf"),
                                (_("POV-Ray export"),
                                 _("Export vector map into POV-Ray format file"),
                                 "self.OnMenuCmd",
                                 "v.out.pov"),
                                (_("SVG export"),
                                 _("Export vector map into SVG file"),
                                 "self.OnMenuCmd",
                                 "v.out.svg"),
                                (_("VTK export"),
                                 _("Export vector map into VTK ASCII file"),
                                 "self.OnMenuCmd",
                                 "v.out.vtk"),
                                )
                         ),
                        (_("Export grid 3D volume"), (
                                (_("ASCII 3D export"),
                                 _("Export ASCII 3D file"),
                                 "self.OnMenuCmd",
                                 "r3.out.ascii"),
                                (_("Vis5D export"),
                                 _("Export Vis5D file"),
                                 "self.OnMenuCmd",
                                 "r3.out.v5d"),
                                (_("VTK export"),
                                 _("Export VTK ASCII file"),
                                 "self.OnMenuCmd",
                                 "r3.out.vtk"),
                                )
                         ),
                        ("","","", ""),
                        (_("Manage maps and volumes"), (
                                (_("Copy"),
                                 _("Copy maps (GIS elements) within mapsets or between mapsets"),
                                 "self.OnMenuCmd",
                                 "g.copy"),
                                ("","","", ""),
                                (_("List"),
                                 _("List by type"),
                                 "self.OnMenuCmd",
                                 "g.list"),
                                (_("List filtered"),
                                 _("List maps (GIS elements) filtered by expressions and wildcards"),
                                 "self.OnMenuCmd",
                                 "g.mlist"),
                                ("","","", ""),
                                (_("Rename"),
                                 _("Rename maps (GIS elements)"),
                                 "self.OnMenuCmd",
                                 "g.rename"),
                                ("","","", ""),
                                (_("Delete"),
                                 _("Delete maps (GIS elements)"),
                                 "self.OnMenuCmd",
                                 "g.remove"),
                                (_("Delete filtered"),
                                 _("Delete maps (GIS elements) using expressions and wildcards"),
                                 "self.OnMenuCmd",
                                 "g.mremove"),
                                )
                         ),
                        (_("Map type conversions"), (
                                (_("Raster to vector"),
                                 _("Convert raster to vector map"),
                                 "self.OnMenuCmd",
                                 "r.to.vect"),
                                (_("Raster series to volume"),
                                 _("Convert raster map series to volume"),
                                 "self.OnMenuCmd",
                                 "r.to.rast3"),
                                (_("Raster 2.5D to volume"),
                                 _("Convert raster 2.5D map to volume"),
                                 "self.OnMenuCmd",
                                 "r.to.rast3elev"),
                                ("","","", ""),
                                (_("Vector to raster"),
                                 _("Convert vector to raster map"),
                                 "self.OnMenuCmd",
                                 "v.to.rast"),
                                (_("Vector to volume"),
                                 _("Convert vector 3D points to volume voxels"),
                                 "self.OnMenuCmd",
                                 "v.to.rast3"),
                                (_("Sites to vector"),
                                 _("Convert sites (GRASS 5) to vector map"),
                                 "self.OnMenuCmd",
                                 "v.in.sites"),
                                ("","","", ""),
                                (_("Volume to raster series"),
                                 _("Convert 3D raster to raster series map"),
                                 "self.OnMenuCmd",
                                 "r3.to.rast"),
                                )
                         ),
                        ("","","", ""),
                        (_("Georectify"),
                         _("Georectify raster and vector maps"),
                         "self.OnGeorectify",
                         ""),
                        ("","","", ""),
                        (_("NVIZ (requires Tcl/Tk)"),
                         _("N-Dimensional visualization of 2D and 3D raster/vector maps"),
                         "self.OnMenuCmd",
                         "nviz"),
                        ("","","", ""),
                        (_("Bearing/distance to coordinates"),
                         _("Convert between bearing/distance and coordinates"),
                         "self.OnMenuCmd",
                         "m.cogo"),
                        ("","","", ""),
                        (_("Postscript plot"),
                         _("Create cartographic PostScript plot"),
                         "self.OnMenuCmd",
                         "ps.map"),
                        ("","","", ""),
                        (_("E&xit"),
                         _("Exit GUI"),
                         "self.OnCloseWindow",
                         ""),
                        )
                 ),
                (_("Config"), (
                        (_("Region"), (
                                (_("Display region"),
                                 _("Display region settings (bounding box and resolution)"),
                                 "self.RunMenuCmd",
                                 "g.region -p"),
                                (_("Set region"),
                                 _("Change region settings"),
                                 "self.OnMenuCmd",
                                 "g.region"),
                                )
                         ),
                        (_("GRASS working environment"), (
                                (_("Mapset access"),
                                 _("Set/unset access to other mapsets in current location"),
                                 "self.OnMapsets",
                                 ""),
                                (_("Change working environment"),
                                 _("Change current working session to new mapset, location, or data directory"),
                                 "self.OnMenuCmd",
                                 "g.mapset"),
                                (_("User access"),
                                 _("Change access by other users to current mapset"),
                                 "self.OnMenuCmd",
                                 "g.access"),
                                (_("Show settings"),
                                 _("Show current GRASS environment settings"),
                                 "self.RunMenuCmd",
                                 "g.gisenv --v"),
                                (_("Change settings"),
                                 _("Change GRASS environment settings"),
                                 "self.OnMenuCmd",
                                 "g.gisenv"),
                                (_("Version"),
                                 _("Show current GRASS version"),
                                 "self.RunMenuCmd",
                                 "g.version -c"),
                                )
                         ),
                        (_("Manage projections"), (
                                (_("Manage projections"),
                                 _("Show projection information and create projection files"),
                                 "self.OnMenuCmd",
                                 "g.proj"),
                                (_("Projection for current location"),
                                 _("Create/edit projection information for current location"),
                                 "self.OnXTerm",
                                 "g.setproj"),
                                ("","","", ""),
                                (_("Convert coordinates"),
                                 _("Convert coordinates from one projection to another"),
                                 "self.OnMenuCmd",
                                 "m.proj"),
                                )
                         ),
                        (_("Preferences"),
                         _("User GUI preferences (display font, commands, digitizer, etc.)"),
                         "self.OnPreferences",
                         ""),
                        )
                 ),
                (_("Raster"), (
                        (_("Develop raster map"), (
                                (_("Digitize raster (requires XTerm)"),
                                 _("Digitize raster map"),
                                 "self.OnXTerm",
                                 "r.digit"),
                                ("","","", ""),
                                (_("Compress/decompress"),
                                 _("Compress/decompress raster file"),
                                 "self.OnMenuCmd",
                                 "r.compress"),
                                ("","","", ""),
                                (_("Region boundaries"),
                                 _("Manage region boundary definition"),
                                 "self.OnMenuCmd",
                                 "r.region"),
                                (_("Manage NULL values"),
                                 _("Manage NULL values"),
                                 "self.OnMenuCmd",
                                 "r.null"),
                                (_("Quantization"),
                                 _("Quantization for floating-point maps"),
                                 "self.OnMenuCmd",
                                 "r.quant"),
                                (_("Timestamp"),
                                 _("Manage timestamp for files"),
                                 "self.OnMenuCmd",
                                 "r.timestamp"),
                                ("","","", ""),
                                (_("Resample using aggregate statistics"),
                                 _("Resample raster map (change resolution) using aggregate statistics"),
                                 "self.OnMenuCmd",
                                 "r.resamp.stats"),
                                (_("Resample using multiple methods"),
                                 _("Resample raster map (change resolution) using nearest neighbor, bilinear, or bicubic interpolation"),
                                 "self.OnMenuCmd",
                                 "r.resamp.interp"),
                                (_("Resample using nearest neighbor"),
                                 _("Resample raster map (change resolution) using nearest neighbor interpolation"),
                                 "self.OnMenuCmd",
                                 "r.resample"),
                                (_("Resample using spline tension"),
                                 _("Resample raster map (change resolution) using regularized spline tension"),
                                 "self.OnMenuCmd",
                                 "r.resamp.rst"),
                                ("","","", ""),
                                (_("Support file maintenance"),
                                 _("Support raster map file creation and maintenance"),
                                 "self.OnMenuCmd",
                                 "r.support"),
                                (_("Update map statistics"),
                                 _("Update raster map statistics"),
                                 "self.OnMenuCmd",
                                 "r.support.stats"),
                                ("","","", ""),
                                (_("Reproject raster"),
                                 _("Reproject raster map from other location"),
                                 "self.OnMenuCmd",
                                 "r.proj"),
                                (_("Tiling"),
                                 _("Generate tiling for other projection"),
                                 "self.OnMenuCmd",
                                 "r.tileset"),
                                )),
                        (_("Manage colors"), (
                                (_("Color tables"),
                                 _("Set colors to predefined color tables"),
                                 "self.OnMenuCmd",
                                 "r.colors"),
                                (_("Color rules"),
                                 _("Set colors interactively by entering color rules"),
                                 "self.RulesCmd",
                                 "r.colors"),
                                ("","","", ""),
                                (_("Blend 2 color rasters"),
                                 _("Blend 2 color raster maps to produce 3 RGB files"),
                                 "self.OnMenuCmd",
                                 "r.blend"),
                                (_("Create RGB"),
                                 _("Create color image from RGB raster maps"),
                                 "self.OnMenuCmd",
                                 "r.composite"),
                                (_("RGB to HIS"),
                                 _("Create 3 RGB (red, green, blue) maps from 3 HIS (hue, intensity, saturation) maps"),
                                 "self.OnMenuCmd",
                                 "r.his"),
                                )),
                        (_("Query by coordinates"),
                         _("Query raster map by coordinates"),
                         "self.OnMenuCmd",
                         "r.what"),
                        ("","","", ""),
                        (_("Buffer rasters"),
                         _("Create raster buffers around raster objects"),
                         "self.OnMenuCmd",
                         "r.buffer"),
                        (_("Closest points"),
                         _("r.distance"),
                         "self.OnMenuCmd",
                         "r.distance"),
                        (_("Mask"),
                         _("Develop raster mask"),
                         "self.OnMenuCmd",
                         "r.mask"),
                        (_("Map calculator"),
                         _("Map calculator for raster map algebra"),
                         "self.DispMapCalculator",
                         ""),
                        (_("Neighborhood analysis"), (
                                (_("Moving window"),
                                 _("Moving window analysis of raster cells"),
                                 "self.OnMenuCmd",
                                 "r.neighbors"),
                                (_("Neighborhood points"),
                                 _("Analyze vector points in neighborhood of raster cells"),
                                 "self.OnMenuCmd",
                                 "v.neighbors"),
                                )
                         ),
                        (_("Overlay rasters"), (
                                (_("Cross product"),
                                 _("Create raster cross product"),
                                 "self.OnMenuCmd",
                                 "r.cross"),
                                (_("Raster series"),
                                 _("Function of raster map series (time series)"),
                                 "self.OnMenuCmd",
                                 "r.series"),
                                (_("Patch raster maps"),
                                 _("Patch several raster maps"),
                                 "self.OnMenuCmd",
                                 "r.patch"),
                                ("","","", ""),
                                (_("Statistical overlay"),
                                 _("Statistical calculations for cover raster map over base raster map"),
                                 "self.OnMenuCmd",
                                 "r.statistics"),
                                )
                         ),
                        (_("Solar radiance and shadows"), (
                                (_("Solar irradiance and irradiation"),
                                 _("Solar irradiance and daily irradiation"),
                                 "self.OnMenuCmd",
                                 "r.sun"),
                                (_("Shadows map"),
                                 _("Shadows raster map for sun position or date/time"),
                                 "self.OnMenuCmd",
                                 "r.sunmask"),
                                )
                         ),
                        (_("Terrain analysis"), (
                                (_("Cumulative movement costs"),
                                 _("Calculate cumulative movement costs between locales"),
                                 "self.OnMenuCmd",
                                 "r.walk"),
                                (_("Cost surface"),
                                 _("Create raster map of cost surface"),
                                 "self.OnMenuCmd",
                                 "r.cost"),
                                (_("Least cost route or flow"),
                                 _("Create raster map of least cost route or flow"),
                                 "self.OnMenuCmd",
                                 "r.drain"),
                                ("","","", ""),
                                (_("Shaded relief"),
                                 _("Shaded relief raster map"),
                                 "self.OnMenuCmd",
                                 "r.shaded.relief"),
                                ("","","", ""),
                                (_("Slope and aspect"),
                                 _("Create raster map of slope and aspect"),
                                 "self.OnMenuCmd",
                                 "r.slope.aspect"),
                                (_("Terrain parameters"),
                                 _("Calculate terrain parameters"),
                                 "self.OnMenuCmd",
                                 "r.param.scale"),
                                (_("Textural features"),
                                 _("Textural features analysis"),
                                 "self.OnMenuCmd",
                                 "r.texture"),
                                ("","","", ""),
                                (_("Visibility"),
                                 _("Visibility and line of sight"),
                                 "self.OnMenuCmd",
                                 "r.los"),
                                )
                         ),
                        (_("Transform features"), (
                                (_("Clump"),
                                 _("Clump small areas (statistics calculated by r.volume)"),
                                 "self.OnMenuCmd",
                                 "r.clump"),
                                (_("Grow"),
                                 _("Grow raster areas"),
                                 "self.OnMenuCmd",
                                 "r.grow"),
                                (_("Thin"),
                                 _("Thin linear features"),
                                 "self.OnMenuCmd",
                                 "r.thin"),
                                )
                         ),
                        ("","","", ""),
                        (_("Hydrologic modeling"), (
                                (_("Carve stream channels"),
                                 _("Carve stream channels into elevation map using vector streams map"),
                                 "self.OnMenuCmd",
                                 "r.carve"),
                                (_("Fill lake"),
                                 _("Fill lake from seed point to specified level"),
                                 "self.OnMenuCmd",
                                 "r.lake"),
                                ("","","", ""),
                                (_("Depressionless map and flowlines"),
                                 _("Depressionless elevation map and flowline map"),
                                 "self.OnMenuCmd",
                                 "r.fill.dir"),
                                (_("Flow accumulation"),
                                 _("Flow accumulation for massive grids"),
                                 "self.OnMenuCmd",
                                 "r.terraflow"),
                                (_("Flow lines"),
                                 _("Generate flow lines for raster map"),
                                 "self.OnMenuCmd",
                                 "r.flow"),
                                ("","","", ""),
                                (_("SIMWE Overland flow modeling"),
                                 _("SIMWE overland flow modeling analysis"),
                                 "self.OnMenuCmd",
                                 "r.sim.water"),
                                (_("SIMWE Sediment flux modeling"),
                                 _("SIMWE sediment erosion, transport, deposition modeling"),
                                 "self.OnMenuCmd",
                                 "r.sim.sediment"),
                                ("","","", ""),
                                (_("Topographic index map"),
                                 _("Create topographic index raster map"),
                                 "self.OnMenuCmd",
                                 "r.topidx"),
                                (_("TOPMODEL simulation"),
                                 _("TOPMODEL simulation analysis"),
                                 "self.OnMenuCmd",
                                 "r.topmodel"),
                                ("","","", ""),
                                (_("Watershed subbasins"),
                                 _("Watershed subbasins modelling"),
                                 "self.OnMenuCmd",
                                 "r.basins.fill"),
                                (_("Watershed analysis"),
                                 _("Run watershed analysis"),
                                 "self.OnMenuCmd",
                                 "r.watershed"),
                                (_("Watershed basin creation"),
                                 _("Watershed basin creation"),
                                 "self.OnMenuCmd",
                                 "r.water.outlet"),
                                )
                         ),
                        (_("Landscape structure modeling"), (
                                (_("Set up (requires XTerm)"),
                                 _("Set up sampling and analysis framework"),
                                 "self.OnXTerm",
                                 "r.le.setup"),
                                ("","","", ""),
                                (_("Analyze landscape"),
                                 _("Analyze landscape characteristics"),
                                 "self.OnMenuCmd",
                                 "r.le.pixel"),
                                (_("Analyze patches"),
                                 _("Analyze landscape patch characteristics"),
                                 "self.OnMenuCmd",
                                 "r.le.patch"),
                                (_("Output"),
                                 _("Output landscape patch information"),
                                 "self.OnMenuCmd",
                                 "r.le.trace"),
                                )
                         ),
                        (_("Landscape patch analysis"), (
                                (_("Set up sampling and analysis framework"),
                                 _("Configure and create patch map for analysis"),
                                 "self.OnMenuCmd",
                                 "r.li.setup"),
                                ("","","", ""),
                                (_("Edge density"),
                                 _("Calculate edge density index using a 4 neighbour algorithm"),
                                 "self.OnMenuCmd",
                                 "r.li.edgedensity"),
                                (_("Contrast weighted edge density"),
                                 _("Calculate contrast weighted edge density index"),
                                 "self.OnMenuCmd",
                                 "r.li.cwed"),
                                ("","","", ""),
                                (_("Patch area mean"),
                                 _("Calculate mean patch size index using a 4 neighbour algorithm"),
                                 "self.OnMenuCmd",
                                 "r.li.mps"),
                                (_("Patch area range"),
                                 _("Calculate range of patch area size"),
                                 "self.OnMenuCmd",
                                 "r.li.padrange"),
                                (_("Patch area Std Dev"),
                                 _("Calculate standard deviation of patch area"),
                                 "self.OnMenuCmd",
                                 "r.li.padsd"),
                                (_("Patch area Coeff Var"),
                                 _("Calculate coefficient of variation of patch area"),
                                 "self.OnMenuCmd",
                                 "r.li.padcv"),
                                (_("Patch density"),
                                 _("Calculate patch density index using a 4 neighbour algorithm"),
                                 "self.OnMenuCmd",
                                 "r.li.patchdensity"),
                                (_("Patch number"),
                                 _("Calculate patch number index using a 4 neighbour algorithm"),
                                 "self.OnMenuCmd",
                                 "r.li.patchnum"),
                                ("","","", ""),
                                (_("Dominance's diversity"),
                                 _("Calculate Dominance's diversity index"),
                                 "self.OnMenuCmd",
                                 "r.li.dominance"),
                                (_("Shannon's diversity"),
                                 _("Calculate Shannon's diversity index"),
                                 "self.OnMenuCmd",
                                 "r.li.shannon"),
                                (_("Simpson's diversity"),
                                 _("Calculate Simpson's diversity index"),
                                 "self.OnMenuCmd",
                                 "r.li.simpson"),
                                ("","","", ""),
                                (_("Richness"),
                                 _("Calculate richness index"),
                                 "self.OnMenuCmd",
                                 "r.li.richness"),
                                (_("Shape index"),
                                 _("Calculate shape index"),
                                 "self.OnMenuCmd",
                                 "r.li.shape"),
                                )
                         ),
                        (_("Wildfire modeling"), (
                                (_("Rate of spread"),
                                 _("Generate rate of spread (ROS) maps"),
                                 "self.OnMenuCmd",
                                 "r.ros"),
                                (_("Least-cost spread paths"),
                                 _("Generate least-cost spread paths"),
                                 "self.OnMenuCmd",
                                 "r.spreadpath"),
                                (_("Anisotropic spread simulation"),
                                 _("Simulate anisotropic spread phenomena"),
                                 "self.OnMenuCmd",
                                 "r.spread"),
                                )
                         ),
                        ("","","", ""),
                        (_("Change category values and labels"), (
                                (_("Interactively edit category values"),
                                 _("Edit category values of individual cells for displayed raster map"),
                                 "self.OnMenuCmd",
                                 "d.rast.edit"),
                                ("","","", ""),
                                (_("Reclassify by size"),
                                 _("Reclassify raster categories for raster areas of specified sizes"),
                                 "self.OnMenuCmd",
                                 "r.reclass.area"),
                                (_("Reclassify interactively"),
                                 _("Reclassify raster categories interactively by entering reclass rules"),
                                 "self.RulesCmd",
                                 "r.reclass"),
                                (_("Reclassify using rules file"),
                                 _("Reclassify raster categories by inputting reclass rules from a text file"),
                                 "self.OnMenuCmd",
                                 "r.reclass"),
                                ("","","", ""),
                                (_("Recode interactively"),
                                 _("Recode raster categories interactively by entering recode rules (create new raster map)"),
                                 "self.RulesCmd",
                                 "r.recode"),
                                (_("Recode using rules file"),
                                 _("Recode raster categories by inputting recode rules from a text file (create new map)"),
                                 "self.OnMenuCmd",
                                 "r.recode.file"),
                                ("","","", ""),
                                (_("Rescale"),
                                 _("Rescale raster categories (create new raster map)"),
                                 "self.OnMenuCmd",
                                 "r.rescale"),
                                (_("Rescale with histogram"),
                                 _("Rescale raster categories with equalized histogram (create new raster map)"),
                                 "self.OnMenuCmd",
                                 "r.rescale.eq"),
                                )
                         ),
                        ("","","", ""),
                        (_("Concentric circles"),
                         _("Generate concentric circles around points"),
                         "self.OnMenuCmd",
                         "r.circle"),
                        (_("Generate random cells"), (
                                (_("Random cells"),
                                 _("Generate random raster cells"),
                                 "self.OnMenuCmd",
                                 "r.random.cells"),
                                (_("Random cells and vector points"),
                                 _("Generate random raster cells and vector points from raster map"),
                                 "self.OnMenuCmd",
                                 "r.random"),
                                )
                         ),
                        (_("Generate surfaces"), (
                                (_("Fractal surface"),
                                 _("Generate fractal surface"),
                                 "self.OnMenuCmd",
                                 "r.surf.fractal"),
                                ("","","", ""),
                                (_("Gaussian kernel density surface"),
                                 _("Generate density surface using moving Gaussian kernel"),
                                 "self.OnMenuCmd",
                                 "v.kernel"),
                                (_("Gaussian deviates surface"),
                                 _("Generate gaussian deviates surface"),
                                 "self.OnMenuCmd",
                                 "r.surf.gauss"),
                                ("","","", ""),
                                (_("Plane"),
                                 _("Generate plane"),
                                 "self.OnMenuCmd",
                                 "r.plane"),
                                ("","","", ""),
                                (_("Random deviates surface"),
                                 _("Generate random deviates surface"),
                                 "self.OnMenuCmd",
                                 "r.surf.random"),
                                (_("Random surface with spatial dependence"),
                                 _("Generate random surface with spatial dependence"),
                                 "self.OnMenuCmd",
                                 "r.random.surface"),
                                )
                         ),
                        (_("Generate contour lines"),
                         _("Generate vector contour lines"),
                         "self.OnMenuCmd",
                         "r.contour"),
                        (_("Interpolate surfaces"), (
                                (_("Bilinear from raster points"),
                                 _("Bilinear interpolation from raster points"),
                                 "self.OnMenuCmd",
                                 "r.bilinear"),
                                (_("Bilinear and bicubic from vector points"),
                                 _("Bicubic and bilinear interpolation with Tykhonov regularization from vector points"),
                                 "self.OnMenuCmd",
                                 "v.surf.bspline"),
                                ("","","", ""),
                                (_("IDW from raster points"),
                                 _("Inverse distance weighted interpolation from raster points"),
                                 "self.OnMenuCmd",
                                 "r.surf.idw"),
                                (_("IDW from vector points"),
                                 _("Inverse distance weighted interpolation from vector points"),
                                 "self.OnMenuCmd",
                                 "v.surf.idw"),
                                ("","","", ""),
                                (_("Raster contours"),
                                 _("Interpolation from raster contour"),
                                 "self.OnMenuCmd",
                                 "r.surf.contour"),
                                (_("Regularized spline tension"),
                                 _("Regularized spline tension interpolation from vector points or contours"),
                                 "self.OnMenuCmd",
                                 "v.surf.rst"),
                                ("","","", ""),
                                (_("Fill NULL cells"),
                                 _("Fill NULL raster cells by interpolation using regularized spline tension"),
                                 "self.OnMenuCmd",
                                 "r.fillnulls"),
                                )
                         ),
                        ("","","", ""),
                        (_("Report and statistics"), (
                                (_("Basic raster metadata"),
                                 _("Report basic raster map metadata"),
                                 "self.OnMenuCmd",
                                 "r.info"),
                                (_("Manage category information"),
                                 _("Manage raster categories labels and values"),
                                 "self.OnMenuCmd",
                                 "r.category"),
                                ("","","", ""),
                                (_("General statistics"),
                                 _("General raster map statistics"),
                                 "self.OnMenuCmd",
                                 "r.stats"),
                                (_("Range of category values"),
                                 _("Range of all raster category values"),
                                 "self.OnMenuCmd",
                                 "r.describe"),
                                (_("Sum category values"),
                                 _("Sum all raster category values"),
                                 "self.OnMenuCmd",
                                 "r.sum"),
                                (_("Sum area by raster map and category"),
                                 _("Calculate sum of area by raster map and category"),
                                 "self.OnMenuCmd",
                                 "r.report"),
                                (_("Statistics for clumped cells"),
                                 _("Summary statistics for clumped raster map (work with r.clump)"),
                                 "self.OnMenuCmd",
                                 "r.volume"),
                                (_("Total corrected area"),
                                 _("Total surface area corrected for topography"),
                                 "self.OnMenuCmd",
                                 "r.surf.area"),
                                (_("Univariate raster statistics"),
                                 _("Calculate univariate statistics for raster categories"),
                                 "self.OnMenuCmd",
                                 "r.univar"),
                                ("","","", ""),
                                (_("Sample transects"),
                                 _("Sample values along transects"),
                                 "self.OnMenuCmd",
                                 "r.profile"),
                                (_("Sample transects (bearing/distance)"),
                                 _("Sample values along transects (use azimuth, distance)"),
                                 "self.OnMenuCmd",
                                 "r.transect"),
                                ("","","", ""),
                                (_("Covariance/correlation"),
                                 _("Covariance/correlation calculation"),
                                 "self.OnMenuCmd",
                                 "r.covar"),
                                (_("Linear regression"),
                                 _("Linear regression between 2 raster maps"),
                                 "self.OnMenuCmd",
                                 "r.regression.line"),
                                (_("Mutual category occurrences"),
                                 _("Mutual category occurrences (coincidence)"),
                                 "self.OnMenuCmd",
                                 "r.coin"),
                                )
                         ),
                        )
                 ),
                (_("Vector"), (
                        (_("Develop vector map"), (
                                (_("Create new vector map"),
                                 _("Create new empty vector map"),
                                 "self.OnMenuCmd",
                                 "v.edit tool=create"),
                                #                                 (_("Digitize vector map"),
                                #                                  _("Digitize/edit vector map"),
                                #                                  "self.OnMenuCmd",
                                #                                 "v.digit"),
                                ("","","", ""),
                                (_("Create/rebuild topology"),
                                 _("Create or rebuild topology of vector objects"),
                                 "self.OnMenuCmd",
                                 "v.build"),
                                (_("Clean vector map"),
                                 _("Clean vector objects (topologically incorect)"),
                                 "self.OnMenuCmd",
                                 "v.clean"),
                                (_("Generalization"),
                                 _("Smooth, simplify, displace, or generalize a vector map"),
                                 "self.OnMenuCmd",
                                 "v.generalize"),
                                ("","","", ""),
                                (_("Convert object types"),
                                 _("Convert vector objects from one feature type to another"),
                                 "self.OnMenuCmd",
                                 "v.type.sh"),
                                ("","","", ""),
                                (_("Add centroids"),
                                 _("Add centroids to closed boundaries to create areas"),
                                 "self.OnMenuCmd",
                                 "v.centroids"),
                                ("","","", ""),
                                (_("Build polylines"),
                                 _("Build polylines from adjacent segments"),
                                 "self.OnMenuCmd",
                                 "v.build.polylines"),
                                (_("Split polylines"),
                                 _("Split polylines into points and segments"),
                                 "self.OnMenuCmd",
                                 "v.segment"),
                                (_("Parallel lines"),
                                 _("Create lines parallel to existing lines"),
                                 "self.OnMenuCmd",
                                 "v.parallel"),
                                ("","","", ""),
                                (_("Dissolve boundaries"),
                                 _("Dissolve common boundaries of areas"),
                                 "self.OnMenuCmd",
                                 "v.dissolve"),
                                ("","","", ""),
                                (_("Create 3D vector over raster"),
                                 _("Create 3D objects by sampling raster map with 2D vector map"),
                                 "self.OnMenuCmd",
                                 "v.drape"),
                                (_("Extrude 3D vector map"),
                                 _("Extrude 3D objects from 2D vector map"),
                                 "self.OnMenuCmd",
                                 "v.extrude"),
                                ("","","", ""),
                                (_("Link to OGR"),
                                 _("Create new vector map as link to external OGR layer"),
                                 "self.OnMenuCmd",
                                 "v.external"),
                                ("","","", ""),
                                (_("Create labels"),
                                 _("Create text label file for vector features"),
                                 "self.OnMenuCmd",
                                 "v.label"),
                                ("","","", ""),
                                (_("Reposition vector map"),
                                 _("Reposition (shift, rotate, skew) vector map in coordinate space"),
                                 "self.OnMenuCmd",
                                 "v.transform"),
                                (_("Reproject vector map"),
                                 _("Reproject vector map from other location"),
                                 "self.OnMenuCmd",
                                 "v.proj"),
                                )
                         ),
                        ("","","", ""),
                        (_("Query with attributes"),
                         _("Query vector objects by attribute values (create new vector map)"),
                         "self.OnMenuCmd",
                         "v.extract"),
                        (_("Query with coordinate(s)"),
                         _("Query vector objects by coordinate(s)"),
                         "self.OnMenuCmd",
                         "v.what"),
                        (_("Query with another vector map"),
                         _("Query objects using objects from a second vector map"),
                         "self.OnMenuCmd",
                         "v.select"),
                        ("","","", ""),
                        (_("Buffer vectors"),
                         _("Create vector buffers around vector objects"),
                         "self.OnMenuCmd",
                         "v.buffer"),
                        (_("Lidar analysis"), (
                                (_("Detect edges"),
                                 _("Detect object edges in Lidar data"),
                                 "self.OnMenuCmd",
                                 "v.lidar.edgedetection"),
                                (_("Detect interiors"),
                                 _("Detect interiors of objects in Lidar data"),
                                 "self.OnMenuCmd",
                                 "v.lidar.growing"),
                                (_("Correct and reclassify objects"),
                                 _("Correct and reclassify objects detected in Lidar data"),
                                 "self.OnMenuCmd",
                                 "v.lidar.correction"),
                                )
                         ),
                        (_("Linear referencing"), (
                                (_("Create LRS"),
                                 _("Create linear reference system"),
                                 "self.OnMenuCmd",
                                 "v.lrs.create"),
                                (_("Create stationing"),
                                 _("Create stationing from input lines, and linear reference system"),
                                 "self.OnMenuCmd",
                                 "v.lrs.label"),
                                (_("Create points/segments"),
                                 _("Create points/segments from input lines, linear reference system and positions read from stdin"),
                                 "self.OnMenuCmd",
                                 "v.lrs.segment"),
                                (_("Find line id and offset"),
                                 _("Find line id and real km+offset for given points in vector map using linear reference system"),
                                 "self.OnMenuCmd",
                                 "v.lrs.where"),
                                )
                         ),
                        (_("Nearest features"),
                         _("Locate nearest feature to points or centroids"),
                         "self.OnMenuCmd",
                         "v.distance"),
                        (_("Network analysis"), (
                                (_("Allocate subnets"),
                                 _("Allocate subnets for nearest centers"),
                                 "self.OnMenuCmd",
                                 "v.net.alloc"),
                                (_("Network maintenance"),
                                 _("Network maintenance support"),
                                 "self.OnMenuCmd",
                                 "v.net"),
                                (_("Visibility network"),
                                 _("Create and maintain a visibility network"),
                                 "self.OnMenuCmd",
                                 "v.net.visibility"),
                                (_("Shortest path"),
                                 _("Calculate shortest route along network between 2 nodes"),
                                 "self.OnMenuCmd",
                                 "v.net.path"),
                                (_("Display shortest route (requires XTerm)"),
                                 _("Display shortest route along network between 2 nodes (visualization only, requires XTerm))"),
                                 "self.OnXTerm",
                                 "d.path"),
                                (_("Split net"),
                                 _("Split net into bands between cost isolines"),
                                 "self.OnMenuCmd",
                                 "v.net.iso"),
                                (_("Steiner tree"),
                                 _("Create Steiner tree for network and given terminals"),
                                 "self.OnMenuCmd",
                                 "v.net.steiner"),
                                (_("Traveling salesman analysis"),
                                 _("Calculate shortest route connecting given set of nodes (Traveling salesman analysis)"),
                                 "self.OnMenuCmd",
                                 "v.net.salesman"),
                                )
                         ),
                        (_("Overlay vector maps"), (
                                (_("Overlay vector maps"),
                                 _("Boolean overlay of 2 vector maps"),
                                 "self.OnMenuCmd",
                                 "v.overlay"),
                                (_("Patch vector maps"),
                                 _("Patch/combine multiple maps (boolean OR)"),
                                 "self.OnMenuCmd",
                                 "v.patch"),
                                )
                         ),
                        ("","","", ""),
                        (_("Change attributes"), (
                                (_("Manage or report categories"),
                                 _("Attach/delete, or report vector categories"),
                                 "self.OnMenuCmd",
                                 "v.category"),
                                (_("Reclassify objects interactively"),
                                 _("Reclassify vector objects interactively by entering SQL rules"),
                                 "self.RulesCmd",
                                 "v.reclass"),
                                (_("Reclassify objects using rules file"),
                                 _("Reclassify vector objects by inputting SQL rules from a text file"),
                                 "self.OnMenuCmd",
                                 "v.reclass"),
                                )
                         ),
                        ("","","", ""),
                        (_("Generate area for current region"),
                         _("Generate area object for extent of current region"),
                         "self.OnMenuCmd",
                         "v.in.region"),
                        (_("Generate areas from points"), (
                                (_("Convex hull"),
                                 _("Generate convex hull for point set"),
                                 "self.OnMenuCmd",
                                 "v.hull"),
                                (_("Delaunay triangles"),
                                 _("Generate Delaunay triangles for point set"),
                                 "self.OnMenuCmd",
                                 "v.delaunay"),
                                (_("Voronoi diagram/Thiessen polygons"),
                                 _("Generate Voronoi diagram/Thiessen polygons for point set"),
                                 "self.OnMenuCmd",
                                 "v.voronoi"),
                                )
                         ),
                        (_("Generate grid"),
                         _("Generate rectangular vector grid"),
                         "self.OnMenuCmd",
                         "v.mkgrid"),
                        (_("Generate points"), (
                                (_("Generate from database"),
                                 _("Generate vector points from database with x/y coordinates"),
                                 "self.OnMenuCmd",
                                 "v.in.db"),
                                (_("Generate points along lines"),
                                 _("Generate vector points along vector lines/boundaries"),
                                 "self.OnMenuCmd",
                                 "v.to.points"),
                                (_("Generate random points"),
                                 _("Generate random vector points"),
                                 "self.OnMenuCmd",
                                 "v.random"),
                                (_("Perturb points"),
                                 _("Random perturbations of point locations"),
                                 "self.OnMenuCmd",
                                 "v.perturb"),
                                )
                         ),
                        ("","","", ""),
                        (_("Remove outliers in point sets"),
                         _("Remove outliers from vector point set"),
                         "self.OnMenuCmd",
                         "v.outlier"),
                        (_("Test/training point sets"),
                         _("Partition points into test/training sets for k-fold cross validation"),
                         "self.OnMenuCmd",
                         "v.kcv"),
                        ("","","", ""),
                        (_("Update area attributes from raster"),
                         _("Update area attribute data from univariate statistics on raster map"),
                         "self.OnMenuCmd",
                         "v.rast.stats"),
                        (_("Update point attributes from areas"),
                         _("Update point attribute data from vector area map"),
                         "self.OnMenuCmd",
                         "v.what.vect"),
                        (_("Update point attributes from raster"), (
                                (_("Sample raster maps at point locations"),
                                 _("Update attribute based on sample raster maps at point locations"),
                                 "self.OnMenuCmd",
                                 "v.what.rast"),
                                (_("Sample raster neighborhood around points"),
                                 _("Update attributes based on sample raster neighborhood around points"),
                                 "self.OnMenuCmd",
                                 "v.sample"),
                                )
                         ),
                        ("","","", ""),
                        (_("Reports and statistics"), (
                                (_("Basic vector metadata"),
                                 _("Rebort basic vector map metadata"),
                                 "self.OnMenuCmd",
                                 "v.info"),
                                ("","","", ""),
                                (_("Report topology by category"),
                                 _("Report areas for vector attribute categories"),
                                 "self.OnMenuCmd",
                                 "v.report"),
                                (_("Upload or report topology"),
                                 _("Update database fields or create reports from vector topology"),
                                 "self.OnMenuCmd",
                                 "v.to.db"),
                                ("","","", ""),
                                (_("Univariate attribute statistics"),
                                 _("Calculate univariate statistics for vector attributes"),
                                 "self.OnMenuCmd",
                                 "v.univar"),
                                ("","","", ""),
                                (_("Quadrat indices"),
                                 _("Indices of point counts in quadrats"),
                                 "self.OnMenuCmd",
                                 "v.qcount"),
                                (_("Test normality"),
                                 _("Test normality of point distribution"),
                                 "self.OnMenuCmd",
                                 "v.normal"),
                                )
                         ),
                        )
                 ),
                (_("Imagery"), (
                        (_("Develop images and groups"), (
                                (_("Create/edit group"),
                                 _("Create/edit imagery group"),
                                 "self.OnMenuCmd",
                                 "i.group"),
                                (_("Target group"),
                                 _("Define target imagery group"),
                                 "self.OnMenuCmd",
                                 "i.target"),
                                ("","","", ""),
                                (_("Mosaic images"),
                                 _("Mosaic up to 4 adjacent images"),
                                 "self.OnMenuCmd",
                                 "i.image.mosaic"),
                                )
                         ),
                        (_("Manage image colors"), (
                                (_("Color balance for RGB"),
                                 _("Color balance and enhance color tables of multiband imagery for RGB display"),
                                 "self.OnMenuCmd",
                                 "i.landsat.rgb"),
                                (_("HIS to RGB"),
                                 _("Transform HIS (Hue/Intensity/Saturation) color image to RGB (Red/Green/Blue)"),
                                 "self.OnMenuCmd",
                                 "i.his.rgb"),
                                (_("RGB to HIS"),
                                 _("Transform RGB (Red/Green/Blue) color image to HIS (Hue/Intensity/Saturation)"),
                                 "self.OnMenuCmd",
                                 "i.rgb.his"),
                                )
                         ),
                        (_("Rectify image or raster"),
                         _("Rectifies raster map using information in previously created POINTS file"),
                         "self.OnMenuCmd",
                         "i.rectify"),
                        (_("Ortho photo rectification (requires Xterm)"),
                         _("Ortho Photo rectification"),
                         "self.OnXTerm",
                         "i.ortho.photo"),
                        ("","","", ""),
                        (_("Brovey sharpening"),
                         _("Brovey transformation and pan sharpening"),
                         "self.OnMenuCmd",
                         "i.fusion.brovey"),
                        (_("Classify image"), (
                                (_("Clustering input for unsupervised classification"),
                                 _("Clustering input for unsupervised classification analysis"),
                                 "self.OnMenuCmd",
                                 "i.cluster"),
                                ("","","", ""),
                                (_("Maximum likelihood classification (MLC)"),
                                 _("Maximum Likelihood Classification analysis"),
                                 "self.OnMenuCmd",
                                 "i.maxlik"),
                                (_("Sequential maximum a posteriori classification (SMAP)"),
                                 _("Sequential Maximum A Posteriori Classification (SMAP) analysis"),
                                 "self.OnMenuCmd",
                                 "i.smap"),
                                ("","","", ""),
                                (_("Interactive input for supervised classification (requires Xterm)"),
                                 _("Interactive input for supervised classification"),
                                 "self.OnXTerm",
                                 "i.class"),
                                (_("Input for supervised MLC"),
                                 _("Non-interactive input for supervised classification (MLC)"),
                                 "self.OnMenuCmd",
                                 "i.gensig"),
                                (_("Input for supervised SMAP"),
                                 _("Non-interactive input for supervised classification (SMAP)"),
                                 "self.OnMenuCmd",
                                 "i.gensigset"),
                                )
                         ),
                        (_("Filter image"), (
                                (_("Edge detection"),
                                 _("Zero edge crossing detection"),
                                 "self.OnMenuCmd",
                                 "i.zc"),
                                (_("Matrix/convolving filter"),
                                 _("User defined matrix/convolving filter"),
                                 "self.OnMenuCmd",
                                 "r.mfilter"),
                                )
                         ),
                        (_("Histogram"),
                         _("Generate histogram of image"),
                         "self.DispHistogram",
                         ""),
                        (_("Spectral response"),
                         _("Calculate spectral response"),
                         "self.OnMenuCmd",
                         "i.spectral"),
                        (_("Tasseled cap vegetation index"),
                         _("Tasseled cap vegetation index analysis"),
                         "self.OnMenuCmd",
                         "i.tasscap"),
                        (_("Transform image"), (
                                (_("Canonical correlation"),
                                 _("Canonical correlation (discriminant analysis)"),
                                 "self.OnMenuCmd",
                                 "i.cca"),
                                (_("Principal components"),
                                 _("Principal components analysis"),
                                 "self.OnMenuCmd",
                                 "i.pca"),
                                (_("Fast Fourier"),
                                 _("Fast Fourier Transform"),
                                 "self.OnMenuCmd",
                                 "i.fft"),
                                (_("Inverse Fast Fourier"),
                                 _("Inverse Fast Fourier Transform"),
                                 "self.OnMenuCmd",
                                 "i.ifft"),
                                )
                         ),
                        ("","","", ""),
                        (_("Report and statistics"), (
                                (_("Bit pattern comparison "),
                                 _("Bit pattern comparison for ID of low quality pixels"),
                                 "self.OnMenuCmd",
                                 "r.bitpattern"),
                                (_("Kappa analysis"),
                                 _("Kappa classification accuracy assessment"),
                                 "self.OnMenuCmd",
                                 "r.kappa"),
                                (_("OIF for LandSat TM"),
                                 _("Optimum index factor for LandSat TM"),
                                 "self.OnMenuCmd",
                                 "i.oif"),
                                )
                         ),
                        )
                 ),
                (_("Volumes"), (
                        (_("Develop volumes"), (
                                (_("Manage 3D NULL values"),
                                 _("Manage NULL values for volume"),
                                 "self.OnMenuCmd",
                                 "r3.null"),
                                (_("Manage timestamp"),
                                 _("Manage timestamp for volume"),
                                 "self.OnMenuCmd",
                                 "r3.timestamp"),
                                )),
                        ("","","", ""),
                        (_("3D Mask"),
                         _("Create 3D mask for 3D raster operations"),
                         "self.OnMenuCmd",
                         "r3.mask"),
                        (_("3D raster map calculator"),
                         _("Map calculator for volumetric map algebra"),
                         "self.Disp3DMapCalculator",
                         ""),
                        (_("Cross section"),
                         _("Create 2D raster cross section from volume"),
                         "self.OnMenuCmd",
                         "r3.cross.rast"),
                        (_("Interpolate volume from points"),
                         _("Interpolate volume from vector points using splines"),
                         "self.OnMenuCmd",
                         "v.vol.rst"),
                        ("","","", ""),
                        (_("Report and Statistics"), (
                                (_("Basic volume metadata"),
                                 _("Report basic volume metadata"),
                                 "self.OnMenuCmd",
                                 "r3.info"),
                                )
                         ),
                        )
                 ),
                (_("Database"), (
                        (_("Database information"), (
                                (_("Describe table"),
                                 _("Describe table structure and attributes"),
                                 "self.OnMenuCmd",
                                 "db.describe"),
                                (_("List columns"),
                                 _("List columns for selected table"),
                                 "self.OnMenuCmd",
                                 "db.columns"),
                                (_("List drivers"),
                                 _("List available database drivers"),
                                 "self.OnMenuCmd",
                                 "db.drivers"),
                                (_("List tables"),
                                 _("List tables in selected database"),
                                 "self.OnMenuCmd",
                                 "db.tables"),
                                )
                         ),
                        ("","","", ""),
                        (_("Manage databases"), (
                                (_("Connect"),
                                 _("Connect to database"),
                                 "self.OnMenuCmd",
                                 "db.connect"),
                                (_("Login"),
                                 _("Login to database"),
                                 "self.OnMenuCmd",
                                 "db.login"),
                                ("","","", ""),
                                (_("Copy table"),
                                 _("Copy attribute table"),
                                 "self.OnMenuCmd",
                                 "db.copy"),
                                (_("New table"),
                                 _("Create and connect new attribute table to vector map"),
                                 "self.OnMenuCmd",
                                 "v.db.addtable"),
                                (_("Remove table"),
                                 _("Remove existing attribute table for vector map"),
                                 "self.OnMenuCmd",
                                 "db.login"),
                                ("","","", ""),
                                (_("Add columns"),
                                 _("Add columns to table"),
                                 "self.OnMenuCmd",
                                 "v.db.addcol"),
                                (_("Change values"),
                                 _("Change values in a column"),
                                 "self.OnMenuCmd",
                                 "v.db.update"),
                                (_("Rename column"),
                                 _("Rename a column"),
                                 "self.OnMenuCmd",
                                 "v.db.renamecol"),
                                ("","","", ""),
                                (_("Test"),
                                 _("Test database"),
                                 "self.OnMenuCmd",
                                 "db.test"),
                                )
                         ),
                        (_("Query"), (
                                (_("Query any table"),
                                 _("Query data in any table"),
                                 "self.OnMenuCmd",
                                 "db.select"),
                                (_("Query vector attribute data"),
                                 _("Query vector attribute data"),
                                 "self.OnMenuCmd",
                                 "v.db.select"),
                                (_("SQL statement"),
                                 _("Execute SQL statement"),
                                 "self.OnMenuCmd",
                                 "db.execute"),
                                )
                         ),
                        ("","","", ""),
                        (_("Vector database connections"), (
                                (_("Reconnect vector to database"), 
                                 _("Reconnect vector map to attribute database"),
                                 "self.OnMenuCmd",
                                 "v.db.reconnect.all"),
                                (_("Set vector map - database connection"),
                                 _("Set database connection for vector attributes"),
                                 "self.OnMenuCmd",
                                 "v.db.connect"),
                                )
                         ),
                        )
                 ),
                (_("Help"), (
                        (_("GRASS GIS help"),
                         _("GRASS GIS Reference Manual"),
                         "self.RunMenuCmd",
                         "g.manual -i"),
                        (_("GRASS GIS GUI help"),
                         _("GUI-related Reference Manual"),
                         "self.RunMenuCmd",
                         "g.manual wxGUI"),
                        (_("About GRASS GIS"),
                         _("About GRASS GIS"),
                         "self.OnAboutGRASS",
                         ""),
                        )
                 )
                )
                ]
