#!/bin/bash
# WebSVN	(http://websvn.tigris.org/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-10-10
# require:
#	apache-2.2
#	php-5.2
#
SRC_URI=http://websvn.tigris.org/files/documents/1380/47525/websvn-2.3.1.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
#SRC_NAME=${SRC_FILE%%.tar.gz}
#PAC_NAME=${SRC_NAME%%-stable}
#echo $PAC_NAME; exit

REL=P2
CPU=noarch
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/websvn
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR || exit 1;
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI ) || exit 1;
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK || exit 1;
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1

cd $WORK
mkdir -p opt/htdocs || exit 1;
tar xvfz $SRC_DIR/$SRC_FILE -C opt/htdocs/
(cd opt/htdocs/$PAC_NAME
 sed -e "/config->parentPath/a\ \ \$config->parentPath('/opt/svn');" \
     -e "/config->parentPath/d"  \
     include/distconfig.php > include/config.php
 cp -a $BUILD_DIR/`basename $0`  \
       *.txt doc \
     $WORK/$DOC_DIR
)



mkdir -p $WORK/opt/htdocs/AppList || exit 1;
cat >> $WORK/opt/htdocs/AppList/2.$PAC_NAME.list <<__EOCL__
TYP	2
NAM	${PAC_NAME}
URL	http://websvn.tigris.org/
DOC	/usr/share/doc/${PAC_NAME}
EXE	/WebSVN/
REM	PHP based web interface of Subversion repositories
__EOCL__


mkdir -p $WORK/install || exit 1;
sed -e "s%_APPNAME_%WebSVN%g" -e "s%_PACKAGENAME_%$PAC_NAME%g" \
    $CUSTOM_DIR/doinst.sh > $WORK/install/doinst.sh


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz  || exit 1;

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
