<?php
/*
	スパム対策済コメントプラグイン Ver1.20 by sue445
*/
require_once(PLUGIN_DIR . 'comment.inc.php');

// 設定
// スパムリストを定義したページ(InterWikiNameみたいなもの)
// これをコメントアウトすると後述のNG_WORDが有効になります
//define('SPAMLIST_PAGE', 'SpamList');

// NGワード(コンマで区切る)
define('NG_WORD', '[url],adult,casino,pharmacy,republika,sex,siski.net,insurance,cloud.prohosting.com,white.prohosting.com,pluto.no,narod.ru,loan,viagra,2www.org,cialis,gatech.edu,digmun.info,homepage,hamburg.de,mortgage,bitdom.com,ac.be,onenight-in-paris,diet,poker,naked,nude,ripway.com,planetsti.info,porn,ewqe-r.info,diazepam,buddyprofile.com,href,xyevdrom.org,nrg-search.net,blogspot.com,forumforfree.com,adsenseru.info');

// 投稿されたメッセージに対してNGチェックを行うかどうか(0:無効 1:有効)
define('NOSPAM_MSG', 1);

// 投稿された名前に対してNGチェックを行うかどうか(0:無効 1:有効)
define('NOSPAM_NAME', 1);

// URLを許容する個数(1〜。0で無効)
// コメント中のURLがこの数値を超えるとエラーになります
define('NOSPAM_URL', 0);

// NGワードが含まれていた場合のエラー表示
define('NG_WARNING', 'NGワードが含まれています');

// URLが規定個数以上含まれていた時のエラー表示
define('URL_WARNING', 'URLは' . NOSPAM_URL . '個以内にしてください');

// ブラウザの言語設定がおかしかったらエラー
define('LNG_WARNING', 'ブラウザの言語設定がおかしいです');


function plugin_comment_nospam_action()
{
	global $vars;
	static $spamlist;
	static $filetime1, $filetime2;


	// スパムリスト(SPAMLIST_PAGE or 自分自身)のタイムスタンプを取得
	if(SPAMLIST_PAGE && is_page(SPAMLIST_PAGE)){
		// SPAMLIST_PAGEに記述されているNGリストを使用
		$filetime1 = get_filetime(SPAMLIST_PAGE);
	}
	else{
		// このプラグイン内で定義されているNGリストを使用
		$filetime1 = filemtime(PLUGIN_DIR . 'comment_nospam.inc.php') - LOCALZONE;
	}

	// スパムリストが初期化されてないか、ファイルが更新されていれば初期化
	// ※タイムスタンプを調べても挙動が怪しいので毎回リストを初期化します(汗
	if(!isset($spamlist) || $filetime1 != $filetime2){
		$filetime2 = $filetime1;	// タイムスタンプを保存
		$spamlist = $matches = array();
		if(SPAMLIST_PAGE!='' && is_page(SPAMLIST_PAGE)){
			// SPAMLIST_PAGEに記述されているNGリストを使用
			foreach(get_source(SPAMLIST_PAGE) as $line){
				if(preg_match('/^-{1,3}(.+)$/', $line, $matches)){
					array_push($spamlist, $matches[1]);
				}
			}
		}
		else{
			// このプラグイン内で定義されているNGリストを使用
			foreach(split(',', NG_WORD) as $word){
				array_push($spamlist, $word);
			}
		}
	}

	// URLが規定個数以上含まれていればエラー
	if(NOSPAM_URL > 0 && preg_match_all("/http/", $vars['msg'], $matches) && count($matches[0])>=NOSPAM_URL){
		return array('msg'=>URL_WARNING);
	}

	// スパムチェック
	foreach($spamlist as $word){
		if(NOSPAM_MSG && isset($vars['msg']) && strpos($vars['msg'],$word)!==false){
			return array('msg'=>NG_WARNING);
		}
		else if(NOSPAM_NAME && isset($vars['name']) && strpos($vars['name'],$word)!==false){
			return array('msg'=>NG_WARNING);
		}
	}

	// 環境変数のHTTP_ACCEPT_LANGUAGE(受付可能言語)がおかしかったらエラー
	// ※本来ならHTTP_ACCEPT_LANGUAGE(受付可能言語)とHTTP_ACCEPT(受付可能メディアタイプ)が
	// 　一致することはないんだが、スパム投稿スクリプトではダミーでHTTP_ACCEPTの値を
	// 　HTTP_ACCEPT_LANGUAGEにセットしてあることがある

	// PukiWikiでは$_SERVERのHTTP_USER_AGENTなどは削除されるのでgetenvを使用
	$HTTP_ACCEPT_LANGUAGE	= getenv("HTTP_ACCEPT_LANGUAGE");
	$HTTP_ACCEPT			= getenv("HTTP_ACCEPT");
	if($HTTP_ACCEPT_LANGUAGE=='' || $HTTP_ACCEPT_LANGUAGE==$HTTP_ACCEPT) {
		return array('msg'=>LNG_WARNING);
	}

	/*
	// 旧仕様(Ver1.00)
	foreach(split(',', NG_WORD) as $word){
		if(NOSPAM_MSG==1 && isset($vars['msg']) && preg_match("/" . $word . "/", $vars['msg'])){
			return array('msg'=>NG_WARNING);
		}
		else if(NOSPAM_NAME==1 && isset($vars['name']) && preg_match("/" . $word . "/", $vars['name'])){
			return array('msg'=>NG_WARNING);
		}
	}
	*/

	// comment.inc.phpに丸投げする
	return plugin_comment_action();
}


function plugin_comment_nospam_convert()
{
	/*
	form内の
	  <input type="hidden" name="plugin" value="comment_nospam" />
	以外はcomment.inc.phpと全く同じです(^^;
	*/
	global $vars, $digest, $_btn_comment, $_btn_name, $_msg_comment;
	static $numbers = array();
	static $comment_cols = PLUGIN_COMMENT_SIZE_MSG;

	if (PKWK_READONLY) return ''; // Show nothing

	if (! isset($numbers[$vars['page']])) $numbers[$vars['page']] = 0;
	$comment_no = $numbers[$vars['page']]++;

	$options = func_num_args() ? func_get_args() : array();
	if (in_array('noname', $options)) {
		$nametags = '<label for="_p_comment_comment_' . $comment_no . '">' .
			$_msg_comment . '</label>';
	} else {
		$nametags = '<label for="_p_comment_name_' . $comment_no . '">' .
			$_btn_name . '</label>' .
			'<input type="text" name="name" id="_p_comment_name_' .
			$comment_no .  '" size="' . PLUGIN_COMMENT_SIZE_NAME .
			'" />' . "\n";
	}
	$nodate = in_array('nodate', $options) ? '1' : '0';
	$above  = in_array('above',  $options) ? '1' :
		(in_array('below', $options) ? '0' : PLUGIN_COMMENT_DIRECTION_DEFAULT);

	$script = get_script_uri();
	$s_page = htmlspecialchars($vars['page']);
	$string = <<<EOD
<br />
<form action="$script" method="post">
 <div>
  <input type="hidden" name="plugin" value="comment_nospam" />
  <input type="hidden" name="refer"  value="$s_page" />
  <input type="hidden" name="comment_no" value="$comment_no" />
  <input type="hidden" name="nodate" value="$nodate" />
  <input type="hidden" name="above"  value="$above" />
  <input type="hidden" name="digest" value="$digest" />
  $nametags
  <input type="text"   name="msg" id="_p_comment_comment_{$comment_no}" size="$comment_cols" />
  <input type="submit" name="comment" value="$_btn_comment" />
 </div>
</form>
EOD;

	return $string;
}

?>
