#%% begin initialize drupal-6.19-noarch-P1
###################################################################
export LANG=C
export PATH=/bin:/usr/bin:/sbin:/usr/sbin

if [ -r /tmp/SeTT_PX ]; then
    ROOT="`cat /tmp/SeTT_PX`"
fi

APACI_DIR=$ROOT/opt/httpd
PG_DIR=$ROOT/opt/pgsql
WWW=$ROOT/home/www
export PGLIB=$PG_DIR/lib
export PGDATA=$PG_DIR/data

if [ -f $ROOT/opt/htdocs/drupal6 ]; then
    /bin/mv  $ROOT/opt/htdocs/drupal6  $ROOT/opt/htdocs/drupal6.bak
fi

if [ -f $ROOT/opt/htdocs/drupal6.bak/sites/default/settings.php ]; then
    # update for minor release(security fix and so on)
    /bin/cp -p $ROOT/opt/htdocs/drupal6.bak/sites/default/settings.php \
	       $ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php
    (cd $ROOT/opt/htdocs/drupal6.bak/;
	for i in `find sites/all/themes/ -mindepth 1 -maxdepth 1 -type d`; do \
	    if [ ! -d $ROOT/opt/htdocs/drupal-6.19/$i ]; then
		echo "copying $i ..."
		/bin/cp -a $i $ROOT/opt/htdocs/drupal-6.19/$i
	    fi
	done
	for i in `find sites/all/modules/ -mindepth 1 -maxdepth 1 -type d`; do \
	    if [ ! -d $ROOT/opt/htdocs/drupal-6.19/$i ]; then
		echo "copying $i ..."
		/bin/cp -a $i $ROOT/opt/htdocs/drupal-6.19/$i
	    fi
	done
	)
    /usr/bin/tar cf - -C $ROOT/opt/htdocs/drupal6.bak/ files | /usr/bin/tar xf - -C $ROOT/opt/htdocs/drupal-6.19/
    /bin/rm -f $ROOT/opt/htdocs/drupal-6.19/install.php
    /bin/chmod go-w  /opt/htdocs/drupal-6.19/sites/default/
else
    # newly install
    FQDN=`hostname -f`
    if [ ".$FQDN" = "." ]; then
	FQDN=localhost
    fi
    
    if [ -f $ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php ]; then
	/bin/mv $ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php \
	        $ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php.bak
    fi
    /usr/bin/sed \
	-e "s%^\$db_url = 'mysql://username:password@localhost/databasename';%\$db_url = 'pgsql://www@127.0.0.1/drupal6';%" \
	-e "s%^\$base_url = 'http://localhost';%\$base_url = 'http://$FQDN/drupal6';%" \
	$ROOT/opt/htdocs/drupal-6.19/sites/default/default.settings.php \
	> $ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php

    /bin/chown www:apache \
	$ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php 
    /bin/chmod 640 \
	$ROOT/opt/htdocs/drupal-6.19/sites/default/settings.php 
    
    /bin/mkdir -p $ROOT/opt/htdocs/drupal-6.19/files
    /bin/mkdir -p $ROOT/opt/htdocs/drupal-6.19/sites/default/files
    /bin/cp $ROOT/opt/htdocs/drupal-6.19/custom/_htaccess $ROOT/opt/htdocs/drupal-6.19/.htaccess
    /bin/chown www:apache $ROOT/opt/htdocs/drupal-6.19/files \
			$ROOT/opt/htdocs/drupal-6.19/sites/default/files \
			$ROOT/opt/htdocs/drupal-6.19/.htaccess 
    /bin/chmod 640 $ROOT/opt/htdocs/drupal-6.19/files \
			$ROOT/opt/htdocs/drupal-6.19/.htaccess
fi
(cd $ROOT/opt/htdocs; /bin/rm -f drupal6; /bin/ln -sf drupal-6.19 drupal6 )
(cd $ROOT/usr/bin; /bin/rm -f drush; /bin/ln -sf ../share/drush/drush drush )

# this script check db existance itself.
/bin/su - postgres -c "sh $ROOT/opt/htdocs/drupal6/custom/create_drupal6_db84"

PGRE=0
if [ -f $PG_DIR/data/postgresql.conf ]; then
  if ! egrep "^default_text_search_config = 'pg_catalog.japanese'" $PG_DIR/data/postgresql.conf 1>/dev/null 2>&1; then
    /bin/mv $PG_DIR/data/postgresql.conf $PG_DIR/data/postgresql.conf.bak
    /usr/bin/sed -e "/^default_text_search_config/a default_text_search_config = \'pg_catalog.japanese\'" \
              -e 's/^\(default_text_search_config.*\)/;\1/' \
    $PG_DIR/data/postgresql.conf.bak >  $PG_DIR/data/postgresql.conf
    /bin/chown -R www.apache  $PG_DIR/data/postgresql.conf
    PGRE=1
  fi
fi
if [ -f $PG_DIR/data/pg_hba.conf ]; then
  if ! egrep "^host	drupal6		www" $PG_DIR/data/pg_hba.conf 1>/dev/null 2>&1; then
    /bin/cp -p $PG_DIR/data/pg_hba.conf $PG_DIR/data/pg_hba.conf.bak
    /usr/bin/sed -e "/^# Allow user access to the all database on localhost/a host	drupal6		www	127.0.0.1/32	trust" $PG_DIR/data/pg_hba.conf.bak > $PG_DIR/data/pg_hba.conf
    PGRE=1
  fi
fi

if [ $PGRE = 1 ]; then
  if [ -x /opt/pgsql/bin/pgsqld ]; then
    /opt/pgsql/bin/pgsqld restart
  fi
fi

if [ ! -f $WWW/.postgresql/postgresql.crt ]; then
    /bin/mkdir -p $WWW/.postgresql
    /bin/cp $PG_DIR/data/server.crt $WWW/.postgresql/postgresql.crt
    /bin/cp $PG_DIR/data/server.key $WWW/.postgresql/postgresql.key
    /bin/chown -R www.apache  $WWW/.postgresql
fi

/bin/mkdir -p            $ROOT/opt/htdocs/drupal6/files
/bin/chown -R www.apache $ROOT/opt/htdocs/drupal6/files \
	                 $ROOT/opt/htdocs/drupal6/themes
/bin/chgrp -R apache     $ROOT/opt/htdocs/drupal6

if ! fgrep "drupal6/cron.php" $ROOT/var/spool/cron/crontabs/www 1>/dev/null 2>&1; then
    echo "0  *  *  *  *	/usr/bin/wget -O - -q http://$FQDN/drupal6/cron.php" >> $ROOT/var/spool/cron/crontabs/www
fi

#%% end
