#!/bin/bash
# Apache	(http://httpd.apache.org/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-08-30
# require:
#	openssl-0.9.8
#
SRC_URI="http://www.apache.org/dist/httpd/httpd-2.2.14.tar.gz"
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/02_apache.tgz/
BUILD_DIR=$PLAMO/httpd22
CUSTOM_DIR=$BUILD_DIR/Custom
DOC_DIR=/usr/share/doc/$PAC_NAME

PREFIX=/opt/httpd
#NOMAKE=yes

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
#export CFLAGS="-O2 -mcpu $CPU"
export PATH=$PATH:/usr/X11R6/bin


if [ "$NOMAKE" != "yes" ]; then
tar xvfz $SRC_DIR/$SRC_FILE
fi
cd $PAC_NAME
if [ "$NOMAKE" != "yes" ]; then
 ./configure --prefix=${PREFIX} --enable-proxy --enable-ssl \
	--enable-modules=all --enable-mods-shared=all \
	--enable-dav --enable-dav-fs

 CFLAGS="-O2 -mcpu $CPU" make
fi
 make certificate
 make install DESTDIR=$WORK

mkdir -p $WORK/$DOC_DIR
cp -p  [A-Z][A-Z]* config.log $WORK/$DOC_DIR
cp -p $BUILD_DIR/`basename $0`  $WORK/$DOC_DIR/
cp -p $CUSTOM_DIR/README.webdav  $WORK/$DOC_DIR/
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR

# NOMAKE

#
# packing at work directory
#
cd $WORK
APR_VAR=
if [ -f ./$PREFIX/bin/apr-1-config ]; then
  APR_VER=`./$PREFIX/bin/apr-1-config --version | sed -e 's/^1/0/'`
fi
mkdir -p install
sed -e "s/_APACIVER_/$PAC_NAME/" -e "s/_APRVER_/$APR_VER/" \
    -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/" \
    $CUSTOM_DIR/doinst.sh > install/doinst.sh

mv  ./$PREFIX/bin/apachectl ./$PREFIX/bin/apachectl.bak
sed -e 's%lynx -dump%w3m -no-proxy -dump%' ./$PREFIX/bin/apachectl.bak \
	> ./$PREFIX/bin/apachectl
rm ./$PREFIX/bin/apachectl.bak
chmod +x ./$PREFIX/bin/apachectl

rm -rf ./$PREFIX/conf/original
mkdir -p ./$PREFIX/conf/original
mv ./$PREFIX/conf/{httpd.conf,extra} ./$PREFIX/conf/original/

cp $CUSTOM_DIR/httpd.conf.template ./$PREFIX/conf
cp -a $CUSTOM_DIR/extra  ./$PREFIX/conf/
rm -f ./$PREFIX/conf/extra/httpd-ssl.conf
cp $CUSTOM_DIR/httpd-ssl.conf.template ./$PREFIX/conf/
mkdir -p ./$PREFIX/conf/conf.d
mkdir -p ./$PREFIX/{var,uploads}
chown -R wadm:apache ./$PREFIX
chown -R www ./$PREFIX/{var,uploads,proxy}


tar xvfz $CUSTOM_DIR/sslfiles.tgz -C ./$PREFIX/conf
cp $CUSTOM_DIR/mkrsakey.sh.template ./$PREFIX/bin

mv $WORK/$PREFIX/htdocs/ $WORK/opt/
(cd $CUSTOM_DIR; \
 cp -p index.html.var index.html.ja.utf8 index.html.en  plamo7a_ss.jpg $WORK/opt/htdocs)
rm -f $WORK/opt/htdocs/index.html

mkdir -p $WORK/opt/htdocs/AppList/
cat >> $WORK/opt/htdocs/AppList/0.${PAC_NAME}.list <<__EOCL__
TYP	0
NAM	${PAC_NAME}
URL	http://httpd.apache.org
DOC	manual/
REM	Apache httpd Web Server
__EOCL__


mkdir -p etc/rc.d/init.d
cp $CUSTOM_DIR/rc.httpd etc/rc.d/init.d/httpd
cp -a $CUSTOM_DIR/profile.d etc/
mkdir -p etc/logrotate.d
cp $CUSTOM_DIR/logrotate.httpd $WORK/$PREFIX/logs/

# Rename to actual name to packing
mv ./$PREFIX opt/$PAC_NAME

# make package
tar cvfz ${PAC_NAME}-${SYS_NAME}.tgz \
	opt/$PAC_NAME/ \
	opt/htdocs/ \
	usr/share/doc/$PAC_NAME/ \
	etc/profile.d/httpd.* \
	etc/rc.d/init.d/httpd \
	install/doinst.sh
mv -v ${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/
echo "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz ... done"
cd $CWD
