#!/bin/bash
# Slony1
VERSION=2.0.3-rc3
PAC_NAME=slony1-$VERSION
#
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-09-10
#
# require:
PGVERSION=8.4.1
POSTGRESQL=postgresql-$PGVERSION

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
BLD_DIR=$PLAMO/slony1
CUSTOM_DIR=$BLD_DIR/Custom
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/01_PostgreSQL.tgz
SRC_DIR=$PLAMO/Archive/dbms/pgsql/8.4/
mkdir -p $SRC_DIR/

if [ ! -f $SRC_DIR/slony1-${VERSION}.tar.bz2 ]; then
   (cd $SRC_DIR; wget -N http://main.slony.info/downloads/2.0/source/slony1-${VERSION}.tar.bz2 )
fi
#SRC_NAME_DOC=slony1-${VERSION}-doc.tar.bz2
SRC_NAME_DOC=slony1-2.0.3-rc2-doc.tar.bz2
PAC_NAME_DOC=${SRC_NAME_DOC%%-doc.tar.bz2}
if [ ! -f $SRC_DIR/$SRC_NAME_DOC ]; then
  ( cd $SRC_DIR; wget -N http://main.slony.info/downloads/2.0/source/$SRC_NAME_DOC )
fi

umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin

tar xvfj $SRC_DIR/$PAC_NAME.tar.bz2
cd $PAC_NAME
JADE=jade NSGMLS=onsgmls SGMLSPL=sgmlspl \
PS2PDF=ps2pdf DJPEG=djpeg GROFF=groff PNMTOPS=pnmtops CONVERT=convert \
./configure --prefix=/opt/pgsql --with-pgconfigdir=/opt/pgsql/bin --with-perltools
make
make install DESTDIR=$WORK

DOC_DIR=usr/share/doc/$PAC_NAME/
mkdir -p  $WORK/$DOC_DIR
cp -p $BLD_DIR/`basename $0`  $WORK/$DOC_DIR/
cp -p COPYRIGHT HISTORY-1.1 INSTALL \
  README README.Unicode RELEASE RELEASE-2.0 \
  SAMPLE TODO UPGRADING \
  $WORK/$DOC_DIR/


# Make Documents
cat >>Makefile.global<<_EOF_
#JADE=                   jade
#NSGMLS=                 onsgmls
#SGMLSPL=                sgmlspl
#PS2PDF=                 ps2pdf
#DJPEG=                  djpeg
#GROFF=                  groff
#PNMTOPS=                pnmtops
#CONVERT=                convert
_EOF_
#vi Makefile.global

cd doc
tar cf - `find . -name "*.txt"` | tar xvf - -C $WORK/$DOC_DIR/

for i in concept/ howto/ implementation/; do \
  cd $i
  make
  make install DESTDIR=$WORK
  cd ..
done


cd $WORK
mkdir -p ./usr/share/doc
tar xvfj $SRC_DIR/$SRC_NAME_DOC -C ./usr/share/doc
mv ./usr/share/doc/$PAC_NAME_DOC/doc/adminguide ./usr/share/doc/$PAC_NAME/
rmdir ./usr/share/doc/$PAC_NAME_DOC/doc
rmdir ./usr/share/doc/$PAC_NAME_DOC
chown -R root:root ./usr/
tar cf - -C ./opt/pgsql . | tar xvf - -C ./opt/$POSTGRESQL
rm -rf ./opt/pgsql
#mkdir ./opt/$POSTGRESQL/share/man/
#mv ./usr/share/doc/$PAC_NAME/doc/adminguide/man* ./opt/$POSTGRESQL/share/man/
#mv ./opt/$POSTGRESQL/share/doc ./opt/$POSTGRESQL/share/slony
mkdir -p ./opt/$POSTGRESQL/share/slony
mv ./opt/$POSTGRESQL/share/slony1_*  ./opt/$POSTGRESQL/share/slony/
chown -R root:root ./opt/
 mkdir -p install
 cat >> install/doinst.sh<<_EOF_
#%% begin initialize ${PAC_NAME}-${VERSION}-${SYS_NAME}
/bin/chown -R postgres:pgsql $ROOT/opt/$POSTGRESQL/bin/slon*
/bin/chown -R postgres:pgsql $ROOT/opt/$POSTGRESQL/share/slon*
( cd  /$DOC_DIR; \
  for i in concept howto implementation adminguide; do \
    /bin/ln -sf /$DOC_DIR/$i /opt/$POSTGRESQL/share/slony/\$i
  done
)
#%% end
_EOF_

chown -R root:root $DOC_DIR
chown -R postgres:pgsql ./opt/$POSTGRESQL

tar cvfz ../$PAC_NAME-$SYS_NAME.tgz ./opt/$POSTGRESQL/bin/slon* ./opt/$POSTGRESQL/lib/* ./opt/$POSTGRESQL/share/* ./usr/share/doc/$PAC_NAME/ ./install/doinst.sh

cd $CWD
PAC_NAME2=`echo $PAC_NAME | sed -e 's/-rc/\.rc/g'`
mv -v ${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/${PAC_NAME2}_${PGVERSION}-${SYS_NAME}.tgz 
