#!/bin/sh 

if [ "$USER" != "postgres" ]; then
  echo "$0 must be run by postgres"
fi
echo "Initializing default data base by user $USER ..."

cd

PG_ROOT=/opt/pgsql
PATH=$PATH:$PG_ROOT/bin
PGLIB=$PG_ROOT/lib
PGDATA=$PG_ROOT/data
LD_LIBRARY_PATH=$PGLIB
export PATH PGLIB PGDATA LD_LIBRARY_PATH

# default db already created in 8.3 or more
# echo "running... createdb postgres"
# createdb postgres

sleep 1
echo "running... create roles www,wadm with 8.x createuser command" 
# www never add user / never create db
createuser -S -R -D www
createuser -S -R -d wadm

sleep 1
# create user www from web access
createdb -O www www

# update .cshrc.mine for users
cp -f $PG_ROOT/apps/_cshrc.pgsqlj $PG_ROOT/.cshrc.mine 
