/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONTEXTBLOCK_H__
#define __QZIONTEXTBLOCK_H__

#include "qzionobject.h"

class QZionTextBlockPrivate;


/*!
    \brief QZionTextBlock.

    A QZionTextBlock is a text that can be put in the canvas.
*/
class QZionTextBlock : public QZionObject
{
    Q_OBJECT

public:
    QZionTextBlock(QZionAbstractCanvas* canvas = NULL);

    QZionTextBlock(QZionAbstractCanvas* canvas, const QString &text);

    virtual ~QZionTextBlock();

    QString text() const;
    void setText(const QString &text);

    QSize size() const;
    void setSize(const QSize &size);

    QSize contentsSize() const;

    int preferredWidth();
    void setPreferredWidth(const int width);

    double scale();
    void setScale(double factor);

    virtual QColor color() const;
    virtual void setColor(const QColor &color);

    virtual QRect rect() const;

    /*!
      Paint text on canvas.
    */
    virtual void paint(QPainter* p);

    /*!
      Return a Pixmap of the Widget
     */
    virtual QPixmap toPixmap();

    /*!
      Return a Image of the Widget
     */
    virtual QImage toImage();

Q_SIGNALS:
    void contentsChanged();
    void contentsLoadFinished();

protected:
    QZionTextBlockPrivate *_QZionTextBlock_data;

    friend class QZionTextBlockPrivate;
};

#endif
