;;;
;;; Copyright (c) 2003-2010 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;;; tutcode.scm: TUT-Code for Japanese input.
;;;
;;; TUT-Code<http://www.crew.sfc.keio.ac.jp/~chk/>ϥץȡ
;;; TUT-CodeܸϤԤ
;;;
;;; ǥեȤΥɽ(ȥϤʸȤб)
;;; Ǥtutcode-ruleQWERTYܡѡ
;;;
;;; Ѵ
;;;   ַΤ߼Ƥޤ
;;;   ƵŪѴǽǤ
;;;   Υ르ꥺtc-2.1ΤΤǤ
;;; 
;;; ڸ򤼽Ѵ
;;;   ñַ򤼽ѴǤޤ
;;;   򤼽Ѵtc2Ʊ(SKKƱͤη)Ǥ
;;; 
;;; * 򤼽Ѵ(:/usr/local/share/tc/mazegaki.dic)ؤΥ
;;;   libuim-skk.soεǽȤäƤޤ
;;;   ΤᡢؽǽSKKƱͤưˤʤޤ:
;;;     ꤷϼѴƬޤ
;;;     ꤷϸĿͼ(~/.mazegaki.dic)¸ޤ
;;;   γؽǽ򥪥դˤˤϡ
;;;   tutcode-enable-mazegaki-learning?ѿ#fꤷƤ
;;; 
;;; * ѤѴϼưŪˤϹԤޤ
;;;   ɤߤŪ""ղäѴƤ
;;; 
;;; * 򤼽Ѵط̤εǽ
;;;  - ַ򤼽Ѵ
;;;  - ɤߤ򿭤Ф̤᤿ꤹ뵡ǽɤߤ䴰ǽ
;;;
;;; 
;;; * ɽΰѹϡ㤨~/.uimǰʲΤ褦˵Ҥ롣
;;;   (require "tutcode.scm")
;;;   (tutcode-rule-set-sequences!
;;;     '(((("s" " "))(""))                ; ѹ
;;;       ((("a" "l" "i"))("Ľ"))            ; ɲ
;;;       ((("d" "l" "u"))("" ""))       ; ʤޤ
;;;       ((("d" "l" "d" "u"))("" ""))))
;;;
;;; * T-CodeȤ
;;;   uim-pref-gtkꤹ뤫~/.uimǰʲΤ褦ꤷƤ
;;;    (define tutcode-rule-filename "/usr/local/share/uim/tcode.scm")
;;;    (define tutcode-mazegaki-start-sequence "fj")
;;;    (define tutcode-bushu-start-sequence "jf")
;;;
;;; ڥˤĤơ
;;; generic.scm١ˤưʲѹ򤷤Ƥ롣
;;;  * Υڡͭˤʤ褦ѹ
;;;  * Ҥ餬/ʥ⡼ɤڤؤɲá
;;;  * rk̤(preedit)ʸɽ򤷤ʤ褦ˤ
;;;    (EmacsT/TUT-CodeϴĶtc2ǤɽʤΤǤ˹碌)
;;;  * 򤼽ѴǤSKKμȤΤǡ
;;;    skk.scmΤʴѴɬפʬߡ
;;;  * Ѵǽɲá
;;;  * ϥ⡼ɤɲá
;;;  * ۸ɽǽɲá
;;;  * ưإɽǽɲá

(require-extension (srfi 1 2))
(require "generic.scm")
(require-custom "tutcode-custom.scm")
(require-custom "generic-key-custom.scm")
(require-custom "tutcode-key-custom.scm")
;;(load-plugin "skk") ;SKKθ򤼽񤭼θΤᡢlibuim-skk.so
(require-dynlib "skk")
(require "tutcode-bushudic.scm") ;Ѵ
(require "tutcode-kigoudic.scm") ;ϥ⡼Ѥεɽ
(require "tutcode-dialog.scm"); 򤼽Ѵ񤫤κǧ

;;; user configs

;; widgets and actions

;; widgets
(define tutcode-widgets '(widget_tutcode_input_mode))

;; default activity for each widgets
(define default-widget_tutcode_input_mode 'action_tutcode_direct)

;; actions of widget_tutcode_input_mode
(define tutcode-input-mode-actions
  '(action_tutcode_direct
    action_tutcode_hiragana
    action_tutcode_katakana
    action_tutcode_kigou))

;;; Ѥ륳ɽ
;;; tutcode-context-new(tutcode-custom-load-rule!)
(define tutcode-rule ())
;;; tutcode-rule롢հ(ǸꥹȤ)alist
;;; (ưإѤѴ両ι®Τ)
(define tutcode-reverse-rule-alist ())
;;; tutcode-bushudic롢
;;; հ(ʸѤ2ʸ)alist
;;; (ưإѤѴ両ι®Τ)
(define tutcode-reverse-bushudic-alist ())

;;; ɽѹ/ɲä뤿Υɽ
;;; ~/.uimtutcode-rule-set-sequences!Ͽơ
;;; tutcode-context-newȿǤ롣
(define tutcode-rule-userconfig ())

;;; 䥦ɥΥץ̾
;;; uim-ximUIM_LIBEXECDIR/uim-candwin-prog䥦ɥȤƻѡ
;;; gtk-immoduleɽ䥦ɥѤ뤫ȽǤ뤿ᡢ
;;; "uim-candwin-tbl"ǻϤޤäƤ뤫ɤåƤ롣
;;; ɽ䥦ɥcustomǤ褦ˤ뤿ᡢ
;;; 餫define
;;; XXX:tutcodeʳˤƶΤǡ¾ξ⡣
(define uim-candwin-prog "")
(if tutcode-use-table-style-candidate-window?
  (set! uim-candwin-prog "uim-candwin-tbl-gtk"))

;;; ɽθ䥦ɥγƥܥȥбɽ(138)
;;; ɽ䥦ɥȤƻѤ롣
(define uim-candwin-prog-layout ())
;;; ɽ䥦ɥΥ쥤:QWERTY(JIS)
(define uim-candwin-prog-layout-qwerty-jis
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "^" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "@" "[" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  ":" "]" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "\"" "#" "$" "%" "&" "'" "(" ")" ""   "=" "~" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "`" "{" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" "+"  "*" "}" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  "_" ""  ""))
;;; ɽ䥦ɥΥ쥤:QWERTY(US/ASCII)
(define uim-candwin-prog-layout-qwerty-us
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "-" "=" "\\"
    "q" "w" "e" "r" "t"  "y" "u" "i" "o" "p"  "[" "]" ""
    "a" "s" "d" "f" "g"  "h" "j" "k" "l" ";"  "'" "`" ""
    "z" "x" "c" "v" "b"  "n" "m" "," "." "/"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "_" "+" "|"
    "Q" "W" "E" "R" "T"  "Y" "U" "I" "O" "P"  "{" "}" ""
    "A" "S" "D" "F" "G"  "H" "J" "K" "L" ":"  "\"" "~" ""
    "Z" "X" "C" "V" "B"  "N" "M" "<" ">" "?"  ""  ""  ""))
;;; ɽ䥦ɥΥ쥤:DVORAK
;;; (֤줵줿Τ̵褦ʤΤǰ)
(define uim-candwin-prog-layout-dvorak
  '("1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"  "[" "]" "\\"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"  "/" "=" ""
    "a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"  "-" "`" ""
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"  ""  ""  " "
    "!" "@" "#" "$" "%"  "^" "&" "*" "(" ")"  "{" "}" "|"
    "\"" "<" ">" "P" "Y" "F" "G" "C" "R" "L"  "?" "+" ""
    "A" "O" "E" "U" "I"  "D" "H" "T" "N" "S"  "_" "~" ""
    ":" "Q" "J" "K" "X"  "B" "M" "W" "V" "Z"  ""  ""  ""))
;;; ɽθ䥦ɥγƥܥȥбɽꡣ
;;; (~/.uimϤθǼ¹ԤΤǡ
;;;  ~/.uimѹˤuim-candwin-prog-layout񤭤ɬפ)
(set! uim-candwin-prog-layout
  (case tutcode-candidate-window-table-layout
    ((qwerty-jis) uim-candwin-prog-layout-qwerty-jis)
    ((qwerty-us) uim-candwin-prog-layout-qwerty-us)
    ((dvorak) uim-candwin-prog-layout-dvorak)
    (else ()))) ; default

;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(JIS)ѡ
(define tutcode-table-heading-label-char-list-qwerty-jis
  '("a" "s" "d" "f" "g" "h" "j" "k" "l" ";"
    "q" "w" "e" "r" "t" "y" "u" "i" "o" "p"
    "z" "x" "c" "v" "b" "n" "m" "," "." "/"
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; QWERTY(US)ѡ
(define tutcode-table-heading-label-char-list-qwerty-us
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; DVORAKѡ
(define tutcode-table-heading-label-char-list-dvorak
  '("a" "o" "e" "u" "i"  "d" "h" "t" "n" "s"
    "'" "," "." "p" "y"  "f" "g" "c" "r" "l"
    ";" "q" "j" "k" "x"  "b" "m" "w" "v" "z"
    "1" "2" "3" "4" "5"  "6" "7" "8" "9" "0"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (Ǥ䤹꤫˸)
(define tutcode-table-heading-label-char-list
  tutcode-table-heading-label-char-list-qwerty-jis)
;;; 򤼽Ѵθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list
  '("1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"))
;;; 򤼽Ѵθѥ٥ʸΥꥹ
(define tutcode-heading-label-char-list ())

;;; ϥ⡼ɻθѥ٥ʸΥꥹ(ɽ䥦ɥ)
;;; (ܡɥ쥤Ȥ˽äơ夫鱦ؽ˸)
(define tutcode-table-heading-label-char-list-for-kigou-mode
  (if (null? uim-candwin-prog-layout)
    (delete "" uim-candwin-prog-layout-qwerty-jis)
    (delete "" uim-candwin-prog-layout)))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ(uim)
(define tutcode-uim-heading-label-char-list-for-kigou-mode
  '(" "
    "1" "2" "3" "4" "5" "6" "7" "8" "9" "0"
    "a" "b" "c" "d" "e" "f" "g" "h" "i" "j"
    "k" "l" "m" "n" "o" "p" "q" "r" "s" "t"
    "u" "v" "w" "x" "y" "z"
    "-" "^" "\\" "@" "[" ";" ":" "]" "," "." "/"
    "!" "\"" "#" "$" "%" "&" "'" "(" ")"
    "A" "B" "C" "D" "E" "F" "G" "H" "I" "J"
    "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T"
    "U" "V" "W" "X" "Y" "Z"
    "=" "~" "|" "`" "{" "+" "*" "}" "<" ">" "?" "_"))
;;; ϥ⡼ɻθѥ٥ʸΥꥹ
;;; (ѱѿ⡼ɤȤƻȤˤϡtutcode-kigoudicȹ碌ɬפ)
(define tutcode-heading-label-char-list-for-kigou-mode ())

;;; ưإפǤʸǤɽκݤ˸ʸȤƻȤʸΥꥹ
(define tutcode-auto-help-cand-str-list
  ;; 1,2,3Ǹ򼨤ʸ(1, 2)
  '((("1" "2" "3") ("4" "5" "6")) ; 1ʸ
    (("a" "b" "c") ("d" "e" "f")) ; 2ʸ
    (("A" "B" "C") ("D" "E" "F"))
    (("" "" "") ("" "" "ϻ"))
    (("" "" "") ("" "" ""))
    (("" "" "") ("" "" ""))))

;;; implementations

;;; 򤼽ѴνäƤ뤫ɤ
(define tutcode-dic-init #f)

(define tutcode-prepare-activation
  (lambda (tc)
    (let ((rkc (tutcode-context-rk-context tc)))
      (rk-flush rkc))))

(register-action 'action_tutcode_direct
		 (lambda (tc)
		   '(ja_halfwidth_alnum
		     "a"
		     "ľ"
		     "ľϥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (not (tutcode-context-on? tc))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (tutcode-flush tc)
                     (tutcode-context-set-state! tc 'tutcode-state-off)
                     (tutcode-update-preedit tc))));flushǥꥢɽȿ

(register-action 'action_tutcode_hiragana
		 (lambda (tc)
		   '(ja_hiragana
		     ""
		     "Ҥ餬"
		     "Ҥ餬ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (not (tutcode-context-katakana-mode? tc)))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (tutcode-context-set-katakana-mode! tc #f)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_katakana
		 (lambda (tc)
		   '(ja_katakana
		     ""
		     ""
		     "ʥ⡼"))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (and (tutcode-context-on? tc)
                          (not (eq? (tutcode-context-state tc)
                                    'tutcode-state-kigou))
                          (tutcode-context-katakana-mode? tc))))
		 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (or
                         (not (tutcode-context-on? tc)) ; Ѵ֤ѹʤ
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (begin
                         (tutcode-reset-candidate-window tc)
                         (tutcode-context-set-state! tc 'tutcode-state-on)))
                     (tutcode-context-set-katakana-mode! tc #t)
                     (tutcode-update-preedit tc))))

(register-action 'action_tutcode_kigou
                 (lambda (tc)
                   '(ja_fullwidth_alnum
                     ""
                     ""
                     "ϥ⡼"))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (eq? (tutcode-context-state tc) 'tutcode-state-kigou)))
                 (lambda (c)
		   (let ((tc (tutcode-find-descendant-context c)))
                     (tutcode-prepare-activation tc)
                     (if
                       (not
                         (eq? (tutcode-context-state tc) 'tutcode-state-kigou))
                       (tutcode-flush tc))
                     (tutcode-begin-kigou-mode tc)
                     (tutcode-update-preedit tc))))

;; Update widget definitions based on action configurations. The
;; procedure is needed for on-the-fly reconfiguration involving the
;; custom API
(define tutcode-configure-widgets
  (lambda ()
    (register-widget 'widget_tutcode_input_mode
		     (activity-indicator-new tutcode-input-mode-actions)
		     (actions-new tutcode-input-mode-actions))))

(define tutcode-context-rec-spec
  (append
   context-rec-spec
   '((rk-context    ()) ; ȥʸؤѴΤΥƥ
     ;;; TUT-CodeϾ
     ;;; 'tutcode-state-off TUT-Code
     ;;; 'tutcode-state-on TUT-Code
     ;;; 'tutcode-state-yomi 򤼽Ѵɤ
     ;;; 'tutcode-state-converting 򤼽Ѵθ
     ;;; 'tutcode-state-bushu ϡѴ
     ;;; 'tutcode-state-kigou ϥ⡼
     (state 'tutcode-state-off)
     ;;; ʥ⡼ɤɤ
     ;;; #t: ʥ⡼ɡ#f: Ҥ餬ʥ⡼ɡ
     (katakana-mode #f)
     ;;; 򤼽Ѵ/Ѵоݤʸꥹ(ս)
     ;;; (: 򤼽Ѵɤߡ֤פϤ硢("" "" ""))
     (head ())
     ;;; 򤼽Ѵθֹ
     (nth 0)
     ;;; 򤼽Ѵθ
     (nr-candidates 0)
     ;;; 䥦ɥξ
     ;;; 'tutcode-candidate-window-off ɽ
     ;;; 'tutcode-candidate-window-converting 򤼽Ѵɽ
     ;;; 'tutcode-candidate-window-kigou ɽ
     ;;; 'tutcode-candidate-window-stroke-help ۸ɽ
     ;;; 'tutcode-candidate-window-auto-help ưإɽ
     (candidate-window 'tutcode-candidate-window-off)
     ;;; ȥɽ
     ;;; Ϥ륭ʸбΡget-candidate-handlerѷǤΥꥹ
     (stroke-help ())
     ;;; 򤼽ѴؤκƵŪϿΤλҥƥ
     (child-context ())
     ;;; ҥƥȤμ
     ;;; 'tutcode-child-type-editor ϿѤѴʸԽǥ
     ;;; 'tutcode-child-type-dialog 񤫤κǧ
     (child-type ())
     ;;; ƥƥ
     (parent-context ())
     ;;; ϿʸԽǥ
     (editor ())
     ;;; ǧ
     (dialog ())
     ;;; ѻѴ(SKK abbrev)⡼ɤɤ
     (latin-conv #f)
     )))
(define-record 'tutcode-context tutcode-context-rec-spec)
(define tutcode-context-new-internal tutcode-context-new)
(define tutcode-context-katakana-mode? tutcode-context-katakana-mode)
(define (tutcode-context-on? pc)
  (not (eq? (tutcode-context-state pc) 'tutcode-state-off)))

;;; TUT-CodeΥƥȤ򿷤롣
;;; @return ƥ
(define (tutcode-context-new id im)
  (if (not tutcode-dic-init)
    (if (not (symbol-bound? 'skk-lib-dic-open))
      (begin
        (if (symbol-bound? 'uim-notify-info)
          (uim-notify-info
            (N_ "libuim-skk.so is not available. Mazegaki conversion is disabled")))
        (set! tutcode-use-recursive-learning? #f)
        (set! tutcode-enable-mazegaki-learning? #f))
      (begin
        (skk-lib-dic-open tutcode-dic-filename #f "localhost" 0 'unspecified)
        (if tutcode-use-recursive-learning?
          (require "tutcode-editor.scm"))
        (set! tutcode-dic-init #t)
        (tutcode-read-personal-dictionary))))
  (let ((tc (tutcode-context-new-internal id im)))
    (tutcode-context-set-widgets! tc tutcode-widgets)
    (if (null? tutcode-rule)
      (begin
        (tutcode-custom-load-rule! tutcode-rule-filename)
        (if tutcode-use-dvorak?
          (set! tutcode-rule (tutcode-rule-qwerty-to-dvorak tutcode-rule)))
        ;; tutcode-mazegaki/bushu-start-sequenceϡ
        ;; tutcode-use-dvorak?ΤȤDvorakΥ󥹤Ȥߤʤȿǡ
        ;; Ĥޤꡢruleqwerty-to-dvorakѴȿǤ롣
        (tutcode-custom-set-mazegaki/bushu-start-sequence!)
        (tutcode-rule-commit-sequences! tutcode-rule-userconfig)))
    ;; ɽ䥦ɥ
    (if (null? tutcode-heading-label-char-list)
      (if tutcode-use-table-style-candidate-window?
        (set! tutcode-heading-label-char-list
          (case tutcode-candidate-window-table-layout
            ((qwerty-jis) tutcode-table-heading-label-char-list-qwerty-jis)
            ((qwerty-us) tutcode-table-heading-label-char-list-qwerty-us)
            ((dvorak) tutcode-table-heading-label-char-list-dvorak)
            (else tutcode-table-heading-label-char-list)))
        (set! tutcode-heading-label-char-list
          tutcode-uim-heading-label-char-list)))
    (if (null? tutcode-heading-label-char-list-for-kigou-mode)
      (if tutcode-use-table-style-candidate-window?
        (begin
          (set! tutcode-heading-label-char-list-for-kigou-mode
            tutcode-table-heading-label-char-list-for-kigou-mode)
          ;; ϥ⡼ɤѱѿ⡼ɤȤƻȤᡢ
          ;; tutcode-heading-label-char-list-for-kigou-modeѤˤ
          ;; tutcode-kigoudicƬ
          (require "japanese.scm") ; for ja-wide
          (set! tutcode-kigoudic
            (append
              (map (lambda (lst) (list (ja-wide lst)))
                tutcode-heading-label-char-list-for-kigou-mode)
              (list-tail tutcode-kigoudic
                (length tutcode-heading-label-char-list-for-kigou-mode)))))
        (set! tutcode-heading-label-char-list-for-kigou-mode
          tutcode-uim-heading-label-char-list-for-kigou-mode)))
    (tutcode-context-set-rk-context! tc (rk-context-new tutcode-rule #t #f))
    (if tutcode-use-recursive-learning?
      (tutcode-context-set-editor! tc (tutcode-editor-new tc)))
    (tutcode-context-set-dialog! tc (tutcode-dialog-new tc))
    tc))

;;; Ҥ餬/ʥ⡼ɤڤؤԤ
;;; ξ֤Ҥ餬ʥ⡼ɤξϥʥ⡼ɤڤؤ롣
;;; ξ֤ʥ⡼ɤξϤҤ餬ʥ⡼ɤڤؤ롣
;;; @param pc ƥȥꥹ
(define (tutcode-context-kana-toggle pc)
  (let ((s (tutcode-context-katakana-mode? pc)))
    (tutcode-context-set-katakana-mode! pc (not s))))

;;; äΥƥȤ롣
(define (tutcode-find-root-context pc)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (null? ppc)
      pc
      (tutcode-find-root-context ppc))))

;;; Υƥ(򤼽ѴκƵŪϿΰֿȤ
;;; =ԽΥƥ)롣
(define (tutcode-find-descendant-context pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (if (null? cpc)
      pc
      (tutcode-find-descendant-context cpc))))

;;; 򤼽ѴѸĿͼɤ߹ࡣ
(define (tutcode-read-personal-dictionary)
  (if (not (setugid?))
      (skk-lib-read-personal-dictionary tutcode-personal-dic-filename)))

;;; 򤼽ѴѸĿͼ񤭹ࡣ
;;; @param force? tutcode-enable-mazegaki-learning?#fǤ񤭹फɤ
(define (tutcode-save-personal-dictionary force?)
  (if (and
        (or force? tutcode-enable-mazegaki-learning?)
        (not (setugid?)))
      (skk-lib-save-personal-dictionary tutcode-personal-dic-filename)))

;;; ȥʸؤѴΤrk-push-key!ƤӽФ
;;; ͤ#fǤʤС(ꥹ)car֤
;;; ʥ⡼ɤξͥꥹȤcadr֤
;;; (rk-push-key!ϥȥξ#f֤)
;;; @param pc ƥȥꥹ
;;; @param key ʸ
(define (tutcode-push-key! pc key)
  (let ((res (rk-push-key! (tutcode-context-rk-context pc) key)))
    (and res
      (if
        (and
          (not (null? (cdr res)))
          (tutcode-context-katakana-mode? pc))
        (cadr res)
        (car res)))))

;;; Ѵ֤򥯥ꥢ롣
;;; @param pc ƥȥꥹ
(define (tutcode-flush pc)
  (let ((cpc (tutcode-context-child-context pc)))
    (rk-flush (tutcode-context-rk-context pc))
    (if tutcode-use-recursive-learning?
      (tutcode-editor-flush (tutcode-context-editor pc)))
    (tutcode-dialog-flush (tutcode-context-dialog pc))
    (if (tutcode-context-on? pc) ; ջ˸ƤФ줿ϥˤ
      (tutcode-context-set-state! pc 'tutcode-state-on)) ; Ѵ֤򥯥ꥢ
    (tutcode-context-set-head! pc ())
    (tutcode-context-set-nr-candidates! pc 0)
    (tutcode-reset-candidate-window pc)
    (tutcode-context-set-latin-conv! pc #f)
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (if (not (null? cpc))
      (tutcode-flush cpc))))

;;; ѴоݤʸꥹȤʸ롣
;;; @param sl ʸꥹ
(define (tutcode-make-string sl)
  (if (null? sl)
    ""
    (string-append (tutcode-make-string (cdr sl)) (car sl))))

;;; 򤼽Ѵnܤθ֤
;;; @param pc ƥȥꥹ
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate pc n)
  (let* ((head (tutcode-context-head pc))
         (cand (skk-lib-get-nth-candidate
                n (tutcode-make-string head) "" "" #f)))
    cand))

;;; ϥ⡼ɻnܤθ֤
;;; @param n оݤθֹ
(define (tutcode-get-nth-candidate-for-kigou-mode pc n)
 (car (nth n tutcode-kigoudic)))

;;; 򤼽Ѵθθ֤
;;; @param pc ƥȥꥹ
(define (tutcode-get-current-candidate pc)
  (tutcode-get-nth-candidate pc (tutcode-context-nth pc)))

;;; ϥ⡼ɻθθ֤
(define (tutcode-get-current-candidate-for-kigou-mode pc)
  (tutcode-get-nth-candidate-for-kigou-mode pc (tutcode-context-nth pc)))

;;; 򤼽Ѵǳꤷʸ֤
;;; @param pc ƥȥꥹ
(define (tutcode-prepare-commit-string pc)
  (let* ((res (tutcode-get-current-candidate pc)))
    ;; ĤΥ٥륭θꤹȤǤ褦ˡ
    ;; tutcode-enable-mazegaki-learning?#fξϸ¤ӽѤʤ
    ;; (:֤פѴˤơdǡֲסeǡֲפ)
    (if tutcode-enable-mazegaki-learning?
      (begin
        ;; skk-lib-commit-candidateƤ֤ȳؽԤ졢礬ѹ
        (skk-lib-commit-candidate
          (tutcode-make-string (tutcode-context-head pc)) "" ""
          (tutcode-context-nth pc) #f)
        (if (> (tutcode-context-nth pc) 0)
          (tutcode-save-personal-dictionary #f))))
    (tutcode-flush pc)
    res))

;;; ϥ⡼ɻ˳ꤷʸ֤
(define (tutcode-prepare-commit-string-for-kigou-mode pc)
  (tutcode-get-current-candidate-for-kigou-mode pc))

;;; im-commit-rawƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
(define (tutcode-commit-raw pc key key-state)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-editor)
        (tutcode-editor-commit-raw (tutcode-context-editor ppc) key key-state)
        (tutcode-dialog-commit-raw (tutcode-context-dialog ppc) key key-state))
      (im-commit-raw pc))))

;;; im-commitƤӽФ
;;; ҥƥȤξϡeditordialogϥϤ
;;; @param str ߥåȤʸ
(define (tutcode-commit pc str)
  (let ((ppc (tutcode-context-parent-context pc)))
    (if (not (null? ppc))
      (if (eq? (tutcode-context-child-type ppc) 'tutcode-child-type-editor)
        (tutcode-editor-commit (tutcode-context-editor ppc) str)
        (tutcode-dialog-commit (tutcode-context-dialog ppc) str))
      (im-commit pc str))))

;;; im-commitƤӽФȤȤˡưإɽΥåԤ
(define (tutcode-commit-with-auto-help pc)
  (let* ((head (tutcode-context-head pc))
         (res (tutcode-prepare-commit-string pc)))
    (tutcode-commit pc res)
    (tutcode-check-auto-help-window-begin pc (string-to-list res) head)))

;;; 򤼽Ѵθˡꤵ줿٥ʸбꤹ
(define (tutcode-commit-by-label-key pc ch)
  ;; ߸䥦ɥɽƤʤ٥ʸϤ硢
  ;; ߰ʹߤθˤϥ٥ʸбꤹ롣
  ;; (ؽǽ򥪥դˤƸ¤ӽˤƻѤˡ
  ;; next-page-key򲡤򸺤餷
  ;; ʤ٤ʤŪθ٤褦ˤ뤿)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (cur-page (cond
                     ((= tutcode-nr-candidate-max 0) 0)
                     (else
                       (quotient nth tutcode-nr-candidate-max))))
         ;; ߸䥦ɥɽθꥹȤƬθֹ
         (cur-offset (* cur-page tutcode-nr-candidate-max))
         (cur-labels (list-tail
                       tutcode-heading-label-char-list
                       (remainder cur-offset
                                  (length tutcode-heading-label-char-list))))
         (target-labels (member ch cur-labels))
         (offset (if target-labels
                   (- (length cur-labels) (length target-labels))
                   (+ (length cur-labels)
                      (- (length tutcode-heading-label-char-list)
                         (length
                           (member ch tutcode-heading-label-char-list))))))
         (idx (+ cur-offset offset)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit-with-auto-help pc)))))

;;; ϥ⡼ɻˡꤵ줿٥ʸбꤹ
(define (tutcode-commit-by-label-key-for-kigou-mode pc ch)
  ;; 򤼽ѴȰۤʤꡢߤθꤹ礢
  ;; (ѱѿϥ⡼ɤȤƻȤ褦ˤ뤿)
  ;; (ϥ⡼ɻϡٳꤷϢ³ϤǤ褦ˡ
  ;; ľθ򤷤Ƥ뤬
  ;; ΤȤ򤼽ѴƱͤθԤȡ
  ;; ٥ʸꥹȤ2ܤбꤷƤޤ礬
  ;; (:thǤä硢ѱѿϤȤƤϣˤʤäߤˤʤ)
  ;; ᡢ򤼽ѴȤϰۤʤԤ)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (labellen (length tutcode-heading-label-char-list-for-kigou-mode))
         (cur-base (quotient nth labellen))
         (offset
           (- labellen
              (length
                (member ch tutcode-heading-label-char-list-for-kigou-mode))))
         (idx (+ (* cur-base labellen) offset)))
    (if (and (>= idx 0)
             (< idx nr))
      (begin
        (tutcode-context-set-nth! pc idx)
        (tutcode-commit pc
          (tutcode-prepare-commit-string-for-kigou-mode pc))))))

;;; 򤼽Ѵ񤫤顢򤵤Ƥ롣
(define (tutcode-purge-candidate pc)
  (let ((res (skk-lib-purge-candidate
               (tutcode-make-string (tutcode-context-head pc))
               ""
               ""
               (tutcode-context-nth pc)
               #f)))
    (if res
      (tutcode-save-personal-dictionary #t))
    (tutcode-reset-candidate-window pc)
    (tutcode-flush pc)
    res))

;;; 򤼽Ѵɤ/Ѵ(ʸꥹhead)ʸɲä롣
;;; @param pc ƥȥꥹ
;;; @param str ɲäʸ
(define (tutcode-append-string pc str)
  (if (and str (string? str))
    (tutcode-context-set-head! pc
      (cons str
        (tutcode-context-head pc)))))

;;; 򤼽񤭼θԤ
;;; @param pc ƥȥꥹ
;;; @param autocommit? 䤬1Ĥξ˼ưŪ˳ꤹ뤫ɤ
;;; @param recursive-learning? 䤬̵˺ƵϿ⡼ɤ뤫ɤ
(define (tutcode-begin-conversion pc autocommit? recursive-learning?)
  (let* ((yomi (tutcode-make-string (tutcode-context-head pc)))
         (res (and (symbol-bound? 'skk-lib-get-entry)
                   (skk-lib-get-entry yomi "" "" #f))))
    (if res
      (begin
        (tutcode-context-set-nth! pc 0)
        (tutcode-context-set-nr-candidates! pc
         (skk-lib-get-nr-candidates yomi "" "" #f))
        (tutcode-context-set-state! pc 'tutcode-state-converting)
        (if (and autocommit? (= (tutcode-context-nr-candidates pc) 1))
          ;; 䤬1ĤʤϼưŪ˳ꤹ롣
          ;; (Ͽtutcode-register-candidate-key򲡤Ū˳Ϥ)
          (tutcode-commit-with-auto-help pc)
          (begin
            (tutcode-check-candidate-window-begin pc)
            (if (eq? (tutcode-context-candidate-window pc)
                     'tutcode-candidate-window-converting)
              (im-select-candidate pc 0)))))
      ;; ̵
      (if recursive-learning?
        (begin
          (tutcode-context-set-state! pc 'tutcode-state-converting)
          (tutcode-setup-child-context pc 'tutcode-child-type-editor)))
        ;(tutcode-flush pc) ; flushϤʸ󤬾äƤä
        )))

;;; ҥƥȤ롣
;;; @param type 'tutcode-child-type-editor'tutcode-child-type-dialog
(define (tutcode-setup-child-context pc type)
  (let ((cpc (tutcode-context-new (tutcode-context-uc pc)
              (tutcode-context-im pc))))
    (tutcode-context-set-child-context! pc cpc)
    (tutcode-context-set-child-type! pc type)
    (tutcode-context-set-parent-context! cpc pc)
    (if (eq? type 'tutcode-child-type-editor)
      (tutcode-context-set-state! cpc 'tutcode-state-on)
      (tutcode-context-set-state! cpc 'tutcode-state-off))))

;;; ϥ⡼ɤ򳫻Ϥ롣
;;; @param pc ƥȥꥹ
(define (tutcode-begin-kigou-mode pc)
  (tutcode-context-set-nth! pc 0)
  (tutcode-context-set-nr-candidates! pc (length tutcode-kigoudic))
  (tutcode-context-set-state! pc 'tutcode-state-kigou)
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-kigou)
    (im-select-candidate pc 0)))

;;; 䥦ɥɽ򳫻Ϥ
(define (tutcode-check-candidate-window-begin pc)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-candidate-window?
           (>= (tutcode-context-nth pc) (- tutcode-candidate-op-count 1)))
    (begin
      (tutcode-context-set-candidate-window! pc
        (if (eq? (tutcode-context-state pc) 'tutcode-state-kigou)
          'tutcode-candidate-window-kigou
          'tutcode-candidate-window-converting))
      (im-activate-candidate-selector
        pc
        (tutcode-context-nr-candidates pc)
        (if (eq? (tutcode-context-state pc) 'tutcode-state-kigou)
          tutcode-nr-candidate-max-for-kigou-mode
          tutcode-nr-candidate-max)))))

;;; ۸פɽ򳫻Ϥ
(define (tutcode-check-stroke-help-window-begin pc)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-stroke-help-window?)
    (let* ((rkc (tutcode-context-rk-context pc))
           (seq (rk-context-seq rkc))
           (seqlen (length seq))
           (ret (rk-lib-find-partial-seqs (reverse seq) tutcode-rule))
           (label-cand-alist ())) ; :(("k" "") ("i" "") ("v" ""))
      (for-each
        (lambda (elem) ; : ((("r" "v" "y")) (""))
          (let* ((label (nth seqlen (caar elem)))
                 (label-cand (assoc label label-cand-alist)))
            ;; ǽθΤɽ
            ;; (tutcode-rule-commit-sequences!ˤꡢƱ쥷󥹤θ䤬
            ;;  ʣ礬뤬ɽθǤϺǽΤ߻ѤΤ)
            (if (not label-cand)
              (let*
                ((candlist (cadr elem))
                 (cand
                  (or
                    ;; ξϢ
                    (and (> (length (caar elem)) (+ seqlen 1)) "")
                    (or
                      (and (not (null? (cdr candlist)))
                           (tutcode-context-katakana-mode? pc)
                           (cadr candlist))
                      (car candlist))))
                 (candstr
                   (case cand
                    ((tutcode-mazegaki-start) "")
                    ((tutcode-latin-conv-start) "/")
                    ((tutcode-bushu-start) "")
                    (else cand))))
                (set! label-cand-alist
                  (cons (list label candstr) label-cand-alist))))))
        ret)
      (if (not (null? label-cand-alist))
        (let
          ((stroke-help
            (map
              (lambda (elem)
                (list (cadr elem) (car elem) ""))
              (reverse label-cand-alist))))
          (tutcode-context-set-stroke-help! pc stroke-help)
          (tutcode-context-set-candidate-window! pc
            'tutcode-candidate-window-stroke-help)
          (im-activate-candidate-selector pc
            (length stroke-help) tutcode-nr-candidate-max-for-kigou-mode))))))

;;; ۸פɽԤɤŪڤؤ(ȥ)
;;; (ɽܤʤΤǡǤ¤äȤɽ
;;;  XXX: tc2ȡְ˼Ǹ̵ä鲾۸פ
;;;  ɽ褦ˤʤäƤ뤬uimƱȤ򤹤Τ񤷤)
(define (tutcode-toggle-stroke-help pc)
  (if tutcode-use-stroke-help-window?
    (begin
      (set! tutcode-use-stroke-help-window? #f)
      (tutcode-reset-candidate-window pc))
    (begin
      (set! tutcode-use-stroke-help-window? #t)
      (tutcode-check-stroke-help-window-begin pc))))

;;; Ѵ򤼽ѴǳꤷʸǤɽ롣
;;; ɽθ䥦ɥξϡʲΤ褦ɽ롣
;;; 11Ǹ22Ǹַȡ
;;;      
;;;      3 
;;;  1   
;;;  2     
;;; 򤼽ѴʣʸַӡפѴϡʲΤ褦ɽ롣
;;;      
;;;  a     3 
;;;  1b  c 
;;;  2     
;;; ꤷʸľϤǤʤ硢ñѴϤǤС
;;; ʲΤ褦Ѵˡɽ롣ͫݵ
;;; 
;;;                               
;;;   
;;;         b                 g   
;;;   
;;;   3                       1   
;;;   
;;;     e   f   2a(Ӵ)        
;;; 
;;;
;;; ̾θ䥦ɥξϡʲΤ褦ɽ롣
;;;   ͫ lns
;;;   ݵ Ӵ nt cbo
;;;
;;; @param strlist ꤷʸΥꥹ(ս)
;;; @param yomilist ѴɤߤʸΥꥹ(ս)
(define (tutcode-check-auto-help-window-begin pc strlist yomilist)
  (if (and (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off)
           tutcode-use-auto-help-window?)
    (let*
      ((helpstrlist (lset-difference string=? (reverse strlist) yomilist))
       (label-cands-alist
        (if (not tutcode-auto-help-with-real-keys?)
          ;; ɽξ:(("y" "2" "1") ("t" "3"))
          (tutcode-auto-help-update-stroke-alist
            () tutcode-auto-help-cand-str-list helpstrlist)
          ;; ̾ξ:(("" "t" "y" "y"))
          (reverse
            (tutcode-auto-help-update-stroke-alist-normal () helpstrlist)))))
      (if (not (null? label-cands-alist))
        (let
          ((stroke-help
            (map
              (lambda (elem)
                (list (tutcode-make-string (cdr elem)) (car elem) ""))
              label-cands-alist)))
          (tutcode-context-set-stroke-help! pc stroke-help)
          (tutcode-context-set-candidate-window! pc
            'tutcode-candidate-window-auto-help)
          (im-activate-candidate-selector pc
            (length stroke-help) tutcode-nr-candidate-max-for-kigou-mode))))))

;;; ưإפɽɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦Ǹ򼨤٥ʸȡɽʸΥꥹ
;;;  :(("y" "2" "1") ("t" "3")) ; ("y" "y" "t")Ȥȥ򸽤
;;;      
;;;  3 12
;;;      
;;;      
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist label-cands-alist
         cand-list kanji-list)
  (if (or (null? cand-list) (null? kanji-list))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist
      (tutcode-auto-help-update-stroke-alist-with-kanji
        label-cands-alist (car cand-list) (car kanji-list))
      (cdr cand-list) (cdr kanji-list))))

;;; ưإפ̾ɽ˻Ȥalist򹹿롣
;;; alistϰʲΤ褦ʸȡʸϤ뤿ΥΥꥹ(ս)
;;;  :(("" "t" "y" "y"))
;;; @param label-cands-alist alist
;;; @param kanji-list إɽоݤǤ롢ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal label-cands-alist
         kanji-list)
  (if (null? kanji-list)
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-normal
      (tutcode-auto-help-update-stroke-alist-normal-with-kanji
        label-cands-alist (car kanji-list))
      (cdr kanji-list))))

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-kanji label-cands-alist
         cand-list kanji)
  (let ((stroke (tutcode-reverse-find-seq kanji)))
    (if stroke
      (tutcode-auto-help-update-stroke-alist-with-stroke
        label-cands-alist (car cand-list) stroke)
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (tutcode-auto-help-update-stroke-alist-with-stroke
            (tutcode-auto-help-update-stroke-alist-with-stroke
              label-cands-alist
              (cons
                (string-append (caar cand-list) "("
                  (caar (cdar decomposed)) (caar (cdadr decomposed)) ")")
                (cdar cand-list))
              (caaar decomposed)) ; 1
            (cadr cand-list) (caaadr decomposed))))))) ; 2

;;; ưإ:оݤ1ʸϤ륹ȥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param kanji إɽоʸ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-kanji
          label-cands-alist kanji)
  (let ((stroke (tutcode-reverse-find-seq kanji)))
    (if stroke
      (tutcode-auto-help-update-stroke-alist-normal-with-stroke
        label-cands-alist stroke kanji)
      (let ((decomposed (tutcode-auto-help-bushu-decompose kanji)))
        ;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
        (if (not decomposed)
          label-cands-alist
          (tutcode-auto-help-update-stroke-alist-normal-with-stroke
            label-cands-alist
            (cons
              (string-append ""
                (caar (cdar decomposed)) (caar (cdadr decomposed)) " ")
              (append
                (caaar decomposed)    ; 1
                (list " ")
                (caaadr decomposed))) ; 2
            kanji))))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param stroke оݥȥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-stroke label-cands-alist
         cand-list stroke)
  (if (or (null? cand-list) (null? stroke))
    label-cands-alist
    (tutcode-auto-help-update-stroke-alist-with-stroke
      (tutcode-auto-help-update-stroke-alist-with-key
        label-cands-alist cand-list (car stroke))
      (cdr cand-list) (cdr stroke))))

;;; ưإ:оݤΥȥ(Υꥹ)إalistɲä롣
;;; @param label-cands-alist alist
;;; @param stroke оݥȥ
;;; @param label ꤵ줿
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-normal-with-stroke
          label-cands-alist stroke label)
  (let ((label-cand (assoc label label-cands-alist)))
    (if (not label-cand)
      (cons (cons label (reverse stroke)) label-cands-alist))))

;;; ưإ:оݤΥإalistɲä롣
;;; @param label-cands-alist alist
;;; @param cand-list إɽ˻ȤǸ򼨤ʸΥꥹ
;;; @param key оݥ
;;; @return μưإalist
(define (tutcode-auto-help-update-stroke-alist-with-key label-cands-alist
         cand-list key)
  (let*
    ((label key)
     (label-cand (assoc label label-cands-alist))
     (cand (if (pair? cand-list) (car cand-list) "")))
    (if label-cand
      (begin
        (set-cdr! label-cand (cons cand (cdr label-cand)))
        label-cands-alist)
      (cons (list label cand) label-cands-alist))))

;;; preeditɽ򹹿롣
(define (tutcode-do-update-preedit pc)
  (let ((stat (tutcode-context-state pc))
        (cpc (tutcode-context-child-context pc)))
    (case stat
      ((tutcode-state-yomi)
        (im-pushback-preedit pc preedit-none "")
        (let ((h (tutcode-make-string (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-converting)
        (im-pushback-preedit pc preedit-none "")
        (if (null? cpc)
          (im-pushback-preedit pc preedit-none
            (tutcode-get-current-candidate pc))
          ;; child context's preedit
          (let ((h (tutcode-make-string (tutcode-context-head pc)))
                (editor (tutcode-context-editor pc))
                (dialog (tutcode-context-dialog pc)))
            (if (string? h)
              (im-pushback-preedit pc preedit-none h))
            (im-pushback-preedit pc preedit-none "")
            (im-pushback-preedit pc preedit-none
              (if (eq? (tutcode-context-child-type pc)
                    'tutcode-child-type-editor)
                (tutcode-editor-get-left-string editor)
                (tutcode-dialog-get-left-string dialog)))
	    (tutcode-do-update-preedit cpc)
            (im-pushback-preedit pc preedit-none
              (if (eq? (tutcode-context-child-type pc)
                    'tutcode-child-type-editor)
                (tutcode-editor-get-right-string editor)
                (tutcode-dialog-get-right-string dialog)))
            (im-pushback-preedit pc preedit-none ""))))
      ;; ѴΥޡʸȤheadǴ(ƵŪΤ)
      ((tutcode-state-bushu)
        (let ((h (tutcode-make-string (tutcode-context-head pc))))
          (if (string? h)
            (im-pushback-preedit pc preedit-none h))))
      ((tutcode-state-kigou)
        ;; 䥦ɥɽǤǤ褦preeditɽ
        (im-pushback-preedit pc preedit-reverse
          (tutcode-get-current-candidate-for-kigou-mode pc))))
    (if (null? cpc)
      (im-pushback-preedit pc preedit-cursor ""))))

;;; preeditɽ򹹿롣
(define (tutcode-update-preedit pc)
  (im-clear-preedit pc)
  (tutcode-do-update-preedit (tutcode-find-root-context pc))
  (im-update-preedit pc))

;; called from tutcode-editor
;;; tutcode-editor¦ǤԽλ˸ƤФ롣
;;; @param str ǥ¦ǳꤵ줿ʸ
(define (tutcode-commit-editor-context pc str)
  (let ((ppc (tutcode-context-parent-context pc)))
    (tutcode-flush pc)
    (tutcode-context-set-child-context! pc ())
    (tutcode-context-set-child-type! pc ())
    (tutcode-commit pc str)
    (tutcode-update-preedit pc)))

;;; TUT-CodeϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-on c key key-state)
  (let*
    ((pc (tutcode-find-descendant-context c))
     (rkc (tutcode-context-rk-context pc)))
    (tutcode-reset-candidate-window pc)
    (cond
      ((and
        (tutcode-vi-escape-key? key key-state)
        tutcode-use-with-vi?)
       (rk-flush rkc)
       (tutcode-context-set-state! pc 'tutcode-state-off)
       (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
       (rk-flush rkc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-begin-kigou-mode pc))
      ((tutcode-kana-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-context-kana-toggle pc))
      ((tutcode-backspace-key? key key-state)
       (if (> (length (rk-context-seq rkc)) 0)
         (rk-flush rkc)
         (tutcode-commit-raw pc key key-state)))
      ((tutcode-stroke-help-toggle-key? key key-state)
       (tutcode-toggle-stroke-help pc))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
       (rk-flush rkc)
       (tutcode-commit-raw pc key key-state))
      ;; ʤ󥹤ƼΤƤ(tc2˹碌ư)
      ;; (rk-push-key!ȡޤǤΥ󥹤ϼΤƤ뤬
      ;; ְäϻĤäƤޤΤǡrk-push-key!ϻȤʤ)
      ((not (rk-expect-key? rkc (charcode->string key)))
       (if (> (length (rk-context-seq rkc)) 0)
         (rk-flush rkc) ; ʤ󥹤ϼΤƤ
         ;; ñȤΥ(TUT-CodeϤǤʤ)
         (tutcode-commit-raw pc key key-state)))
      (else
       (let ((res (tutcode-push-key! pc (charcode->string key))))
         (if res
           (case res
            ((tutcode-mazegaki-start)
              (tutcode-context-set-latin-conv! pc #f)
              (tutcode-context-set-state! pc 'tutcode-state-yomi))
            ((tutcode-latin-conv-start)
              (tutcode-context-set-latin-conv! pc #t)
              (tutcode-context-set-state! pc 'tutcode-state-yomi))
            ((tutcode-bushu-start)
              (tutcode-context-set-state! pc 'tutcode-state-bushu)
              (tutcode-append-string pc ""))
            (else
              (tutcode-commit pc res)))
	   (tutcode-check-stroke-help-window-begin pc)))))))

;;; ľϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-off c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (if (tutcode-on-key? key key-state)
      (tutcode-context-set-state! pc 'tutcode-state-on)
      (tutcode-commit-raw pc key key-state))))

;;; ϥ⡼ɻΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-kigou c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((and
        (tutcode-vi-escape-key? key key-state)
        tutcode-use-with-vi?)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off)
       (tutcode-commit-raw pc key key-state)) ; ESC򥢥ץˤϤ
      ((tutcode-off-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kigou-toggle-key? key key-state)
       (tutcode-reset-candidate-window pc)
       (tutcode-context-set-state! pc 'tutcode-state-on))
      ;; ڡѥڡϲǽȤ뤿ᡢ
      ;; next-candidate-key?Υåheading-label-char?å
      ((and tutcode-commit-candidate-by-label-key?
            (not (and (modifier-key-mask key-state)
                      (not (shift-key-mask key-state))))
            (tutcode-heading-label-char-for-kigou-mode? key))
        (tutcode-commit-by-label-key-for-kigou-mode pc (charcode->string key))
        (if (eq? (tutcode-context-candidate-window pc)
                 'tutcode-candidate-window-kigou)
          (im-select-candidate pc (tutcode-context-nth pc))))
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-begin-kigou-mode pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc
          tutcode-nr-candidate-max-for-kigou-mode))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc
          (- tutcode-nr-candidate-max-for-kigou-mode)))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
        (tutcode-commit pc (tutcode-prepare-commit-string-for-kigou-mode pc)))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
        (tutcode-commit-raw pc key key-state))
      (else
        (tutcode-commit-raw pc key key-state)))))

;;; 򤼽ѴɤϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-yomi c key key-state)
  (let* ((pc (tutcode-find-descendant-context c))
         (rkc (tutcode-context-rk-context pc))
         (res #f))
    (tutcode-reset-candidate-window pc)
    (cond
      ((tutcode-off-key? key key-state)
       (tutcode-flush pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kana-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-context-kana-toggle pc))
      ((tutcode-backspace-key? key key-state)
       (if (> (length (rk-context-seq rkc)) 0)
        (rk-flush rkc)
        (if (> (length (tutcode-context-head pc)) 0)
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
       (tutcode-commit pc (tutcode-make-string (tutcode-context-head pc)))
       (tutcode-flush pc))
      ((tutcode-cancel-key? key key-state)
       (tutcode-flush pc))
      ((tutcode-stroke-help-toggle-key? key key-state)
       (tutcode-toggle-stroke-help pc))
      ;; 1Ĥξ硢Ѵ弫ưꤵconverting⡼ɤʤΤ
      ;; ξǤpurgeǤ褦ˡǥå
      ((and (tutcode-purge-candidate-key? key key-state)
            (not (null? (tutcode-context-head pc))))
       ;; converting⡼ɤ˰ܹԤƤpurge
       (tutcode-begin-conversion pc #f #f)
       (if (eq? (tutcode-context-state pc) 'tutcode-state-converting)
         (tutcode-proc-state-converting pc key key-state)))
      ((and (tutcode-register-candidate-key? key key-state)
            tutcode-use-recursive-learning?)
       (tutcode-context-set-state! pc 'tutcode-state-converting)
       (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((symbol? key)
       (tutcode-flush pc)
       (tutcode-proc-state-on pc key key-state))
      ((and
        (modifier-key-mask key-state)
        (not (shift-key-mask key-state)))
       ;; <Control>nǤѴ?
       (if (tutcode-begin-conv-key? key key-state)
         (if (not (null? (tutcode-context-head pc)))
           (tutcode-begin-conversion pc #t tutcode-use-recursive-learning?)
           (tutcode-flush pc))
         (begin
           (tutcode-flush pc)
           (tutcode-proc-state-on pc key key-state))))
      ((not (rk-expect-key? rkc (charcode->string key)))
       (if (> (length (rk-context-seq rkc)) 0)
         (rk-flush rkc)
         ;; spaceǤѴ?
         ;; (spaceϥ󥹤˴ޤޤ礬Τǡ
         ;;  rk-expectspace̵Ȥ)
         ;; (trycodespaceǻϤޤ륭󥹤ȤäƤ硢
         ;;  spaceѴϤϤǤʤΤǡ<Control>nȤɬפ)
         (if (tutcode-begin-conv-key? key key-state)
           (if (not (null? (tutcode-context-head pc)))
             (tutcode-begin-conversion pc #t tutcode-use-recursive-learning?)
             (tutcode-flush pc))
           (set! res (charcode->string key)))))
      ((tutcode-context-latin-conv pc)
       (set! res (charcode->string key)))
      (else
       (set! res (tutcode-push-key! pc (charcode->string key)))
       (if (not res)
        (tutcode-check-stroke-help-window-begin pc))))
    (if res
      (tutcode-append-string pc res))))

;;; ѴϾ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-bushu c key key-state)
  (let* ((pc (tutcode-find-descendant-context c))
         (rkc (tutcode-context-rk-context pc))
         (res #f))
    (tutcode-reset-candidate-window pc)
    (cond
      ((tutcode-off-key? key key-state)
       (tutcode-flush pc)
       (tutcode-context-set-state! pc 'tutcode-state-off))
      ((tutcode-kana-toggle-key? key key-state)
       (rk-flush rkc)
       (tutcode-context-kana-toggle pc))
      ((tutcode-backspace-key? key key-state)
       (if (> (length (rk-context-seq rkc)) 0)
        (rk-flush rkc)
        ;; head1ʸܤѴΥޡbackspaceǤϾäʤ褦
        ;; 롣ְäƳѤʸäʤ褦ˤ뤿ᡣ
        (if (> (length (tutcode-context-head pc)) 1)
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
        ;; ƵŪѴ(ꤷ)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
          (set! res #f))
        (if (= (length (tutcode-context-head pc)) 0)
          (begin
            ;; Ǿ̤Ѵξ硢Ѵ󤬤commit
            (if res
              (tutcode-commit pc res))
            (tutcode-flush pc)
            (if res (tutcode-check-auto-help-window-begin pc (list res) ()))
            (set! res #f))))
      ((tutcode-cancel-key? key key-state)
        ;; ƵŪѴ(󥻥뤷)᤹
        (set! res (car (tutcode-context-head pc)))
        (tutcode-context-set-head! pc (cdr (tutcode-context-head pc)))
        (if (not (string=? res ""))
          ;; ⤦1ʸ(ΤϤ)äơä
          (tutcode-context-set-head! pc (cdr (tutcode-context-head pc))))
        (set! res #f)
        (if (= (length (tutcode-context-head pc)) 0)
          (tutcode-flush pc)))
      ((tutcode-stroke-help-toggle-key? key key-state)
       (tutcode-toggle-stroke-help pc))
      ((or
        (symbol? key)
        (and
          (modifier-key-mask key-state)
          (not (shift-key-mask key-state))))
       (tutcode-flush pc)
       (tutcode-proc-state-on pc key key-state))
      ((not (rk-expect-key? rkc (charcode->string key)))
       (if (> (length (rk-context-seq rkc)) 0)
         (rk-flush rkc)
         (set! res (charcode->string key))))
      (else
       (set! res (tutcode-push-key! pc (charcode->string key)))
       (case res
        ((tutcode-mazegaki-start) ;XXX Ѵϸ򤼽Ѵ̵ˤ
          (set! res #f))
        ((tutcode-latin-conv-start)
          (set! res #f))
        ((tutcode-bushu-start) ; ƵŪѴ
          (tutcode-append-string pc "")
          (set! res #f))
        ((#f)
	  (tutcode-check-stroke-help-window-begin pc)))))
    (if res
      (let loop ((prevchar (car (tutcode-context-head pc)))
                  (char res))
        (if (string=? prevchar "")
          (tutcode-append-string pc char)
          ;; ľʸޡǤʤ2ʸܤϤ줿Ѵ
          (begin
            (set! char
              (tutcode-bushu-convert prevchar char))
            (if (string? char)
              ;; 
              (begin
                ;; 1ܤȢä
                (tutcode-context-set-head! pc (cddr (tutcode-context-head pc)))
                (if (null? (tutcode-context-head pc))
                  ;; ѴԤ󤬻ĤäƤʤСꤷƽλ
                  (begin
                    (tutcode-commit pc char)
                    (tutcode-flush pc)
                    (tutcode-check-auto-help-window-begin pc (list char) ()))
                  ;; 󤬤ޤĤäƤСƳǧ
                  ;; (ʸ2ʸܤʤСϢ³Ѵ)
                  (loop
                    (car (tutcode-context-head pc))
                    char)))
              ;; ԻϤľԤ
              )))))))

;;; 򤹤
;;; @param pc ƥȥꥹ
;;; @param num ߤθֹ椫鿷ֹޤǤΥեå
(define (tutcode-change-candidate-index pc num)
  (let* ((nr (tutcode-context-nr-candidates pc))
         (nth (tutcode-context-nth pc))
         (new-nth (+ nth num)))
    (cond
      ((< new-nth 0)
       (set! new-nth 0))
      ((and tutcode-use-recursive-learning? (= nth (- nr 1)) (>= new-nth nr))
       (tutcode-reset-candidate-window pc)
       (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((>= new-nth nr)
       (set! new-nth (- nr 1))))
    (tutcode-context-set-nth! pc new-nth))
  (if (null? (tutcode-context-child-context pc))
    (begin
      (tutcode-check-candidate-window-begin pc)
      (if (not (eq? (tutcode-context-candidate-window pc)
                    'tutcode-candidate-window-off))
        (im-select-candidate pc (tutcode-context-nth pc))))))

;;; 䥦ɥĤ
(define (tutcode-reset-candidate-window pc)
  (if (not (eq? (tutcode-context-candidate-window pc)
                'tutcode-candidate-window-off))
    (begin
      (im-deactivate-candidate-selector pc)
      (tutcode-context-set-candidate-window! pc
        'tutcode-candidate-window-off))))

;;; 򤼽Ѵθ֤顢ɤϾ֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-yomi-state pc)
  (tutcode-reset-candidate-window pc)
  (tutcode-context-set-state! pc 'tutcode-state-yomi)
  (tutcode-context-set-nr-candidates! pc 0))

;;; 򤼽ѴμϿ֤顢֤᤹
;;; @param pc ƥȥꥹ
(define (tutcode-back-to-converting-state pc)
  (tutcode-context-set-nth! pc (- (tutcode-context-nr-candidates pc) 1))
  (tutcode-check-candidate-window-begin pc)
  (if (eq? (tutcode-context-candidate-window pc)
           'tutcode-candidate-window-converting)
    (im-select-candidate pc (tutcode-context-nth pc)))
  (tutcode-context-set-state! pc 'tutcode-state-converting))

;;; Ϥ줿٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char? key)
  (member (charcode->string key) tutcode-heading-label-char-list))

;;; Ϥ줿ϥ⡼ɻθ٥ʸɤĴ٤
;;; @param key Ϥ줿
(define (tutcode-heading-label-char-for-kigou-mode? key)
  (member (charcode->string key) tutcode-heading-label-char-list-for-kigou-mode))

;;; 򤼽Ѵθ֤ΤȤΥϤ롣
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-proc-state-converting c key key-state)
  (let ((pc (tutcode-find-descendant-context c)))
    (cond
      ((tutcode-next-candidate-key? key key-state)
        (tutcode-change-candidate-index pc 1))
      ((tutcode-prev-candidate-key? key key-state)
        (tutcode-change-candidate-index pc -1))
      ((tutcode-cancel-key? key key-state)
        (tutcode-back-to-yomi-state pc))
      ((tutcode-next-page-key? key key-state)
        (tutcode-change-candidate-index pc tutcode-nr-candidate-max))
      ((tutcode-prev-page-key? key key-state)
        (tutcode-change-candidate-index pc (- tutcode-nr-candidate-max)))
      ((or
        (tutcode-commit-key? key key-state)
        (tutcode-return-key? key key-state))
        (tutcode-commit-with-auto-help pc))
      ((tutcode-purge-candidate-key? key key-state)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-dialog))
      ((and (tutcode-register-candidate-key? key key-state)
            tutcode-use-recursive-learning?)
        (tutcode-reset-candidate-window pc)
        (tutcode-setup-child-context pc 'tutcode-child-type-editor))
      ((and tutcode-commit-candidate-by-label-key?
            (tutcode-heading-label-char? key))
        (tutcode-commit-by-label-key pc (charcode->string key)))
      (else
        (tutcode-commit pc (tutcode-prepare-commit-string pc))
        (tutcode-proc-state-on pc key key-state)))))

;;; ѴԤ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-convert c1 c2)
  ;; tc-2.1+[tcode-ml:1925]르ꥺ
  (and c1 c2
    (or
      (tutcode-bushu-compose-sub c1 c2)
      (let ((a1 (tutcode-bushu-alternative c1))
            (a2 (tutcode-bushu-alternative c2)))
        (and
          (or
            (not (string=? a1 c1))
            (not (string=? a2 c2)))
          (begin
            (set! c1 a1)
            (set! c2 a2)
            #t)
          (tutcode-bushu-compose-sub c1 c2)))
      (let* ((decomposed1 (tutcode-bushu-decompose c1))
             (decomposed2 (tutcode-bushu-decompose c2))
             (tc11 (and decomposed1 (car decomposed1)))
             (tc12 (and decomposed1 (cadr decomposed1)))
             (tc21 (and decomposed2 (car decomposed2)))
             (tc22 (and decomposed2 (cadr decomposed2)))
             ;; ʸ2ĤȤϰۤʤ
             ;; ʸǤ뤳Ȥǧ롣
             ;; (string=?#fäȤ˥顼ˤʤΤequal?)
             (newchar
                (lambda (new)
                  (and
                    (not (equal? new c1))
                    (not (equal? new c2))
                    new))))
        (or
          ;; 
          (and
            (equal? tc11 c2)
            (newchar tc12))
          (and
            (equal? tc12 c2)
            (newchar tc11))
          (and
            (equal? tc21 c1)
            (newchar tc22))
          (and
            (equal? tc22 c1)
            (newchar tc21))
          ;; ʤˤ­
          (let ((compose-newchar
                  (lambda (i1 i2)
                    (let ((res (tutcode-bushu-compose-sub i1 i2)))
                      (and res
                        (newchar res))))))
            (or
              (compose-newchar c1 tc22) (compose-newchar tc11 c2)
              (compose-newchar c1 tc21) (compose-newchar tc12 c2)
              (compose-newchar tc11 tc22) (compose-newchar tc11 tc21)
              (compose-newchar tc12 tc22) (compose-newchar tc12 tc21)))
          ;; ʤˤ
          (and tc11
            (equal? tc11 tc21)
            (newchar tc12))
          (and tc11
            (equal? tc11 tc22)
            (newchar tc12))
          (and tc12
            (equal? tc12 tc21)
            (newchar tc11))
          (and tc12
            (equal? tc12 tc22)
            (newchar tc11)))))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; ꤵ줿֤ǸĤʤäϡ֤줫õ
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose-sub c1 c2)
  (and c1 c2
    (or
      (tutcode-bushu-compose c1 c2)
      (tutcode-bushu-compose c2 c1))))

;;; Ѵ:c1c2ƤǤʸõ֤
;;; @param c1 1ܤ
;;; @param c2 2ܤ
;;; @return ʸǤʤäȤ#f
(define (tutcode-bushu-compose c1 c2)
  (let ((seq (rk-lib-find-seq (list c1 c2) tutcode-bushudic)))
    (and seq
      (car (cadr seq)))))

;;; Ѵ:ʸõ֤
;;; @param c оݤʸ
;;; @return ʸʸĤʤäȤϸʸ
(define (tutcode-bushu-alternative c)
  (let ((alt (assoc c tutcode-bushudic-altchar)))
    (or
      (and alt (cadr alt))
      c)))

;;; Ѵ:ʸ2Ĥʬ򤹤롣
;;; @param c ʬоݤʸ
;;; @return ʬ򤷤ƤǤ2ĤΥꥹȡʬǤʤäȤ#f
(define (tutcode-bushu-decompose c)
  (if (null? tutcode-reverse-bushudic-alist)
    (set! tutcode-reverse-bushudic-alist
      (map
        (lambda (elem)
          (cons (caadr elem) (caar elem)))
        tutcode-bushudic)))
  (let ((res (assoc c tutcode-reverse-bushudic-alist)))
    (and res
      (cdr res))))

;;; ưإ:оʸΤɬפȤʤ롢
;;; Ǥʤ2ĤʸΥꥹȤ֤
;;; : "" => (((("," "o"))("")) ((("f" "q"))("")))
;;; @param c оʸ
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose c)
  (let*
    ((bushu (tutcode-bushu-decompose c))
     (b1 (and bushu (car bushu)))
     (b2 (and bushu (cadr bushu)))
     (seq1 (and b1 (tutcode-auto-help-get-stroke b1)))
     (seq2 (and b2 (tutcode-auto-help-get-stroke b2))))
    (or
      ;; ­ˤ
      (and seq1 seq2
        (list seq1 seq2))
      ;; ñʰˤ
      (tutcode-auto-help-bushu-decompose-by-subtraction c)
      ;; ʤˤ
      (or
        ;; 1ľϲǽ
        ;; (1)(2ʤȤƻĴ)ˤǽ?
        (and seq1 b2
          (tutcode-auto-help-bushu-decompose-looking-bushudic tutcode-bushudic
            () 99
            (lambda (elem)
              (tutcode-auto-help-get-stroke-list-with-right-part
                c b1 b2 seq1 elem))))
        ;; 2ľϲǽ
        ;; (2)(1ʤȤƻĴ)ˤǽ?
        (and seq2 b1
          (tutcode-auto-help-bushu-decompose-looking-bushudic tutcode-bushudic
            () 99
            (lambda (elem)
              (tutcode-auto-help-get-stroke-list-with-left-part
                c b1 b2 seq2 elem))))
        ;; XXX: ʤɤι䡢3ʸʾǤι̤б
        ))))

;;; ưإ:оʸϤݤǸΥꥹȤ롣
;;; : "" => ((("," "o")) (""))
;;; @param b оʸ
;;; @return ǸꥹȡԲǽʾ#f
(define (tutcode-auto-help-get-stroke b)
  (let
    ((seq
      (or (tutcode-reverse-find-seq b)
          ;; ǻȤ"3"Τ褦ľϲǽб뤿ᡢ
          ;; ٥ʸ˴ޤޤƤСľϲǽȤߤʤ
          (and
            (member b tutcode-heading-label-char-list-for-kigou-mode)
            (list b)))))
    (and seq
      (list (list seq) (list b)))))

;;; ưإ:Ǥ˸
;;; ǽ˸Ĥä2ǸȤ߹碌֤
;;; (filtermapȤäơǾΥȥΤΤõȻ֤Τǡ)
;;; ξȤ2ǸȤ߹碌Ĥʤä顢
;;; 3ǸȤȤ߹碌֤
;;; @param long-stroke-result 3Ǹʾʸޤ
;;; @param min-stroke long-stroke-resultθߤκǾǸ
;;; @param get-stroke-list Ѥ2ĤʸȥȥΥꥹȤ֤ؿ
;;; @return Ѥ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-looking-bushudic bushudic
          long-stroke-result min-stroke get-stroke-list)
  (if (null? bushudic)
    (and
      (not (null? long-stroke-result))
      long-stroke-result)
    (let*
      ((res
        (get-stroke-list (list min-stroke (car bushudic))))
       (len (if (not res) 99 (tutcode-auto-help-count-stroke-length res)))
       (min (if (< len min-stroke) len min-stroke)))
      (if (<= len 4) ; "5"Ȥ4Ǹ̤⤢뤬ޤǤϸʤ
        res
        (tutcode-auto-help-bushu-decompose-looking-bushudic (cdr bushudic)
          (if (< len min-stroke) res long-stroke-result)
          min get-stroke-list)))))

;;; ưإ:оʸˤΤɬפȤʤ롢
;;; ǤʤʸΥꥹȤ֤
;;; : "" => (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;;    (Ȥʤtutcode-bushudicǤ((("" "")) ("")))
;;; @param c оʸ
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  Ĥʤä#f
(define (tutcode-auto-help-bushu-decompose-by-subtraction c)
  (tutcode-auto-help-bushu-decompose-looking-bushudic tutcode-bushudic
    () 99
    (lambda (elem)
      (tutcode-auto-help-get-stroke-list-by-subtraction c elem))))

;;; ưإ:ɬפǸ
;;; @param bushu-compose-list ˻Ȥ2ʸȥȥΥꥹȡ
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
;;; @return bushu-compose-list˴ޤޤǸ(ξ5)
(define (tutcode-auto-help-count-stroke-length bushu-compose-list)
  (+ (length (caaar bushu-compose-list))
     (length (caaadr bushu-compose-list))))

;;; ưإ:оʸˤǤϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("g" "t" "h")) ("")) ((("G" "I")) ("")))
(define (tutcode-auto-help-get-stroke-list-by-subtraction
          c min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member c (caar bushu-list)))
     (b1 (caadr bushu-list))
     ;; 2ĤΤcʳ
     (b2 (if (= 2 (length mem)) (cadr mem) (car (caar bushu-list))))
     (seq1 (tutcode-auto-help-get-stroke b1))
     (seq2 (tutcode-auto-help-get-stroke b2))
     (ret (list seq1 seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 b2))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1פȡ2ʤȤƻĴפˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ
;;; @param b1 1(ľϲǽ)
;;; @param b2 2(ľԲǽ)
;;; @param seq1 b1ϥ󥹤Υꥹ
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
(define (tutcode-auto-help-get-stroke-list-with-right-part
         c b1 b2 seq1 min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b2 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 2ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji))
     (ret (list seq1 seq))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert b1 kanji))
     (c-composed? (string=? composed c)))
    ret))

;;; ưإ:оʸ1ʤȤƻĴפȡ2פˤ
;;; Ǥϡ
;;; ˻ȤʸȡΥȥΥꥹȤ֤
;;; @param c оʸ (: "")
;;; @param b1 1(ľԲǽ) (: "")
;;; @param b2 2(ľϲǽ) (: "")
;;; @param seq2 b2ϥ󥹤Υꥹȡ
;;;  : ((("b" ",")) (""))
;;; @param min-stroke-bushu-list min-strokebushudicǤΥꥹȡ
;;;  : (6 ((("" "")) ("")))
;;; @return оʸɬפ2ĤʸȥȥΥꥹȡ
;;;  bushu-listȤäƹǤʤ#f
;;;  : (((("e" "v" ".")) ("")) ((("b" ",")) ("")))
(define (tutcode-auto-help-get-stroke-list-with-left-part
         c b1 b2 seq2 min-stroke-bushu-list)
  (and-let*
    ((min-stroke (car min-stroke-bushu-list))
     (bushu-list (cadr min-stroke-bushu-list))
     (mem (member b1 (caar bushu-list)))
     (kanji (caadr bushu-list)) ; 1ʤȤƻĴ
     (seq (tutcode-auto-help-get-stroke kanji))
     (ret (list seq seq2))
     ;; ٤ΤǡǸå
     (small-stroke? (< (tutcode-auto-help-count-stroke-length ret) min-stroke))
     ;; ºݤơоʸʤΤ
     (composed (tutcode-bushu-convert kanji b2))
     (c-composed? (string=? composed c)))
    ret))

;;; tutcode-ruleհơѴʸ顢ϥ롣
;;; : (tutcode-reverse-find-seq "") => ("r" "k")
;;; @param c Ѵʸ
;;; @return ϥΥꥹȡtutcode-rulecĤʤä#f
(define (tutcode-reverse-find-seq c)
  (if (null? tutcode-reverse-rule-alist)
    (set! tutcode-reverse-rule-alist
      (map
        (lambda (elem)
          (cons (caadr elem) (caar elem)))
        tutcode-rule)))
  (let ((res (assoc c tutcode-reverse-rule-alist)))
    (and res
      (cdr res))))

;;; ߤstatepreeditĤɤ֤
;;; @param pc ƥȥꥹ
(define (tutcode-state-has-preedit? pc)
  (or
    (not (null? (tutcode-context-child-context pc)))
    (memq (tutcode-context-state pc)
      '(tutcode-state-yomi tutcode-state-bushu tutcode-state-converting
                           tutcode-state-kigou))))

;;; 줿ȤνοʬԤ
;;; @param c ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-press-handler c key key-state)
  (if (ichar-control? key)
      (im-commit-raw c)
      (let ((pc (tutcode-find-descendant-context c)))
        (case (tutcode-context-state pc)
          ((tutcode-state-on)
           (tutcode-proc-state-on pc key key-state)
           (if (tutcode-state-has-preedit? c)
             ;; 򤼽ѴѴϡ䢥ɽ
             (tutcode-update-preedit pc)))
          ((tutcode-state-kigou)
           (tutcode-proc-state-kigou pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-yomi)
           (tutcode-proc-state-yomi pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-converting)
           (tutcode-proc-state-converting pc key key-state)
           (tutcode-update-preedit pc))
          ((tutcode-state-bushu)
           (tutcode-proc-state-bushu pc key key-state)
           (tutcode-update-preedit pc))
          (else
           (tutcode-proc-state-off pc key key-state)
           (if (tutcode-state-has-preedit? c) ; Ƶؽ
             (tutcode-update-preedit pc)))))))

;;; Υ줿ȤνԤ
;;; @param pc ƥȥꥹ
;;; @param key Ϥ줿
;;; @param key-state ȥ륭ξ
(define (tutcode-key-release-handler pc key key-state)
  (if (or (ichar-control? key)
	  (not (tutcode-context-on? pc)))
      ;; don't discard key release event for apps
      (im-commit-raw pc)))

;;; TUT-Code IMνԤ
(define (tutcode-init-handler id im arg)
  (tutcode-context-new id im))

(define (tutcode-release-handler pc)
  (tutcode-save-personal-dictionary #f))

(define (tutcode-reset-handler tc)
  (tutcode-flush tc))

(define (tutcode-focus-in-handler tc) #f)

(define (tutcode-focus-out-handler c)
  (let* ((tc (tutcode-find-descendant-context c))
         (rkc (tutcode-context-rk-context tc)))
    (rk-flush rkc)))

(define tutcode-place-handler tutcode-focus-in-handler)
(define tutcode-displace-handler tutcode-focus-out-handler)

;;; 䥦ɥʸ뤿˸Ƥִؿ
(define (tutcode-get-candidate-handler c idx accel-enum-hint)
  (let ((tc (tutcode-find-descendant-context c)))
    (cond
      ((= accel-enum-hint 9999) ;XXX ɽ䥦ɥdisplay_limitĴ
        (set! tutcode-nr-candidate-max (length tutcode-heading-label-char-list))
        (set! tutcode-nr-candidate-max-for-kigou-mode
          (length tutcode-heading-label-char-list-for-kigou-mode))
        (list "" ""
          (string-append "display_limit="
            (number->string
              (if (eq? (tutcode-context-state tc) 'tutcode-state-kigou)
                tutcode-nr-candidate-max-for-kigou-mode
                tutcode-nr-candidate-max)))))
      ((eq? (tutcode-context-state tc) 'tutcode-state-kigou)
        (let* ((cand (tutcode-get-nth-candidate-for-kigou-mode tc idx))
               (n (remainder idx
                    (length tutcode-heading-label-char-list-for-kigou-mode)))
               (label (nth n tutcode-heading-label-char-list-for-kigou-mode)))
          ;; XXX:annotationɽϸ̵ƤΤǡ""֤Ƥ
          (list cand label "")))
      ((and (not (eq? (tutcode-context-state tc) 'tutcode-state-converting))
            (or tutcode-use-stroke-help-window? tutcode-use-auto-help-window?))
        (nth idx (tutcode-context-stroke-help tc)))
      (else
        (let* ((cand (tutcode-get-nth-candidate tc idx))
               (n (remainder idx (length tutcode-heading-label-char-list)))
               (label (nth n tutcode-heading-label-char-list)))
          (list cand label ""))))))

;;; 䥦ɥ򤷤Ȥ˸Ƥִؿ
;;; 򤵤줿ꤹ롣
(define (tutcode-set-candidate-index-handler c idx)
  (let ((pc (tutcode-find-descendant-context c)))
    (if (and
          (or (eq? (tutcode-context-candidate-window pc)
                   'tutcode-candidate-window-converting)
              (eq? (tutcode-context-candidate-window pc)
                   'tutcode-candidate-window-kigou))
          (>= idx 0)
          (< idx (tutcode-context-nr-candidates pc)))
      (begin
        (tutcode-context-set-nth! pc idx)
        (if (eq? (tutcode-context-state pc) 'tutcode-state-kigou)
          (tutcode-commit pc (tutcode-prepare-commit-string-for-kigou-mode pc))
          (tutcode-commit-with-auto-help pc))
        (tutcode-update-preedit pc)))))

(tutcode-configure-widgets)

;;; TUT-Code IMϿ롣
(register-im
 'tutcode
 "ja"
 "EUC-JP"
 tutcode-im-name-label
 tutcode-im-short-desc
 #f
 tutcode-init-handler
 tutcode-release-handler
 context-mode-handler
 tutcode-key-press-handler
 tutcode-key-release-handler
 tutcode-reset-handler
 tutcode-get-candidate-handler
 tutcode-set-candidate-index-handler
 context-prop-activate-handler
 #f
 tutcode-focus-in-handler
 tutcode-focus-out-handler
 tutcode-place-handler
 tutcode-displace-handler
 )

;;; ɽQwertyDvorakѤѴ롣
;;; @param qwerty QwertyΥɽ
;;; @return DvorakѴɽ
(define (tutcode-rule-qwerty-to-dvorak qwerty)
  (map
    (lambda (elem)
      (cons
        (list
          (map
            (lambda (key)
              (cadr (assoc key tutcode-rule-qwerty-to-dvorak-alist)))
            (caar elem)))
        (cdr elem)))
    qwerty))

;;; QwertyDvorakؤѴơ֥롣
(define tutcode-rule-qwerty-to-dvorak-alist
  '(
    ;ľǻȤʳϥȥ
    ("1" "1")
    ("2" "2")
    ("3" "3")
    ("4" "4")
    ("5" "5")
    ("6" "6")
    ("7" "7")
    ("8" "8")
    ("9" "9")
    ("0" "0")
    ;("-" "[")
    ;("^" "]") ;106
    ("q" "'")
    ("w" ",")
    ("e" ".")
    ("r" "p")
    ("t" "y")
    ("y" "f")
    ("u" "g")
    ("i" "c")
    ("o" "r")
    ("p" "l")
    ;("@" "/") ;106
    ;("[" "=") ;106
    ("a" "a")
    ("s" "o")
    ("d" "e")
    ("f" "u")
    ("g" "i")
    ("h" "d")
    ("j" "h")
    ("k" "t")
    ("l" "n")
    (";" "s")
    ;(":" "-") ;106
    ("z" ";")
    ("x" "q")
    ("c" "j")
    ("v" "k")
    ("b" "x")
    ("n" "b")
    ("m" "m")
    ("," "w")
    ("." "v")
    ("/" "z")
    ;; shift
    ;("\"" "@") ;106
    ;("&" "^") ;106
    ;("'" "&") ;106
    ;("(" "*") ;106
    ;(")" "(") ;106
    ;("=" "{") ;106
    ;("~" "}") ;106
    ("Q" "\"")
    ("W" "<")
    ("E" ">")
    ("R" "P")
    ("T" "Y")
    ("Y" "F")
    ("U" "G")
    ("I" "C")
    ("O" "R")
    ("P" "L")
    ;("`" "?") ;106
    ;("{" "+") ;106
    ("A" "A")
    ("S" "O")
    ("D" "E")
    ("F" "U")
    ("G" "I")
    ("H" "D")
    ("J" "H")
    ("K" "T")
    ("L" "N")
    ("+" "S") ;106
    ;("*" "_") ;106
    ("Z" ":")
    ("X" "Q")
    ("C" "J")
    ("V" "K")
    ("B" "X")
    ("N" "B")
    ("M" "M")
    ("<" "W")
    (">" "V")
    ("?" "Z")
    (" " " ")
    ))

;;; tutcode-customꤵ줿ɽΥե̾饳ɽ̾äơ
;;; Ѥ륳ɽȤꤹ롣
;;; 륳ɽ̾ϡե̾".scm"򤱤äơ
;;; "-rule"ĤƤʤäɲäΡ
;;; : "tutcode-rule.scm"tutcode-rule
;;;     "tcode.scm"tcode-rule
;;; @param filename tutcode-rule-filename
(define (tutcode-custom-load-rule! filename)
  (and
    (try-load filename)
    (let*
      ((basename (last (string-split filename "/")))
       ;; ե̾".scm"򤱤
       (bnlist (string-to-list basename))
       (codename
        (or
          (and
            (> (length bnlist) 4)
            (string=? (string-list-concat (list-head bnlist 4)) ".scm")
            (string-list-concat (list-tail bnlist 4)))
          basename))
       ;; "-rule"ĤƤʤäɲ
       (rulename
        (or
          (and
            (not (string=? (last (string-split codename "-")) "rule"))
            (string-append codename "-rule"))
          codename)))
      (and rulename
        (symbol-bound? (string->symbol rulename))
        (set! tutcode-rule
          (eval (string->symbol rulename) (interaction-environment)))))))

;;; tutcode-key-customꤵ줿򤼽/ѴϤΥ󥹤
;;; ɽȿǤ
(define (tutcode-custom-set-mazegaki/bushu-start-sequence!)
  (let*
    ((make-subrule
      (lambda (keyseq cmd)
        (if
          (and
            keyseq
            (> (string-length keyseq) 0))
          (let ((keys (reverse (string-to-list keyseq))))
            (list (list (list keys) cmd)))
          #f)))
     (mazegaki-rule
      (make-subrule tutcode-mazegaki-start-sequence
        '(tutcode-mazegaki-start)))
     (latin-conv-rule
      (make-subrule tutcode-latin-conv-start-sequence
        '(tutcode-latin-conv-start)))
     (bushu-rule
      (make-subrule tutcode-bushu-start-sequence
        '(tutcode-bushu-start))))
    (if mazegaki-rule
      (tutcode-rule-set-sequences! mazegaki-rule))
    (if latin-conv-rule
      (tutcode-rule-set-sequences! latin-conv-rule))
    (if bushu-rule
      (tutcode-rule-set-sequences! bushu-rule))))

;;; ɽΰѹ/ɲä롣~/.uimλѤꡣ
;;; ƤӽФˤtutcode-rule-userconfigϿƤǡ
;;; ºݤ˥ɽȿǤΤϡtutcode-context-new
;;;
;;; (tutcode-rule-filename꤬uim-pref~/.uimΤɤǹԤ줿Ǥ
;;;  ~/.uimǤΥɽΰѹƱҤǤǤ褦ˤ뤿ᡣ
;;;  ɽɸhookѰդ)
;;;
;;; ƤӽФ:
;;;   (tutcode-rule-set-sequences!
;;;     '(((("d" "l" "u")) ("" ""))
;;;       ((("d" "l" "d" "u")) ("" ""))))
;;; @param rules 󥹤ϤʸΥꥹ
(define (tutcode-rule-set-sequences! rules)
  (set! tutcode-rule-userconfig
    (append rules tutcode-rule-userconfig)))

;;; ɽξѹ/ɲäΤtutcode-rule-userconfig
;;; ɽȿǤ롣
(define (tutcode-rule-commit-sequences! rules)
  (let* ((newseqs ()) ;ɲä륭
         ;; ɽλꥷ󥹤Ϥʸѹ롣
         ;; seq 
         ;; kanji ϤʸcarҤ餬ʥ⡼ѡcadrʥ⡼
         (setseq1!
          (lambda (elem)
            (let* ((seq (caar elem))
                   (kanji (cadr elem))
                   (curseq (rk-lib-find-seq seq tutcode-rule))
                   (pair (and curseq (cadr curseq))))
              (if (and pair (pair? pair))
                (begin
                  (set-car! pair (car kanji))
                  (if (not (null? (cdr kanji)))
                    (if (< (length pair) 2)
                      (set-cdr! pair (list (cadr kanji)))
                      (set-car! (cdr pair) (cadr kanji)))))
                (begin
                  ;; ɽ˻ꤵ줿󥹤̵
                  (set! newseqs (append newseqs (list elem)))))))))
    (for-each setseq1! rules)
    ;; ɲå
    (if (not (null? newseqs))
      (set! tutcode-rule (append newseqs tutcode-rule)))))
