/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int n, int n2) {
        super(-1, 0, n2, n, new char[n], 0);
    }

    HeapCharBuffer(char[] cArray, int n, int n2) {
        super(-1, n, n + n2, cArray.length, cArray, 0);
    }

    protected HeapCharBuffer(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, cArray, n5);
    }

    public CharBuffer slice() {
        return new HeapCharBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    public char get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public char get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), cArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public CharBuffer put(char c) {
        this.hb[this.ix((int)this.nextPutIndex())] = c;
        return this;
    }

    public CharBuffer put(int n, char c) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = c;
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        HeapCharBuffer.checkBounds(n, n2, cArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(cArray, n, this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof HeapCharBuffer) {
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapCharBuffer heapCharBuffer = (HeapCharBuffer)charBuffer;
            int n = heapCharBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapCharBuffer.hb, heapCharBuffer.ix(heapCharBuffer.position()), this.hb, this.ix(this.position()), n);
            heapCharBuffer.position(heapCharBuffer.position() + n);
            this.position(this.position() + n);
        } else if (charBuffer.isDirect()) {
            int n = charBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            charBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    public CharBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    String toString(int n, int n2) {
        try {
            return new String(this.hb, n + this.offset, n2 - n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 > this.length() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        return new HeapCharBuffer(this.hb, -1, 0, n3, n3, this.offset + this.position() + n);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

