/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.pings.Pings;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.ComponentRef;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.DownloadWindowHelper;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Launcher
implements Runnable {
    private DownloadWindowHelper _downloadWindowHelper = null;
    private LaunchDesc _initialLaunchDesc;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private boolean _isRelaunch = false;
    private boolean _javafx_install_initiated = false;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._initialLaunchDesc = launchDesc;
        this._downloadWindowHelper = new DownloadWindowHelper();
        Trace.println((String)("new Launcher: " + launchDesc.toString()), (TraceLevel)TraceLevel.BASIC);
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray;
        this._exit = bl;
        if (this.prepareToLaunch()) {
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        }
    }

    public void run() {
        block8: {
            try {
                this.doLaunchApp();
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n2 = n = exitException.getReason() == 0 ? 0 : -1;
                if (exitException.getReason() == 3) {
                    if (this._launchDesc.getUpdater().isBackgroundUpdateRunning() && this._lap != null) {
                        this._lap.setForceUpdateCheck(true);
                        try {
                            this._lap.store();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block8;
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
        }
    }

    private boolean prepareToLaunch() {
        if (SingleInstanceManager.isServerRunning((String)this._initialLaunchDesc.getCanonicalHome().toString())) {
            String[] stringArray = Globals.getApplicationArgs();
            if (stringArray != null && this._initialLaunchDesc.getApplicationDescriptor() != null) {
                this._initialLaunchDesc.getApplicationDescriptor().setArguments(stringArray);
            }
            if (SingleInstanceManager.connectToServer((String)this._initialLaunchDesc.toString())) {
                Trace.println((String)"Exiting (launched in the other instance)", (TraceLevel)TraceLevel.BASIC);
                return true;
            }
        }
        boolean bl = Cache.isCacheEnabled() && (this._initialLaunchDesc.getUpdate().isBackgroundCheck() || DeployOfflineManager.isForcedOffline() || JnlpxArgs.getIsRelaunch());
        try {
            if (!bl && DeployOfflineManager.isForcedOffline()) {
                throw new CacheUpdateRequiredException("Forced offline mode!");
            }
            boolean bl2 = this.prepareToLaunch(bl);
            if (Cache.isCacheEnabled() && !DeployOfflineManager.isForcedOffline()) {
                this._launchDesc.getUpdater().startBackgroundUpdateOpt();
            }
            return bl2;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            Trace.println((String)("Could not launch from cache. Will try online mode. [" + cacheUpdateRequiredException.getMessage() + "]"));
            if (bl && DeployOfflineManager.isForcedOffline()) {
                DeployOfflineManager.setForcedOffline((boolean)false);
                if (!DeployOfflineManager.askUserGoOnline((URL)this._initialLaunchDesc.getLocation())) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                    Trace.println((String)"User chose not to go online and we can not not start in offline mode");
                    LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), new OfflineLaunchException(0), this._exit);
                    return false;
                }
            }
            try {
                return this.prepareToLaunch(false);
            }
            catch (CacheUpdateRequiredException cacheUpdateRequiredException2) {
                Trace.println((String)("Unexpected exception: " + cacheUpdateRequiredException2));
                return false;
            }
        }
    }

    private boolean prepareToLaunch(boolean bl) throws CacheUpdateRequiredException {
        try {
            boolean bl2;
            URL uRL;
            Trace.println((String)("prepareToLaunch: offlineOnly=" + bl), (TraceLevel)TraceLevel.NETWORK);
            boolean bl3 = Globals.isSilentMode();
            PerfLogger.setTime((String)"Begin updateFinalLaunchDesc");
            boolean bl4 = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, bl);
            this.removeTempJnlpFile(this._launchDesc);
            if (bl4) {
                File file = null;
                if (this._launchDesc.isApplicationDescriptor()) {
                    try {
                        file = DownloadEngine.getCachedFile((URL)this._launchDesc.getCanonicalHome());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                    if (this._args != null) {
                        this._args[0] = file.getPath();
                    }
                }
            }
            PerfLogger.setTime((String)"End updateFinalLaunchDesc");
            boolean bl5 = this._launchDesc.isInstaller();
            this._isRelaunch = JnlpxArgs.getIsRelaunch();
            URL uRL2 = this._launchDesc.getCanonicalHome();
            if (!bl5 && !this._launchDesc.isLibrary()) {
                this._lap = Cache.getLocalApplicationProperties((URL)uRL2);
            }
            if (bl4 && this._lap != null && Cache.isCacheEnabled() && this._lap.isLocallyInstalled() && LocalInstallHandler.getInstance().isShortcutExists(this._lap)) {
                Launcher.notifyLocalInstallHandler(this._launchDesc, this._lap, true, false, bl3, this._downloadWindowHelper.getOwnerRef());
            }
            if ((uRL = this._launchDesc.getLocation()) != null) {
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
            }
            Trace.println((String)("isUpdated: " + bl4), (TraceLevel)TraceLevel.NETWORK);
            if (this._launchDesc.getResources() != null) {
                Globals.getDebugOptionsFromProperties(this._launchDesc.getResources().getResourceProperties());
            }
            if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
                this._ja = JAuthenticator.getInstance(this._downloadWindowHelper.getOwnerRef());
                Authenticator.setDefault((Authenticator)((Object)this._ja));
            }
            boolean bl6 = bl2 = Environment.isImportMode() || this._launchDesc.getLaunchType() == 3;
            if (!bl3) {
                this._downloadWindowHelper.initialize(this._launchDesc, true, false);
            }
            this.prepareLaunchFile(this._launchDesc, this._args, bl2, bl3, bl4, bl);
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Throwable throwable) {
            int n;
            ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
            int n2 = n = exitException.getReason() == 0 ? 0 : -1;
            if (exitException.getReason() == 3) {
                LaunchErrorDialog.show(this._downloadWindowHelper.getOwner(), exitException.getException(), this._exit);
            }
            if (n == 0) {
                Trace.println((String)"Exiting", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.ignoredException((Exception)exitException);
            }
            if (this._exit) {
                try {
                    Main.systemExit(n);
                }
                catch (ExitException exitException2) {
                    Trace.println((String)("systemExit: " + exitException2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException2);
                }
            }
            return false;
        }
        return true;
    }

    private boolean updateFinalLaunchDesc(LaunchDesc launchDesc, int n, boolean bl) throws ExitException, CacheUpdateRequiredException {
        try {
            URL uRL = launchDesc.getLocation();
            if (uRL == null) {
                this._launchDesc = launchDesc;
                return LaunchDownload.updateNoHrefLaunchDescInCache(launchDesc);
            }
            String string = Config.getCacheDirectory();
            String string2 = Config.getSystemCacheDirectory();
            boolean bl2 = this._args[0] != null && (string != null && this._args[0].startsWith(string) || string2 != null && this._args[0].startsWith(string2));
            File file = DownloadEngine.getCachedFile((URL)uRL);
            if (!bl && bl2) {
                LaunchDesc launchDesc2 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                if (launchDesc2 == null) {
                    this._launchDesc = launchDesc;
                    return false;
                }
                URL uRL2 = launchDesc2.getLocation();
                if (uRL2 == null || !uRL2.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(launchDesc2, ++n, false);
                }
                this._launchDesc = launchDesc2;
                return true;
            }
            if (file != null) {
                block20: {
                    try {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, uRL);
                    }
                    catch (LaunchDescException launchDescException) {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(file);
                        if (this._launchDesc != null) break block20;
                        throw launchDescException;
                    }
                }
                byte[] byArray = this._launchDesc.getBytes();
                LaunchDesc launchDesc3 = null;
                if (!launchDesc.hasIdenticalContent(byArray)) {
                    if (n == 0 && bl) {
                        throw new CacheUpdateRequiredException("Given JNLP is newer than cached copy!");
                    }
                    launchDesc3 = LaunchDownload.getUpdatedLaunchDesc(uRL, null);
                }
                if (launchDesc3 != null) {
                    this._launchDesc = launchDesc3;
                    URL uRL3 = this._launchDesc.getLocation();
                    if (uRL3 == null || !uRL3.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                URL uRL4 = this._launchDesc.getLocation();
                if (uRL4 == null || !uRL4.toString().equals(uRL.toString()) && n == 0) {
                    Cache.removeCacheEntry((URL)uRL, null, null);
                    return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                }
                this._launchDesc = launchDesc;
                return false;
            }
            if (bl) {
                throw new CacheUpdateRequiredException("Missing from the cache: " + uRL);
            }
            if (Cache.isCacheEnabled()) {
                DownloadEngine.getResource((URL)uRL, null, null, null, (boolean)true);
                file = DownloadEngine.getCachedFile((URL)uRL);
                if (file != null) {
                    this._launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, uRL);
                    URL uRL5 = this._launchDesc.getLocation();
                    if (uRL5 == null || !uRL5.toString().equals(uRL.toString()) && n == 0) {
                        Cache.removeCacheEntry((URL)uRL, null, null);
                        return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
                    }
                    return true;
                }
                throw new Exception("cache failed for" + uRL);
            }
            this._launchDesc = LaunchDescFactory.buildDescriptor(uRL, null);
            URL uRL6 = this._launchDesc.getLocation();
            if (uRL6 != null && !uRL6.toString().equals(uRL.toString()) && n == 0) {
                return this.updateFinalLaunchDesc(this._launchDesc, ++n, bl);
            }
            return false;
        }
        catch (CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        File file = null;
        if (launchDesc.isApplicationDescriptor()) {
            try {
                file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (file == null) {
            return;
        }
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    static String getCurrentJavaFXVersion() {
        URL uRL = null;
        try {
            uRL = new URL("http://dl.javafx.com/javafx-rt.jnlp");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        CacheEntry cacheEntry = Cache.getLatestCacheEntry((URL)uRL, null);
        LaunchDesc launchDesc = null;
        String string = "XX";
        if (cacheEntry != null) {
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), null, null, uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = launchDesc.getVersion();
        }
        return string;
    }

    static String getRequestedJavaFXVersion(LaunchDesc launchDesc) {
        String string = "XX";
        if (launchDesc != null) {
            string = launchDesc.getVersion();
        }
        return string;
    }

    private void prepareLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ExitException, CacheUpdateRequiredException {
        boolean bl5;
        Object object;
        Serializable serializable;
        boolean bl6;
        Serializable serializable2;
        LaunchDescException launchDescException;
        boolean bl7 = false;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!bl && launchDesc.isLibrary()) {
            LaunchDescException launchDescException2 = new LaunchDescException(launchDesc, "Internal Error: !isImport && ld.isLibrary()", null);
            this.handleJnlpFileException(launchDesc, launchDescException2);
        }
        boolean bl8 = launchDesc.isInstaller();
        JNLPException.setDefaultLaunchDesc(launchDesc);
        JREInfo jREInfo = JREInfo.getHomeJRE();
        Trace.println((String)("Launcher: isInstaller: " + bl8 + ", isRelaunch: " + this._isRelaunch + ", isImport: " + bl + ", java.home:" + Config.getJavaHome() + ", Running JRE: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)"JREInfos", (TraceLevel)TraceLevel.BASIC);
        JREInfo.traceJREs();
        if (jREInfo == null) {
            launchDescException = new LaunchDescException(launchDesc, "Internal Error: no running JRE", null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 3);
        }
        launchDescException = null;
        PerfLogger.setTime((String)"Begin LaunchDownload.isInCache(ld)");
        boolean bl9 = LaunchDownload.isInCache(launchDesc);
        PerfLogger.setTime((String)"End LaunchDownload.isInCache(ld)");
        if (!bl9 && bl4) {
            throw new CacheUpdateRequiredException("Some of required resources are not cached.");
        }
        LaunchSelection.MatchJREIf matchJREIf = launchDesc.getJREMatcher();
        JVMParameters jVMParameters = matchJREIf.getSelectedJVMParameters();
        JREInfo jREInfo2 = matchJREIf.getSelectedJREInfo();
        JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
        if (jREInfo2 == null && jREDesc == null || null == jVMParameters) {
            Trace.println((String)((Object)matchJREIf).toString());
            serializable2 = new LaunchDescException(launchDesc, "Internal Error: Internal error, jreMatcher uninitialized", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable2);
        }
        if (!launchDesc.isJRESpecified()) {
            serializable2 = new LaunchDescException(launchDesc, "Internal Error: !isJRESpecified()", null);
            this.handleJnlpFileException(launchDesc, (Exception)serializable2);
        }
        if ((serializable2 = launchDesc.getCanonicalHome()) == null) {
            LaunchDescException launchDescException3 = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException3, 3);
        }
        if (bl8) {
            this._lap = Cache.getLocalApplicationProperties((String)stringArray[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            serializable2 = this._lap.getLocation();
        } else if (!launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)serializable2);
        }
        Trace.println((String)("LaunchDesc location: " + serializable2), (TraceLevel)TraceLevel.BASIC);
        boolean bl10 = bl6 = bl9 && DeployOfflineManager.isGlobalOffline();
        if (!bl && jREInfo2 == null) {
            boolean bl11;
            if (bl4) {
                throw new CacheUpdateRequiredException("Need to install JRE");
            }
            String string = Config.getProperty((String)"deployment.javaws.autodownload");
            if (string != null && string.equalsIgnoreCase("NEVER")) {
                throw new ExitException(new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 3);
            }
            String string2 = jREDesc.getSource();
            serializable = jREDesc.getHref();
            boolean bl12 = bl11 = serializable == null;
            if (bl11) {
                object = Config.getProperty((String)"deployment.javaws.installURL");
                try {
                    serializable = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ExitException(malformedURLException, 3);
                }
            }
            if ((object = DownloadEngine.getAvailableVersion((URL)serializable, (String)jREDesc.getVersion(), (boolean)bl11, (String)JREInfo.getKnownPlatforms())) == null) {
                object = jREDesc.getVersion();
            }
            if (SecureStaticVersioning.promptRequired(launchDesc, this._lap, true, (String)object) ? !SecureStaticVersioning.promptDownload((Component)((Object)launchDescException), launchDesc, this._lap, (String)object, string2) : string != null && string.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt((Component)((Object)launchDescException), launchDesc)) {
                throw new ExitException(null, 0);
            }
        } else if (!bl && SecureStaticVersioning.promptRequired(launchDesc, this._lap, false, jREInfo2.getProduct()) && !SecureStaticVersioning.promptUse((Component)((Object)launchDescException), launchDesc, this._lap, jREInfo2)) {
            throw new ExitException(null, 0);
        }
        PerfLogger.setTime((String)"Begin UpdateCheck");
        boolean bl13 = bl5 = !bl9 || !bl && jREInfo2 == null || bl8;
        if (bl5 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        boolean bl14 = bl5;
        if (!bl6) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                bl14 = true;
            } else if (!bl4) {
                bl14 = launchDesc.getUpdater().isUpdateAvailable();
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException(new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        }
        if (bl4 && bl14) {
            throw new CacheUpdateRequiredException("Need to update");
        }
        Trace.println((String)("Offline mode: " + bl6 + "\nIsInCache: " + bl9 + "\nforceUpdate: " + bl5 + "\nneedUpdate: " + bl14 + "\nIsInstaller: " + bl8), (TraceLevel)TraceLevel.BASIC);
        if (bl14 && !bl5) {
            bl5 = launchDesc.getUpdater().needUpdatePerPolicy(this._downloadWindowHelper);
        }
        if (bl5 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        serializable = new ArrayList();
        if (bl5) {
            if (!bl && jREInfo2 == null) {
                this.downloadJREResource(launchDesc, (ArrayList)serializable, bl2);
                if (!((ArrayList)serializable).isEmpty()) {
                    JnlpxArgs.executeInstallers((ArrayList)serializable, this._downloadWindowHelper.get());
                    if (!this.isValidSpecificationVersion(launchDesc)) {
                        Config.getInstance().resetJavaHome();
                    }
                }
                String string = Config.getJavaHome() + File.separator + "bin" + File.separator;
                Config.getInstance().notifyJREInstalled(string);
                bl7 = true;
            } else {
                if (Environment.getJavaFxInstallMode() != 0) {
                    this._javafx_install_initiated = true;
                }
                try {
                    this.downloadResources(launchDesc, (ArrayList)serializable, bl2);
                }
                catch (ExitException exitException) {
                    if (this._javafx_install_initiated) {
                        object = exitException.getException();
                        if (object instanceof FailedDownloadException) {
                            String string = ((FailedDownloadException)object).getLocation().toString();
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)3, (String)string);
                        } else {
                            Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)2, null);
                        }
                    }
                    throw exitException;
                }
            }
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        } else {
            PerfLogger.setTime((String)"End UpdateCheck - Nothing to update");
        }
        if (jREInfo2 != null || bl) {
            SplashScreen.generateCustomSplash((Component)((Object)launchDescException), launchDesc, bl3);
            if (!bl && !((ArrayList)serializable).isEmpty()) {
                if (bl8) {
                    // empty if block
                }
                JnlpxArgs.executeInstallers((ArrayList)serializable, this._downloadWindowHelper.get());
            }
            if (!bl2) {
                String string = ResourceManager.getString((String)"progress.title.app");
                if (launchDesc.getLaunchType() == 4) {
                    string = ResourceManager.getString((String)"progress.title.installer");
                }
                this._downloadWindowHelper.showLaunchingApplication(string);
            }
        }
        if (!bl) {
            if (!this.isValidSpecificationVersion(launchDesc)) {
                JNLPException.setDefaultLaunchDesc(launchDesc);
                this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
            }
            if (jREInfo2 == null) {
                Config.refreshProps();
                jREInfo2 = launchDesc.selectJRE();
                if (jREInfo2 == null) {
                    Trace.println((String)("No JREInfo(1): " + launchDesc.getJREMatcher()));
                    LaunchDescException launchDescException4 = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException4, 3);
                }
                matchJREIf = launchDesc.getJREMatcher();
                jREDesc = matchJREIf.getSelectedJREDesc();
                jVMParameters = matchJREIf.getSelectedJVMParameters();
            }
            boolean bl15 = matchJREIf.isRunningJVMSatisfying(true);
            Trace.println((String)("jreInstalled:    " + bl7), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)((Object)matchJREIf).toString(), (TraceLevel)TraceLevel.BASIC);
            if (bl7 && bl15) {
                throw new ExitException(new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
            }
            if (launchDesc.isSecureJVMArgs() && !bl15 && jREInfo2 != null) {
                if (!this._isRelaunch) {
                    long l = jREDesc.getMinHeap();
                    long l2 = jREDesc.getMaxHeap();
                    try {
                        stringArray = this.insertApplicationArgs(stringArray);
                        JnlpxArgs.execProgram(jREInfo2, stringArray, l, l2, jVMParameters, false);
                    }
                    catch (IOException iOException) {
                        throw new ExitException(new JreExecException(jREInfo2.getPath(), iOException), 3);
                    }
                    if (JnlpxArgs.shouldRemoveArgumentFile()) {
                        JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                    }
                    throw new ExitException(null, 0);
                }
                Trace.println((String)"JAVAWS: Relaunch ignored(1): relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
        JnlpxArgs.removeArgumentFile(stringArray[0]);
        PerfLogger.setTime((String)"End removeArgumentFile");
        if (bl) {
            this._downloadWindowHelper.disposeWindow();
            boolean bl16 = LaunchDownload.isJnlpCached(launchDesc) && bl3;
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, bl16, true, bl2, null);
            if (this._javafx_install_initiated) {
                Pings.sendJFXPing((String)"jfxic", (String)Launcher.getCurrentJavaFXVersion(), (String)Launcher.getRequestedJavaFXVersion(launchDesc), (int)0, null);
            }
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        final String string = ResourceManager.getMessage((String)"console.caption") + " - " + launchDesc.getInformation().getTitle();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavawsConsoleController.setTitle(string);
                JavawsConsoleController.showConsoleIfEnable();
            }
        });
        object = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        boolean bl17 = false;
        try {
            PerfLogger.setTime((String)"Begin checkSignedLaunchDesc");
            LaunchDownload.checkSignedLaunchDesc(launchDesc);
            PerfLogger.setTime((String)"End checkSignedLaunchDesc");
            bl17 = LaunchDownload.checkSignedResources(launchDesc);
            bl17 = bl17 && launchDesc.isSigned();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl17), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("trusted app: " + !launchDesc.isSecure() + ", -secure=" + Globals.isSecureMode()), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)((Object)matchJREIf).toString(), (TraceLevel)TraceLevel.BASIC);
        boolean bl18 = matchJREIf.isRunningJVMSatisfying(bl17);
        if (!bl18) {
            if (!this._isRelaunch) {
                long l = jREDesc.getMinHeap();
                long l3 = jREDesc.getMaxHeap();
                try {
                    stringArray = this.insertApplicationArgs(stringArray);
                    JnlpxArgs.execProgram(jREInfo2, stringArray, l, l3, jVMParameters, bl17);
                }
                catch (IOException iOException) {
                    throw new ExitException(new JreExecException(jREInfo2.getPath(), iOException), 3);
                }
                if (JnlpxArgs.shouldRemoveArgumentFile()) {
                    JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                }
                throw new ExitException(null, 0);
            }
            Trace.println((String)"JAVAWS: Relaunch ignored(2): relaunched already", (TraceLevel)TraceLevel.BASIC);
        }
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(launchDesc, (AppPolicy)object);
        System.setSecurityManager(new JavaWebStartSecurity());
        try {
            String string3 = "http";
            URL uRL = launchDesc.getCanonicalHome();
            if (uRL.getProtocol().equalsIgnoreCase("file") && uRL.getHost().equals("")) {
                string3 = "file";
            }
            BasicServiceImpl.initialize(launchDesc.getCodebase(), BrowserSupport.isWebBrowserSupported(), string3);
            if (launchDesc.getLaunchType() == 4) {
                String string4 = this._lap.getInstallDirectory();
                if (string4 == null) {
                    string4 = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(string4);
                }
                ExtensionInstallerServiceImpl.initialize(launchDesc.isSecure() ? null : string4, this._lap, this._downloadWindowHelper.get());
            }
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (Cache.isCacheEnabled() && (!LocalInstallHandler.getInstance().isShortcutExists(this._lap) || Globals.isIconImageUpdated())) {
            Launcher.notifyLocalInstallHandler(launchDesc, this._lap, bl3 || Globals.isIconImageUpdated(), false, bl2, this._downloadWindowHelper.getOwnerRef());
            if (Globals.isIconImageUpdated()) {
                Globals.setIconImageUpdated(false);
            }
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
    }

    private boolean isValidSpecificationVersion(LaunchDesc launchDesc) {
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        return versionString.contains(new VersionID("6.0.10")) || versionString.contains(new VersionID("6.0")) || versionString.contains(new VersionID("1.5")) || versionString.contains(new VersionID("1.0"));
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private void doLaunchApp() throws ExitException {
        final JNLPClassLoader jNLPClassLoader = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(jNLPClassLoader);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException((Exception)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException((Exception)invocationTargetException);
        }
        String string = null;
        Class<?> clazz = null;
        try {
            string = LaunchDownload.getMainClassName(this._launchDesc, true);
            Trace.println((String)("Main-class: " + string), (TraceLevel)TraceLevel.BASIC);
            if (string == null) {
                throw new ClassNotFoundException(string);
            }
            PerfLogger.setTime((String)"Begin load main class ");
            clazz = jNLPClassLoader.loadClass(string);
            PerfLogger.setTime((String)"End load main class ");
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string);
            }
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != jNLPClassLoader) {
                SecurityException securityException = new SecurityException("Bad main-class name");
                throw new ExitException(securityException, 3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        try {
            this._downloadWindowHelper.disable();
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            PerfLogger.setTime((String)"calling executeMainClass ...");
            this.executeMainClass(this._launchDesc, this._lap, clazz, this._downloadWindowHelper);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExitException(illegalAccessException, 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExitException(illegalArgumentException, 3);
        }
        catch (InstantiationException instantiationException) {
            throw new ExitException(instantiationException, 3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exception exception = invocationTargetException;
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                exception = (Exception)invocationTargetException.getTargetException();
            } else {
                throwable.printStackTrace();
            }
            throw new ExitException(exception, 3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 3);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 3);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private void downloadJREResource(LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        if (!this._shownDownloadWindow && !bl) {
            this._shownDownloadWindow = true;
            this._downloadWindowHelper.get().showLoadingProgressScreen();
            this._downloadWindowHelper.get().setVisible(true);
        }
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload.downloadJRE(launchDesc, this._downloadWindowHelper.get(), arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            throw new ExitException(new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 3);
        }
    }

    private void downloadResources(LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        if (!this._shownDownloadWindow && !bl) {
            this._shownDownloadWindow = true;
            this._downloadWindowHelper.get().showLoadingProgressScreen();
            this._downloadWindowHelper.get().setVisible(true);
        }
        try {
            LaunchDownload.downloadExtensions(launchDesc, this._downloadWindowHelper.get(), 0, arrayList);
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, this._downloadWindowHelper.get(), false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 3);
        }
    }

    public static void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, boolean bl3, ComponentRef componentRef) {
        LocalInstallHandler localInstallHandler;
        if (localApplicationProperties == null) {
            return;
        }
        localApplicationProperties.setLastAccessed(new Date());
        if (!bl2) {
            localApplicationProperties.incrementLaunchCount();
        }
        if ((localInstallHandler = LocalInstallHandler.getInstance()) != null) {
            localInstallHandler.install(launchDesc, localApplicationProperties, bl, bl3, componentRef);
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindowHelper downloadWindowHelper) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            boolean bl;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            if (localApplicationProperties != null) {
                string = localApplicationProperties.getCodebase();
                string2 = localApplicationProperties.getDocumentBase();
                bl2 = localApplicationProperties.isDraggedApplet();
            }
            boolean bl3 = bl = !bl2 && (string == null || string2 == null);
            if (bl) {
                AppletDesc appletDesc = launchDesc.getAppletDescriptor();
                URL uRL = BasicServiceImpl.getInstance().getCodeBase();
                URL uRL2 = appletDesc.getDocumentBase();
                if (uRL2 == null) {
                    uRL2 = uRL;
                }
                string = uRL != null ? uRL.toString() : null;
                String string3 = string2 = uRL2 != null ? uRL2.toString() : null;
                if (string2 == null) {
                    string2 = launchDesc.getCanonicalHome().toString();
                }
            }
            this.executeApplet(launchDesc, clazz, downloadWindowHelper, localApplicationProperties, string, string2, bl);
        } else {
            this.executeApplication(launchDesc, localApplicationProperties, clazz, downloadWindowHelper);
        }
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindowHelper downloadWindowHelper) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        PerfLogger.setTime((String)"Begin executeApplication");
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            downloadWindowHelper.reset();
            stringArray = new String[]{localApplicationProperties.isLocallyInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setLocallyInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            stringArray = Globals.getApplicationArgs() != null ? Globals.getApplicationArgs() : launchDesc.getApplicationDescriptor().getArguments();
        }
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        PerfLogger.setTime((String)"End executeApplication (invoking App main)");
        method.invoke(null, objectArray);
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, DownloadWindowHelper downloadWindowHelper, LocalApplicationProperties localApplicationProperties, String string, String string2, boolean bl) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        try {
            Class<?> clazz2 = null;
            clazz2 = Class.forName("sun.plugin2.applet.viewer.JNLP2Viewer");
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            Class[] classArray = new Class[]{new String[0].getClass()};
            Method method = clazz2.getMethod("main", classArray);
            method.setAccessible(true);
            URL uRL = launchDesc.getCanonicalHome();
            File file = null;
            try {
                file = DownloadEngine.getCachedFile((URL)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file != null) {
                Object[] objectArray;
                String[] stringArray = null;
                stringArray = !bl ? ((objectArray = SingleInstanceManager.getActionName()) != null && (objectArray.equals("-open") || objectArray.equals("-print")) ? new String[]{objectArray, SingleInstanceManager.getOpenPrintFilePath(), file.toString()} : (localApplicationProperties.isDraggedApplet() ? new String[]{"-draggedApplet", file.toString()} : new String[]{file.toString()})) : new String[]{"-codebase", string, "-documentbase", string2, file.toString()};
                objectArray = new Object[]{stringArray};
                DeployOfflineManager.setForcedOffline((boolean)false);
                method.invoke(null, objectArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AppletDesc appletDesc = launchDesc.getAppletDescriptor();
            int n = appletDesc.getWidth();
            int n2 = appletDesc.getHeight();
            Applet applet = null;
            applet = (Applet)clazz.newInstance();
            downloadWindowHelper.disposeWindow();
            SplashScreen.hide();
            final JFrame jFrame = new JFrame();
            boolean bl2 = BrowserSupport.isWebBrowserSupported();
            AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

                public void showDocument(URL uRL) {
                    BrowserSupport.showDocument(uRL);
                }

                public void relativeResize(Dimension dimension) {
                    Dimension dimension2 = jFrame.getSize();
                    dimension2.width += dimension.width;
                    dimension2.height += dimension.height;
                    jFrame.setSize(dimension2);
                }
            };
            URL uRL = BasicServiceImpl.getInstance().getCodeBase();
            URL uRL2 = appletDesc.getDocumentBase();
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    appletContainer.stopApplet();
                }
            });
            jFrame.setTitle(launchDesc.getInformation().getTitle());
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add("Center", appletContainer);
            jFrame.pack();
            Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
            jFrame.setSize(dimension);
            jFrame.getRootPane().revalidate();
            jFrame.getRootPane().repaint();
            jFrame.setResizable(false);
            if (!jFrame.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jFrame.setVisible(true);
                    }
                });
            }
            appletContainer.startApplet();
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DownloadEngine.removeCachedResource((URL)launchDesc.getCanonicalHome(), null, null);
        throw new ExitException(exception, 3);
    }

    class CacheUpdateRequiredException
    extends Exception {
        public CacheUpdateRequiredException(String string) {
            super(string);
        }
    }
}

