#include <stdio.h>
#include <stdlib.h>
#include <sys/times.h>
#include <eggx.h>
#include "ppms.h"

#define WD 300
#define HT 500

int main()
{
  double x, y, v, a = -10, t = 0, dt = 0.05;
  double xe, ye;
  float firex[3], firey[3];
  int win, raise = 0;
  char strv[80], strtime[80];

  srand48(times(NULL));
  win = gopen(WD,HT);
  newcolor(win, "Orange");
  gsetbgcolor(win, "black");
  gclr(win);
  window(win, 0, 0, WD, HT);
  layer(win,0,1);

  y = HT - 35;
  x = 0.5*WD;
  v = 0;
  xe = drand48()*80 + 10;
  ye = drand48()*300 + 100;
  gsetnonblock(ENABLE);
  for (;;) {  
    gclr(win);
    if (ggetch() == 0x020) { /* space key */
      a = 10; raise = 1;
    } else {
      a = -10; raise = 0;
    }
    t += dt;
    v += a * dt;
    y += v * dt;
    sprintf(strv,"velocity = %.1f",v);
    sprintf(strtime,"time = %.1f",t);
    firex[0] = x; firex[1] = x - 4; firex[2] = x + 4;
    firey[0] = y - 10; firey[1] = y + 5; firey[2] = y + 5;
    putimg24(win, xe, ye, 32, 32, earth);
    putimg24(win, 0, 0, 300, 34, moon);
    putimg24(win, x-18, y, 35, 35, lander);
    if (raise == 1) fillpoly(win, firex, firey, 3, 1);
    drawstr(win, WD/2+35, 55, 14, 0, strtime);
    drawstr(win, WD/2+35, 35, 14, 0, strv);
    copylayer(win, 1, 0);
    msleep(50);
    if (y < 25) break;
  }
  if ( v >= -15 ) {
    drawstr(win, WD/2 - 90, HT/2, 24, 0, "Congraturation!");
    copylayer(win, 1, 0);
    gsetnonblock(DISABLE);
    for (;;){ 
      if (ggetch() == 0x071) break; /* q key */
    }
  }  
  gclose(win);

  return 0;
}
