#!/bin/bash
# SQLiteManager	(http://www.sqlitemanager.org/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-05-08
# require:
#	php5
#	sqlite3
#
VERSION=1.2.4
PAC_BASE=SQLiteManager
SRC_FILE=SQliteManager-${VERSION}.tar.gz
SRC_URI=http://sourceforge.net/projects/sqlitemanager/files/sqlitemanager/${VERSION}/${SRC_FILE}/download
SRC_NAME=${SRC_FILE%%.tar.gz}
PAC_NAME=${PAC_BASE}-${VERSION}

REL=P1
CPU=noarch
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/sqlitemanager
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=
CUSTOM_PAT_FILE=$CUSTOM_DIR/user_define.diff

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/opt/teTeX/bin:/opt/php5/bin

tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME || exit 1

if [ -f "$SRC_DIR/$PAT_FILE" ]; then
  patch -p1 < $SRC_DIR/$PAT_FILE
fi
if [ -f "$CUSTOM_PAT_FILE" ]; then
  patch -p1 < $CUSTOM_PAT_FILE
fi

cp $CUSTOM_DIR/_htaccess ./.htaccess
mv lang/japanese.inc.php lang/japanese_euc.inc.php
cp $CUSTOM_DIR/japanese_utf8.inc.php lang/japanese.inc.php
nkf -w8 jscalendar/lang/calendar-jp.js > jscalendar/lang/calendar-ja-utf8.js 

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
    `find . -maxdepth 1 -type f -name  "[A-Z]*" | grep -vi makefile` \
    $WORK/$DOC_DIR/
cp -p $CUSTOM_DIR/Plamo-readme-euc.txt  \
    $WORK/$DOC_DIR/
chown -R root.root $WORK/$DOC_DIR/
chmod -R a+rX,go-w $WORK/$DOC_DIR/

mkdir -p $WORK/install || exit 1
sed -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/" \
    -e "s/_VERSION_/${VERSION}/" \
      $CUSTOM_DIR/doinst.sh > $WORK/install/doinst.sh


cd $WORK
mkdir -p opt/htdocs
mv ../$PAC_NAME opt/htdocs/
chown -R wadm.apache $WORK/opt/htdocs/$PAC_NAME

mkdir -p opt/sqliteDB
chown www.apache opt/sqliteDB

mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://www.sqlitemanager.org/
DOC	/${DOC_DIR}/
EXE	/SQLiteManager/
REM	SQLiteManager: Web-based SQLite administration.
__EOCL__


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
