#!/bin/sh

#-PARAMETERS--------------------------------------
CWCHANNEL=1000
CALLSIGN="RAC_ham_news"
GRIDSQUARE=
RAC_NEWS_URL_BASE=http://www.rac.ca/news
RAC_NEWS_HTML_PAGE=cwnews.htm
#-------------------------------------------------



# Function that grabs a morse midi file from the www.rac.ca site, converts it
# into CWirc format and sends it with the correct timing
function send_midi_cw_file
{
  echo "[REJECT INCOMING MESSAGES]"
  echo "Retrieving news file ..."
  CW_EVTS=`curl -stderr=/dev/null $RAC_NEWS_URL_BASE/$1 | mf2t |	\
	awk '/MFile/ {ppqn=$4} /Tempo/ {tempo_ms=$3/1000} /(On)|(Off)/	\
	{tstamp_prev=tstamp; tstamp=$1; if(tstamp>0) printf("%d ",	\
	((tstamp-tstamp_prev)*mul*tempo_ms)/ppqn);			\
	if(/On/) mul=1;else mul=-1}'`
  CW_EVTS=$CW_EVTS" -500"	# Make the the last event is a .5s silence

  echo "Sending news. Send anything to stop ..."
  echo $CW_EVTS								\
	|./send_cw events $CWCHANNEL "" "" "$CALLSIGN" "$GRIDSQUARE" &
  SENDING_PROCESS_PID=$!

  echo "[ACCEPT INCOMING MESSAGES]"
  while [ "`ps --no-headers -p $SENDING_PROCESS_PID`" ];do
    if read -t 2;then
      kill $SENDING_PROCESS_PID
    fi
  done
  wait $SENDING_PROCESS_PID 2> /dev/null

  echo "Done sending news."
}



# Function that gets the main RAC CW news html page and extracts the list of
# available CW midi files with their titles
function get_midi_cw_files_list
{
  IFS_SAVE=$IFS
  IFS=\|
  A=(`curl -stderr=/dev/null $RAC_NEWS_URL_BASE/$RAC_NEWS_HTML_PAGE	\
	| awk '/[hH][rR][eE][fF]=\".*[mM][iI][dD]\"/			\
	{sub(/^.*[hH][rR][eE][fF]=\"/,"");midifile=$0;title=$0;		\
	sub(/\">.*$/,"",midifile);sub(/^.*.[mM][iI][dD]\">/,"",title);	\
	sub(/<\/[aA]>/,"",title);sub(/ *<.*$/,"",title);printf		\
	midifile"|"title"|"}'`)
  IFS=$IFS_SAVE
  I=0
  J=1
  K=0
  while [ "${A[$I]}" ];do
    MIDIFILE_L[$K]=${A[$I]}
    TITLE_L[$K]=${A[$J]}
    let I=I+2
    let J=J+2
    let K=K+1
  done
}



# Main program
echo "[ACCEPT INCOMING MESSAGES]"
echo "----------RAC-NEWS_REPEATER----------"
echo "73 $1!"
echo "I will send CW on channel $CWCHANNEL."
echo "-------------------------------------"
echo " "
echo "This repeater allows you to listen to news in"
echo "morse available from the Radio Amateurs of Canada"
echo "(RAC) page at $RAC_NEWS_URL_BASE/$RAC_NEWS_HTML_PAGE"

echo "[REJECT INCOMING MESSAGES]"
get_midi_cw_files_list

QUIT=0
while [ $QUIT = 0 ];do
  echo "[ACCEPT INCOMING MESSAGES]"
  echo " "
  echo "Available RAC news items:"
  echo " "

  I=0
  J=1
  S="  "
  while [ "${TITLE_L[$I]}" ];do
    echo "${S:${#J}}$J - ${TITLE_L[$I]}"
    let I=I+1
    let J=J+1
  done
  echo " "
  echo "Choose a message to replay, or Q to quit:"

  read
  if [ "$REPLY" != q ] && [ "$REPLY" != Q ];then
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY-1
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 0 ] || [ "${MIDIFILE_L[$INTVAL]}" = "" ];then
      echo "Invalid message!"
    else
      send_midi_cw_file ${MIDIFILE_L[$INTVAL]}
    fi
  else
    QUIT=1
  fi
done

echo "[ACCEPT INCOMING MESSAGES]"
