#!/bin/sh

#-CW-PARAMETERS-----------------------------------
CWCHANNEL=1000
CHAR_WPM=12
AVG_WPM=12
CALLSIGN=CWBot
GRIDSQUARE=
#-NEWS-SOURCE_PARAMETERS--------------------------
RSS_NEWS_FEED=news.bbc.co.uk/rss/newsonline_uk_edition/world/rss.xml
#-------------------------------------------------



# Function to encode prosigns in plain text into high-8th-bit ASCII suitable
# for send_cw, in a news item.
function encode_prosigns
{
  NEWS=`echo $NEWS | awk '{	gsub(/\[AR\]/,	"\200");		\
				gsub(/\[AS\]/,	"\201");		\
				gsub(/\[BK\]/,	"\202");		\
				gsub(/\[BT\]/,	"\203");		\
				gsub(/\[KA\]/,	"\204");		\
				gsub(/\[CL\]/,	"\205");		\
				gsub(/\[KN\]/,	"\206");		\
				gsub(/\[VA\]/,	"\207");		\
				gsub(/\[VE\]/,	"\210");		\
				gsub(/\[GR\]/,	"\211");		\
				gsub(/\[HM\]/,	"\212");		\
				gsub(/\[IX\]/,	"\213");		\
				gsub(/\[IMI\]/,	"\214");		\
				gsub(/\[INT\]/,	"\215");		\
				gsub(/\[SOS\]/,	"\216");		\
				printf($0)}'`
}



# Functions
function send_cw_newsbriefs ()
{
  echo "[REJECT INCOMING MESSAGES]"
  echo "Fetching newsbriefs ..."
  NEWS=`curl -stderr=/dev/null $RSS_NEWS_FEED |				\
        sed -e 's/\(<[^>]*>\)/\1\n/g' | awk '				\
	BEGIN {first_news_item=1;printf("[KA] ")}			\
	/<item>/ {in_item=1}						\
	/<title>/ && in_item {in_title=1;title=""}			\
	in_title {title=sprintf("%s %s",title,$0)}			\
	/<\/title>/ && in_item						\
		{in_title=0;gsub(/<\/*title>/,"",title)}		\
	/<description>/ && in_item {in_desc=1;desc=""}			\
	in_desc {desc=sprintf("%s %s",desc,$0)}				\
	/<\/description>/ && in_item					\
		{in_desc=0;gsub(/<\/*description>/,"",desc)}		\
	/<\/item>/							\
	{								\
	  in_item=0;							\
	  sub(/^[\t ]*/,"",title);					\
	  sub(/[\t \r\n]*$/,"",title);					\
	  sub(/^[\t ]*/,"",desc);					\
	  sub(/[\t \r\n]*$/,"",desc);					\
	  news=sprintf("%s [BT] %s",title,desc);			\
	  gsub(/\t/," ",news);						\
	  gsub(/ +/," ",news);						\
	  								\
	  v=gensub(/^.*&#([[:digit:]]*);.*$/,"\\1",1,news);		\
	  while(v!=news)						\
	  {								\
	    gsub(/^0*/,"",v);						\
	    i=v+0;							\
	    v=sprintf("%c",i);						\
	    news=gensub(/^(.*)&#[[:digit:]]*;(.*)$/,"\\1"v"\\2",1,news);\
	    v=gensub(/^.*&#([[:digit:]]*);.*$/,"\\1",1,news);		\
	  }								\
									\
	  if(!first_news_item)						\
	    printf(" [BT] ");						\
	  printf("%s",news);						\
	  first_news_item=0;						\
	}								\
	END {printf(" [AR]\n")}' | html2text`
  encode_prosigns

  echo "Sending news at $CHAR_WPM WPM (average speed $AVG_WPM WPM)."
  echo "Send anything to stop ..."
  echo $NEWS								\
	|./send_cw ascii $CWCHANNEL $CHAR_WPM $AVG_WPM			\
	"$CALLSIGN" "$GRIDSQUARE" &
  SENDING_PROCESS_PID=$!

  echo "[ACCEPT INCOMING MESSAGES]"
  while [ "`ps --no-headers -p $SENDING_PROCESS_PID`" ];do
    if read -t 2;then
      kill $SENDING_PROCESS_PID
    fi
  done
  wait $SENDING_PROCESS_PID 2> /dev/null

  echo "Done."
}



# Main program
echo "-------------------------------------"
echo "73 $1 de $CALLSIGN!"
echo "I will send CW on channel $CWCHANNEL."
echo "-------------------------------------"

QUIT=0
while [ $QUIT = 0 ];do
  echo "[ACCEPT INCOMING MESSAGES]"
  echo " "
  echo "Menu:"
  echo " "
  echo "1 - Listen to live world newsbriefs in CW (BBC news)"
  echo "2 - Listen to ham news from Radio Amateurs of Canada"
  echo "3 - Access the brasspounder.com MorseMail repeater"
  echo "4 - Access the USMT MorseMail repeater"
  echo "5 - Access the CW tutor"
  echo "6 - Get a random fortune cookie in CW"
  echo " "
  echo "C - Change character keying speed (currently $CHAR_WPM WPM)"
  echo "A - Change average keying speed (currently $AVG_WPM WPM)"
  echo " "
  echo "Q - Quit"
  echo " "
  echo "Your choice ?"
  read

  case "$REPLY" in
  1)
    send_cw_newsbriefs
    ;;

  2)
    ./rac_news_repeater.sh $1
    ;;

  3)
    ./morsemail_repeater.sh "$1" brasspounder.com 8873
    ;;

  4)
    ./morsemail_repeater.sh "$1" dot.trwagner.org 8873
    ;;

  5)
    ./cw_tutor.sh $1
    ;;

  6)
    fortune -s | ./send_cw ascii $CWCHANNEL $CHAR_WPM $AVG_WPM		\
			"$CALLSIGN" "$GRIDSQUARE"
    ;;

  c|C)
    echo "New character keying speed (5 -> 60 WPM) ?"
    read
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 5 ] || [ $INTVAL -gt 60 ];then
      echo "Invalid character keying speed!"
    else
      if [ $AVG_WPM = $CHAR_WPM ];then
        AVG_WPM=$INTVAL
      fi
      CHAR_WPM=$INTVAL
      if [ $AVG_WPM -gt $CHAR_WPM ];then
        AVG_WPM=$CHAR_WPM
      fi
    fi
    ;;

  a|A)
    echo "New average keying speed (5 -> 60 WPM) ?"
    read
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 5 ] || [ $INTVAL -gt 60 ];then
      echo "Invalid average keying speed!"
    else
      AVG_WPM=$INTVAL
      if [ $AVG_WPM -ge $CHAR_WPM ];then
        CHAR_WPM=$AVG_WPM
      fi
    fi
    ;;

  q|Q)
    QUIT=1
    ;;
  esac
done

echo "[ACCEPT INCOMING MESSAGES]"
