#!/bin/sh

#-CW-PARAMETERS-----------------------------------
CWCHANNEL=1000
CHAR_WPM=12
AVG_WPM=12
CALLSIGN=CWtutor
GRIDSQUARE=
#-------------------------------------------------



# Function to create the characters and words sets sent to the user
function makesets
{
  J=0
  G=0
  
  SET_NAME[$G]="Letter groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P"	\
	"Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="Number groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("0" "1" "2" "3" "4" "5" "6" "7" "8" "9")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="Alphanumeric groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P"	\
	"Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z" "0" "1" "2" "3" "4" "5"	\
	"6" "7" "8" "9")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  SET_ELEMENTS_ARE_CHARS[$G]=1
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="All character groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P"	\
	"Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z" "0" "1" "2" "3" "4" "5"	\
	"6" "7" "8" "9" "=" "-" " " "?" "." ";" ")" "/")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="EISH5 groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("E" "I" "S" "H" "5")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="TMO0 groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("T" "M" "O" "0")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="AUV4 groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("A" "U" "V" "4")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="NDB6 groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("N" "D" "B" "6")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="KX=-RP groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("K" "X" "=" "-" "R" "P")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="FLYQC groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("F" "L" "Y" "Q" "C")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="WJ1GZ groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("W" "J" "1" "G" "Z")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="23789 groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("2" "3" "7" "8" "9")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]=",?.;)/ groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("," "?" "." ";" ")" "/")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="\"\'\$(+:_ groups"
  SET_ELEMENTS_ARE_CHARS[$G]=1
  TMP=("\"" "\'" "\$" "(" "+" ":" "_")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="Custom practice set"
  SET_ELEMENTS_ARE_CHARS[$G]=2
  TMP=("")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="Short english words"
  SET_ELEMENTS_ARE_CHARS[$G]=0
  TMP=("ACT" "ADD" "AGE" "AGO" "AID" "AIM" "AIR" 			\
	"ALL" "AND" "ANY" "APE" "ARC" "ARE" "ARK" 			\
	"ARM" "ART" "ASH" "ASK" "ATE" "AWE" "BAD" 			\
	"BAG" "BAR" "BAT" "BAY" "BED" "BEE" "BEG" 			\
	"BET" "BID" "BIG" "BIN" "BIT" "BOB" "BOO" 			\
	"BOW" "BOX" "BOY" "BUD" "BUN" "BUS" "BUT" 			\
	"BUY" "BYE" "CAB" "CAN" "CAR" "CAT" "CON" 			\
	"COP" "COW" "CRY" "CUP" "CUT" "DAN" "DAY" 			\
	"DEW" "DID" "DIE" "DIG" "DIM" "DIN" "DIP" 			\
	"DOG" "DON" "DOT" "DRY" "DUE" "DUG" "EAR" 			\
	"EAT" "EBB" "EGG" "EGO" "END" "ERA" "ERE" 			\
	"ERR" "EYE" "FAN" "FAR" "FAT" "FED" "FEE" 			\
	"FEN" "FEW" "FIN" "FIT" "FIX" "FLY" "FOG" 			\
	"FOR" "FOX" "FRY" "FUN" "FUR" "GAG" "GAP" 			\
	"GAS" "GET" "GIG" "GIN" "GOD" "GOT" "GUM" 			\
	"GUN" "GUT" "GUY" "HAD" "HAM" "HAN" "HAP" 			\
	"HAS" "HAT" "HAY" "HER" "HEY" "HID" "HIM" 			\
	"HIP" "HIS" "HIT" "HOP" "HOT" "HOW" "HUB" 			\
	"HUG" "HUH" "HUM" "HUT" "ICE" "ICY" "ILL" 			\
	"ION" "ITS" "JAR" "JAW" "JAY" "JET" "JIG" 			\
	"JIM" "JOB" "JOT" "JOY" "JUG" "KEY" "KID" 			\
	"KIT" "LAB" "LAD" "LAG" "LAP" "LAW" "LAY" 			\
	"LED" "LEG" "LET" "LID" "LIE" "LIP" "LIT" 			\
	"LOS" "LOT" "LOU" "LOW" "MAD" "MAN" "MAP" 			\
	"MAX" "MAY" "MEG" "MEN" "MET" "MID" "MIX" 			\
	"MOB" "MUD" "MUG" "NAG" "NAP" "NED" "NET" 			\
	"NEW" "NIL" "NIP" "NOD" "NON" "NOR" "NOT" 			\
	"NOW" "NUT" "ODD" "ODE" "OFF" "OIL" "OLD" 			\
	"ONE" "OUR" "OUT" "OWE" "OWN" "PAD" "PAL" 			\
	"PAN" "PAT" "PAY" "PEN" "PER" "PET" "PIG" 			\
	"PIN" "PIT" "POP" "POT" "PUB" "PUN" "PUT" 			\
	"RAG" "RAM" "RAN" "RAP" "RAT" "RAY" "RED" 			\
	"RIB" "RID" "RIG" "RIM" "RIP" "ROB" "ROD" 			\
	"RON" "ROT" "ROW" "RUB" "RUM" "RUN" "SAD" 			\
	"SAN" "SAT" "SAW" "SAY" "SEA" "SEE" "SET" 			\
	"SHE" "SHY" "SIP" "SIR" "SIT" "SIX" "SKY" 			\
	"SOB" "SOD" "SOL" "SON" "SUB" "SUE" "SUM" 			\
	"SUN" "TAB" "TAN" "TAP" "TAR" "TAU" "TAX" 			\
	"TEA" "TED" "TEN" "TEX" "THE" "TIE" "TIN" 			\
	"TIP" "TOE" "TON" "TOO" "TOP" "TOY" "TRY" 			\
	"TUG" "TWO" "UGH" "URN" "USE" "VAN" "VAT" 			\
	"VIA" "VIE" "WAG" "WAN" "WAR" "WAS" "WAY" 			\
	"WEB" "WET" "WHO" "WHY" "WIN" "WIT" "WON" 			\
	"WOO" "YES" "YET" "YOU" "ZOO"					\
	"ABLE" "ACHE" "ACID" "ACTS" "AGED" "AGES" 			\
	"AIRY" "AJAR" "AKIN" "ALEC" "ALLY" "ALSO" 			\
	"AMEN" "ANDY" "ANTI" "ANTS" "ARCH" "ARCS" 			\
	"AREA" "ARID" "ARMS" "ARMY" "ARTS" "ASKS" 			\
	"ATOM" "AUNT" "AVID" "AWAY" "AWED" "AXEL" 			\
	"AXES" "AXIS" "BABY" "BACK" "BAGS" "BAIL" 			\
	"BAIT" "BALL" "BAND" "BANG" "BANK" "BARK" 			\
	"BARS" "BASE" "BASK" "BASS" "BATH" "BATS" 			\
	"BAYS" "BEAD" "BEAK" "BEAM" "BEAN" "BEAR" 			\
	"BEAT" "BEDS" "BEEN" "BEEP" "BEER" "BEES" 			\
	"BELL" "BELT" "BEND" "BENT" "BEST" "BETA" 			\
	"BIDS" "BIKE" "BILL" "BINS" "BIRD" "BITE" 			\
	"BITS" "BLEW" "BLIP" "BLOB" "BLOT" "BLOW" 			\
	"BLUE" "BLUR" "BOAT" "BOBS" "BODY" "BOER" 			\
	"BOIL" "BOLD" "BOLT" "BOMB" "BONE" "BONY" 			\
	"BOOK" "BOOM" "BOOT" "BORE" "BORN" "BOSS" 			\
	"BOTH" "BOUT" "BOWL" "BOYS" "BRIM" "BROW" 			\
	"BUCK" "BUDS" "BULK" "BULL" "BUMP" "BUMS" 			\
	"BUNK" "BURN" "BURY" "BUSH" "BUST" "BUSY" 			\
	"BUYS" "BUZZ" "CAFE" "CAGE" "CAKE" "CALL" 			\
	"CALM" "CAME" "CANS" "CANT" "CAPE" "CARD" 			\
	"CARE" "CARS" "CART" "CASE" "CASH" "CAST" 			\
	"CATS" "CAVE" "CENT" "CHAP" "CHAT" "CHEF" 			\
	"CHEW" "CHIN" "CHIP" "CITY" "CLAD" "CLAP" 			\
	"CLIP" "CLOT" "CLUB" "CLUE" "COAT" "COAX" 			\
	"CODE" "COGS" "COIN" "COKE" "COLD" "COME" 			\
	"COOK" "COOL" "COPE" "COPS" "COPY" "CORE" 			\
	"CORN" "COST" "COWS" "CRAB" "CREW" "CUPS" 			\
	"CURE" "CURL" "CUTE" "DAMP" "DARE" "DARK" 			\
	"DARN" "DART" "DASH" "DATA" "DATE" "DAWN" 			\
	"DAYS" "DAZE" "DEAD" "DEAL" "DEAR" "DEBT" 			\
	"DECK" "DEEP" "DEER" "DENT" "DENY" "DESK" 			\
	"DEWY" "DIAL" "DICE" "DIED" "DIES" "DIET" 			\
	"DINE" "DINT" "DIRE" "DIRT" "DISC" "DISH" 			\
	"DISK" "DIVE" "DOCK" "DOES" "DOGS" "DOLE" 			\
	"DOLL" "DOME" "DONE" "DOOM" "DOOR" "DOSE" 			\
	"DOTS" "DOWN" "DRAG" "DRAW" "DREW" "DRIP" 			\
	"DROP" "DRUG" "DRUM" "DUCK" "DUET" "DULL" 			\
	"DULY" "DUMB" "DUMP" "DUNG" "DUSK" "DUST" 			\
	"DUTY" "DYED" "EACH" "EARS" "EASE" "EAST" 			\
	"EASY" "ECHO" "EDDY" "EDEN" "EDGE" "EDIT" 			\
	"EELS" "EGGS" "ELMS" "ELSE" "EMIT" "ENDS" 			\
	"ENID" "ENVY" "EPIC" "ERAS" "ERIC" "EVEN" 			\
	"EVER" "EVIL" "EXIT" "EYED" "EYES" "FACE" 			\
	"FACT" "FADE" "FAIL" "FAIR" "FAKE" "FALL" 			\
	"FAME" "FARE" "FARM" "FAST" "FATE" "FEAR" 			\
	"FEAT" "FEED" "FEEL" "FEET" "FELL" "FELT" 			\
	"FEND" "FERN" "FIAT" "FILE" "FILL" "FILM" 			\
	"FIND" "FINE" "FINS" "FIRE" "FIRM" "FISH" 			\
	"FIST" "FITS" "FIVE" "FLAG" "FLAP" "FLAT" 			\
	"FLAW" "FLEA" "FLED" "FLEE" "FLEW" "FLEX" 			\
	"FLIP" "FLIT" "FLOP" "FLOW" "FOAM" "FOIL" 			\
	"FOLD" "FOND" "FOOD" "FOOL" "FOOT" "FORD" 			\
	"FORK" "FORM" "FOUL" "FOUR" "FRAY" "FREE" 			\
	"FRET" "FROG" "FROM" "FULL" "FURS" "FURY" 			\
	"FUSS" "GAIL" "GAIN" "GAIT" "GAME" "GARY" 			\
	"GASH" "GASP" "GATE" "GAVE" "GAZE" "GEAR" 			\
	"GENE" "GETS" "GIFT" "GIRD" "GIRL" "GIST" 			\
	"GIVE" "GLAD" "GLEN" "GLOW" "GNAT" "GNAW" 			\
	"GOAL" "GOAT" "GODS" "GOES" "GOLD" "GOLF" 			\
	"GONE" "GONG" "GOOD" "GOWN" "GRAB" "GREW" 			\
	"GREY" "GRIM" "GRIN" "GRIP" "GRIT" "GROW" 			\
	"GULF" "GUNS" "GUYS" "HACK" "HAIR" "HALE" 			\
	"HALF" "HALL" "HALT" "HAND" "HANG" "HARD" 			\
	"HARM" "HATE" "HATS" "HAUL" "HAVE" "HAWK" 			\
	"HAZE" "HAZY" "HEAD" "HEAP" "HEAR" "HEAT" 			\
	"HECK" "HEEL" "HELD" "HELL" "HELP" "HERD" 			\
	"HERE" "HERO" "HERS" "HIDE" "HIGH" "HILL" 			\
	"HIND" "HINT" "HIPS" "HIRE" "HISS" "HOLD" 			\
	"HOLE" "HOLY" "HOME" "HOOK" "HOOP" "HOOT" 			\
	"HOPE" "HORN" "HOSE" "HOST" "HOUR" "HOWL" 			\
	"HUGE" "HULL" "HUMS" "HUNG" "HUNK" "HUNT" 			\
	"HURL" "HURT" "HUSH" "HUSK" "HUTS" "HYDE" 			\
	"HYMN" "ICED" "IDEA" "IDLE" "IDLY" "INCH" 			\
	"INTO" "IRON" "ITEM" "JAIL" "JANE" "JAWS" 			\
	"JAZZ" "JETS" "JOBS" "JOIN" "JOKE" "JOLT" 			\
	"JOYS" "JUMP" "JUNK" "JURY" "JUST" "KARL" 			\
	"KEEL" "KEEN" "KEEP" "KENT" "KEPT" "KEYS" 			\
	"KICK" "KIDS" "KILL" "KIND" "KING" "KISS" 			\
	"KNEE" "KNEW" "KNOB" "KNOT" "KNOW" "LABS" 			\
	"LACK" "LADS" "LADY" "LAID" "LAIN" "LAKE" 			\
	"LAME" "LAMP" "LAND" "LANE" "LARK" "LAST" 			\
	"LATE" "LAVA" "LAWN" "LAWS" "LAYS" "LAZY" 			\
	"LEAD" "LEAF" "LEAK" "LEAN" "LEAP" "LEFT" 			\
	"LEGS" "LEND" "LESS" "LETS" "LEWD" "LICK" 			\
	"LIED" "LIES" "LIFE" "LIFT" "LIKE" "LIMB" 			\
	"LIMP" "LINE" "LINK" "LIPS" "LISA" "LIST" 			\
	"LIVE" "LOAD" "LOAF" "LOAN" "LOCK" "LOGO" 			\
	"LONE" "LONG" "LOOK" "LOOM" "LOOP" "LORD" 			\
	"LOSE" "LOSS" "LOST" "LOTS" "LOUD" "LOVE" 			\
	"LUCK" "LUMP" "LURE" "LURK" "LUSH" "LYNX" 			\
	"MADE" "MAIL" "MAIN" "MAKE" "MANE" "MANS" 			\
	"MANY" "MAPS" "MARK" "MARS" "MASH" "MASS" 			\
	"MATE" "MAZE" "MEAL" "MEAN" "MEAT" "MEET" 			\
	"MELT" "MEND" "MENS" "MENU" "MERE" "MESS" 			\
	"MICE" "MIKE" "MILD" "MILE" "MILK" "MILL" 			\
	"MIND" "MINE" "MINI" "MINT" "MIRE" "MISS" 			\
	"MIST" "MOCK" "MODE" "MOOD" "MOON" "MORE" 			\
	"MOSS" "MOST" "MOTH" "MOVE" "MUCH" "MUCK" 			\
	"MUST" "MUTE" "MYTH" "NAIL" "NAME" "NEAR" 			\
	"NEAT" "NECK" "NEED" "NEON" "NEST" "NEWS" 			\
	"NEWT" "NEXT" "NICE" "NINE" "NOEL" "NONE" 			\
	"NOON" "NOSE" "NOTE" "NUMB" "NUTS" "OATH" 			\
	"ODDS" "OILY" "ONCE" "ONES" "ONLY" "ONTO" 			\
	"OPEN" "OUCH" "OURS" "OVEN" "OVER" "OWED" 			\
	"OWLS" "OWNS" "PACE" "PACK" "PADS" "PAGE" 			\
	"PAID" "PAIN" "PAIR" "PALE" "PALL" "PALM" 			\
	"PANG" "PARK" "PART" "PASS" "PAST" "PATH" 			\
	"PAUL" "PEAK" "PEAR" "PEAT" "PEEL" "PEEP" 			\
	"PEER" "PEGS" "PENT" "PHIL" "PICK" "PIES" 			\
	"PIGS" "PILE" "PINE" "PING" "PINK" "PINS" 			\
	"PINT" "PISA" "PITS" "PITY" "PLAN" "PLAY" 			\
	"PLOD" "PLOT" "PLOY" "PLUG" "PLUS" "PODS" 			\
	"POEM" "POET" "POKE" "POLE" "POLO" "POND" 			\
	"PONY" "POOL" "POOR" "PORK" "PORT" "POSE" 			\
	"POST" "POUR" "PRAY" "PREY" "PRIM" "PROD" 			\
	"PROP" "PROW" "PUBS" "PUFF" "PULL" "PULP" 			\
	"PUMP" "PURE" "PURR" "PUSH" "PUTS" "QUIZ" 			\
	"RACE" "RAFT" "RAGE" "RAID" "RAIL" "RAIN" 			\
	"RAMP" "RANG" "RANK" "RAPT" "RARE" "RASP" 			\
	"RATE" "RATS" "RAVE" "RAYS" "READ" "REAL" 			\
	"REAR" "REEL" "RELY" "REND" "RENT" "REST" 			\
	"RIBS" "RICE" "RICH" "RICK" "RIDE" "RIFT" 			\
	"RING" "RISE" "RISK" "ROAD" "ROAM" "ROAR" 			\
	"ROBE" "ROCK" "RODE" "RODS" "ROLE" "ROLL" 			\
	"ROME" "ROOF" "ROOM" "ROOT" "ROPE" "ROSE" 			\
	"RUDE" "RUIN" "RULE" "RUNG" "RUNS" "RUSH" 			\
	"RUST" "SACK" "SAFE" "SAGA" "SAGE" "SAID" 			\
	"SAIL" "SAKE" "SALE" "SALT" "SAME" "SAND" 			\
	"SANE" "SANG" "SANK" "SASH" "SAVE" "SAWS" 			\
	"SAYS" "SCAN" "SEAL" "SEAS" "SEAT" "SEED" 			\
	"SEEK" "SEEM" "SEEN" "SEER" "SEES" "SELF" 			\
	"SELL" "SEMI" "SEND" "SENT" "SETS" "SHED" 			\
	"SHIP" "SHOD" "SHOE" "SHOP" "SHOT" "SHOW" 			\
	"SHUT" "SICK" "SIDE" "SIGH" "SIGN" "SILK" 			\
	"SILO" "SING" "SINK" "SINS" "SITE" "SITS" 			\
	"SITU" "SIZE" "SKID" "SKIN" "SKIP" "SKIS" 			\
	"SLAP" "SLAY" "SLEW" "SLID" "SLIM" "SLIP" 			\
	"SLOT" "SLOW" "SLUG" "SLUM" "SMUG" "SNAP" 			\
	"SNOW" "SNUG" "SOAP" "SODA" "SOFA" "SOFT" 			\
	"SOIL" "SOLD" "SOLE" "SOLO" "SOME" "SONG" 			\
	"SONY" "SOON" "SORE" "SORT" "SOUL" "SOUP" 			\
	"SOUR" "SPAN" "SPAT" "SPED" "SPIN" "SPIT" 			\
	"SPOT" "SPUN" "SPUR" "STAB" "STAR" "STAY" 			\
	"STEP" "STIR" "STOP" "STUB" "STUN" "SUCH" 			\
	"SUED" "SUIT" "SULK" "SUMS" "SUNK" "SUNS" 			\
	"SURE" "SURF" "SWAB" "SWAM" "SWAY" "SWIM" 			\
	"TACT" "TAIL" "TAKE" "TALK" "TALL" "TANK" 			\
	"TAPE" "TAPS" "TASK" "TAXI" "TEAM" "TEAR" 			\
	"TELL" "TEND" "TENS" "TENT" "TERM" "TEST" 			\
	"TEXT" "THAN" "THAT" "THEM" "THEN" "THEY" 			\
	"THIN" "THIS" "THOR" "THUD" "THUS" "TICK" 			\
	"TIDE" "TIED" "TIES" "TILE" "TILL" "TILT" 			\
	"TIME" "TINY" "TIPS" "TIRE" "TOES" "TOLD" 			\
	"TOLL" "TOMB" "TONE" "TONS" "TOOK" "TOOL" 			\
	"TOPS" "TORE" "TORN" "TOTO" "TOUR" "TOWN" 			\
	"TRAP" "TRAY" "TREE" "TREK" "TRIM" "TRIP" 			\
	"TROD" "TROT" "TRUE" "TUBE" "TUFT" "TUNE" 			\
	"TURF" "TURN" "TWIG" "TWIN" "TWOS" "TYPE" 			\
	"UGLY" "UNIT" "UNIX" "UNTO" "UPON" "URGE" 			\
	"URSA" "USED" "VAIN" "VARY" "VAST" "VEIL" 			\
	"VERY" "VIEW" "VILE" "VOID" "VOTE" "VOWS" 			\
	"WAFT" "WAGE" "WAIL" "WAIT" "WAKE" "WALK" 			\
	"WALL" "WANT" "WARD" "WARM" "WARN" "WARP" 			\
	"WARS" "WART" "WARY" "WASH" "WAVE" "WAYS" 			\
	"WEAK" "WEAR" "WEBS" "WEEK" "WEEP" "WELL" 			\
	"WENT" "WERE" "WEST" "WHAT" "WHEN" "WHIM" 			\
	"WHIP" "WHOM" "WICK" "WIDE" "WIFE" "WIGS" 			\
	"WILD" "WILL" "WILT" "WIND" "WINE" "WING" 			\
	"WINK" "WINS" "WIPE" "WIRE" "WIRY" "WISE" 			\
	"WISH" "WISP" "WITH" "WOKE" "WOLF" "WONT" 			\
	"WOOD" "WOOF" "WORD" "WORE" "WORK" "WORM" 			\
	"WORN" "WRAP" "YANK" "YAWN" "YEAR" "YELL" 			\
	"YELP" "YORK" "YOUR" "ZERO" "ZEST" "ZONE" 			\
	"ZOOM"								\
	"ABACK" "ABOUT" "ABOVE" "ABUSE" "ACHED" "ACHES" 		\
	"ACORN" "ACRID" "ACTOR" "ACUTE" "ADDED" "ADMIT" 		\
	"ADOPT" "AFOOT" "AFTER" "AGAIN" "AGENT" "AGONY" 		\
	"AGREE" "AHEAD" "AIMED" "AISLE" "ALARM" "ALBUM" 		\
	"ALERT" "ALGOL" "ALIEN" "ALIVE" "ALLEN" "ALLEY" 		\
	"ALLOW" "ALOFT" "ALONE" "ALONG" "ALOUD" "ALPHA" 		\
	"ALTAR" "ALTER" "AMISS" "AMONG" "AMPLY" "ANGEL" 		\
	"ANGER" "ANGLE" "ANGRY" "ANGST" "ANKLE" "ANNOY" 		\
	"ANTIC" "APART" "APPLE" "APPLY" "APRIL" "APRON" 		\
	"AREAS" "ARGUE" "ARISE" "ARMED" "AROSE" "ARRAY" 		\
	"ARROW" "ASHEN" "ASHES" "ASIDE" "ASKED" "ATLAS" 		\
	"ATOLL" "ATOMS" "ATONE" "AURAL" "AVIAN" "AVOID" 		\
	"AWAKE" "AWARD" "AWARE" "AWFUL" "AWOKE" "BABEL" 		\
	"BACKS" "BACON" "BADLY" "BAGGY" "BAKED" "BAKER" 		\
	"BALLS" "BALMY" "BANDS" "BANGS" "BANKS" "BARED" 		\
	"BARRY" "BASED" "BASIC" "BASIS" "BATHS" "BEACH" 		\
	"BEADS" "BEADY" "BEAMS" "BEARD" "BEAST" "BEERS" 		\
	"BEGAN" "BEGIN" "BEGUN" "BEING" "BELLS" "BELOW" 		\
	"BELTS" "BENCH" "BERTH" "BETEL" "BILLS" "BINGO" 		\
	"BIRDS" "BIRTH" "BLACK" "BLADE" "BLAME" "BLANK" 		\
	"BLAST" "BLAZE" "BLEAK" "BLEND" "BLESS" "BLIND" 		\
	"BLINK" "BLITZ" "BLOBS" "BLOCK" "BLOKE" "BLOND" 		\
	"BLOOM" "BLOWN" "BLUER" "BLUNT" "BLURS" "BOARD" 		\
	"BOATS" "BOBBY" "BOLTS" "BONES" "BOOKS" "BOOTH" 		\
	"BOOTS" "BOOZE" "BORED" "BORNE" "BOUND" "BOUTS" 		\
	"BOWED" "BOWLS" "BOXES" "BRAIN" "BRAKE" "BRAND" 		\
	"BRASH" "BRASS" "BRAUN" "BRAVE" "BREAD" "BREAK" 		\
	"BRICK" "BRIEF" "BRING" "BRINK" "BRISK" "BROAD" 		\
	"BROCK" "BROKE" "BROWN" "BROWS" "BRUSH" "BUDGE" 		\
	"BUGGY" "BUILD" "BUILT" "BULKY" "BUNCH" "BURLY" 		\
	"BURNS" "BURNT" "BURST" "BUSES" "CABIN" "CACTI" 		\
	"CAFES" "CAKES" "CALLS" "CAPES" "CARDS" "CARED" 		\
	"CARES" "CARGO" "CAROL" "CARRY" "CARTS" "CARVE" 		\
	"CASES" "CATCH" "CATER" "CAUSE" "CAVED" "CAVES" 		\
	"CEASE" "CELLS" "CHAIN" "CHAIR" "CHANT" "CHAOS" 		\
	"CHAPS" "CHARM" "CHART" "CHASE" "CHASM" "CHEAP" 		\
	"CHECK" "CHEEK" "CHEER" "CHEFS" "CHESS" "CHIEF" 		\
	"CHILD" "CHILL" "CHIME" "CHINA" "CHINK" "CHINS" 		\
	"CHOIR" "CHOKE" "CHOSE" "CHUCK" "CHURN" "CHUTE" 		\
	"CIGAR" "CIVIL" "CLAIM" "CLARE" "CLASS" "CLAWS" 		\
	"CLEAN" "CLEAR" "CLERK" "CLICK" "CLIFF" "CLIMB" 		\
	"CLING" "CLOAK" "CLOCK" "CLOGS" "CLONE" "CLOSE" 		\
	"CLOTH" "CLOUD" "CLUBS" "CLUES" "CLUMP" "CLUNG" 		\
	"COACH" "COAST" "COATS" "COBOL" "CODES" "COINS" 		\
	"COMBS" "COMES" "COMET" "COMMA" "COOKS" "CORKS" 		\
	"CORPS" "COSTS" "COUCH" "COUGH" "COULD" "COUNT" 		\
	"COURT" "COVER" "CRAFT" "CRAGS" "CRASH" "CRAVE" 		\
	"CRAWL" "CRAZY" "CREAK" "CREAM" "CREEP" "CREPT" 		\
	"CREST" "CREWS" "CRIED" "CRIES" "CRIME" "CROOK" 		\
	"CROPS" "CROSS" "CROWD" "CROWN" "CRUDE" "CRUEL" 		\
	"CRUMB" "CRUST" "CRYPT" "CUBES" "CUBIC" "CURES" 		\
	"CURSE" "CURVE" "CYCLE" "DADDY" "DAILY" "DAIRY" 		\
	"DANCE" "DARED" "DARTS" "DATED" "DAVID" "DAWNS" 		\
	"DAZED" "DEALS" "DEALT" "DEATH" "DECAY" "DEEDS" 		\
	"DELAY" "DELTA" "DENSE" "DENTS" "DEPTH" "DESKS" 		\
	"DETER" "DEVIL" "DEVON" "DIALS" "DIARY" "DIMLY" 		\
	"DINER" "DIODE" "DIRGE" "DIRTY" "DIVED" "DIZZY" 		\
	"DODGE" "DOING" "DOMED" "DONOR" "DOORS" "DOUBT" 		\
	"DOWNS" "DOZED" "DOZEN" "DRAMA" "DRANK" "DRAWL" 		\
	"DRAWN" "DREAM" "DRESS" "DRIED" "DRIER" "DRIFT" 		\
	"DRILL" "DRINK" "DRIVE" "DRONE" "DROPS" "DROVE" 		\
	"DRUGS" "DRUMS" "DRUNK" "DUCKS" "DULLY" "DUSTY" 		\
	"DWELL" "DYING" "EAGER" "EAGLE" "EARLY" "EARTH" 		\
	"EASED" "EASES" "EATEN" "EATER" "EBONY" "EDDIE" 		\
	"EDGED" "EDGES" "EDITS" "EERIE" "EIGHT" "EJECT" 		\
	"ELBOW" "ELDER" "ELVIS" "EMILY" "EMPTY" "ENDED" 		\
	"ENJOY" "ENTER" "ENTRY" "EQUAL" "ERROR" "ESSAY" 		\
	"ETHEL" "ETHER" "ETHIC" "EVENT" "EVERY" "EXACT" 		\
	"EXERT" "EXILE" "EXIST" "EXTRA" "FACED" "FACES" 		\
	"FACTO" "FACTS" "FADED" "FADES" "FAINT" "FAITH" 		\
	"FAKED" "FALLS" "FALSE" "FAMED" "FANCY" "FANGS" 		\
	"FARED" "FARMS" "FATES" "FAULT" "FEAST" "FEEDS" 		\
	"FEELS" "FENCE" "FERNS" "FETCH" "FETID" "FEVER" 		\
	"FEWER" "FIELD" "FIERY" "FIFTH" "FIFTY" "FIGHT" 		\
	"FILED" "FILES" "FILMS" "FINAL" "FINDS" "FINER" 		\
	"FIRED" "FIRES" "FIRST" "FISTS" "FIXED" "FLAGS" 		\
	"FLAME" "FLARE" "FLASH" "FLASK" "FLATS" "FLAWS" 		\
	"FLEET" "FLESH" "FLICK" "FLIES" "FLING" "FLINT" 		\
	"FLIPS" "FLOAT" "FLOCK" "FLOOD" "FLOOR" "FLOWN" 		\
	"FLOWS" "FLUFF" "FLUID" "FLUNG" "FLYER" "FOAMY" 		\
	"FOCUS" "FOLDS" "FOLKS" "FOLLY" "FOODS" "FOOLS" 		\
	"FORCE" "FORDS" "FORGE" "FORMS" "FORTH" "FORTY" 		\
	"FOUND" "FRAME" "FRANK" "FRAUD" "FREAK" "FREED" 		\
	"FRESH" "FRIED" "FRIES" "FROGS" "FRONT" "FROST" 		\
	"FROTH" "FROWN" "FROZE" "FRUIT" "FUDGE" "FUGUE" 		\
	"FULLY" "FUMED" "FUMES" "FUNNY" "FURRY" "GAILY" 		\
	"GAMES" "GAMMA" "GAPED" "GASES" "GASPS" "GAUGE" 		\
	"GAUNT" "GAZED" "GEARS" "GEESE" "GENES" "GENUS" 		\
	"GERMS" "GHOST" "GIANT" "GIDDY" "GIFTS" "GIRLS" 		\
	"GIVEN" "GIVES" "GLADE" "GLAND" "GLARE" "GLASS" 		\
	"GLEAM" "GLINT" "GLOBE" "GLOOM" "GLORY" "GLOSS" 		\
	"GOALS" "GOATS" "GOING" "GOLDS" "GONER" "GOOSE" 		\
	"GRACE" "GRAFT" "GRAIN" "GRAND" "GRANT" "GRAPH" 		\
	"GRASP" "GRASS" "GRATE" "GRAVE" "GRAVY" "GREAT" 		\
	"GREEK" "GREEN" "GREET" "GRIEF" "GRILL" "GRIME" 		\
	"GRINS" "GRIPS" "GROAN" "GROOM" "SET" "GROWL" 		\
	"GROWN" "GROWS" "GRUNT" "GUARD" "GUESS" "GUEST" 		\
	"GUIDE" "GUILT" "GUISE" "GULLY" "GUSTS" "GYPSY" 		\
	"HABIT" "HADES" "HALLS" "HANDS" "HANDY" "HAPPY" 		\
	"HARMS" "HARSH" "HATCH" "HATED" "HATES" "HAVEN" 		\
	"HAVOC" "HEADS" "HEARD" "HEART" "HEAVE" "HEAVY" 		\
	"HEDGE" "HEELS" "HEFTY" "HEIRS" "HELLO" "HENCE" 		\
	"HERDS" "HERES" "HIKED" "HIKER" "HILLS" "HITCH" 		\
	"HOBBY" "HOLDS" "HOLES" "HOMED" "HOMES" "HONDO" 		\
	"HONED" "HONEY" "HOOPS" "HOPED" "HOPES" "HORNS" 		\
	"HORSE" "HOSTS" "HOTEL" "HOTLY" "HOURS" "HOUSE" 		\
	"HOVEL" "HOVER" "HUMAN" "HUMID" "HUNCH" "HUNTS" 		\
	"HURRY" "HURTS" "HUSKY" "HYENA" "IDEAL" "IDEAS" 		\
	"IDIOT" "IGLOO" "IMAGE" "INANE" "INDEX" "INDIA" 		\
	"INEPT" "INERT" "INFRA" "INNER" "INPUT" "IRATE" 		\
	"IRONY" "ISSUE" "ITALY" "ITEMS" "JAMES" "JEANS" 		\
	"JOKES" "JOLLY" "JUDGE" "JUICE" "JUMPS" "JUMPY" 		\
	"JUNKY" "KAPPA" "KEEPS" "KEVIN" "KICKS" "KILLS" 		\
	"KINDS" "KINGS" "KNACK" "KNEEL" "KNEES" "KNELT" 		\
	"KNIFE" "KNOBS" "KNOCK" "KNOTS" "KNOWN" "KNOWS" 		\
	"LACES" "LACEY" "LADEN" "LANDS" "LARGE" "LASER" 		\
	"LASTS" "LATER" "LAUGH" "LAYER" "LEADS" "LEAFY" 		\
	"LEAKY" "LEAPS" "LEAPT" "LEARN" "LEAST" "LEAVE" 		\
	"LEDGE" "LEGAL" "LEMON" "LEVEL" "LEVER" "LICKS" 		\
	"LIFTS" "LIGHT" "LIKED" "LIKES" "LILAC" "LIMBS" 		\
	"LIMIT" "LINED" "LINEN" "LINER" "LINES" "LINKS" 		\
	"LIONS" "LIVED" "LIVER" "LIVES" "LIVID" "LLOYD" 		\
	"LOBBY" "LOCAL" "LOCKS" "LODGE" "LOGIC" "LOOKS" 		\
	"LOOPS" "LOOSE" "LORDS" "LORRY" "LOSER" "LOUSY" 		\
	"LOVED" "LOVES" "LOWER" "LUCKY" "LUMPS" "LUMPY" 		\
	"LUNCH" "LUNGS" "LURCH" "LYING" "MADAM" "MAGIC" 		\
	"MAGNA" "MAJOR" "MAKER" "MAKES" "MANIC" "MARCH" 		\
	"MARKS" "MARRY" "MARSH" "MATCH" "MAYBE" "MAZES" 		\
	"MEALS" "MEANS" "MEANT" "MEATY" "MEDIA" "MEETS" 		\
	"MELON" "MEMOS" "MENUS" "MERRY" "MESON" "MESSY" 		\
	"METAL" "MICRO" "MIGHT" "MILES" "MINCE" "MINDS" 		\
	"MINES" "MINOR" "MINUS" "MISTS" "MISTY" "MIXED" 		\
	"MODEL" "MOIST" "MONEY" "MONKS" "MONTH" "MOODS" 		\
	"MOONS" "MOPED" "MORAL" "MOSES" "MOTEL" "MOTOR" 		\
	"MOTTO" "MOUSE" "MOUTH" "MOVED" "MOVER" "MOVES" 		\
	"MOVIE" "MOWER" "MUDDY" "MULTI" "MURAL" "MURKY" 		\
	"MUSED" "MUSIC" "MUSTY" "MUTED" "NAIVE" "NAKED" 		\
	"NAMED" "NAMES" "NANCY" "NASTY" "NAVEL" "NEEDS" 		\
	"NERVE" "NEVER" "NEWLY" "NICER" "NIFTY" "NIGHT" 		\
	"NOBLE" "NOISE" "NOISY" "NORTH" "NOTES" "NYLON" 		\
	"OBEYS" "OCCUR" "OCEAN" "ODDLY" "OFFER" "OFTEN" 		\
	"OILED" "OLDER" "OLIVE" "OMITS" "OOZED" "OPENS" 		\
	"OPERA" "OPTED" "OPTIC" "ORBIT" "ORDER" "ORGAN" 		\
	"ORION" "OTHER" "OTTER" "OUGHT" "OUTER" "OWNED" 		\
	"OWNER" "OZONE" "PACED" "PACES" "PACKS" "PADDY" 		\
	"PAGES" "PAINS" "PAINT" "PAIRS" "PALMS" "PANEL" 		\
	"PANIC" "PAPER" "PARKS" "PARTS" "PARTY" "PATCH" 		\
	"PATHS" "PAULA" "PAUSE" "PAVED" "PEACE" "PEAKS" 		\
	"PEARS" "PEDAL" "PENCE" "PENNY" "PERCH" "PERIL" 		\
	"PERKY" "PETER" "PETTY" "PHASE" "PHONE" "PHOTO" 		\
	"PIECE" "PIGGY" "PILED" "PILES" "PILLS" "PILOT" 		\
	"PINTS" "PIOUS" "PIPED" "PIPER" "PIPES" "PITCH" 		\
	"PIZZA" "PLACE" "PLAIN" "PLANE" "PLANK" "PLANS" 		\
	"PLANT" "PLATE" "PLAYS" "PLAZA" "PLEAD" "PLIED" 		\
	"PLUCK" "PLUSH" "PLUTO" "POEMS" "POETS" "POINT" 		\
	"POKED" "POLES" "POOLS" "PORED" "PORTS" "POSSE" 		\
	"POUCH" "POUND" "POWER" "PRESS" "PRICE" "PRIDE" 		\
	"PRIME" "PRINT" "PRIOR" "PRISM" "PRIZE" "PROBE" 		\
	"PRONE" "PRONG" "PROOF" "PROUD" "PROVE" "PROWL" 		\
	"PULSE" "PUMPS" "PUNCH" "PUPPY" "PUTTY" "QUARK" 		\
	"QUEST" "QUEUE" "QUICK" "QUIET" "QUILL" "QUITE" 		\
	"QUOTE" "RACED" "RACES" "RACKS" "RADIO" "RAGED" 		\
	"RAGES" "RAINS" "RAISE" "RAKED" "RANGE" "RANKS" 		\
	"RAPID" "RAVED" "REACH" "REACT" "READY" "REDLY" 		\
	"REEDS" "REFER" "RELAX" "RENEW" "RENTS" "REPLY" 		\
	"RESET" "RIDES" "RIDGE" "RIGHT" "RIGID" "RINGS" 		\
	"RIOTS" "RISEN" "RISES" "RISKS" "RIVAL" "RIVER" 		\
	"ROADS" "ROAST" "ROBED" "ROBES" "ROBOT" "ROCKS" 		\
	"ROCKY" "ROLLS" "ROOMS" "ROOTS" "ROSES" "ROUGH" 		\
	"ROUND" "ROUTE" "ROYAL" "RUINS" "RULED" "RULER" 		\
	"RULES" "RUSTS" "RUSTY" "SADLY" "SAFER" "SAGES" 		\
	"SAINT" "SALAD" "SALES" "SALLY" "SANDS" "SANDY" 		\
	"SANER" "SANTA" "SAUCE" "SAVED" "SAVES" "SAWED" 		\
	"SCALE" "SCALP" "SCALY" "SCARE" "SCARF" "SCARS" 		\
	"SCARY" "SCENE" "SCENT" "SCOOP" "SCOPE" "SCORE" 		\
	"SCOUT" "SCOWL" "SCREW" "SCRUB" "SEALS" "SEAMS" 		\
	"SEATS" "SEEDS" "SEEDY" "SEEMS" "SEERS" "SEIZE" 		\
	"SELLS" "SENDS" "SENSE" "SERVE" "SETUP" "SEVEN" 		\
	"SHACK" "SHADE" "SHADY" "SHAKE" "SHAKY" "SHALL" 		\
	"SHAME" "SHAPE" "SHARD" "SHARE" "SHARK" "SHARP" 		\
	"SHEAF" "SHEEN" "SHEEP" "SHEER" "SHEET" "SHELF" 		\
	"SHIED" "SHIFT" "SHINE" "SHINY" "SHIPS" "SHIRT" 		\
	"SHOAL" "SHOCK" "SHOES" "SHONE" "SHOOK" "SHOOT" 		\
	"SHOPS" "SHORE" "SHORT" "SHOUT" "SHOVE" "SHOWN" 		\
	"SHOWS" "SHRUG" "SHUTS" "SIDES" "SIEVE" "SIGHT" 		\
	"SIGNS" "SILKY" "SILLY" "SIMON" "SINAI" "SINCE" 		\
	"SINKS" "SIXTH" "SIXTY" "SIZED" "SKIES" "SKILL" 		\
	"SKINS" "SKIPS" "SKULL" "SLANG" "SLASH" "SLATE" 		\
	"SLEEK" "SLEEP" "SLEPT" "SLICE" "SLIDE" "SLIME" 		\
	"SLIMY" "SLITS" "SLOPE" "SLUMP" "SLUNG" "SMACK" 		\
	"SMALL" "SMART" "SMASH" "SMELL" "SMELT" "SMILE" 		\
	"SMIRK" "SMITH" "SMOKE" "SNARL" "SNEAK" "SNEER" 		\
	"SNIFF" "SNOWS" "SNOWY" "SOBER" "SOCKS" "SOFAS" 		\
	"SOGGY" "SOLAR" "SOLES" "SOLID" "SOLVE" "SONGS" 		\
	"SONIC" "SONNY" "SORRY" "SORTS" "SOULS" "SOUND" 		\
	"SOUTH" "SPACE" "SPANS" "SPARE" "SPASM" "SPEAK" 		\
	"SPEAR" "SPECK" "SPEED" "SPELL" "SPEND" "SPENT" 		\
	"SPIKE" "SPILL" "SPILT" "SPINE" "SPITE" "SPLIT" 		\
	"SPOIL" "SPOKE" "SPOON" "SPORT" "SPOTS" "SPOUT" 		\
	"SPRAY" "SQUAD" "SQUAT" "STACK" "STAFF" "STAGE" 		\
	"STAIR" "STAKE" "STALE" "STALK" "STALL" "STAMP" 		\
	"STAND" "STARE" "STARK" "STARS" "START" "STATE" 		\
	"STAYS" "STEAD" "STEAK" "STEAL" "STEAM" "STEEL" 		\
	"STEEP" "STEER" "STEPS" "STERN" "STEVE" "STICK" 		\
	"STILL" "STING" "STINT" "STOCK" "STOLE" "STOMP" 		\
	"STONE" "STONY" "STOOD" "STOPS" "STORE" "STORM" 		\
	"STORY" "STOUT" "STOVE" "STRAW" "STRAY" "STRIP" 		\
	"STRUT" "STUCK" "STUDY" "STUFF" "STUMP" "STUNG" 		\
	"STUNT" "STYLE" "SUGAR" "SUING" "SUITE" "SUITS" 		\
	"SUNNY" "SUPER" "SURGE" "SURLY" "SWAMP" "SWARM" 		\
	"SWEAR" "SWEAT" "SWEEP" "SWEET" "SWELL" "SWEPT" 		\
	"SWIFT" "SWING" "SWISH" "SWISS" "SWOON" "SWOOP" 		\
	"SWORE" "SWORN" "SWUNG" "SYRUP" "TABLE" "TAINT" 		\
	"TAKEN" "TAKES" "TALES" "TALKS" "TALLY" "TANKS" 		\
	"TAPES" "TASTE" "TAXIS" "TEACH" "TEAMS" "TEARS" 		\
	"TEASE" "TEETH" "TELLS" "TENDS" "TENEX" "TENOR" 		\
	"TENSE" "TENTH" "TERMS" "TESTS" "THANK" "THATS" 		\
	"THEFT" "THEIR" "THEME" "THERE" "THESE" "THICK" 		\
	"THIEF" "THIGH" "THING" "THINK" "THIRD" "THOSE" 		\
	"THREE" "THREW" "THROB" "THROW" "THUDS" "THUGS" 		\
	"THUMB" "THUMP" "TIDAL" "TIDES" "TIGHT" "TILES" 		\
	"TIMER" "TIMES" "TIRED" "TITAN" "TITLE" "TOAST" 		\
	"TODAY" "TOKEN" "TOMBS" "TONES" "TONGS" "TONIC" 		\
	"TOOLS" "TOOTH" "TORCH" "TOTAL" "TOUCH" "TOUGH" 		\
	"TOWEL" "TOWER" "TOWNS" "TOYED" "TRACE" "TRACK" 		\
	"TRACT" "TRADE" "TRAIL" "TRAIN" "TRAMP" "TRASH" 		\
	"TREAD" "TREES" "TRESS" "TRIAL" "TRIBE" "TRICK" 		\
	"TRIED" "TRIES" "TRUCK" "TRULY" "TRUNK" "TRUST" 		\
	"TRUTH" "TUBES" "TUNED" "TURNS" "TWANG" "TWICE" 		\
	"TWIST" "TYING" "TYPES" "ULTRA" "UNDER" "UNION" 		\
	"UNITS" "UNTIL" "UPPER" "UPSET" "URGED" "USAGE" 		\
	"USERS" "USHER" "USING" "USUAL" "UTTER" "VAGUE" 		\
	"VALUE" "VAULT" "VENUS" "VERBS" "VERSE" "VESTS" 		\
	"VEXED" "VIDEO" "VIEWS" "VILLA" "VIRGO" "VIRUS" 		\
	"VISIT" "VITAL" "VIVID" "VOCAL" "VOICE" "VOTED" 		\
	"VOWED" "WADED" "WAIST" "WALES" "WALLS" "WANED" 		\
	"WANLY" "WANTS" "WASPS" "WASTE" "WATCH" "WATER" 		\
	"WAVED" "WAVER" "WAVES" "WAYNE" "WEARY" "WEAVE" 		\
	"WEEDS" "WEEKS" "WEIRD" "WETLY" "WHACK" "WHALE" 		\
	"WHEEL" "WHERE" "WHICH" "WHILE" "WHINE" "WHIPS" 		\
	"WHITE" "WHOLE" "WHOOP" "WHOSE" "WIDER" "WIDTH" 		\
	"WIELD" "WILLS" "WINDS" "WINDY" "WINES" "WINGS" 		\
	"WIPED" "WIPER" "WIRES" "WISER" "WISPS" "WIVES" 		\
	"WOMAN" "WOMEN" "WOODS" "WOODY" "WORDS" "WORKS" 		\
	"WORLD" "WORRY" "WORSE" "WORST" "WORTH" "WOULD" 		\
	"WOUND" "WRAPS" "WRECK" "WREST" "WRIST" "WRITE" 		\
	"WRONG" "WROTE" "YARDS" "YEARS" "YIELD" "YOUNG" 		\
	"YOURS" "YOUTH" "ZAIRE" "ZEBRA" "ZONES")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
  
  SET_NAME[$G]="CW words"
  SET_ELEMENTS_ARE_CHARS[$G]=0
  TMP=("(" "+" "73" "88" "AA" "AB" "ABT" "ADR" "AGN" 			\
	"AM" "ANT" "AS" "B4" "BCI" "BCL" "BK" "BN" 			\
	"BUG" "C" "CFM" "CL" "CLD" "CLG" "CQ" "CW" 			\
	"DLD" "DLVD" "DR" "DX" "ES" "FB" "FM" "GA" "GM" 		\
	"GN" "GND" "GUD" "HI" "HR" "HV" "HW" "K" "LID" 			\
	"MA" "MILS" "MSG" "N" "NCS" "ND" "NIL" "NM" 			\
	"NR" "NW" "OB" "OC" "OM" "OP" "OPR" "OT" "PBL" 			\
	"PSE" "PWR" "PX" "QRG" "QRH" "QRI" "QRJ" "QRK" 			\
	"QRL" "QRM" "QRN" "QRO" "QRP" "QRQ" "QRS" "QRT" 		\
	"QRU" "QRV" "QRW" "QRX" "QRY" "QRZ" "QSA" "QSB" 		\
	"QSD" "QSG" "QSK" "QSL" "QSM" "QSN" "QSO" "QSP" 		\
	"QST" "QSU" "QSW" "QSX" "QSY" "QSZ" "QTA" "QTB" 		\
	"QTC" "QTH" "QTR" "R" "RCD" "RCVR" "REF" "RFI" 			\
	"RIG" "RTTY" "RX" "SASE" "SED" "SIG" "SKED" 			\
	"SRI" "SSB" "SVC" "T" "TFC" "TKS" "TMW" "TNX" 			\
	"TT" "TU" "TVI" "TX" "TXT" "UR" "URS" "VFO" 			\
	"VY" "WA" "WB" "WD" "WDS" "WKD" "WKG" "WL" 			\
	"WUD" "WX" "XCVR" "XMTR" "XTAL" "XYL" "YL" 			\
	"BURO" "HPE" "CU" "SN" "TEST" "TEMP" "MNI" 			\
	"RST" "599" "5NN" "559" "CPY" "DE" "OK" "RPT" 			\
	"ANI" "BCNU" "BD" "BLV" "CC" "CK" "CNT" "CO" 			\
	"CONDX" "CPSE" "CRD" "CUD" "CUAGN" "CUL" 			\
	"ELBUG" "ENUF" "FER" "FONE" "FREQ" "GB" "GD" 			\
	"GE" "HVY" "II" "INPT" "LSN" "PA" "PP" "RPRT" 			\
	"RPT" "SA" "STN" "SUM" "SWL" "TRX" "WID")
  SET_START[$G]=$J;for I in ${TMP[*]};do SET[$J]=$I;let J=J+1;done;
  let SET_SIZE[$G]=J-SET_START[$G];let G=G+1
}



# Function to make a random group of 5 characters, or a random word, from the
# set number passed as argument
function makegroup
{
  if [ ${SET_ELEMENTS_ARE_CHARS[$1]} -ge 1 ];then
    GROUP=""
    MGJ=5
    while [ $MGJ -gt 0 ];do
      if [ ${SET_ELEMENTS_ARE_CHARS[$1]} = 1 ];then
        let MGI=(RANDOM*SET_SIZE[$1])/32768+SET_START[$1];
        GROUP="$GROUP${SET[$MGI]}"
      else
        let MGI=(RANDOM*${#CPS})/32768;
        GROUP="$GROUP${CPS:$MGI:1}"
      fi
      let MGJ=MGJ-1
    done
  else
    let MGI=(RANDOM*SET_SIZE[$1])/32768+SET_START[$1];
    GROUP=${SET[$MGI]}
  fi
}



# Main program
makesets
CPS=""

echo "-------------------------------------"
echo "73 $1!"
echo "I will send CW on channel $CWCHANNEL."
echo "-------------------------------------"

QUIT=0
G=0
NBG=3
while [ $QUIT = 0 ];do
  echo "[ACCEPT INCOMING MESSAGES]"
  echo " "
  echo "Menu:"
  echo " "
  if [ ${SET_ELEMENTS_ARE_CHARS[$G]} = 2 ];then
    echo "1 - Choose a practice set (currently ${SET_NAME[$G]} \"${CPS}\")"
  else
    echo "1 - Choose a practice set (currently ${SET_NAME[$G]})"
  fi
  echo "2 - Set how many groups to send (currently $NBG)"
  echo "3 - Practice copying CW"
  echo " "
  echo "C - Change character keying speed (currently $CHAR_WPM WPM)"
  echo "A - Change average keying speed (currently $AVG_WPM WPM)"
  echo " "
  echo "Q - Quit"
  echo " "
  echo "Your choice ?"
  read

  case "$REPLY" in
  1)
    echo " "
    I=0
    J=1
    S="  "
    while [ "${SET_NAME[$I]}" ];do
      echo "${S:${#J}}$J - ${SET_NAME[$I]}"
      let I=I+1
      let J=J+1
    done
    echo " "
    echo "Choose a practice set, or Q to return to the main menu:"
    read
    if [ "$REPLY" != q ] && [ "$REPLY" != Q ];then
      if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
      then
        let INTVAL=$REPLY-1
      else
        let INTVAL=-1
      fi
      if [ $INTVAL -lt 0 ] || [ "${SET_NAME[$INTVAL]}" = "" ];then
        echo "Invalid practice set!"
      else
        if [ ${SET_ELEMENTS_ARE_CHARS[$INTVAL]} = 2 ];then
          echo "Enter the custom set of characters you want to use:"
          read
          if [ "$REPLY" = "" ];then
            echo "Invalid practice set!"
          else
            G=$INTVAL
            CPS=`echo ${REPLY} | tr '\-a-z' _A-Z | sed -e "s/[ 	]//g"`
          fi
        else
          G=$INTVAL
        fi
      fi
    fi
    ;;

  2)
    echo "How many groups shall I send you in one go"
    echo "before correcting ? (1 -> 15) ?"
    read
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 1 ] || [ $INTVAL -gt 15 ];then
      echo "Invalid number of groups!"
    else
      NBG=$INTVAL
    fi
    ;;

  3)
    echo "I will send you $NBG groups then correct you."

    ALLGROUPS=""
    I=0
    while [ $I -lt $NBG ];do
      makegroup $G
      if [ "$ALLGROUPS" ];then
        ALLGROUPS="$ALLGROUPS $GROUP"
      else
        ALLGROUPS=$GROUP
      fi
      let I=I+1
    done

    echo "Sending groups. Send anything to stop ..."
    echo $ALLGROUPS							\
	|./send_cw ascii $CWCHANNEL $CHAR_WPM $AVG_WPM			\
	"$CALLSIGN" "$GRIDSQUARE" &
    SENDING_PROCESS_PID=$!

    while [ "`ps --no-headers -p $SENDING_PROCESS_PID`" ];do
      if read -t 2;then
        kill $SENDING_PROCESS_PID
      fi
    done
    wait $SENDING_PROCESS_PID 2> /dev/null

    echo "Type what you copied, using spaces between"
    echo "groups and | for the characters you missed"
    echo "(Example: G|RTF DE|GH ES23H), or Q if you"
    echo "don't want the correction ..."
    read
    if [ "$REPLY" ] && [ "$REPLY" != q ] && [ "$REPLY" != Q ];then
      REPLY=`echo $REPLY | awk '{print toupper($0)}'`
      if [ "$REPLY" = "$ALLGROUPS" ];then
        echo "No errors! Congratulations!"
      else
        CORR=""
        I=0
        ERRORS=0
        while [ "${ALLGROUPS:$I:1}" ] || [ "${REPLY:$I:1}" ];do
          if [ "${ALLGROUPS:$I:1}" = "${REPLY:$I:1}" ];then
            CORR="$CORR "
          else
            CORR="$CORR|"
            let ERRORS=ERRORS+1
          fi
          let I=I+1
        done

        echo "You made $ERRORS errors:"
        echo " "
        echo "I sent:     $ALLGROUPS"
        echo "            $CORR"
        echo "You copied: $REPLY"
      fi
    fi
    ;;

  c|C)
    echo "New character keying speed (5 -> 60 WPM) ?"
    read
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 5 ] || [ $INTVAL -gt 60 ];then
      echo "Invalid character keying speed!"
    else
      if [ $AVG_WPM = $CHAR_WPM ];then
        AVG_WPM=$INTVAL
      fi
      CHAR_WPM=$INTVAL
      if [ $AVG_WPM -gt $CHAR_WPM ];then
        AVG_WPM=$CHAR_WPM
      fi
    fi
    ;;

  a|A)
    echo "New average keying speed (5 -> 60 WPM) ?"
    read
    if [ "$REPLY" ] &&
	[ "`echo $REPLY|awk '{sub(/[^[:digit:]]/,"");print $0}'`" = "$REPLY" ]
    then
      let INTVAL=$REPLY
    else
      let INTVAL=-1
    fi
    if [ $INTVAL -lt 5 ] || [ $INTVAL -gt 60 ];then
      echo "Invalid average keying speed!"
    else
      AVG_WPM=$INTVAL
      if [ $AVG_WPM -ge $CHAR_WPM ];then
        CHAR_WPM=$AVG_WPM
      fi
    fi
    ;;

  q|Q)
    QUIT=1
    ;;
  esac
done

echo "[ACCEPT INCOMING MESSAGES]"
