/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.CallbackUtil;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.common.SecurityProviderInfo;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.hash.MD5;
import gnu.java.security.hash.Sha160;
import gnu.java.security.util.Util;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

abstract class Command {
    private static final Logger log = Logger.getLogger(Command.class.getName());
    private static final String DEFAULT_ALIAS = "mykey";
    private static final String DEFAULT_KEY_ALGORITHM = "DSA";
    private static final String DSA_SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static final String RSA_SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int DEFAULT_VALIDITY = 90;
    protected static final OID SHA1_WITH_DSA = new OID("1.2.840.10040.4.3");
    private static final OID MD2_WITH_RSA = new OID("1.2.840.113549.1.1.2");
    private static final OID MD5_WITH_RSA = new OID("1.2.840.113549.1.1.4");
    private static final OID SHA1_WITH_RSA = new OID("1.2.840.113549.1.1.5");
    private static final long MILLIS_IN_A_DAY = 86400000L;
    protected String alias;
    protected char[] keyPasswordChars;
    protected Provider provider;
    protected String storeType;
    protected char[] storePasswordChars;
    protected URL storeURL;
    protected InputStream storeStream;
    protected KeyStore store;
    protected OutputStream outStream;
    protected boolean systemOut;
    protected KeyPairGenerator keyPairGenerator;
    protected Signature signatureAlgorithm;
    protected int validityInDays;
    protected InputStream inStream;
    protected boolean verbose;
    private IMessageDigest md5 = new MD5();
    private IMessageDigest sha = new Sha160();
    private int providerNdx = -2;
    private CallbackHandler handler;
    private ShutdownHook shutdownThread = new ShutdownHook();

    protected Command() {
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public void doCommand() throws Exception {
        try {
            this.setup();
            this.start();
        }
        finally {
            this.teardown();
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
        }
    }

    public void setVerbose(String flag) {
        this.verbose = Boolean.valueOf(flag);
    }

    String[] processArgs(String[] args) {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "processArgs", args);
        }
        Parser cmdOptionsParser = this.getParser();
        String[] result = cmdOptionsParser.parse(args);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "processArgs", result);
        }
        return result;
    }

    abstract void setup() throws Exception;

    void start() throws Exception {
        throw new RuntimeException("Not implemented yet");
    }

    void teardown() {
        block15: {
            if (Configuration.DEBUG) {
                log.entering(this.getClass().getName(), "teardown");
            }
            if (this.storeStream != null) {
                try {
                    this.storeStream.close();
                }
                catch (IOException ignored) {
                    if (!Configuration.DEBUG) break block15;
                    log.fine("Exception while closing key store URL stream. Ignored: " + ignored);
                }
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.flush();
            }
            catch (IOException iOException) {}
            if (!this.systemOut) {
                try {
                    this.outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.providerNdx > 0) {
            ProviderUtil.removeProvider(this.provider.getName());
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    abstract Parser getParser();

    protected void setKeyStoreParams(String className, String type, String password, String url) throws IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setKeyStoreParams(false, className, type, password, url);
    }

    protected void setKeyStoreParams(boolean createIfNotFound, String className, String type, String password, String url) throws IOException, UnsupportedCallbackException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setProviderClassNameParam(className);
        this.setKeystoreTypeParam(type);
        this.setKeystoreURLParam(createIfNotFound, url, password);
    }

    private void setProviderClassNameParam(String className) {
        if (Configuration.DEBUG) {
            log.fine("setProviderClassNameParam(" + className + ")");
        }
        if (className != null && className.trim().length() > 0) {
            className = className.trim();
            SecurityProviderInfo spi = ProviderUtil.addProvider(className);
            this.provider = spi.getProvider();
            if (this.provider == null && Configuration.DEBUG) {
                log.fine("Was unable to add provider from class " + className);
            }
            this.providerNdx = spi.getPosition();
        }
    }

    private void setKeystoreTypeParam(String type) {
        if (Configuration.DEBUG) {
            log.fine("setKeystoreTypeParam(" + type + ")");
        }
        this.storeType = type == null || type.trim().length() == 0 ? KeyStore.getDefaultType() : type.trim();
    }

    protected void setKeyPasswordParam(String password) throws IOException, UnsupportedCallbackException {
        this.setKeyPasswordNoPrompt(password);
        if (this.keyPasswordChars == null) {
            this.setKeyPasswordParam();
        }
    }

    protected void setAliasParam(String name) {
        this.alias = name == null ? DEFAULT_ALIAS : name.trim();
    }

    protected void setKeyPasswordNoPrompt(String password) {
        if (password != null) {
            this.keyPasswordChars = password.toCharArray();
        }
    }

    private void setKeyPasswordParam() throws IOException, UnsupportedCallbackException {
        String prompt = Messages.getFormattedString("Command.21", this.alias);
        PasswordCallback pcb = new PasswordCallback(prompt, false);
        this.getCallbackHandler().handle(new Callback[]{pcb});
        this.keyPasswordChars = pcb.getPassword();
        pcb.clearPassword();
        if (this.keyPasswordChars == null) {
            throw new SecurityException(Messages.getString("Command.23"));
        }
    }

    private void setKeystorePasswordParam(String password) throws IOException, UnsupportedCallbackException {
        if (password != null) {
            this.storePasswordChars = password.toCharArray();
        } else {
            String prompt = Messages.getString("Command.24");
            PasswordCallback pcb = new PasswordCallback(prompt, false);
            this.getCallbackHandler().handle(new Callback[]{pcb});
            this.storePasswordChars = pcb.getPassword();
            pcb.clearPassword();
        }
    }

    private void setKeystoreURLParam(boolean createIfNotFound, String url, String password) throws IOException, KeyStoreException, UnsupportedCallbackException, NoSuchAlgorithmException, CertificateException {
        block17: {
            if (Configuration.DEBUG) {
                log.fine("setKeystoreURLParam(" + url + ")");
            }
            if (url == null || url.trim().length() == 0) {
                String userHome = SystemProperties.getProperty((String)"user.home");
                if (userHome == null || userHome.trim().length() == 0) {
                    throw new InvalidParameterException(Messages.getString("Command.36"));
                }
                url = String.valueOf(userHome.trim()) + "/.keystore";
                if (createIfNotFound) {
                    new File(url).createNewFile();
                }
                url = "file:" + url;
            } else {
                if ((url = url.trim()).indexOf(":") == -1 && createIfNotFound) {
                    new File(url).createNewFile();
                }
                url = "file:" + url;
            }
            boolean newKeyStore = false;
            this.storeURL = new URL(url);
            this.storeStream = this.storeURL.openStream();
            if (this.storeStream.available() == 0) {
                if (Configuration.DEBUG) {
                    log.fine("Store is empty. Will use <null> when loading, to create it");
                }
                newKeyStore = true;
            }
            try {
                this.store = KeyStore.getInstance(this.storeType);
            }
            catch (KeyStoreException x) {
                if (this.provider != null) {
                    throw x;
                }
                if (Configuration.DEBUG) {
                    log.fine("Exception while getting key store with default provider(s). Will prompt user for another provider and continue");
                }
                String prompt = Messages.getString("Command.40");
                NameCallback ncb = new NameCallback(prompt);
                this.getCallbackHandler().handle(new Callback[]{ncb});
                String className = ncb.getName();
                this.setProviderClassNameParam(className);
                if (this.provider == null) {
                    x.fillInStackTrace();
                    throw x;
                }
                this.store = KeyStore.getInstance(this.storeType, this.provider);
            }
            this.setKeystorePasswordParam(password);
            if (newKeyStore) {
                this.store.load(null, this.storePasswordChars);
            } else {
                this.store.load(this.storeStream, this.storePasswordChars);
            }
            try {
                this.storeStream.close();
                this.storeStream = null;
            }
            catch (IOException x) {
                if (!Configuration.DEBUG) break block17;
                log.fine("Exception while closing the key store input stream: " + x + ". Ignore");
            }
        }
    }

    protected void setOutputStreamParam(String fileName) throws SecurityException, IOException {
        if (fileName == null || fileName.trim().length() == 0) {
            this.outStream = System.out;
            this.systemOut = true;
        } else {
            File outFile = new File(fileName = fileName.trim());
            if (!outFile.exists()) {
                boolean ok = outFile.createNewFile();
                if (!ok) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.19", fileName));
                }
            } else {
                if (!outFile.isFile()) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.42", fileName));
                }
                if (!outFile.canWrite()) {
                    throw new InvalidParameterException(Messages.getFormattedString("Command.44", fileName));
                }
            }
            this.outStream = new FileOutputStream(outFile);
        }
    }

    protected void setInputStreamParam(String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.trim().length() == 0) {
            this.inStream = System.in;
        } else {
            File inFile = new File(fileName = fileName.trim());
            if (!(inFile.exists() && inFile.isFile() && inFile.canRead())) {
                throw new InvalidParameterException(Messages.getFormattedString("Command.46", fileName));
            }
            this.inStream = new FileInputStream(inFile);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setAlgorithmParams(String kpAlg, String sigAlg) throws NoSuchAlgorithmException {
        kpAlg = kpAlg == null || kpAlg.trim().length() == 0 ? DEFAULT_KEY_ALGORITHM : kpAlg.trim().toLowerCase();
        this.keyPairGenerator = KeyPairGenerator.getInstance(kpAlg);
        if (sigAlg == null || sigAlg.trim().length() == 0) {
            if (kpAlg.equalsIgnoreCase("dss") || kpAlg.equalsIgnoreCase("dsa")) {
                sigAlg = DSA_SIGNATURE_ALGORITHM;
            } else {
                if (!kpAlg.equalsIgnoreCase("rsa")) throw new IllegalArgumentException(Messages.getFormattedString("Command.20", new String[]{sigAlg, kpAlg}));
                sigAlg = RSA_SIGNATURE_ALGORITHM;
            }
        } else {
            sigAlg = sigAlg.trim().toLowerCase();
        }
        this.signatureAlgorithm = Signature.getInstance(sigAlg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setSignatureAlgorithmParam(String algorithm, Key privateKey) throws NoSuchAlgorithmException {
        if (algorithm == null || algorithm.trim().length() == 0) {
            if (privateKey instanceof DSAKey) {
                algorithm = DSA_SIGNATURE_ALGORITHM;
            } else {
                if (!(privateKey instanceof RSAKey)) throw new InvalidParameterException(Messages.getString("Command.48"));
                algorithm = RSA_SIGNATURE_ALGORITHM;
            }
        } else {
            algorithm = algorithm.trim();
        }
        this.signatureAlgorithm = Signature.getInstance(algorithm);
    }

    protected void setValidityParam(String days) {
        if (days == null || days.trim().length() == 0) {
            this.validityInDays = 90;
        } else {
            days = days.trim();
            this.validityInDays = Integer.parseInt(days);
            if (this.validityInDays < 1) {
                throw new InvalidParameterException(Messages.getString("Command.51"));
            }
        }
    }

    protected byte[] getSelfSignedCertificate(X500DistinguishedName distinguishedName, PublicKey publicKey, PrivateKey privateKey) throws IOException, SignatureException, InvalidKeyException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getSelfSignedCertificate", new Object[]{distinguishedName, publicKey, privateKey});
        }
        byte[] versionBytes = new DERValue(2, (Object)BigInteger.ZERO).getEncoded();
        DERValue derVersion = new DERValue(160, versionBytes.length, (Object)versionBytes, null);
        Preferences prefs = Preferences.systemNodeForPackage(this.getClass());
        int lastSerialNumber = prefs.getInt("lastSerialNumber", 0) + 1;
        prefs.putInt("lastSerialNumber", lastSerialNumber);
        DERValue derSerialNumber = new DERValue(2, (Object)BigInteger.valueOf(lastSerialNumber));
        OID signatureID = this.getSignatureAlgorithmOID();
        DERValue derSignatureID = new DERValue(6, (Object)signatureID);
        ArrayList<DERValue> signature = new ArrayList<DERValue>(1);
        signature.add(derSignatureID);
        if (!signatureID.equals((Object)SHA1_WITH_DSA)) {
            signature.add(new DERValue(5, null));
        }
        DERValue derSignature = new DERValue(48, signature);
        DERValue derIssuer = new DERReader(distinguishedName.getDer()).read();
        long notBefore = System.currentTimeMillis();
        long notAfter = notBefore + (long)this.validityInDays * 86400000L;
        ArrayList<DERValue> validity = new ArrayList<DERValue>(2);
        validity.add(new DERValue(23, (Object)new Date(notBefore)));
        validity.add(new DERValue(23, (Object)new Date(notAfter)));
        DERValue derValidity = new DERValue(48, validity);
        DERValue derSubject = derIssuer;
        DERValue derSubjectPublicKeyInfo = new DERReader(publicKey.getEncoded()).read();
        ArrayList<DERValue> tbsCertificate = new ArrayList<DERValue>(7);
        tbsCertificate.add(derVersion);
        tbsCertificate.add(derSerialNumber);
        tbsCertificate.add(derSignature);
        tbsCertificate.add(derIssuer);
        tbsCertificate.add(derValidity);
        tbsCertificate.add(derSubject);
        tbsCertificate.add(derSubjectPublicKeyInfo);
        DERValue derTBSCertificate = new DERValue(48, tbsCertificate);
        DERValue derSignatureAlgorithm = derSignature;
        this.signatureAlgorithm.initSign(privateKey);
        this.signatureAlgorithm.update(derTBSCertificate.getEncoded());
        byte[] sigBytes = this.signatureAlgorithm.sign();
        DERValue derSignatureValue = new DERValue(3, (Object)new BitString(sigBytes));
        ArrayList<DERValue> certificate = new ArrayList<DERValue>(3);
        certificate.add(derTBSCertificate);
        certificate.add(derSignatureAlgorithm);
        certificate.add(derSignatureValue);
        DERValue derCertificate = new DERValue(48, certificate);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DERWriter.write((OutputStream)baos, (DERValue)derCertificate);
        byte[] result = baos.toByteArray();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getSelfSignedCertificate");
        }
        return result;
    }

    protected OID getSignatureAlgorithmOID() {
        String algorithm = this.signatureAlgorithm.getAlgorithm();
        if (algorithm == null || algorithm.trim().length() == 0) {
            throw new InvalidParameterException(Messages.getString("Command.52"));
        }
        if ((algorithm = algorithm.trim()).equalsIgnoreCase("dss") || algorithm.equalsIgnoreCase(DSA_SIGNATURE_ALGORITHM)) {
            return SHA1_WITH_DSA;
        }
        if (algorithm.equalsIgnoreCase("rsa-pkcs1-v1.5-md2") || algorithm.equalsIgnoreCase("MD2withRSA")) {
            return MD2_WITH_RSA;
        }
        if (algorithm.equalsIgnoreCase("rsa-pkcs1-v1.5-md5") || algorithm.equalsIgnoreCase(RSA_SIGNATURE_ALGORITHM) || algorithm.equalsIgnoreCase("rsa")) {
            return MD5_WITH_RSA;
        }
        if (algorithm.equalsIgnoreCase("rsa-pkcs1-v1.5-sha-160") || algorithm.equalsIgnoreCase("SHA1withRSA")) {
            return SHA1_WITH_RSA;
        }
        throw new InvalidParameterException(Messages.getFormattedString("Command.60", algorithm));
    }

    protected void saveKeyStore(char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "saveKeyStore");
        }
        URLConnection con = this.storeURL.openConnection();
        con.setDoOutput(true);
        con.setUseCaches(false);
        OutputStream out = con.getOutputStream();
        if (this.verbose) {
            System.out.println(Messages.getFormattedString("Command.63", this.storeURL.getPath()));
        }
        this.store.store(out, password);
        out.flush();
        out.close();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "saveKeyStore");
        }
    }

    protected void saveKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.saveKeyStore(this.storePasswordChars);
    }

    protected void printVerbose(Certificate certificate, PrintWriter writer) throws CertificateEncodingException {
        X509Certificate x509 = (X509Certificate)certificate;
        writer.println(Messages.getFormattedString("Command.66", x509.getSubjectDN()));
        writer.println(Messages.getFormattedString("Command.67", x509.getIssuerDN()));
        writer.println(Messages.getFormattedString("Command.68", x509.getSerialNumber()));
        writer.println(Messages.getFormattedString("Command.69", x509.getNotBefore()));
        writer.println(Messages.getFormattedString("Command.70", x509.getNotAfter()));
        writer.println(Messages.getString("Command.71"));
        byte[] derBytes = certificate.getEncoded();
        writer.println(Messages.getFormattedString("Command.72", this.digest(this.md5, derBytes)));
        writer.println(Messages.getFormattedString("Command.73", this.digest(this.sha, derBytes)));
    }

    protected void printVerbose(Certificate certificate) throws CertificateEncodingException {
        this.printVerbose(certificate, new PrintWriter(System.out, true));
    }

    protected String digestWithMD5(byte[] contents) {
        return this.digest(this.md5, contents);
    }

    private String digest(IMessageDigest hash, byte[] encoded) {
        hash.update(encoded);
        byte[] b = hash.digest();
        StringBuilder sb = new StringBuilder().append(Util.toString((byte[])b, (int)0, (int)1));
        int i = 1;
        while (i < b.length) {
            sb.append(":").append(Util.toString((byte[])b, (int)i, (int)1));
            ++i;
        }
        String result = sb.toString();
        return result;
    }

    protected void ensureStoreContainsAlias() throws KeyStoreException {
        if (!this.store.containsAlias(this.alias)) {
            throw new IllegalArgumentException(Messages.getFormattedString("Command.75", this.alias));
        }
    }

    protected void ensureAliasIsKeyEntry() throws KeyStoreException {
        if (!this.store.isKeyEntry(this.alias)) {
            throw new SecurityException(Messages.getFormattedString("Command.77", this.alias));
        }
    }

    protected Key getAliasPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException {
        Key result;
        this.ensureAliasIsKeyEntry();
        if (this.keyPasswordChars == null) {
            try {
                result = this.store.getKey(this.alias, this.storePasswordChars);
                this.keyPasswordChars = this.storePasswordChars;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.setKeyPasswordParam();
                result = this.store.getKey(this.alias, this.keyPasswordChars);
            }
        } else {
            result = this.store.getKey(this.alias, this.keyPasswordChars);
        }
        return result;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.handler == null) {
            this.handler = CallbackUtil.getConsoleHandler();
        }
        return this.handler;
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            Command.this.teardown();
        }
    }
}

