/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;

public class DTD
implements DTDConstants {
    public static final int FILE_VERSION = 1;
    static Hashtable<String, DTD> dtdHash = new Hashtable();
    public Element applet;
    public Element base;
    public Element body;
    public Element head;
    public Element html;
    public Element isindex;
    public Element meta;
    public Element p;
    public Element param;
    public Element pcdata;
    public Element title;
    public Hashtable<String, Element> elementHash = new Hashtable();
    public Hashtable<Object, Entity> entityHash = new Hashtable();
    public String name;
    public Vector<Element> elements = new Vector();

    protected DTD(String a_name) {
        this.name = a_name;
    }

    public static DTD getDTD(String name) throws IOException {
        DTD d = dtdHash.get(name);
        if (d == null) {
            d = new DTD(name);
            dtdHash.put(d.name, d);
        }
        return d;
    }

    public Element getElement(String element_name) {
        return this.newElement(element_name);
    }

    public Element getElement(int index) {
        return this.elements.get(index);
    }

    public Entity getEntity(int id) {
        String name = Entity.mapper.get(id);
        if (name != null) {
            return this.entityHash.get(name);
        }
        return null;
    }

    public Entity getEntity(String entity_name) {
        return this.entityHash.get(entity_name);
    }

    public String getName() {
        return this.name;
    }

    public Entity defEntity(String name, int type, int character) {
        Entity e = this.newEntity(name, type);
        e.data = new char[]{(char)character};
        return e;
    }

    public void defineAttributes(String forElement, AttributeList attributes) {
        Element e = this.elementHash.get(forElement.toLowerCase());
        if (e == null) {
            e = this.newElement(forElement);
        }
        e.atts = attributes;
    }

    public Element defineElement(String name, int type, boolean headless, boolean tailless, ContentModel content, BitSet exclusions, BitSet inclusions, AttributeList attributes) {
        Element e = this.newElement(name);
        e.type = type;
        e.oStart = headless;
        e.oEnd = tailless;
        e.content = content;
        e.exclusions = exclusions;
        e.inclusions = inclusions;
        e.atts = attributes;
        return e;
    }

    public Entity defineEntity(String name, int type, char[] data) {
        Entity e = this.newEntity(name, type);
        e.data = data;
        return e;
    }

    public static void putDTDHash(String name, DTD dtd) {
        dtdHash.put(name, dtd);
    }

    public void read(DataInputStream stream) throws IOException {
        ObjectInputStream oi = new ObjectInputStream(stream);
        try {
            while (true) {
                DTDConstants e;
                Object def;
                if ((def = oi.readObject()) instanceof Element) {
                    e = (Element)def;
                    this.elementHash.put(e.name.toLowerCase(), (Element)e);
                    this.assignField((Element)e);
                    continue;
                }
                if (!(def instanceof Entity)) continue;
                e = (Entity)def;
                this.entityHash.put(((Entity)e).name, (Entity)e);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public String toString() {
        return this.name;
    }

    protected AttributeList defAttributeList(String name, int type, int modifier, String default_value, String allowed_values, AttributeList atts) {
        AttributeList al = new AttributeList(name);
        al.modifier = modifier;
        al.value = default_value;
        al.next = atts;
        if (allowed_values != null) {
            StringTokenizer st = new StringTokenizer(allowed_values, " \t|");
            Vector<String> v = new Vector<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            al.values = v;
        }
        return al;
    }

    protected ContentModel defContentModel(int type, Object content, ContentModel next) {
        ContentModel model = new ContentModel();
        model.type = type;
        model.next = next;
        model.content = content;
        return model;
    }

    protected Element defElement(String name, int type, boolean headless, boolean tailless, ContentModel content, String[] exclusions, String[] inclusions, AttributeList attributes) {
        BitSet exclude = this.bitSet(exclusions);
        BitSet include = this.bitSet(inclusions);
        Element e = this.defineElement(name, type, headless, tailless, content, exclude, include, attributes);
        return e;
    }

    protected Entity defEntity(String name, int type, String data) {
        Entity e = this.newEntity(name, type);
        e.data = data.toCharArray();
        return e;
    }

    private void assignField(Element e) {
        block5: {
            String element_name = e.name;
            try {
                Field f = this.getClass().getField(element_name.toLowerCase());
                if ((f.getModifiers() & 1) != 0 && (f.getModifiers() & 8) == 0 && f.getType().isAssignableFrom(e.getClass())) {
                    f.set(this, e);
                }
            }
            catch (IllegalAccessException ex) {
                this.unexpected(ex);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Throwable t) {
                if (!(t instanceof OutOfMemoryError)) break block5;
                throw (Error)t;
            }
        }
    }

    private BitSet bitSet(String[] elements) {
        BitSet b = new BitSet();
        int i = 0;
        while (i < elements.length) {
            Element e = this.getElement(elements[i]);
            if (e == null) {
                e = this.newElement(elements[i]);
            }
            b.set(e.index);
            ++i;
        }
        return b;
    }

    private Element newElement(String name) {
        Element e = this.elementHash.get(name.toLowerCase());
        if (e == null) {
            e = new Element();
            e.name = name;
            e.index = this.elements.size();
            this.elements.add(e);
            this.elementHash.put(e.name.toLowerCase(), e);
            this.assignField(e);
        }
        return e;
    }

    private Entity newEntity(String name, int type) {
        Entity e = new Entity(name, type, null);
        this.entityHash.put(e.name, e);
        return e;
    }

    private void unexpected(Exception ex) {
        throw new Error("This should never happen, report a bug", ex);
    }
}

