/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.io.Serializable;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultColorSelectionModel
implements ColorSelectionModel,
Serializable {
    private static final long serialVersionUID = -8117143602864778804L;
    private Color selectedColor;
    protected transient ChangeEvent changeEvent = new ChangeEvent(this);
    protected EventListenerList listenerList = new EventListenerList();

    public DefaultColorSelectionModel() {
        this(Color.white);
    }

    public DefaultColorSelectionModel(Color color) {
        if (color == null) {
            throw new Error("ColorSelectionModel cannot be set to have null color.");
        }
        this.selectedColor = color;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        if (color == null) {
            throw new Error("ColorSelectionModel cannot be set to have null color.");
        }
        if (color != this.selectedColor) {
            this.selectedColor = color;
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }
}

