/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8191026883931977036L;
    private transient SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private boolean borderPainted = true;
    private Insets margin;

    public JMenuBar() {
        this.updateUI();
    }

    public JMenu add(JMenu c) {
        c.setAlignmentX(0.0f);
        super.add(c);
        return c;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getManager().registerJMenuBar(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int i) {
        return this.getComponent(i);
    }

    public int getComponentIndex(Component c) {
        Component[] comps = this.getComponents();
        int index = -1;
        int i = 0;
        while (i < comps.length) {
            if (comps[i].equals(c)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() is not implemented");
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public JMenu getMenu(int index) {
        if (this.getComponentAtIndex(index) instanceof JMenu) {
            return (JMenu)this.getComponentAtIndex(index);
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        MenuElement[] subElements = new MenuElement[this.getComponentCount()];
        int j = 0;
        boolean doResize = false;
        int i = 0;
        while (i < this.getComponentCount()) {
            JMenu menu = this.getMenu(i);
            if (menu != null) {
                subElements[j++] = menu;
            } else {
                doResize = true;
            }
            ++i;
        }
        if (!doResize) {
            return subElements;
        }
        MenuElement[] subElements2 = new MenuElement[j];
        int i2 = 0;
        while (i2 < j) {
            subElements2[i2] = subElements[i2];
            ++i2;
        }
        return subElements2;
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public String getUIClassID() {
        return "MenuBarUI";
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public void menuSelectionChanged(boolean isIncluded) {
    }

    protected void paintBorder(Graphics g) {
        Border border;
        if (this.borderPainted && (border = this.getBorder()) != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getSize(null).width, this.getSize(null).height);
        }
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.paramString());
        sb.append(",margin=");
        if (this.getMargin() != null) {
            sb.append(this.getMargin());
        }
        sb.append(",paintBorder=").append(this.isBorderPainted());
        return sb.toString();
    }

    public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MenuElement[] children = this.getSubElements();
        int i = 0;
        while (i < children.length) {
            if (JMenuBar.processKeyBindingHelper(children[i], ks, e, condition, pressed)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean processKeyBindingHelper(MenuElement menuElement, KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement instanceof JComponent && ((JComponent)((Object)menuElement)).processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MenuElement[] children = menuElement.getSubElements();
        int i = 0;
        while (i < children.length) {
            if (JMenuBar.processKeyBindingHelper(children[i], ks, e, condition, pressed)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void removeNotify() {
        KeyboardManager.getManager().unregisterJMenuBar(this);
        super.removeNotify();
    }

    public void setBorderPainted(boolean b) {
        if (b != this.borderPainted) {
            boolean old = this.borderPainted;
            this.borderPainted = b;
            this.firePropertyChange("borderPainted", old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public void setHelpMenu(JMenu menu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public void setMargin(Insets m) {
        if (m != this.margin) {
            Insets oldMargin = this.margin;
            this.margin = m;
            this.firePropertyChange("margin", oldMargin, this.margin);
        }
    }

    public void setSelected(Component sel) {
        int index = this.getComponentIndex(sel);
        this.selectionModel.setSelectedIndex(index);
    }

    public void setSelectionModel(SingleSelectionModel model) {
        if (this.selectionModel != model) {
            SingleSelectionModel oldModel = this.selectionModel;
            this.selectionModel = model;
            this.firePropertyChange("model", oldModel, this.selectionModel);
        }
    }

    public void setUI(MenuBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
            super(JMenuBar.this);
        }

        public int getAccessibleSelectionCount() {
            int count = 0;
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != -1) {
                count = 1;
            }
            return count;
        }

        public Accessible getAccessibleSelection(int i) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != i) {
                return null;
            }
            return JMenuBar.this.getMenu(i);
        }

        public boolean isAccessibleChildSelected(int i) {
            return JMenuBar.this.getSelectionModel().getSelectedIndex() == i;
        }

        public void addAccessibleSelection(int i) {
            JMenuBar.this.getSelectionModel().setSelectedIndex(i);
        }

        public void removeAccessibleSelection(int i) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() == i) {
                JMenuBar.this.getSelectionModel().clearSelection();
            }
        }

        public void clearAccessibleSelection() {
            JMenuBar.this.getSelectionModel().clearSelection();
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet stateSet = super.getAccessibleStateSet();
            return stateSet;
        }
    }
}

