/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class Query {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int GT = 0;
    public static final int LT = 1;
    public static final int GE = 2;
    public static final int LE = 3;
    public static final int EQ = 4;

    public static QueryExp and(QueryExp q1, QueryExp q2) {
        return new AndQueryExp(q1, q2);
    }

    public static QueryExp anySubString(AttributeValueExp attrib, StringValueExp string) {
        return new MatchQueryExp(attrib, "*" + string.getValue() + "*");
    }

    public static AttributeValueExp attr(String name) {
        return new AttributeValueExp(name);
    }

    public static AttributeValueExp attr(String className, String name) {
        return new QualifiedAttributeValueExp(className, name);
    }

    public static QueryExp between(ValueExp v1, ValueExp v2, ValueExp v3) {
        return new BetweenQueryExp(v1, v2, v3);
    }

    public static AttributeValueExp classattr() {
        return new ClassAttributeValueExp();
    }

    public static ValueExp div(ValueExp v1, ValueExp v2) {
        return new BinaryOpValueExp(3, v1, v2);
    }

    public static QueryExp eq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(4, v1, v2);
    }

    public static QueryExp finalSubString(AttributeValueExp attrib, StringValueExp string) {
        return new MatchQueryExp(attrib, "*" + string.getValue());
    }

    public static QueryExp geq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(2, v1, v2);
    }

    public static QueryExp gt(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(0, v1, v2);
    }

    public static QueryExp in(ValueExp v, ValueExp[] vlist) {
        return new InQueryExp(v, vlist);
    }

    public static QueryExp initialSubString(AttributeValueExp attrib, StringValueExp string) {
        return new MatchQueryExp(attrib, String.valueOf(string.getValue()) + "*");
    }

    public static QueryExp isInstanceOf(StringValueExp className) {
        return new InstanceOfQueryExp(className);
    }

    public static QueryExp leq(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(3, v1, v2);
    }

    public static QueryExp lt(ValueExp v1, ValueExp v2) {
        return new BinaryRelQueryExp(1, v1, v2);
    }

    public static QueryExp match(AttributeValueExp attrib, StringValueExp string) {
        return new MatchQueryExp(attrib, string.getValue());
    }

    public static ValueExp minus(ValueExp v1, ValueExp v2) {
        return new BinaryOpValueExp(1, v1, v2);
    }

    public static QueryExp not(QueryExp q) {
        return new NotQueryExp(q);
    }

    public static QueryExp or(QueryExp q1, QueryExp q2) {
        return new OrQueryExp(q1, q2);
    }

    public static ValueExp plus(ValueExp v1, ValueExp v2) {
        return new BinaryOpValueExp(0, v1, v2);
    }

    public static ValueExp times(ValueExp v1, ValueExp v2) {
        return new BinaryOpValueExp(2, v1, v2);
    }

    public static ValueExp value(boolean val) {
        return new BooleanValueExp(val);
    }

    public static ValueExp value(double val) {
        return new NumericValueExp(val);
    }

    public static ValueExp value(float val) {
        return new NumericValueExp(Float.valueOf(val));
    }

    public static ValueExp value(int val) {
        return new NumericValueExp(val);
    }

    public static ValueExp value(long val) {
        return new NumericValueExp(val);
    }

    public static ValueExp value(Number val) {
        return new NumericValueExp(val);
    }

    public static StringValueExp value(String val) {
        return new StringValueExp(val);
    }

    private static final class AndQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -1081892073854801359L;
        private QueryExp exp1;
        private QueryExp exp2;

        public AndQueryExp(QueryExp exp1, QueryExp exp2) {
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this.exp1.apply(name) && this.exp2.apply(name);
        }
    }

    private static final class BetweenQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -2933597532866307444L;
        private ValueExp exp1;
        private ValueExp exp2;
        private ValueExp exp3;

        public BetweenQueryExp(ValueExp exp1, ValueExp exp2, ValueExp exp3) {
            this.exp1 = exp1;
            this.exp2 = exp2;
            this.exp3 = exp3;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String v1 = this.exp1.apply(name).toString();
            String v2 = this.exp2.apply(name).toString();
            String v3 = this.exp3.apply(name).toString();
            return v1.compareTo(v2) >= 0 && v1.compareTo(v3) <= 0;
        }
    }

    private static final class BinaryOpValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = 1216286847881456786L;
        private int op;
        private ValueExp exp1;
        private ValueExp exp2;

        public BinaryOpValueExp(int op, ValueExp exp1, ValueExp exp2) {
            this.op = op;
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            NumericValueExp v1 = (NumericValueExp)this.exp1.apply(name);
            NumericValueExp v2 = (NumericValueExp)this.exp2.apply(name);
            switch (this.op) {
                case 0: {
                    return v1.plus(v2);
                }
                case 1: {
                    return v1.minus(v2);
                }
                case 2: {
                    return v1.times(v2);
                }
                case 3: {
                    return v1.div(v2);
                }
            }
            throw new BadBinaryOpValueExpException(this);
        }

        public String toString() {
            String opS;
            switch (this.op) {
                case 0: {
                    opS = "+";
                    break;
                }
                case 1: {
                    opS = "-";
                    break;
                }
                case 2: {
                    opS = "x";
                    break;
                }
                case 3: {
                    opS = "/";
                    break;
                }
                default: {
                    opS = "?";
                }
            }
            return this.exp1 + " " + opS + " " + this.exp2;
        }
    }

    private static final class BinaryRelQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -5690656271650491000L;
        private int relOp;
        private ValueExp exp1;
        private ValueExp exp2;

        public BinaryRelQueryExp(int relOp, ValueExp exp1, ValueExp exp2) {
            this.relOp = relOp;
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String v1 = this.exp1.apply(name).toString();
            String v2 = this.exp2.apply(name).toString();
            switch (this.relOp) {
                case 4: {
                    return v1.equals(v2);
                }
                case 0: {
                    return v1.compareTo(v2) > 0;
                }
                case 2: {
                    return v1.compareTo(v2) >= 0;
                }
                case 3: {
                    return v1.compareTo(v2) <= 0;
                }
                case 1: {
                    return v1.compareTo(v2) < 0;
                }
            }
            throw new BadStringOperationException("Invalid operator: " + this.relOp);
        }

        public String toString() {
            String op;
            switch (this.relOp) {
                case 4: {
                    op = "=";
                    break;
                }
                case 0: {
                    op = ">";
                    break;
                }
                case 2: {
                    op = ">=";
                    break;
                }
                case 3: {
                    op = "<=";
                    break;
                }
                case 1: {
                    op = "<";
                    break;
                }
                default: {
                    op = "?";
                }
            }
            return this.exp1 + " " + op + " " + this.exp2;
        }
    }

    private static final class BooleanValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = 7754922052666594581L;
        private boolean val;

        public BooleanValueExp(boolean val) {
            this.val = val;
        }

        public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this;
        }

        public String toString() {
            return Boolean.toString(this.val);
        }
    }

    private static final class ClassAttributeValueExp
    extends AttributeValueExp {
        private static final long serialVersionUID = -1081892073854801359L;

        private ClassAttributeValueExp() {
        }

        public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                return new StringValueExp(QueryEval.getMBeanServer().getObjectInstance(name).getClassName());
            }
            catch (InstanceNotFoundException e) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(e);
            }
        }
    }

    private static final class InQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -5801329450358952434L;
        private ValueExp val;
        private ValueExp[] valueList;

        public InQueryExp(ValueExp val, ValueExp[] valueList) {
            this.val = val;
            this.valueList = valueList;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String v = this.val.apply(name).toString();
            ValueExp[] valueExpArray = this.valueList;
            int n = this.valueList.length;
            int n2 = 0;
            while (n2 < n) {
                ValueExp vl = valueExpArray[n2];
                if (v.equals(vl.apply(name).toString())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static final class InstanceOfQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -1081892073854801359L;
        private StringValueExp classNameValue;

        public InstanceOfQueryExp(StringValueExp classNameValue) {
            this.classNameValue = classNameValue;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                String className = ((StringValueExp)this.classNameValue.apply(name)).getValue();
                return QueryEval.getMBeanServer().isInstanceOf(name, className);
            }
            catch (InstanceNotFoundException e) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(e);
            }
        }
    }

    private static final class MatchQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = -7156603696948215014L;
        private AttributeValueExp exp;
        private String pattern;

        public MatchQueryExp(AttributeValueExp exp, String pattern2) {
            this.exp = exp;
            this.pattern = pattern2;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            String val = ((StringValueExp)this.exp.apply(name)).getValue();
            int valPos = 0;
            int fallback = -1;
            int fallbackP = -1;
            boolean backslash = false;
            int a = 0;
            while (a < this.pattern.length()) {
                boolean matched = false;
                int next = this.pattern.codePointAt(a);
                if (!backslash) {
                    if (next == 63 && valPos < val.length()) {
                        ++valPos;
                        matched = true;
                    } else if (next == 42) {
                        fallback = valPos;
                        fallbackP = a;
                        matched = true;
                    } else if (next == 91 && valPos < val.length()) {
                        boolean negated = false;
                        int b = a + 1;
                        int classChar = this.pattern.codePointAt(b);
                        do {
                            if (classChar == 33 && b == a + 1) {
                                negated = true;
                                continue;
                            }
                            if (this.pattern.codePointAt(b + 1) == 45 && this.pattern.codePointAt(b + 2) != 93) {
                                if (classChar > this.pattern.codePointAt(b + 2)) {
                                    throw new BadStringOperationException("Invalid range: " + classChar + " to " + this.pattern.codePointAt(b + 2));
                                }
                                int c = classChar;
                                while (c <= this.pattern.codePointAt(b + 2)) {
                                    if (val.codePointAt(valPos) == c) {
                                        matched = true;
                                    }
                                    ++c;
                                }
                                b += 2;
                                continue;
                            }
                            if (val.codePointAt(valPos) != classChar) continue;
                            matched = true;
                        } while ((classChar = this.pattern.codePointAt(++b)) != 93);
                        if (negated) {
                            matched = !matched;
                        }
                        ++valPos;
                        a = b;
                    } else if (next == 92) {
                        backslash = true;
                    } else if (valPos < val.length() && next == val.codePointAt(valPos)) {
                        matched = true;
                        ++valPos;
                    }
                } else {
                    backslash = false;
                    if (valPos < val.length() && next == val.codePointAt(valPos)) {
                        matched = true;
                        ++valPos;
                    }
                }
                if (!matched) {
                    if (fallback != -1) {
                        valPos = ++fallback;
                        a = fallbackP;
                        if (valPos == val.length()) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                ++a;
            }
            return true;
        }
    }

    private static final class NotQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 5269643775896723397L;
        private QueryExp exp;

        public NotQueryExp(QueryExp exp) {
            this.exp = exp;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return !this.exp.apply(name);
        }
    }

    private static final class NumericValueExp
    extends QueryEval
    implements ValueExp {
        private static final long serialVersionUID = -4679739485102359104L;
        private Number val;

        public NumericValueExp(Number val) {
            this.val = val;
        }

        public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this;
        }

        public Number getValue() {
            return this.val;
        }

        public String toString() {
            return this.val.toString();
        }

        public NumericValueExp plus(NumericValueExp o) {
            Number v = o.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (v instanceof Double) {
                    return new NumericValueExp(d + v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(d + (double)v.floatValue());
                }
                if (v instanceof Long) {
                    return new NumericValueExp(d + (double)v.longValue());
                }
                return new NumericValueExp(d + (double)v.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)f + v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f + v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f + (float)v.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f + (float)v.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)l + v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l + v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(l + v.longValue());
                }
                return new NumericValueExp(l + (long)v.intValue());
            }
            int i = this.val.intValue();
            if (v instanceof Double) {
                return new NumericValueExp((double)i + v.doubleValue());
            }
            if (v instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)i + v.floatValue()));
            }
            if (v instanceof Long) {
                return new NumericValueExp((long)i + v.longValue());
            }
            return new NumericValueExp(i + v.intValue());
        }

        public NumericValueExp minus(NumericValueExp o) {
            Number v = o.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (v instanceof Double) {
                    return new NumericValueExp(d - v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(d - (double)v.floatValue());
                }
                if (v instanceof Long) {
                    return new NumericValueExp(d - (double)v.longValue());
                }
                return new NumericValueExp(d - (double)v.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)f - v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f - v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f - (float)v.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f - (float)v.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)l - v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l - v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(l - v.longValue());
                }
                return new NumericValueExp(l - (long)v.intValue());
            }
            int i = this.val.intValue();
            if (v instanceof Double) {
                return new NumericValueExp((double)i - v.doubleValue());
            }
            if (v instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)i - v.floatValue()));
            }
            if (v instanceof Long) {
                return new NumericValueExp((long)i - v.longValue());
            }
            return new NumericValueExp(i - v.intValue());
        }

        public NumericValueExp times(NumericValueExp o) {
            Number v = o.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (v instanceof Double) {
                    return new NumericValueExp(d * v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(d * (double)v.floatValue());
                }
                if (v instanceof Long) {
                    return new NumericValueExp(d * (double)v.longValue());
                }
                return new NumericValueExp(d * (double)v.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)f * v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f * v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f * (float)v.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f * (float)v.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)l * v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l * v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(l * v.longValue());
                }
                return new NumericValueExp(l * (long)v.intValue());
            }
            int i = this.val.intValue();
            if (v instanceof Double) {
                return new NumericValueExp((double)i * v.doubleValue());
            }
            if (v instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)i * v.floatValue()));
            }
            if (v instanceof Long) {
                return new NumericValueExp((long)i * v.longValue());
            }
            return new NumericValueExp(i * v.intValue());
        }

        public NumericValueExp div(NumericValueExp o) {
            Number v = o.getValue();
            if (this.val instanceof Double) {
                double d = this.val.doubleValue();
                if (v instanceof Double) {
                    return new NumericValueExp(d / v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(d / (double)v.floatValue());
                }
                if (v instanceof Long) {
                    return new NumericValueExp(d / (double)v.longValue());
                }
                return new NumericValueExp(d / (double)v.intValue());
            }
            if (this.val instanceof Float) {
                float f = this.val.floatValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)f / v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf(f / v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(Float.valueOf(f / (float)v.longValue()));
                }
                return new NumericValueExp(Float.valueOf(f / (float)v.intValue()));
            }
            if (this.val instanceof Long) {
                long l = this.val.longValue();
                if (v instanceof Double) {
                    return new NumericValueExp((double)l / v.doubleValue());
                }
                if (v instanceof Float) {
                    return new NumericValueExp(Float.valueOf((float)l / v.floatValue()));
                }
                if (v instanceof Long) {
                    return new NumericValueExp(l / v.longValue());
                }
                return new NumericValueExp(l / (long)v.intValue());
            }
            int i = this.val.intValue();
            if (v instanceof Double) {
                return new NumericValueExp((double)i / v.doubleValue());
            }
            if (v instanceof Float) {
                return new NumericValueExp(Float.valueOf((float)i / v.floatValue()));
            }
            if (v instanceof Long) {
                return new NumericValueExp((long)i / v.longValue());
            }
            return new NumericValueExp(i / v.intValue());
        }
    }

    private static final class OrQueryExp
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 2962973084421716523L;
        private QueryExp exp1;
        private QueryExp exp2;

        public OrQueryExp(QueryExp exp1, QueryExp exp2) {
            this.exp1 = exp1;
            this.exp2 = exp2;
        }

        public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            return this.exp1.apply(name) || this.exp2.apply(name);
        }
    }

    private static final class QualifiedAttributeValueExp
    extends AttributeValueExp {
        private static final long serialVersionUID = 8832517277410933254L;
        private String className;

        public QualifiedAttributeValueExp(String className, String name) {
            super(name);
            this.className = className;
        }

        public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
            try {
                if (!QueryEval.getMBeanServer().getObjectInstance(name).getClassName().equals(this.className)) {
                    throw new BadAttributeValueExpException((Object)"The value is not from the correct class.");
                }
            }
            catch (InstanceNotFoundException e) {
                throw (BadAttributeValueExpException)new BadAttributeValueExpException((Object)"The named bean is not registered.").initCause(e);
            }
            return super.apply(name);
        }
    }
}

