/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements Serializable,
LayoutManager2 {
    private static final long serialVersionUID = 8838754796412211005L;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected Hashtable<Component, GridBagConstraints> comptable = new Hashtable();
    private Hashtable<Component, GridBagConstraints> internalcomptable = new Hashtable();
    protected GridBagLayoutInfo layoutInfo;
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public double[] columnWeights;
    public int[] columnWidths;
    public double[] rowWeights;
    public int[] rowHeights;

    private int sumIntArray(int[] array, int upto) {
        int result = 0;
        int i = 0;
        while (i < upto) {
            result += array[i];
            ++i;
        }
        return result;
    }

    private int sumIntArray(int[] array) {
        return this.sumIntArray(array, array.length);
    }

    private double sumDoubleArray(double[] array) {
        double result = 0.0;
        int i = 0;
        while (i < array.length) {
            result += array[i];
            ++i;
        }
        return result;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            return;
        }
        if (!(constraints instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("constraints " + constraints + " are not an instance of GridBagConstraints");
        }
        this.setConstraints(component, (GridBagConstraints)constraints);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (parent == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo li = this.getLayoutInfo(parent, 2);
        return this.getMinSize(parent, li);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (parent == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo li = this.getLayoutInfo(parent, 1);
        return this.getMinSize(parent, li);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.arrangeGrid(parent);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.layoutInfo = null;
    }

    public void setConstraints(Component component, GridBagConstraints constraints) {
        GridBagConstraints clone = (GridBagConstraints)constraints.clone();
        if (clone.gridx < 0) {
            clone.gridx = -1;
        }
        if (clone.gridy < 0) {
            clone.gridy = -1;
        }
        if (clone.gridwidth == 0) {
            clone.gridwidth = 0;
        } else if (clone.gridwidth < 0) {
            clone.gridwidth = 1;
        }
        if (clone.gridheight == 0) {
            clone.gridheight = 0;
        } else if (clone.gridheight < 0) {
            clone.gridheight = 1;
        }
        this.comptable.put(component, clone);
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints result = this.comptable.get(component);
        if (result == null) {
            this.setConstraints(component, this.defaultConstraints);
            result = this.comptable.get(component);
        }
        return result;
    }

    private GridBagConstraints lookupInternalConstraints(Component component) {
        GridBagConstraints result = this.internalcomptable.get(component);
        if (result == null) {
            result = (GridBagConstraints)this.lookupConstraints(component).clone();
            this.internalcomptable.put(component, result);
        }
        return result;
    }

    public Point getLayoutOrigin() {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        return new Point(this.layoutInfo.pos_x, this.layoutInfo.pos_y);
    }

    public int[][] getLayoutDimensions() {
        int[][] result = new int[2][];
        if (this.layoutInfo == null) {
            result[0] = new int[0];
            result[1] = new int[0];
            return result;
        }
        result[0] = new int[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWidths, 0, result[0], 0, this.layoutInfo.cols);
        result[1] = new int[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowHeights, 0, result[1], 0, this.layoutInfo.rows);
        return result;
    }

    public double[][] getLayoutWeights() {
        double[][] result = new double[2][];
        if (this.layoutInfo == null) {
            result[0] = new double[0];
            result[1] = new double[0];
            return result;
        }
        result[0] = new double[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWeights, 0, result[0], 0, this.layoutInfo.cols);
        result[1] = new double[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowWeights, 0, result[1], 0, this.layoutInfo.rows);
        return result;
    }

    public Point location(int x, int y) {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        int pixel_x = this.layoutInfo.pos_x;
        int pixel_y = this.layoutInfo.pos_y;
        int col = 0;
        while (col < this.layoutInfo.cols) {
            int w = this.layoutInfo.colWidths[col];
            if (x < pixel_x + w) break;
            pixel_x += w;
            ++col;
        }
        int row = 0;
        while (row < this.layoutInfo.rows) {
            int h = this.layoutInfo.rowHeights[row];
            if (y < pixel_y + h) break;
            pixel_y += h;
            ++row;
        }
        return new Point(col, row);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void AdjustForGravity(GridBagConstraints constraints, Rectangle r) {
        Insets insets = constraints.insets;
        if (insets != null) {
            r.x += insets.left;
            r.y += insets.top;
            r.width -= insets.left + insets.right;
            r.height -= insets.top + insets.bottom;
        }
    }

    protected void ArrangeGrid(Container parent) {
        Component[] components = parent.getComponents();
        if (components.length == 0) {
            return;
        }
        GridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        if (info.cols == 0 && info.rows == 0) {
            return;
        }
        Component lastComp = null;
        Rectangle cell = new Rectangle();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            if (component.isVisible()) {
                Dimension dim = component.getPreferredSize();
                GridBagConstraints constraints = this.lookupInternalConstraints(component);
                cell.y = lastComp != null && constraints.gridheight == 0 ? (cell.y += cell.height) : this.sumIntArray(info.rowHeights, constraints.gridy);
                cell.x = lastComp != null && constraints.gridwidth == 0 ? (cell.x += cell.width) : this.sumIntArray(info.colWidths, constraints.gridx);
                cell.width = this.sumIntArray(info.colWidths, constraints.gridx + constraints.gridwidth) - cell.x;
                cell.height = this.sumIntArray(info.rowHeights, constraints.gridy + constraints.gridheight) - cell.y;
                this.AdjustForGravity(constraints, cell);
                dim.width += constraints.ipadx;
                dim.height += constraints.ipady;
                switch (constraints.fill) {
                    case 2: {
                        dim.width = cell.width;
                        break;
                    }
                    case 3: {
                        dim.height = cell.height;
                        break;
                    }
                    case 1: {
                        dim.width = cell.width;
                        dim.height = cell.height;
                    }
                }
                int x = 0;
                int y = 0;
                switch (constraints.anchor) {
                    case 11: {
                        x = cell.x + (cell.width - dim.width) / 2;
                        y = cell.y;
                        break;
                    }
                    case 15: {
                        x = cell.x + (cell.width - dim.width) / 2;
                        y = cell.y + cell.height - dim.height;
                        break;
                    }
                    case 17: {
                        x = cell.x;
                        y = cell.y + (cell.height - dim.height) / 2;
                        break;
                    }
                    case 13: {
                        x = cell.x + cell.width - dim.width;
                        y = cell.y + (cell.height - dim.height) / 2;
                        break;
                    }
                    case 12: {
                        x = cell.x + cell.width - dim.width;
                        y = cell.y;
                        break;
                    }
                    case 18: {
                        x = cell.x;
                        y = cell.y;
                        break;
                    }
                    case 14: {
                        x = cell.x + cell.width - dim.width;
                        y = cell.y + cell.height - dim.height;
                        break;
                    }
                    case 16: {
                        x = cell.x;
                        y = cell.y + cell.height - dim.height;
                        break;
                    }
                    default: {
                        x = cell.x + (cell.width - dim.width) / 2;
                        y = cell.y + (cell.height - dim.height) / 2;
                    }
                }
                component.setBounds(info.pos_x + x, info.pos_y + y, dim.width, dim.height);
                lastComp = component;
            }
            ++i;
        }
        this.layoutInfo = this.getLayoutInfo(parent, 2);
    }

    protected GridBagLayoutInfo GetLayoutInfo(Container parent, int sizeflag) {
        Component component;
        int y;
        GridBagConstraints lastConstraints;
        int x;
        GridBagConstraints constraints;
        if (sizeflag != 1 && sizeflag != 2) {
            throw new IllegalArgumentException();
        }
        Dimension parentDim = parent.getSize();
        Insets parentInsets = parent.getInsets();
        parentDim.width -= parentInsets.left + parentInsets.right;
        parentDim.height -= parentInsets.top + parentInsets.bottom;
        int current_y = 0;
        int max_x = 0;
        int max_y = 0;
        HashMap<Integer, Component> lastInRow = new HashMap<Integer, Component>();
        HashMap<Integer, Component> lastInCol = new HashMap<Integer, Component>();
        Component[] components = parent.getComponents();
        ArrayList<Component> sortedByWidth = new ArrayList<Component>(components.length);
        ArrayList<Component> sortedByHeight = new ArrayList<Component>(components.length);
        int i = 0;
        while (i < components.length) {
            Component component2 = components[i];
            if (component2.isVisible()) {
                GridBagConstraints lastConstraints2;
                Component lastComponent;
                GridBagConstraints originalConstraints = this.lookupConstraints(component2);
                constraints = (GridBagConstraints)originalConstraints.clone();
                this.internalcomptable.put(component2, constraints);
                if (constraints.gridx == -1) {
                    if (constraints.gridy == -1) {
                        constraints.gridy = current_y;
                    }
                    if (!lastInRow.containsKey(new Integer(constraints.gridy))) {
                        x = 0;
                    } else {
                        Component lastComponent2 = (Component)lastInRow.get(new Integer(constraints.gridy));
                        lastConstraints = this.lookupInternalConstraints(lastComponent2);
                        x = lastConstraints.gridx + Math.max(1, lastConstraints.gridwidth);
                    }
                    int y2 = constraints.gridy + 1;
                    while (y2 < constraints.gridy + Math.max(1, constraints.gridheight)) {
                        if (lastInRow.containsKey(new Integer(y2))) {
                            lastComponent = (Component)lastInRow.get(new Integer(y2));
                            lastConstraints2 = this.lookupInternalConstraints(lastComponent);
                            x = Math.max(x, lastConstraints2.gridx + Math.max(1, lastConstraints2.gridwidth));
                        }
                        ++y2;
                    }
                    constraints.gridx = x;
                } else if (constraints.gridy == -1) {
                    if (!lastInCol.containsKey(new Integer(constraints.gridx))) {
                        y = current_y;
                    } else {
                        Component lastComponent3 = (Component)lastInCol.get(new Integer(constraints.gridx));
                        lastConstraints = this.lookupInternalConstraints(lastComponent3);
                        y = lastConstraints.gridy + Math.max(1, lastConstraints.gridheight);
                    }
                    int x2 = constraints.gridx + 1;
                    while (x2 < constraints.gridx + Math.max(1, constraints.gridwidth)) {
                        if (lastInCol.containsKey(new Integer(x2))) {
                            lastComponent = (Component)lastInCol.get(new Integer(x2));
                            lastConstraints2 = this.lookupInternalConstraints(lastComponent);
                            y = Math.max(y, lastConstraints2.gridy + Math.max(1, lastConstraints2.gridheight));
                        }
                        ++x2;
                    }
                    constraints.gridy = y;
                }
                max_x = Math.max(max_x, constraints.gridx + Math.max(1, constraints.gridwidth));
                max_y = Math.max(max_y, constraints.gridy + Math.max(1, constraints.gridheight));
                this.sortBySpan(component2, constraints.gridwidth, sortedByWidth, true);
                this.sortBySpan(component2, constraints.gridheight, sortedByHeight, false);
                if (constraints.gridwidth == 0) {
                    current_y = constraints.gridy + Math.max(1, constraints.gridheight);
                } else if (constraints.gridwidth != 0) {
                    y = constraints.gridy;
                    while (y < constraints.gridy + Math.max(1, constraints.gridheight)) {
                        if (lastInRow.containsKey(new Integer(y))) {
                            Component lastComponent4 = (Component)lastInRow.get(new Integer(y));
                            lastConstraints = this.lookupInternalConstraints(lastComponent4);
                            if (constraints.gridx > lastConstraints.gridx) {
                                lastInRow.put(new Integer(y), component2);
                            }
                        } else {
                            lastInRow.put(new Integer(y), component2);
                        }
                        ++y;
                    }
                    x = constraints.gridx;
                    while (x < constraints.gridx + Math.max(1, constraints.gridwidth)) {
                        if (lastInCol.containsKey(new Integer(x))) {
                            Component lastComponent5 = (Component)lastInCol.get(new Integer(x));
                            lastConstraints = this.lookupInternalConstraints(lastComponent5);
                            if (constraints.gridy > lastConstraints.gridy) {
                                lastInCol.put(new Integer(x), component2);
                            }
                        } else {
                            lastInCol.put(new Integer(x), component2);
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
        GridBagLayoutInfo info = new GridBagLayoutInfo(max_x, max_y);
        int x3 = 0;
        while (x3 < max_x) {
            if (this.columnWidths != null && this.columnWidths.length > x3) {
                info.colWidths[x3] = this.columnWidths[x3];
            }
            if (this.columnWeights != null && this.columnWeights.length > x3) {
                info.colWeights[x3] = this.columnWeights[x3];
            }
            ++x3;
        }
        int y3 = 0;
        while (y3 < max_y) {
            if (this.rowHeights != null && this.rowHeights.length > y3) {
                info.rowHeights[y3] = this.rowHeights[y3];
            }
            if (this.rowWeights != null && this.rowWeights.length > y3) {
                info.rowWeights[y3] = this.rowWeights[y3];
            }
            ++y3;
        }
        int i2 = 0;
        while (i2 < components.length) {
            component = components[i2];
            if (component.isVisible()) {
                constraints = this.lookupInternalConstraints(component);
                if (constraints.gridwidth == 0 || constraints.gridwidth == -1) {
                    if (constraints.gridwidth == 0) {
                        y = constraints.gridy;
                        while (y < constraints.gridy + Math.max(1, constraints.gridheight)) {
                            if (lastInRow.containsKey(new Integer(y))) {
                                Component lastComponent = (Component)lastInRow.get(new Integer(y));
                                lastConstraints = this.lookupInternalConstraints(lastComponent);
                                if (lastConstraints.gridwidth == -1) {
                                    constraints.gridx = max_x - 1;
                                    break;
                                }
                                constraints.gridx = Math.max(constraints.gridx, lastConstraints.gridx + Math.max(1, lastConstraints.gridwidth));
                            }
                            ++y;
                        }
                        constraints.gridwidth = max_x - constraints.gridx;
                    } else if (constraints.gridwidth == -1) {
                        constraints.gridwidth = max_x - constraints.gridx - 1;
                    }
                    sortedByWidth.remove(sortedByWidth.indexOf(component));
                    this.sortBySpan(component, constraints.gridwidth, sortedByWidth, true);
                }
                if (constraints.gridheight == 0 || constraints.gridheight == -1) {
                    if (constraints.gridheight == 0) {
                        x = constraints.gridx;
                        while (x < constraints.gridx + Math.max(1, constraints.gridwidth)) {
                            Component lastComponent;
                            if (lastInCol.containsKey(new Integer(x)) && (lastComponent = (Component)lastInRow.get(new Integer(x))) != null) {
                                lastConstraints = this.lookupInternalConstraints(lastComponent);
                                if (lastConstraints.gridheight == -1) {
                                    constraints.gridy = max_y - 1;
                                    break;
                                }
                                constraints.gridy = Math.max(constraints.gridy, lastConstraints.gridy + Math.max(1, lastConstraints.gridheight));
                            }
                            ++x;
                        }
                        constraints.gridheight = max_y - constraints.gridy;
                    } else if (constraints.gridheight == -1) {
                        constraints.gridheight = max_y - constraints.gridy - 1;
                    }
                    sortedByHeight.remove(sortedByHeight.indexOf(component));
                    this.sortBySpan(component, constraints.gridheight, sortedByHeight, false);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < sortedByWidth.size()) {
            component = (Component)sortedByWidth.get(i2);
            if (component.isVisible()) {
                int width;
                constraints = this.lookupInternalConstraints(component);
                int n = width = sizeflag == 2 ? component.getPreferredSize().width : component.getMinimumSize().width;
                if (constraints.insets != null) {
                    width += constraints.insets.left + constraints.insets.right;
                }
                this.distributeSizeAndWeight(width += constraints.ipadx, constraints.weightx, constraints.gridx, constraints.gridwidth, info.colWidths, info.colWeights);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < sortedByHeight.size()) {
            component = (Component)sortedByHeight.get(i2);
            if (component.isVisible()) {
                int height;
                constraints = this.lookupInternalConstraints(component);
                int n = height = sizeflag == 2 ? component.getPreferredSize().height : component.getMinimumSize().height;
                if (constraints.insets != null) {
                    height += constraints.insets.top + constraints.insets.bottom;
                }
                this.distributeSizeAndWeight(height += constraints.ipady, constraints.weighty, constraints.gridy, constraints.gridheight, info.rowHeights, info.rowWeights);
            }
            ++i2;
        }
        if (parentDim.width > 0 && parentDim.height > 0) {
            this.calcCellSizes(info.colWidths, info.colWeights, parentDim.width);
            this.calcCellSizes(info.rowHeights, info.rowWeights, parentDim.height);
        }
        int totalWidth = this.sumIntArray(info.colWidths);
        int totalHeight = this.sumIntArray(info.rowHeights);
        info.pos_x = totalWidth >= parentDim.width ? parentInsets.left : parentInsets.left + (parentDim.width - totalWidth) / 2;
        info.pos_y = totalHeight >= parentDim.height ? parentInsets.top : parentInsets.top + (parentDim.height - totalHeight) / 2;
        return info;
    }

    protected Dimension GetMinSize(Container parent, GridBagLayoutInfo info) {
        if (parent == null || info == null) {
            return new Dimension(0, 0);
        }
        Insets insets = parent.getInsets();
        int width = this.sumIntArray(info.colWidths) + insets.left + insets.right;
        int height = this.sumIntArray(info.rowHeights) + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    protected Dimension getMinSize(Container parent, GridBagLayoutInfo info) {
        return this.GetMinSize(parent, info);
    }

    private void sortBySpan(Component component, int span, ArrayList<Component> list2, boolean sortByWidth) {
        if (span == 0 || span == -1) {
            list2.add(component);
        } else {
            int i = 0;
            if (list2.size() > 0) {
                GridBagConstraints gbc = this.lookupInternalConstraints(list2.get(i));
                int otherspan = sortByWidth ? gbc.gridwidth : gbc.gridheight;
                while (otherspan != 0 && otherspan != -1 && span >= otherspan) {
                    if (++i >= list2.size()) break;
                    gbc = this.lookupInternalConstraints(list2.get(i));
                    int n = otherspan = sortByWidth ? gbc.gridwidth : gbc.gridheight;
                }
            }
            list2.add(i, component);
        }
    }

    private void distributeSizeAndWeight(int size, double weight, int start, int span, int[] sizes, double[] weights) {
        if (span == 1) {
            sizes[start] = Math.max(sizes[start], size);
            weights[start] = Math.max(weights[start], weight);
        } else {
            int numOccupied = span;
            int lastOccupied = -1;
            int i = start;
            while (i < start + span) {
                if ((double)sizes[i] == 0.0) {
                    --numOccupied;
                } else {
                    size -= sizes[i];
                    lastOccupied = i;
                }
                ++i;
            }
            if (numOccupied == 0) {
                sizes[start + span - 1] = size;
            } else if (size > 0) {
                int n = lastOccupied;
                sizes[n] = sizes[n] + size;
            }
            this.calcCellWeights(weight, weights, start, span);
        }
    }

    private void calcCellWeights(double weight, double[] weights, int start, int span) {
        double totalWeight = 0.0;
        int k = start;
        while (k < start + span) {
            totalWeight += weights[k];
            ++k;
        }
        if (weight > totalWeight) {
            if (totalWeight == 0.0) {
                int n = start + span - 1;
                weights[n] = weights[n] + weight;
            } else {
                double diff;
                double remaining = diff = weight - totalWeight;
                int k2 = start;
                while (k2 < start + span) {
                    double extraWeight = diff * weights[k2] / totalWeight;
                    int n = k2++;
                    weights[n] = weights[n] + extraWeight;
                    remaining -= extraWeight;
                }
                if (remaining > 0.0 && weights[start + span - 1] != 0.0) {
                    int n = start + span - 1;
                    weights[n] = weights[n] + remaining;
                }
            }
        }
    }

    private void calcCellSizes(int[] sizes, double[] weights, int range) {
        int totalSize = this.sumIntArray(sizes);
        double totalWeight = this.sumDoubleArray(weights);
        int diff = range - totalSize;
        if (diff == 0) {
            return;
        }
        int i = 0;
        while (i < sizes.length) {
            int newsize = (int)((double)sizes[i] + (double)diff * weights[i] / totalWeight);
            if (newsize > 0) {
                sizes[i] = newsize;
            }
            ++i;
        }
    }

    private void dumpLayoutInfo(GridBagLayoutInfo info) {
        System.out.println("GridBagLayoutInfo:");
        System.out.println("cols: " + info.cols + ", rows: " + info.rows);
        System.out.print("colWidths: ");
        this.dumpArray(info.colWidths);
        System.out.print("rowHeights: ");
        this.dumpArray(info.rowHeights);
        System.out.print("colWeights: ");
        this.dumpArray(info.colWeights);
        System.out.print("rowWeights: ");
        this.dumpArray(info.rowWeights);
    }

    private void dumpArray(int[] array) {
        String sep = "";
        int i = 0;
        while (i < array.length) {
            System.out.print(sep);
            System.out.print(array[i]);
            sep = ", ";
            ++i;
        }
        System.out.println();
    }

    private void dumpArray(double[] array) {
        String sep = "";
        int i = 0;
        while (i < array.length) {
            System.out.print(sep);
            System.out.print(array[i]);
            sep = ", ";
            ++i;
        }
        System.out.println();
    }

    protected void arrangeGrid(Container parent) {
        this.ArrangeGrid(parent);
    }

    protected GridBagLayoutInfo getLayoutInfo(Container parent, int sizeflag) {
        return this.GetLayoutInfo(parent, sizeflag);
    }

    protected void adjustForGravity(GridBagConstraints constraints, Rectangle r) {
        this.AdjustForGravity(constraints, r);
    }
}

