/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;

public abstract class DomNsNode
extends DomNode {
    private String name;
    private String namespace;
    private String prefix;
    String localName;

    DomNsNode(short nodeType, DomDocument owner, String namespaceURI, String name) {
        super(nodeType, owner);
        this.setNodeName(name);
        this.setNamespaceURI(namespaceURI);
    }

    public final String getNodeName() {
        return this.name;
    }

    final void setNodeName(String name) {
        this.name = name.intern();
        int index = name.indexOf(58);
        if (index == -1) {
            this.prefix = null;
            this.localName = this.name;
        } else {
            this.prefix = name.substring(0, index).intern();
            this.localName = name.substring(index + 1).intern();
        }
    }

    public final String getNamespaceURI() {
        return this.namespace;
    }

    final void setNamespaceURI(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        this.namespace = namespaceURI == null ? null : namespaceURI.intern();
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        if (prefix == null) {
            this.name = this.localName;
            return;
        }
        if (this.namespace == null) {
            throw new DomDOMException(14, "can't set prefix, node has no namespace URI", this, 0);
        }
        DomDocument.checkName(prefix, "1.1".equals(this.owner.getXmlVersion()));
        if (prefix.indexOf(58) != -1) {
            throw new DomDOMException(14, "illegal prefix " + prefix, this, 0);
        }
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespace)) {
            throw new DomDOMException(14, "xml namespace is always http://www.w3.org/XML/1998/namespace", this, 0);
        }
        if ("xmlns".equals(prefix)) {
            if (this.namespace != null || this.getNodeType() != 2) {
                throw new DomDOMException(14, "xmlns attribute prefix is reserved", this, 0);
            }
        } else if (this.getNodeType() == 2 && ("xmlns".equals(this.name) || this.name.startsWith("xmlns:"))) {
            throw new DomDOMException(14, "namespace declarations can't change names", this, 0);
        }
        this.prefix = prefix.intern();
    }

    public final String getLocalName() {
        return this.localName;
    }
}

