/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;

public class SmallHtmlAttributeSet
implements AttributeSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    final Object[] keys;
    final Object[] values;
    final AttributeSet parent;

    public SmallHtmlAttributeSet(AttributeSet copyFrom) {
        int n = copyFrom.getAttributeCount();
        this.keys = new Object[n];
        this.values = new Object[n];
        this.parent = copyFrom.getResolveParent();
        Enumeration<?> en = copyFrom.getAttributeNames();
        int i = 0;
        while (i < n) {
            Object value;
            Object key = en.nextElement();
            this.keys[i] = key;
            this.values[i] = value = copyFrom.getAttribute(key);
            ++i;
        }
    }

    public boolean containsAttribute(Object name, Object value) {
        Object contains = this.getAttribute(name);
        if (value == null) {
            return value == contains;
        }
        return value.equals(contains);
    }

    public boolean containsAttributes(AttributeSet attributes) {
        if (attributes == this) {
            return true;
        }
        int i = 0;
        while (i < this.keys.length) {
            Object v = attributes.getAttribute(this.keys[i]);
            if (v != this.values[i]) {
                if (this.values[i] == null) {
                    return false;
                }
                if (!this.values[i].equals(v)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        return this;
    }

    public Object getAttribute(Object key) {
        if (key == null || key instanceof HTML.Attribute || key instanceof HTML.Tag) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] == key) {
                    return this.values[i];
                }
                ++i;
            }
        } else if (key instanceof String) {
            String ks = (String)key;
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] instanceof String && ks.equalsIgnoreCase((String)this.keys[i])) {
                    return this.values[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.keys.length) {
                if (key.equals(this.keys[i])) {
                    return this.values[i];
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.getAttribute(key);
        }
        return null;
    }

    public int getAttributeCount() {
        return this.keys.length;
    }

    public Enumeration getAttributeNames() {
        return new Enumeration(){
            int p = 0;

            public boolean hasMoreElements() {
                return this.p < SmallHtmlAttributeSet.this.keys.length;
            }

            public Object nextElement() {
                if (this.p < SmallHtmlAttributeSet.this.keys.length) {
                    return SmallHtmlAttributeSet.this.keys[this.p++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public AttributeSet getResolveParent() {
        return this.parent;
    }

    public boolean isDefined(Object attrName) {
        if (attrName instanceof String) {
            attrName = ((String)attrName).toLowerCase();
        }
        int i = 0;
        while (i < this.keys.length) {
            if (attrName.equals(this.keys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEqual(AttributeSet attr) {
        return this.keys.length == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    protected Object clone() {
        return this;
    }
}

