/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp.attribute;

import gnu.javax.print.ipp.IppUtilities;
import java.net.URI;
import java.net.URISyntaxException;
import javax.print.attribute.Attribute;

public final class UnknownAttribute
implements Attribute {
    private byte tag;
    private String name;
    private byte[] value;

    public UnknownAttribute(byte tag, String name, byte[] value) {
        this.tag = tag;
        this.name = name;
        this.value = value;
    }

    public Class getCategory() {
        return UnknownAttribute.class;
    }

    public String getName() {
        return this.name;
    }

    public byte getValueTag() {
        return this.tag;
    }

    public String getAttributeName() {
        return this.name;
    }

    public byte[] getAttributeValue() {
        return this.value;
    }

    public String getAttributeValueAsString() {
        return new String(this.value);
    }

    public int getAttributeValueAsInt() {
        return IppUtilities.convertToInt(this.value);
    }

    public URI getAttributeValueAsUri() {
        try {
            return new URI(new String(this.value));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        switch (this.tag) {
            case 33: {
                return "" + this.getAttributeValueAsInt();
            }
            case 51: {
                int lower = IppUtilities.convertToInt(this.value[0], this.value[1], this.value[2], this.value[3]);
                int upper = IppUtilities.convertToInt(this.value[4], this.value[5], this.value[6], this.value[7]);
                return String.valueOf(lower) + "-" + upper;
            }
            case 69: {
                return this.getAttributeValueAsUri().toString();
            }
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getAttributeValueAsString();
            }
        }
        return "No conversion found.";
    }
}

