/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.SSLRecordHandler;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHandshake;
import gnu.javax.net.ssl.provider.ClientHelloBuilder;
import gnu.javax.net.ssl.provider.ClientHelloV2;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.ServerHandshake;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Util;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class SSLEngineImpl
extends SSLEngine {
    final SSLContextImpl contextImpl;
    private SSLRecordHandler[] handlers;
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private SessionImpl session;
    private InputSecurityParameters insec;
    private OutputSecurityParameters outsec;
    private boolean inClosed;
    private boolean outClosed;
    private boolean createSessions;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean initialHandshakeDone;
    private AbstractHandshake handshake;
    private Alert lastAlert;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean changeCipherSpec;
    private String[] enabledSuites;
    private String[] enabledProtocols;
    private final ByteBuffer alertBuffer;
    private Mode mode;

    SSLEngineImpl(SSLContextImpl contextImpl, String host, int port) {
        super(host, port);
        this.contextImpl = contextImpl;
        this.handlers = new SSLRecordHandler[256];
        this.session = new SessionImpl();
        this.session.suite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
        this.session.version = ProtocolVersion.TLS_1_1;
        byte[] sid = new byte[32];
        contextImpl.random.nextBytes(sid);
        this.session.setId(new Session.ID(sid));
        this.session.setRandom(contextImpl.random);
        logger.logv(Component.SSL_RECORD_LAYER, "generated session ID {0} with random {1}", this.session.id(), contextImpl.random);
        this.insec = new InputSecurityParameters(null, null, null, this.session, CipherSuite.TLS_NULL_WITH_NULL_NULL);
        this.outsec = new OutputSecurityParameters(null, null, null, this.session, CipherSuite.TLS_NULL_WITH_NULL_NULL);
        this.inClosed = false;
        this.outClosed = false;
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.createSessions = true;
        this.initialHandshakeDone = false;
        this.alertBuffer = ByteBuffer.wrap(new byte[2]);
        this.mode = null;
        this.lastAlert = null;
        this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        this.changeCipherSpec = false;
        this.enabledProtocols = new String[]{ProtocolVersion.TLS_1_1.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.SSL_3.toString()};
        this.enabledSuites = SSLEngineImpl.defaultSuites();
    }

    static String[] defaultSuites() {
        return new String[]{CipherSuite.TLS_DHE_DSS_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_RC4_128_MD5.toString(), CipherSuite.TLS_RSA_WITH_RC4_128_SHA.toString(), CipherSuite.TLS_DHE_DSS_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_DES_CBC_SHA.toString(), CipherSuite.TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_EXPORT_WITH_RC4_40_MD5.toString(), CipherSuite.TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA.toString(), CipherSuite.TLS_RSA_WITH_NULL_MD5.toString(), CipherSuite.TLS_RSA_WITH_NULL_SHA.toString()};
    }

    public void beginHandshake() throws SSLException {
        logger.log((Level)Component.SSL_HANDSHAKE, "{0} handshake begins", (Object)this.mode);
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never used");
        }
        switch (this.mode) {
            case SERVER: {
                if (this.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    throw new SSLException("handshake already in progress");
                }
                try {
                    this.handshake = new ServerHandshake(this.initialHandshakeDone, this);
                    break;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new SSLException(nsae);
                }
            }
            case CLIENT: {
                try {
                    this.handshake = new ClientHandshake(this);
                    break;
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new SSLException(nsae);
                }
            }
        }
    }

    public void closeInbound() {
        this.inClosed = true;
    }

    public void closeOutbound() {
        this.lastAlert = new Alert(Alert.Level.WARNING, Alert.Description.CLOSE_NOTIFY);
    }

    public Runnable getDelegatedTask() {
        if (this.handshake == null) {
            return null;
        }
        return this.handshake.getTask();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledSuites.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.handshake == null) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        return this.handshake.status();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLSession getSession() {
        return this.session;
    }

    public boolean getUseClientMode() {
        return this.mode == Mode.CLIENT;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean isInboundDone() {
        return this.inClosed;
    }

    public boolean isOutboundDone() {
        return this.outClosed;
    }

    public void setEnableSessionCreation(boolean createSessions) {
        this.createSessions = createSessions;
    }

    public void setEnabledCipherSuites(String[] suites) {
        if (suites.length == 0) {
            throw new IllegalArgumentException("need at least one suite");
        }
        this.enabledSuites = (String[])suites.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        if (protocols.length == 0) {
            throw new IllegalArgumentException("need at least one protocol");
        }
        this.enabledProtocols = (String[])protocols.clone();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedProtocols() {
        return new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setUseClientMode(boolean clientMode) {
        this.mode = clientMode ? Mode.CLIENT : Mode.SERVER;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngineResult unwrap(ByteBuffer source, ByteBuffer[] sinks, int offset, int length) throws SSLException {
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never called");
        }
        if (this.inClosed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.handshakeStatus, 0, 0);
        }
        if (source.remaining() < 5) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.handshakeStatus, 0, 0);
        }
        Record record = null;
        boolean helloV2 = false;
        if (!this.getUseClientMode() && (source.get(source.position()) & 0x80) == 128) {
            if (this.handshake == null) {
                this.beginHandshake();
            }
            int hellolen = source.getShort(source.position()) & Short.MAX_VALUE;
            this.handshake.handleV2Hello(source.slice());
            if (!this.insec.cipherSuite().equals(CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                throw new SSLException("received SSLv2 client hello in encrypted session; this is invalid.");
            }
            logger.log(Component.SSL_RECORD_LAYER, "converting SSLv2 client hello to version 3 hello");
            source.getShort();
            ClientHelloV2 v2 = new ClientHelloV2(source.slice());
            logger.log((Level)Component.SSL_RECORD_LAYER, "v2 hello: {0}", v2);
            List<CipherSuite> suites = v2.cipherSpecs();
            ClientHelloBuilder hello = new ClientHelloBuilder();
            hello.setVersion(v2.version());
            Random random = hello.random();
            byte[] challenge = v2.challenge();
            if (challenge.length < 32) {
                byte[] b = new byte[32];
                System.arraycopy(challenge, 0, b, b.length - challenge.length, challenge.length);
                challenge = b;
            }
            random.setGmtUnixTime((challenge[0] & 0xFF) << 24 | (challenge[1] & 0xFF) << 16 | (challenge[2] & 0xFF) << 8 | challenge[3] & 0xFF);
            random.setRandomBytes(challenge, 4);
            byte[] sessionId = v2.sessionId();
            hello.setSessionId(sessionId, 0, sessionId.length);
            hello.setCipherSuites(suites);
            ArrayList<CompressionMethod> comps = new ArrayList<CompressionMethod>(1);
            comps.add(CompressionMethod.NULL);
            hello.setCompressionMethods(comps);
            record = new Record(ByteBuffer.allocate(hello.length() + 9));
            record.setContentType(ContentType.HANDSHAKE);
            record.setVersion(v2.version());
            record.setLength(hello.length() + 4);
            Handshake handshake = new Handshake(record.fragment());
            handshake.setLength(hello.length());
            handshake.setType(Handshake.Type.CLIENT_HELLO);
            handshake.bodyBuffer().put(hello.buffer());
            source.position(source.position() + hellolen);
            helloV2 = true;
        } else {
            record = new Record(source);
        }
        ContentType type = record.contentType();
        logger.log((Level)Component.SSL_RECORD_LAYER, "input record:\n{0}", record);
        if (record.length() > this.session.getPacketBufferSize() - 5) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.RECORD_OVERFLOW);
            throw new AlertException(this.lastAlert);
        }
        ByteBufferOutputStream sysMsg = null;
        ByteBuffer msg = null;
        int produced = 0;
        try {
            if (record.contentType() == ContentType.APPLICATION_DATA) {
                produced = this.insec.decrypt(record, sinks, offset, length);
            } else if (this.insec.cipherSuite() == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
                msg = record.fragment();
            } else {
                sysMsg = new ByteBufferOutputStream();
                this.insec.decrypt(record, sysMsg);
            }
            if (!helloV2) {
                source.position(source.position() + record.length() + 5);
            }
        }
        catch (BufferOverflowException boe) {
            logger.log((Level)Component.SSL_RECORD_LAYER, "buffer overflow when decrypting", boe);
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.handshakeStatus, 0, 0);
        }
        catch (IllegalBlockSizeException ibse) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.BAD_RECORD_MAC);
            throw new AlertException(this.lastAlert, (Throwable)ibse);
        }
        catch (DataFormatException dfe) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.DECOMPRESSION_FAILURE);
            throw new AlertException(this.lastAlert, (Throwable)dfe);
        }
        catch (MacException me) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.BAD_RECORD_MAC);
            throw new AlertException(this.lastAlert, (Throwable)me);
        }
        catch (ShortBufferException sbe) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            throw new AlertException(this.lastAlert, (Throwable)sbe);
        }
        SSLEngineResult result = null;
        if (sysMsg != null) {
            logger.logv(Component.SSL_RECORD_LAYER, "sysmessage {0}", sysMsg);
            msg = sysMsg.buffer();
        }
        if (type == ContentType.CHANGE_CIPHER_SPEC) {
            if (msg.remaining() == 0) {
                result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            } else {
                byte b = msg.get();
                if (b != 1) {
                    throw new SSLException("unknown ChangeCipherSpec value: " + (b & 0xFF));
                }
                InputSecurityParameters params = this.handshake.getInputParams();
                logger.log((Level)Component.SSL_RECORD_LAYER, "switching to input security parameters {0}", params.cipherSuite());
                this.insec = params;
                result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            }
        } else if (type == ContentType.ALERT) {
            int len = 0;
            if (this.alertBuffer.position() > 0) {
                this.alertBuffer.put(msg.get());
                len = 1;
            }
            logger.logv(Component.SSL_RECORD_LAYER, "processing alerts {0}", Util.wrapBuffer(msg));
            Alert[] alerts = new Alert[len += msg.remaining() / 2];
            int i = 0;
            if (this.alertBuffer.position() > 0) {
                this.alertBuffer.flip();
                alerts[0] = new Alert(this.alertBuffer);
                ++i;
            }
            while (i < alerts.length) {
                alerts[i++] = new Alert(msg.duplicate());
                msg.position(msg.position() + 2);
            }
            logger.logv(Component.SSL_RECORD_LAYER, "alerts: {0}", alerts.length);
            i = 0;
            while (i < alerts.length) {
                if (alerts[i].level() == Alert.Level.FATAL) {
                    throw new AlertException(alerts[i], false);
                }
                if (alerts[i].description() != Alert.Description.CLOSE_NOTIFY) {
                    logger.log(Level.WARNING, "received alert: {0}", alerts[i]);
                }
                if (alerts[i].description() == Alert.Description.CLOSE_NOTIFY) {
                    this.inClosed = true;
                }
                ++i;
            }
            if (msg.hasRemaining()) {
                this.alertBuffer.position(0).limit(2);
            }
            result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
        } else if (type == ContentType.HANDSHAKE) {
            if (this.handshake == null) {
                this.beginHandshake();
            }
            try {
                this.handshakeStatus = this.handshake.handleInput(msg);
            }
            catch (AlertException ae) {
                this.lastAlert = ae.alert();
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
            }
            logger.logv(Component.SSL_HANDSHAKE, "handshake status {0}", new Object[]{this.handshakeStatus});
            result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.handshake = null;
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        } else if (type == ContentType.APPLICATION_DATA) {
            result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, produced);
        } else {
            SSLRecordHandler handler = this.handlers[type.getValue()];
            if (handler != null) {
                result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, record.length() + 5, 0);
            } else {
                throw new SSLException("unknown content type: " + (Object)((Object)type));
            }
        }
        logger.logv(Component.SSL_RECORD_LAYER, "return result: {0}", result);
        return result;
    }

    public SSLEngineResult wrap(ByteBuffer[] sources, int offset, int length, ByteBuffer sink) throws SSLException {
        if (this.mode == null) {
            throw new IllegalStateException("setUseClientMode was never called");
        }
        if (this.outClosed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.handshakeStatus, 0, 0);
        }
        ContentType type = null;
        ByteBuffer sysMessage = null;
        logger.logv(Component.SSL_RECORD_LAYER, "wrap {0} {1} {2} {3} / {4}", new Object[]{sources, offset, length, sink, this.getHandshakeStatus()});
        if (this.lastAlert != null) {
            type = ContentType.ALERT;
            sysMessage = ByteBuffer.allocate(2);
            Alert alert = new Alert(sysMessage);
            alert.setDescription(this.lastAlert.description());
            alert.setLevel(this.lastAlert.level());
            if (this.lastAlert.description() == Alert.Description.CLOSE_NOTIFY) {
                this.outClosed = true;
            }
        } else if (this.changeCipherSpec) {
            type = ContentType.CHANGE_CIPHER_SPEC;
            sysMessage = ByteBuffer.allocate(1);
            sysMessage.put(0, (byte)1);
        } else if (this.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            if (this.outsec.suite() == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
                int orig = sink.position();
                sink.order(ByteOrder.BIG_ENDIAN);
                sink.put((byte)ContentType.HANDSHAKE.getValue());
                sink.putShort((short)this.session.version.rawValue());
                sink.putShort((short)0);
                this.handshakeStatus = this.handshake.handleOutput(sink);
                int produced = sink.position() - orig;
                sink.putShort(orig + 3, (short)(produced - 5));
                logger.logv(Component.SSL_RECORD_LAYER, "emitting record:\n{0}", new Record((ByteBuffer)sink.duplicate().position(orig)));
                SSLEngineResult result = new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, produced);
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.handshake = null;
                    this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                }
                return result;
            }
            sysMessage = ByteBuffer.allocate(sink.remaining() - 2048);
            type = ContentType.HANDSHAKE;
            try {
                this.handshakeStatus = this.handshake.handleOutput(sysMessage);
            }
            catch (AlertException ae) {
                this.lastAlert = ae.alert();
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
            }
            sysMessage.flip();
            logger.logv(Component.SSL_HANDSHAKE, "handshake status {0}", new Object[]{this.handshakeStatus});
        }
        int produced = 0;
        int consumed = 0;
        try {
            int orig = sink.position();
            int[] inout = null;
            if (sysMessage != null) {
                logger.logv(Component.SSL_RECORD_LAYER, "encrypt system message {0} to {1}", sysMessage, sink);
                inout = this.outsec.encrypt(new ByteBuffer[]{sysMessage}, 0, 1, type, sink);
                produced = inout[1];
            } else {
                inout = this.outsec.encrypt(sources, offset, length, ContentType.APPLICATION_DATA, sink);
                consumed = inout[0];
                produced = inout[1];
            }
            logger.logv(Component.SSL_RECORD_LAYER, "emitting record:\n{0}", new Record((ByteBuffer)sink.duplicate().position(orig).limit(produced)));
        }
        catch (ShortBufferException shortBufferException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        catch (DataFormatException dataFormatException) {
            this.lastAlert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshakeStatus, 0, 0);
        }
        if (this.lastAlert != null && this.lastAlert.level() == Alert.Level.FATAL) {
            AlertException ae = new AlertException(this.lastAlert);
            this.lastAlert = null;
            throw ae;
        }
        if (this.changeCipherSpec) {
            this.outsec = this.handshake.getOutputParams();
            this.changeCipherSpec = false;
        }
        SSLEngineResult result = new SSLEngineResult(this.outClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, this.handshakeStatus, consumed, produced);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshake = null;
            this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        return result;
    }

    SessionImpl session() {
        return this.session;
    }

    void setSession(SessionImpl session) {
        this.session = session;
    }

    void changeCipherSpec() {
        this.changeCipherSpec = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        SERVER,
        CLIENT;

    }
}

