/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.logging.Logger;

public final class PKCS7
extends BasePad {
    private static final Logger log = Logger.getLogger(PKCS7.class.getName());

    PKCS7() {
        super("pkcs7");
    }

    public void setup() {
        if (this.blockSize < 2 || this.blockSize > 256) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] pad(byte[] in, int offset, int length) {
        int padLength = this.blockSize;
        if (length % this.blockSize != 0) {
            padLength = this.blockSize - length % this.blockSize;
        }
        byte[] result = new byte[padLength];
        int i = 0;
        while (i < padLength) {
            result[i++] = (byte)padLength;
        }
        return result;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        int limit = offset + length;
        int result = in[--limit] & 0xFF;
        int i = 0;
        while (i < result - 1) {
            if (result != (in[--limit] & 0xFF)) {
                throw new WrongPaddingException();
            }
            ++i;
        }
        return result;
    }
}

