/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.jar;

import gnu.java.net.URLParseError;
import gnu.java.net.protocol.jar.Connection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Handler
extends URLStreamHandler {
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    protected void parseURL(URL url, String url_string, int start, int end) {
        String file = url.getFile();
        if (!file.equals("")) {
            if ((url_string = url_string.substring(start, end)).startsWith("/")) {
                int idx = file.lastIndexOf("!/");
                if (idx < 0) {
                    throw new URLParseError("no !/ in spec");
                }
                file = String.valueOf(file.substring(0, idx + 1)) + url_string;
            } else if (url_string.length() > 0) {
                int idx = file.lastIndexOf("/");
                file = idx == -1 ? "/" + url_string : (idx == file.length() - 1 ? String.valueOf(file) + url_string : String.valueOf(file.substring(0, idx + 1)) + url_string);
            }
            this.setURL(url, "jar", url.getHost(), url.getPort(), Handler.flat(file), null);
            return;
        }
        if (end < start) {
            return;
        }
        if (end - start < 2) {
            return;
        }
        if (start > url_string.length()) {
            return;
        }
        int jar_stop = (url_string = url_string.substring(start, end)).indexOf("!/");
        if (jar_stop < 0) {
            throw new URLParseError("no !/ in spec");
        }
        try {
            new URL(url_string.substring(0, jar_stop));
        }
        catch (MalformedURLException e) {
            throw new URLParseError("invalid inner URL: " + e.getMessage());
        }
        if (!url.getProtocol().equals("jar")) {
            throw new URLParseError("unexpected protocol " + url.getProtocol());
        }
        this.setURL(url, "jar", url.getHost(), url.getPort(), url_string, null);
    }

    private static String flat(String url_string) {
        int jar_stop = url_string.indexOf("!/");
        String jar_path = url_string.substring(jar_stop + 1, url_string.length());
        if (jar_path.indexOf("/.") < 0) {
            return url_string;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(jar_path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(".")) continue;
            if (token.equals("..")) {
                if (tokens.isEmpty()) continue;
                tokens.remove(tokens.size() - 1);
                continue;
            }
            tokens.add(token);
        }
        StringBuffer path = new StringBuffer(url_string.length());
        path.append(url_string.substring(0, jar_stop + 1));
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            path.append('/').append((String)it.next());
        }
        return path.toString();
    }

    protected String toExternalForm(URL url) {
        String file = url.getFile();
        String ref = url.getRef();
        StringBuffer sb = new StringBuffer(file.length() + 5);
        sb.append("jar:");
        sb.append(file);
        if (ref != null) {
            sb.append('#').append(ref);
        }
        return sb.toString();
    }
}

